/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration;

import com.atlassian.jira.migration.MigrationServicesConfiguration;
import com.atlassian.jira.migration.version.JiraMigrationVersionService;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import javax.inject.Inject;
import javax.inject.Named;

@WebSudoRequired
@Named
public class AppAction
extends JiraWebActionSupport {
    private static final String TEMPLATE_FILE_PATH = AppAction.class.getResource("/fe-resources/script-template.html") == null ? "fallback.html" : "fe-resources/script-template.html";
    private static final String SCRIPT_TEMPLATE_HTML = "fe-resources/script-template.html";
    private static final String JIRA_10_URLMODE_REFERENCE_CLASS = "com.atlassian.webresource.api.UrlMode";
    private static final String OLD_URLMODE_REFERENCE_CLASS = "com.atlassian.plugin.webresource.UrlMode";
    private final MigrationServicesConfiguration configuration;
    private final JiraMigrationVersionService versionService;

    @Inject
    public AppAction(MigrationServicesConfiguration configuration, JiraMigrationVersionService versionService) {
        this.configuration = configuration;
        this.versionService = versionService;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doExecute() {
        return "success";
    }

    @HtmlSafe
    public String getTemplateFilePath() {
        return TEMPLATE_FILE_PATH;
    }

    public Enum<?> getUrlMode() {
        String className = this.versionService.getJiraMajorVersion() >= 10 ? JIRA_10_URLMODE_REFERENCE_CLASS : OLD_URLMODE_REFERENCE_CLASS;
        Class<?> urlModeClass = this.getUrlModeClass(className);
        return Enum.valueOf(urlModeClass.asSubclass(Enum.class), "ABSOLUTE");
    }

    private Class<?> getUrlModeClass(String className) {
        try {
            return this.getUrlModeAvailableOnClasspath(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Did not find the UrlMode class reference: " + className, e);
        }
    }

    public Class<?> getUrlModeAvailableOnClasspath(String className) throws ClassNotFoundException {
        return Class.forName(className);
    }

    @HtmlSafe
    public String getFrontendTargetCloudEnv() {
        return this.configuration.getFrontendTargetCloudEnv().replaceAll("[^a-z]", "");
    }
}

