/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.events.CrowdEventDetectionService;
import com.atlassian.jira.migration.events.JiraEventDetectionService;
import com.atlassian.jira.migration.preflight.PreflightLockRepository;
import com.atlassian.jira.migration.setup.PollingSetup;
import com.atlassian.jira.migration.utils.log4j.AbstractLog4jAppenderUtil;
import com.atlassian.jira.migration.utils.log4j.Log4jAppenderUtilFactory;
import com.atlassian.jira.migration.version.JiraMigrationVersionService;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 &2\u00020\u00012\u00020\u0002:\u0002&'BG\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0007J\u0006\u0010\u001a\u001a\u00020\u0018J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0016H\u0002J\b\u0010\u001e\u001a\u00020\u0018H\u0002J\u0010\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0016H\u0002J\u0010\u0010 \u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020!H\u0007J\b\u0010\"\u001a\u00020\u0018H\u0016J\b\u0010#\u001a\u00020\u0018H\u0016J\b\u0010$\u001a\u00020\u0018H\u0002J\b\u0010%\u001a\u00020\u0018H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/atlassian/jira/migration/PluginLauncher;", "Lcom/atlassian/sal/api/lifecycle/LifecycleAware;", "Lorg/springframework/beans/factory/InitializingBean;", "eventPublisher", "Lcom/atlassian/event/api/EventPublisher;", "jiraMigrationVersionService", "Lcom/atlassian/jira/migration/version/JiraMigrationVersionService;", "pollingSetup", "Lcom/atlassian/jira/migration/setup/PollingSetup;", "jiraEventDetectionService", "Lcom/atlassian/jira/migration/events/JiraEventDetectionService;", "log4jAppenderUtilFactory", "Lcom/atlassian/jira/migration/utils/log4j/Log4jAppenderUtilFactory;", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "crowdEventDetectionService", "Lcom/atlassian/jira/migration/events/CrowdEventDetectionService;", "preflightLockRepository", "Lcom/atlassian/jira/migration/preflight/PreflightLockRepository;", "(Lcom/atlassian/event/api/EventPublisher;Lcom/atlassian/jira/migration/version/JiraMigrationVersionService;Lcom/atlassian/jira/migration/setup/PollingSetup;Lcom/atlassian/jira/migration/events/JiraEventDetectionService;Lcom/atlassian/jira/migration/utils/log4j/Log4jAppenderUtilFactory;Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/jira/migration/events/CrowdEventDetectionService;Lcom/atlassian/jira/migration/preflight/PreflightLockRepository;)V", "lifecycleEvents", "", "Lcom/atlassian/jira/migration/PluginLauncher$LifecycleEvent;", "afterPropertiesSet", "", "createMigrationAppender", "destroy", "isLifecycleReady", "", "event", "launch", "onLifecycleEvent", "onPluginEnabled", "Lcom/atlassian/plugin/event/events/PluginEnabledEvent;", "onStart", "onStop", "registerListener", "unregisterListener", "Companion", "LifecycleEvent", "jira-migration-plugin"})
public final class PluginLauncher
implements LifecycleAware,
InitializingBean {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EventPublisher eventPublisher;
    @NotNull
    private final JiraMigrationVersionService jiraMigrationVersionService;
    @NotNull
    private final PollingSetup pollingSetup;
    @NotNull
    private final JiraEventDetectionService jiraEventDetectionService;
    @NotNull
    private final Log4jAppenderUtilFactory log4jAppenderUtilFactory;
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;
    @NotNull
    private final CrowdEventDetectionService crowdEventDetectionService;
    @NotNull
    private final PreflightLockRepository preflightLockRepository;
    @GuardedBy(value="this")
    @NotNull
    private final Set<LifecycleEvent> lifecycleEvents;
    private static final Logger log = LoggerFactory.getLogger(PluginLauncher.class);

    @Inject
    public PluginLauncher(@NotNull EventPublisher eventPublisher, @NotNull JiraMigrationVersionService jiraMigrationVersionService, @NotNull PollingSetup pollingSetup, @NotNull JiraEventDetectionService jiraEventDetectionService, @NotNull Log4jAppenderUtilFactory log4jAppenderUtilFactory, @NotNull CloudSiteRepository cloudSiteRepository, @NotNull CrowdEventDetectionService crowdEventDetectionService, @NotNull PreflightLockRepository preflightLockRepository) {
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)jiraMigrationVersionService, (String)"jiraMigrationVersionService");
        Intrinsics.checkNotNullParameter((Object)pollingSetup, (String)"pollingSetup");
        Intrinsics.checkNotNullParameter((Object)jiraEventDetectionService, (String)"jiraEventDetectionService");
        Intrinsics.checkNotNullParameter((Object)log4jAppenderUtilFactory, (String)"log4jAppenderUtilFactory");
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)crowdEventDetectionService, (String)"crowdEventDetectionService");
        Intrinsics.checkNotNullParameter((Object)preflightLockRepository, (String)"preflightLockRepository");
        this.eventPublisher = eventPublisher;
        this.jiraMigrationVersionService = jiraMigrationVersionService;
        this.pollingSetup = pollingSetup;
        this.jiraEventDetectionService = jiraEventDetectionService;
        this.log4jAppenderUtilFactory = log4jAppenderUtilFactory;
        this.cloudSiteRepository = cloudSiteRepository;
        this.crowdEventDetectionService = crowdEventDetectionService;
        this.preflightLockRepository = preflightLockRepository;
        EnumSet<LifecycleEvent> enumSet = EnumSet.noneOf(LifecycleEvent.class);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"noneOf(...)");
        this.lifecycleEvents = enumSet;
    }

    public void afterPropertiesSet() {
        this.registerListener();
        this.onLifecycleEvent(LifecycleEvent.AFTER_PROPERTIES_SET);
    }

    public void onStart() {
        this.onLifecycleEvent(LifecycleEvent.LIFECYCLE_AWARE_ON_START);
    }

    public void onStop() {
        log.info("Jira Migration Plugin " + this.jiraMigrationVersionService.getPluginVersion() + " stopped");
        this.unregisterListener();
        this.lifecycleEvents.clear();
    }

    @EventListener
    public final void onPluginEnabled(@NotNull PluginEnabledEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (Intrinsics.areEqual((Object)"com.atlassian.jira.migration.jira-migration-plugin", (Object)event.getPlugin().getKey())) {
            this.onLifecycleEvent(LifecycleEvent.PLUGIN_ENABLED);
            try {
                this.preflightLockRepository.clearLocks();
                log.info("Preflight locks cleared successfully on plugin enabled");
            }
            catch (Exception e) {
                log.error("Failed to clear preflight locks on plugin enabled", (Throwable)e);
            }
        }
    }

    public final void destroy() throws Exception {
        this.unregisterListener();
    }

    private final void onLifecycleEvent(LifecycleEvent event) {
        log.debug("onLifecycleEvent [" + this.getClass().hashCode() + "]: " + (Object)((Object)event));
        if (this.isLifecycleReady(event)) {
            this.unregisterListener();
            try {
                this.launch();
            }
            catch (Exception ex) {
                log.error("Unexpected error during launch", (Throwable)ex);
            }
        }
    }

    private final synchronized boolean isLifecycleReady(LifecycleEvent event) {
        return this.lifecycleEvents.add(event) && this.lifecycleEvents.size() == LifecycleEvent.values().length;
    }

    private final void launch() throws Exception {
        log.info("Jira Migration Plugin " + this.jiraMigrationVersionService.getPluginVersion() + " initialising..");
        this.pollingSetup.init();
        this.jiraEventDetectionService.init();
        this.crowdEventDetectionService.init();
        this.cloudSiteRepository.encryptAllContainerTokens();
        this.createMigrationAppender();
        log.info("Jira Migration Plugin " + this.jiraMigrationVersionService.getPluginVersion() + " initialised");
    }

    @VisibleForTesting
    public final void createMigrationAppender() {
        AbstractLog4jAppenderUtil appenderUtil = this.log4jAppenderUtilFactory.getAppenderUtil();
        appenderUtil.createAppender();
        log.info("Initialized atlassian-jcma " + appenderUtil.getAPIVersion() + " log appender.");
    }

    private final void registerListener() {
        log.debug("registerListeners");
        this.eventPublisher.register((Object)this);
    }

    private final void unregisterListener() {
        log.debug("unregisterListeners");
        this.jiraEventDetectionService.stop();
        this.crowdEventDetectionService.stop();
        this.eventPublisher.unregister((Object)this);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/PluginLauncher$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/PluginLauncher$LifecycleEvent;", "", "(Ljava/lang/String;I)V", "AFTER_PROPERTIES_SET", "PLUGIN_ENABLED", "LIFECYCLE_AWARE_ON_START", "jira-migration-plugin"})
    public static final class LifecycleEvent
    extends Enum<LifecycleEvent> {
        public static final /* enum */ LifecycleEvent AFTER_PROPERTIES_SET = new LifecycleEvent();
        public static final /* enum */ LifecycleEvent PLUGIN_ENABLED = new LifecycleEvent();
        public static final /* enum */ LifecycleEvent LIFECYCLE_AWARE_ON_START = new LifecycleEvent();
        private static final /* synthetic */ LifecycleEvent[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static LifecycleEvent[] values() {
            return (LifecycleEvent[])$VALUES.clone();
        }

        public static LifecycleEvent valueOf(String value) {
            return Enum.valueOf(LifecycleEvent.class, value);
        }

        @NotNull
        public static EnumEntries<LifecycleEvent> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = lifecycleEventArray = new LifecycleEvent[]{LifecycleEvent.AFTER_PROPERTIES_SET, LifecycleEvent.PLUGIN_ENABLED, LifecycleEvent.LIFECYCLE_AWARE_ON_START};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

