/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.advancedroadmaps;

import com.atlassian.jira.migration.advancedroadmaps.AdvancedRoadmapsProjectsService;
import com.atlassian.jira.migration.export.db.advancedroadmaps.AdvancedRoadmapsPlanData;
import com.atlassian.jira.migration.export.db.advancedroadmaps.PlanDataReader;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.plan.AdvancedRoadmapPlanMigrationMode;
import com.atlassian.jira.migration.serverdataextractors.RelatedEntitiesDataReader;
import com.atlassian.jira.migration.serverdataextractors.ServerProjectDto;
import com.atlassian.jira.migration.serverdataextractors.SortOrder;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 +2\u00020\u0001:\u0001+B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0002J1\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016\u00a2\u0006\u0002\u0010\u001cJ6\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00122\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u000e\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012H\u0016J\u001a\u0010\"\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 2\b\u0010\u001e\u001a\u0004\u0018\u00010\u000bH\u0016J \u0010\"\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 2\u000e\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0012H\u0016J\u001c\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00160\u00122\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012H\u0016J\u0018\u0010$\u001a\u00020\u00132\u000e\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0012H\u0002J\u001e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u000e\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0012H\u0016J\u001c\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u00122\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u0010\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u000bH\u0002J\u0018\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00122\b\u0010\u001e\u001a\u0004\u0018\u00010\u000bH\u0002R'\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/atlassian/jira/migration/advancedroadmaps/AdvancedRoadmapsProjectsServiceImpl;", "Lcom/atlassian/jira/migration/advancedroadmaps/AdvancedRoadmapsProjectsService;", "dataReader", "Lcom/atlassian/jira/migration/export/db/advancedroadmaps/PlanDataReader;", "relatedEntitiesDataReader", "Lcom/atlassian/jira/migration/serverdataextractors/RelatedEntitiesDataReader;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/export/db/advancedroadmaps/PlanDataReader;Lcom/atlassian/jira/migration/serverdataextractors/RelatedEntitiesDataReader;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "arCache", "Lcom/google/common/cache/LoadingCache;", "", "", "getArCache", "()Lcom/google/common/cache/LoadingCache;", "arCache$delegate", "Lkotlin/Lazy;", "getAllPlanIds", "", "", "getAllPlansCount", "getPaginatedPlans", "Lcom/atlassian/jira/migration/export/db/advancedroadmaps/AdvancedRoadmapsPlanData;", "page", "", "pageSize", "sortOrder", "Lcom/atlassian/jira/migration/serverdataextractors/SortOrder;", "(Ljava/lang/Integer;Ljava/lang/Integer;Lcom/atlassian/jira/migration/serverdataextractors/SortOrder;)Ljava/util/List;", "getPlanIds", "projectKeys", "advancedRoadmapPlanMigrationMode", "Lcom/atlassian/jira/migration/plan/AdvancedRoadmapPlanMigrationMode;", "planIds", "getPlansCount", "getPlansForProjects", "getPlansIdsCountForProjects", "getPlansIdsForProjects", "getProjectsFromPlans", "Lcom/atlassian/jira/migration/serverdataextractors/ServerProjectDto;", "loadCache", "key", "parseProjectKeys", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAdvancedRoadmapsProjectsServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdvancedRoadmapsProjectsServiceImpl.kt\ncom/atlassian/jira/migration/advancedroadmaps/AdvancedRoadmapsProjectsServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n1549#2:103\n1620#2,3:104\n*S KotlinDebug\n*F\n+ 1 AdvancedRoadmapsProjectsServiceImpl.kt\ncom/atlassian/jira/migration/advancedroadmaps/AdvancedRoadmapsProjectsServiceImpl\n*L\n90#1:103\n90#1:104,3\n*E\n"})
public final class AdvancedRoadmapsProjectsServiceImpl
implements AdvancedRoadmapsProjectsService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlanDataReader dataReader;
    @NotNull
    private final RelatedEntitiesDataReader relatedEntitiesDataReader;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final Lazy arCache$delegate;
    private static final Logger log = LoggerFactory.getLogger(AdvancedRoadmapsProjectsServiceImpl.class);

    public AdvancedRoadmapsProjectsServiceImpl(@NotNull PlanDataReader dataReader, @NotNull RelatedEntitiesDataReader relatedEntitiesDataReader, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)dataReader, (String)"dataReader");
        Intrinsics.checkNotNullParameter((Object)relatedEntitiesDataReader, (String)"relatedEntitiesDataReader");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.dataReader = dataReader;
        this.relatedEntitiesDataReader = relatedEntitiesDataReader;
        this.migrationFeatures = migrationFeatures;
        this.arCache$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LoadingCache<String, Object>>(this){
            final /* synthetic */ AdvancedRoadmapsProjectsServiceImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final LoadingCache<String, Object> invoke() {
                return CacheBuilder.newBuilder().maximumSize(1L).expireAfterWrite(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Object>(this.this$0){
                    final /* synthetic */ AdvancedRoadmapsProjectsServiceImpl this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    @NotNull
                    public Object load(@NotNull String key) {
                        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                        return AdvancedRoadmapsProjectsServiceImpl.access$loadCache(this.this$0, key);
                    }
                });
            }
        }));
    }

    private final LoadingCache<String, Object> getArCache() {
        Lazy lazy = this.arCache$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (LoadingCache)object;
    }

    @Override
    @NotNull
    public List<Long> getPlansIdsForProjects(@Nullable List<String> projectKeys) {
        log.info("Getting AR plans for the selected projects in migration plan.");
        Collection<String> collection = projectKeys;
        if (collection == null || (collection = CollectionsKt.toSet((Iterable)collection)) == null) {
            collection = SetsKt.emptySet();
        }
        Collection<String> projectKeysSet = collection;
        List<Long> allPlanIds = this.dataReader.getAllAdvancedRoadmapIds();
        return CollectionsKt.toList((Iterable)this.relatedEntitiesDataReader.getPlanIdsFromProjects(allPlanIds, (Set<String>)projectKeysSet));
    }

    @Override
    @NotNull
    public List<Long> getAllPlanIds() {
        return this.dataReader.getAllAdvancedRoadmapIds();
    }

    @Override
    @NotNull
    public List<Long> getPlanIds(@NotNull List<String> projectKeys, @Nullable AdvancedRoadmapPlanMigrationMode advancedRoadmapPlanMigrationMode, @Nullable List<Long> planIds) {
        List<Long> list;
        Intrinsics.checkNotNullParameter(projectKeys, (String)"projectKeys");
        boolean it = this.migrationFeatures.getEnableArPhasedFeature();
        boolean bl = false;
        if (!it) {
            log.info("AR phased feature is not enabled, going ALL mode...");
            List<Long> list2 = planIds;
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            return list2;
        }
        AdvancedRoadmapPlanMigrationMode advancedRoadmapPlanMigrationMode2 = advancedRoadmapPlanMigrationMode;
        switch (advancedRoadmapPlanMigrationMode2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[advancedRoadmapPlanMigrationMode2.ordinal()]) {
            case 1: {
                log.info("In selected project AR migration mode, getting the AR related to the selected projects...");
                list = this.getPlansIdsForProjects(projectKeys);
                break;
            }
            case 2: {
                log.info("In all AR migration mode, getting all AR...");
                list = this.getAllPlanIds();
                break;
            }
            case 3: {
                log.info("In no AR migration mode, getting no AR...");
                list = CollectionsKt.emptyList();
                break;
            }
            default: {
                list = planIds;
                if (list != null) break;
                list = CollectionsKt.emptyList();
            }
        }
        return list;
    }

    @Override
    @NotNull
    public List<AdvancedRoadmapsPlanData> getPlansForProjects(@NotNull List<String> projectKeys) {
        Intrinsics.checkNotNullParameter(projectKeys, (String)"projectKeys");
        return this.dataReader.getPlans(this.getPlansIdsForProjects(projectKeys));
    }

    @Override
    @NotNull
    public List<ServerProjectDto> getProjectsFromPlans(@NotNull List<Long> planIds) {
        Intrinsics.checkNotNullParameter(planIds, (String)"planIds");
        return this.relatedEntitiesDataReader.getProjectsFromPlans(planIds);
    }

    @Override
    @NotNull
    public List<AdvancedRoadmapsPlanData> getPaginatedPlans(@Nullable Integer page, @Nullable Integer pageSize, @Nullable SortOrder sortOrder) {
        return this.dataReader.pagination(page, pageSize, sortOrder == SortOrder.DESC);
    }

    @Override
    public long getPlansCount(@NotNull AdvancedRoadmapPlanMigrationMode advancedRoadmapPlanMigrationMode, @Nullable String projectKeys) {
        Intrinsics.checkNotNullParameter((Object)((Object)advancedRoadmapPlanMigrationMode), (String)"advancedRoadmapPlanMigrationMode");
        return this.getPlansCount(advancedRoadmapPlanMigrationMode, this.parseProjectKeys(projectKeys));
    }

    @Override
    public long getPlansCount(@NotNull AdvancedRoadmapPlanMigrationMode advancedRoadmapPlanMigrationMode, @Nullable List<String> projectKeys) {
        long l;
        Intrinsics.checkNotNullParameter((Object)((Object)advancedRoadmapPlanMigrationMode), (String)"advancedRoadmapPlanMigrationMode");
        switch (WhenMappings.$EnumSwitchMapping$0[advancedRoadmapPlanMigrationMode.ordinal()]) {
            case 2: {
                Object object = this.getArCache().get((Object)"AR_TOTAL_PLANS_COUNT");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
                l = (Long)object;
                break;
            }
            case 1: {
                l = this.getPlansIdsCountForProjects(projectKeys);
                break;
            }
            case 3: {
                l = 0L;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return l;
    }

    private final long getAllPlansCount() {
        return this.dataReader.totalPlansCount();
    }

    private final long getPlansIdsCountForProjects(List<String> projectKeys) {
        List<String> list = projectKeys;
        return list == null ? 0L : (long)this.getPlansIdsForProjects(list).size();
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> parseProjectKeys(String projectKeys) {
        Object object;
        block4: {
            block3: {
                void $this$mapTo$iv$iv;
                char[] cArray;
                object = projectKeys;
                if (object == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (char[])(cArray = new char[]{','}), (boolean)false, (int)0, (int)6, null)) == null) break block3;
                Iterable $this$map$iv = (Iterable)object;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString().toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                    collection.add(string2);
                }
                object = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                if (object != null) break block4;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private final long loadCache(String key) {
        if (!Intrinsics.areEqual((Object)key, (Object)"AR_TOTAL_PLANS_COUNT")) {
            throw new IllegalStateException(("Unhandled cache key " + key).toString());
        }
        return this.getAllPlansCount();
    }

    public static final /* synthetic */ long access$loadCache(AdvancedRoadmapsProjectsServiceImpl $this, String key) {
        return $this.loadCache(key);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/advancedroadmaps/AdvancedRoadmapsProjectsServiceImpl$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AdvancedRoadmapPlanMigrationMode.values().length];
            try {
                nArray[AdvancedRoadmapPlanMigrationMode.SELECTED_PROJECTS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AdvancedRoadmapPlanMigrationMode.ALL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AdvancedRoadmapPlanMigrationMode.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

