/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.advancedroadmaps;

import com.atlassian.jira.bc.issue.properties.IssuePropertyService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyOptions;
import com.atlassian.jira.entity.property.EntityPropertyService;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.migration.advancedroadmaps.ExcludedIssueIdsWithPlans;
import com.atlassian.jira.migration.advancedroadmaps.IssueExclusionFromPlans;
import com.atlassian.jira.migration.advancedroadmaps.IssueIdExclusionFromPlans;
import com.atlassian.jira.migration.advancedroadmaps.RawIssueProperties;
import com.atlassian.jira.migration.db.EntityPropertyTable;
import com.atlassian.jira.migration.db.JiraIssueTable;
import com.atlassian.jira.migration.export.framework.ExportErrorCode;
import com.atlassian.jira.migration.export.framework.ExportException;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.jira.advancedroadmaps.Plan;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.util.OnRollback;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0002J\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\tJ\u0010\u0010\u0011\u001a\n \u0007*\u0004\u0018\u00010\u00120\u0012H\u0002J\"\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\u0006\u0010\u0016\u001a\u00020\u000bJ\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/atlassian/jira/migration/advancedroadmaps/IssuePropertiesReader;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getEntityProperty", "", "issueId", "", "propertyKey", "getExcludedIssueIdsWithPlans", "", "Lcom/atlassian/jira/migration/advancedroadmaps/ExcludedIssueIdsWithPlans;", "migrationId", "getMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "readBatchIssueExclusionFromPlans", "Lcom/atlassian/jira/migration/advancedroadmaps/IssueIdExclusionFromPlans;", "issueIds", "planId", "readIssueExclusionFromPlans", "Lcom/atlassian/jira/migration/advancedroadmaps/IssueExclusionFromPlans;", "readRawIssueProperties", "Lcom/atlassian/jira/migration/advancedroadmaps/RawIssueProperties;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nIssuePropertiesReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IssuePropertiesReader.kt\ncom/atlassian/jira/migration/advancedroadmaps/IssuePropertiesReader\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,160:1\n58#2:161\n51#2:162\n58#2:163\n51#2:164\n58#2:175\n51#2:176\n58#2:194\n51#2:195\n1603#3,9:165\n1855#3:174\n1549#3:177\n1620#3,3:178\n1856#3:182\n1612#3:183\n1603#3,9:184\n1855#3:193\n1856#3:197\n1612#3:198\n1#4:181\n1#4:196\n*S KotlinDebug\n*F\n+ 1 IssuePropertiesReader.kt\ncom/atlassian/jira/migration/advancedroadmaps/IssuePropertiesReader\n*L\n37#1:161\n37#1:162\n42#1:163\n42#1:164\n67#1:175\n67#1:176\n99#1:194\n99#1:195\n60#1:165,9\n60#1:174\n68#1:177\n68#1:178,3\n60#1:182\n60#1:183\n93#1:184,9\n93#1:193\n93#1:197\n93#1:198\n60#1:181\n93#1:196\n*E\n"})
public final class IssuePropertiesReader {
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    private final Logger log;

    @Inject
    public IssuePropertiesReader(@NotNull DatabaseAccessor databaseAccessor) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        this.databaseAccessor = databaseAccessor;
        this.log = LoggerFactory.getLogger(IssuePropertiesReader.class);
    }

    @Nullable
    public final RawIssueProperties readRawIssueProperties(long issueId) {
        String entityProperty = this.getEntityProperty(issueId, "jpo-issue-properties");
        ObjectMapper objectMapper2 = this.getMapper();
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper2, (String)"getMapper(...)");
        ObjectMapper $this$readValue$iv = objectMapper2;
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef = false;
        return (RawIssueProperties)$this$readValue$iv.readValue(entityProperty, (TypeReference)new TypeReference<RawIssueProperties>(){});
    }

    @Nullable
    public final IssueExclusionFromPlans readIssueExclusionFromPlans(long issueId) {
        String entityProperty = this.getEntityProperty(issueId, "jpo-exclude-from-plan");
        ObjectMapper objectMapper2 = this.getMapper();
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper2, (String)"getMapper(...)");
        ObjectMapper $this$readValue$iv = objectMapper2;
        boolean $i$f$readValue = false;
        boolean $i$f$jacksonTypeRef = false;
        return (IssueExclusionFromPlans)$this$readValue$iv.readValue(entityProperty, (TypeReference)new TypeReference<IssueExclusionFromPlans>(){});
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ExcludedIssueIdsWithPlans> getExcludedIssueIdsWithPlans(@Nullable String migrationId) {
        void $this$mapNotNullTo$iv$iv;
        List result2 = (List)this.databaseAccessor.run(IssuePropertiesReader::getExcludedIssueIdsWithPlans$lambda$0, OnRollback.NOOP);
        Intrinsics.checkNotNull((Object)result2);
        Iterable $this$mapNotNull$iv = result2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ExcludedIssueIdsWithPlans excludedIssueIdsWithPlans;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Tuple row = (Tuple)element$iv$iv;
            boolean bl2 = false;
            Long entityId = (Long)row.get((Expression)EntityPropertyTable.INSTANCE.getENTITY_ID());
            Long projectId = (Long)row.get((Expression)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getPROJECT());
            String jsonValue = (String)row.get((Expression)EntityPropertyTable.INSTANCE.getJSON_VALUE());
            if (entityId != null && jsonValue != null && projectId != null) {
                ExcludedIssueIdsWithPlans excludedIssueIdsWithPlans2;
                try {
                    Set set;
                    String[] stringArray;
                    ObjectMapper $this$readValue$iv;
                    Intrinsics.checkNotNullExpressionValue((Object)this.getMapper(), (String)"getMapper(...)");
                    boolean $i$f$readValue = false;
                    boolean $i$f$jacksonTypeRef = false;
                    IssueExclusionFromPlans plansContainer = (IssueExclusionFromPlans)$this$readValue$iv.readValue(jsonValue, (TypeReference)new TypeReference<IssueExclusionFromPlans>(){});
                    Object object = plansContainer.getPlans();
                    if (object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{","}), (boolean)false, (int)0, (int)6, null)) != null) {
                        void $this$mapTo$iv$iv;
                        Iterable $this$map$iv = (Iterable)object;
                        boolean $i$f$map = false;
                        Iterable iterable2 = $this$map$iv;
                        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            String string = (String)item$iv$iv;
                            Collection collection = destination$iv$iv2;
                            boolean bl3 = false;
                            collection.add(Long.parseLong((String)it));
                        }
                        set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
                    } else {
                        set = null;
                    }
                    Set plans = set;
                    excludedIssueIdsWithPlans2 = new ExcludedIssueIdsWithPlans(entityId, projectId, plans);
                }
                catch (JsonParseException e) {
                    this.log.error((migrationId != null ? "migrationId: " + migrationId + " : " : "") + "Invalid JSON value - " + jsonValue + " on entityId " + entityId + '.', (Throwable)e);
                    excludedIssueIdsWithPlans2 = null;
                }
                excludedIssueIdsWithPlans = excludedIssueIdsWithPlans2;
            } else {
                excludedIssueIdsWithPlans = null;
            }
            if (excludedIssueIdsWithPlans == null) continue;
            ExcludedIssueIdsWithPlans it$iv$iv = excludedIssueIdsWithPlans;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List getExcludedIssueIdsWithPlans$default(IssuePropertiesReader issuePropertiesReader, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return issuePropertiesReader.getExcludedIssueIdsWithPlans(string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<IssueIdExclusionFromPlans> readBatchIssueExclusionFromPlans(@NotNull List<Long> issueIds, long planId) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(issueIds, (String)"issueIds");
        List result2 = (List)this.databaseAccessor.run(arg_0 -> IssuePropertiesReader.readBatchIssueExclusionFromPlans$lambda$3(issueIds, arg_0), OnRollback.NOOP);
        Intrinsics.checkNotNull((Object)result2);
        Iterable $this$mapNotNull$iv = result2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            IssueIdExclusionFromPlans issueIdExclusionFromPlans;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Tuple row = (Tuple)element$iv$iv;
            boolean bl2 = false;
            Long entityId = (Long)row.get((Expression)EntityPropertyTable.INSTANCE.getENTITY_ID());
            String jsonValue = (String)row.get((Expression)EntityPropertyTable.INSTANCE.getJSON_VALUE());
            if (entityId != null && jsonValue != null) {
                IssueIdExclusionFromPlans issueIdExclusionFromPlans2;
                try {
                    ObjectMapper $this$readValue$iv;
                    Intrinsics.checkNotNullExpressionValue((Object)this.getMapper(), (String)"getMapper(...)");
                    boolean $i$f$readValue = false;
                    boolean $i$f$jacksonTypeRef = false;
                    IssueExclusionFromPlans plansContainer = (IssueExclusionFromPlans)$this$readValue$iv.readValue(jsonValue, (TypeReference)new TypeReference<IssueExclusionFromPlans>(){});
                    issueIdExclusionFromPlans2 = new IssueIdExclusionFromPlans(entityId, plansContainer.getPlans());
                }
                catch (JsonParseException e) {
                    this.log.error("Invalid JSON value - " + jsonValue + " on entityId " + entityId + '.', (Throwable)e);
                    MRI mRI = MriExtensionsKt.mri$default(Plan.Companion.getEntityType(), planId, null, 2, null);
                    String string = "We couldn't export Plan " + planId + ". Reason: Invalid JSON value - " + jsonValue + " on entityId " + entityId + '.';
                    ExportErrorCode exportErrorCode = ExportErrorCode.PRJ_PLAN_HAS_INVALID_EXCLUDED_ISSUE_JSON_VALUE;
                    throw new ExportException(mRI, exportErrorCode, string, "Please fix the invalid JSON value.", null, null, null, 112, null);
                }
                issueIdExclusionFromPlans = issueIdExclusionFromPlans2;
            } else {
                issueIdExclusionFromPlans = null;
            }
            if (issueIdExclusionFromPlans == null) continue;
            IssueIdExclusionFromPlans it$iv$iv = issueIdExclusionFromPlans;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final ObjectMapper getMapper() {
        return ExtensionsKt.jacksonObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    private final String getEntityProperty(long issueId, String propertyKey) {
        EntityProperty entityProperty;
        IssuePropertyService issuePropertyService = (IssuePropertyService)ComponentAccessor.getComponentOfType(IssuePropertyService.class);
        EntityPropertyOptions entityPropertyOptions = new EntityPropertyOptions.Builder().skipPermissionChecks().build();
        EntityPropertyService.PropertyResult propertyResult = issuePropertyService.getProperty(null, Long.valueOf(issueId), propertyKey, entityPropertyOptions);
        Object option = propertyResult.getClass().getMethod("getEntityProperty", new Class[0]).invoke((Object)propertyResult, new Object[0]);
        EntityProperty entityProperty2 = entityProperty = (EntityProperty)option.getClass().getMethod("getOrNull", new Class[0]).invoke(option, new Object[0]);
        String string = entityProperty2 != null ? entityProperty2.getValue() : null;
        if (string == null) {
            string = "{}";
        }
        return string;
    }

    private static final List getExcludedIssueIdsWithPlans$lambda$0(DatabaseConnection db) {
        Expression[] expressionArray = new Expression[]{EntityPropertyTable.INSTANCE.getENTITY_ID(), JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getPROJECT(), EntityPropertyTable.INSTANCE.getJSON_VALUE()};
        return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)EntityPropertyTable.INSTANCE)).innerJoin((EntityPath)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE())).on((Predicate)EntityPropertyTable.INSTANCE.getENTITY_ID().eq((Expression)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getID()))).where((Predicate)EntityPropertyTable.INSTANCE.getPROPERTY_KEY().eq((Object)"jpo-exclude-from-plan").and((Predicate)EntityPropertyTable.INSTANCE.getENTITY_NAME().eq((Object)EntityPropertyType.ISSUE_PROPERTY.getDbEntityName())))).fetch();
    }

    private static final List readBatchIssueExclusionFromPlans$lambda$3(List $issueIds, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$issueIds, (String)"$issueIds");
        Expression[] expressionArray = new Expression[]{EntityPropertyTable.INSTANCE.getENTITY_ID(), EntityPropertyTable.INSTANCE.getJSON_VALUE()};
        return ((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)EntityPropertyTable.INSTANCE)).where((Predicate)EntityPropertyTable.INSTANCE.getPROPERTY_KEY().eq((Object)"jpo-exclude-from-plan").and((Predicate)EntityPropertyTable.INSTANCE.getENTITY_ID().in((Collection)$issueIds)))).fetch();
    }
}

