/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.advancedroadmaps;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.migration.export.db.core.JiraIssueReader;
import com.atlassian.jira.migration.export.utils.ExportFilters;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.utility.JQLUtility;
import com.atlassian.jira.migration.utils.MigrationModeUtil;
import com.atlassian.jira.user.ApplicationUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ$\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J#\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0016\u001a\u00020\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\u0002\u0010\u0019J)\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\u0002\u0010\u001bJ\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u000fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/atlassian/jira/migration/advancedroadmaps/IssueSearchService;", "", "jqlUtility", "Lcom/atlassian/jira/migration/utility/JQLUtility;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "issueManager", "Lcom/atlassian/jira/issue/IssueManager;", "exportFilters", "Lcom/atlassian/jira/migration/export/utils/ExportFilters;", "jiraIssueReader", "Lcom/atlassian/jira/migration/export/db/core/JiraIssueReader;", "(Lcom/atlassian/jira/migration/utility/JQLUtility;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/issue/IssueManager;Lcom/atlassian/jira/migration/export/utils/ExportFilters;Lcom/atlassian/jira/migration/export/db/core/JiraIssueReader;)V", "getActiveIssuesInProjects", "Lkotlin/sequences/Sequence;", "Lcom/atlassian/jira/issue/Issue;", "user", "Lcom/atlassian/jira/user/ApplicationUser;", "projectIds", "", "", "getAllChildIssuesForIssue", "issue", "migrateArchivedIssues", "", "(Lcom/atlassian/jira/issue/Issue;Ljava/lang/Boolean;)Lkotlin/sequences/Sequence;", "getAllIssuesInProjects", "(Ljava/util/List;Ljava/lang/Boolean;)Lkotlin/sequences/Sequence;", "getChildIssuesForIssue", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nIssueSearchService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IssueSearchService.kt\ncom/atlassian/jira/migration/advancedroadmaps/IssueSearchService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1360#2:83\n1446#2,5:84\n*S KotlinDebug\n*F\n+ 1 IssueSearchService.kt\ncom/atlassian/jira/migration/advancedroadmaps/IssueSearchService\n*L\n41#1:83\n41#1:84,5\n*E\n"})
public final class IssueSearchService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JQLUtility jqlUtility;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final IssueManager issueManager;
    @NotNull
    private final ExportFilters exportFilters;
    @NotNull
    private final JiraIssueReader jiraIssueReader;
    private static final int CHUNK_SIZE = 300;
    private static final Logger log = LoggerFactory.getLogger(IssueSearchService.class);

    @Inject
    public IssueSearchService(@NotNull JQLUtility jqlUtility, @NotNull MigrationFeatures migrationFeatures, @NotNull IssueManager issueManager, @NotNull ExportFilters exportFilters, @NotNull JiraIssueReader jiraIssueReader) {
        Intrinsics.checkNotNullParameter((Object)jqlUtility, (String)"jqlUtility");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)issueManager, (String)"issueManager");
        Intrinsics.checkNotNullParameter((Object)exportFilters, (String)"exportFilters");
        Intrinsics.checkNotNullParameter((Object)jiraIssueReader, (String)"jiraIssueReader");
        this.jqlUtility = jqlUtility;
        this.migrationFeatures = migrationFeatures;
        this.issueManager = issueManager;
        this.exportFilters = exportFilters;
        this.jiraIssueReader = jiraIssueReader;
    }

    @NotNull
    public final Sequence<Issue> getActiveIssuesInProjects(@Nullable ApplicationUser user, @NotNull List<Long> projectIds) {
        Intrinsics.checkNotNullParameter(projectIds, (String)"projectIds");
        if (projectIds.isEmpty()) {
            return SequencesKt.emptySequence();
        }
        return this.jqlUtility.executeJQL(user, "project in (" + CollectionsKt.joinToString$default((Iterable)projectIds, null, null, null, (int)0, null, null, (int)63, null) + ')');
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Sequence<Issue> getAllIssuesInProjects(@NotNull List<Long> projectIds, @Nullable Boolean migrateArchivedIssues) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter(projectIds, (String)"projectIds");
        Iterable iterable = projectIds;
        boolean $i$f$flatMap = false;
        void var6_5 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            long id = ((Number)element$iv$iv).longValue();
            boolean bl = false;
            Collection collection = this.issueManager.getIssueIdsForProject(Long.valueOf(id));
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getIssueIdsForProject(...)");
            Iterable list$iv$iv = collection;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List issueIds = (List)destination$iv$iv;
        Sequence issueObjects2 = SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)CollectionsKt.chunked((Iterable)issueIds, (int)300)), (Function1)((Function1)new Function1<List<? extends Long>, List<Issue>>(this){
            final /* synthetic */ IssueSearchService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final List<Issue> invoke(@NotNull List<Long> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                List list = IssueSearchService.access$getIssueManager$p(this.this$0).getIssueObjects((Collection)it);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getIssueObjects(...)");
                return list;
            }
        }));
        if (!MigrationModeUtil.INSTANCE.shouldMigrateArchivedIssues(this.migrationFeatures, migrateArchivedIssues)) {
            log.info("Filtering out archived issues");
            return this.exportFilters.filterArchivedIssues((Sequence<? extends Issue>)issueObjects2);
        }
        return issueObjects2;
    }

    @NotNull
    public final Sequence<Issue> getAllChildIssuesForIssue(@NotNull Issue issue2, @Nullable Boolean migrateArchivedIssues) {
        Intrinsics.checkNotNullParameter((Object)issue2, (String)"issue");
        Long l = issue2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
        Sequence<Long> issueIds = this.jiraIssueReader.getChildIssuesForIssue(((Number)l).longValue());
        Sequence issueObjects2 = SequencesKt.flatMapIterable((Sequence)SequencesKt.chunked(issueIds, (int)300), (Function1)((Function1)new Function1<List<? extends Long>, List<Issue>>(this){
            final /* synthetic */ IssueSearchService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final List<Issue> invoke(@NotNull List<Long> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                List list = IssueSearchService.access$getIssueManager$p(this.this$0).getIssueObjects((Collection)it);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getIssueObjects(...)");
                return list;
            }
        }));
        if (!MigrationModeUtil.INSTANCE.shouldMigrateArchivedIssues(this.migrationFeatures, migrateArchivedIssues)) {
            log.info("Filtering out archived issues");
            return this.exportFilters.filterArchivedIssues((Sequence<? extends Issue>)issueObjects2);
        }
        return issueObjects2;
    }

    @NotNull
    public final Sequence<Issue> getChildIssuesForIssue(@Nullable ApplicationUser user, @NotNull Issue issue2) {
        Intrinsics.checkNotNullParameter((Object)issue2, (String)"issue");
        return this.jqlUtility.executeJQL(user, "issue in childIssuesOf(" + issue2.getKey() + ')');
    }

    public static final /* synthetic */ IssueManager access$getIssueManager$p(IssueSearchService $this) {
        return $this.issueManager;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/advancedroadmaps/IssueSearchService$Companion;", "", "()V", "CHUNK_SIZE", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

