/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.advancedroadmaps;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.migration.advancedroadmaps.IssueSearchService;
import com.atlassian.jira.migration.advancedroadmaps.RawIssuePropertiesReader;
import com.atlassian.jira.migration.export.core.issueparentassociation.IssueParentAssociationWrapper;
import com.atlassian.jira.migration.export.framework.MriExtensionsKt;
import com.atlassian.migration.base.mri.MRI;
import com.atlassian.migration.base.mri.registry.EntityType;
import com.atlassian.migration.jira.classic.issueassociation.IssueParentAssociationType;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J%\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0002\u0010\u000eJ)\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/jira/migration/advancedroadmaps/ParentLinkReader;", "", "issueSearchService", "Lcom/atlassian/jira/migration/advancedroadmaps/IssueSearchService;", "rawIssuePropertiesReader", "Lcom/atlassian/jira/migration/advancedroadmaps/RawIssuePropertiesReader;", "(Lcom/atlassian/jira/migration/advancedroadmaps/IssueSearchService;Lcom/atlassian/jira/migration/advancedroadmaps/RawIssuePropertiesReader;)V", "getChildLinks", "Lkotlin/sequences/Sequence;", "Lcom/atlassian/jira/migration/export/core/issueparentassociation/IssueParentAssociationWrapper;", "issue", "Lcom/atlassian/jira/issue/Issue;", "migrateArchivedIssues", "", "(Lcom/atlassian/jira/issue/Issue;Ljava/lang/Boolean;)Lkotlin/sequences/Sequence;", "getParentChildLinks", "issuesInProjects", "(Lkotlin/sequences/Sequence;Ljava/lang/Boolean;)Lkotlin/sequences/Sequence;", "getParentLink", "jira-migration-plugin"})
public final class ParentLinkReader {
    @NotNull
    private final IssueSearchService issueSearchService;
    @NotNull
    private final RawIssuePropertiesReader rawIssuePropertiesReader;

    @Inject
    public ParentLinkReader(@NotNull IssueSearchService issueSearchService, @NotNull RawIssuePropertiesReader rawIssuePropertiesReader) {
        Intrinsics.checkNotNullParameter((Object)issueSearchService, (String)"issueSearchService");
        Intrinsics.checkNotNullParameter((Object)rawIssuePropertiesReader, (String)"rawIssuePropertiesReader");
        this.issueSearchService = issueSearchService;
        this.rawIssuePropertiesReader = rawIssuePropertiesReader;
    }

    @NotNull
    public final Sequence<IssueParentAssociationWrapper> getParentChildLinks(@NotNull Sequence<? extends Issue> issuesInProjects, @Nullable Boolean migrateArchivedIssues) {
        Intrinsics.checkNotNullParameter(issuesInProjects, (String)"issuesInProjects");
        return SequencesKt.flatMap(issuesInProjects, (Function1)((Function1)new Function1<Issue, Sequence<? extends IssueParentAssociationWrapper>>(this, migrateArchivedIssues){
            final /* synthetic */ ParentLinkReader this$0;
            final /* synthetic */ Boolean $migrateArchivedIssues;
            {
                this.this$0 = $receiver;
                this.$migrateArchivedIssues = $migrateArchivedIssues;
                super(1);
            }

            @NotNull
            public final Sequence<IssueParentAssociationWrapper> invoke(@NotNull Issue issue2) {
                Intrinsics.checkNotNullParameter((Object)issue2, (String)"issue");
                return SequencesKt.plus((Sequence)ParentLinkReader.access$getParentLink(this.this$0, issue2), (Sequence)ParentLinkReader.access$getChildLinks(this.this$0, issue2, this.$migrateArchivedIssues));
            }
        }));
    }

    private final Sequence<IssueParentAssociationWrapper> getChildLinks(Issue issue2, Boolean migrateArchivedIssues) {
        Sequence<Issue> childIssues = this.issueSearchService.getAllChildIssuesForIssue(issue2, migrateArchivedIssues);
        return SequencesKt.mapNotNull(childIssues, (Function1)((Function1)new Function1<Issue, IssueParentAssociationWrapper>(this, issue2){
            final /* synthetic */ ParentLinkReader this$0;
            final /* synthetic */ Issue $issue;
            {
                this.this$0 = $receiver;
                this.$issue = $issue;
                super(1);
            }

            @Nullable
            public final IssueParentAssociationWrapper invoke(@NotNull Issue childIssue) {
                IssueParentAssociationWrapper issueParentAssociationWrapper;
                Intrinsics.checkNotNullParameter((Object)childIssue, (String)"childIssue");
                if (Intrinsics.areEqual((Object)ParentLinkReader.access$getRawIssuePropertiesReader$p(this.this$0).parentId(childIssue), (Object)this.$issue.getId())) {
                    Long l = childIssue.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
                    long l2 = ((Number)l).longValue();
                    EntityType entityType = com.atlassian.migration.jira.core.Issue.Companion.getEntityType();
                    Long l3 = childIssue.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)l3, (String)"getId(...)");
                    MRI mRI = MriExtensionsKt.mri$default(entityType, l3, null, 2, null);
                    EntityType entityType2 = com.atlassian.migration.jira.core.Issue.Companion.getEntityType();
                    Long l4 = this.$issue.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)l4, (String)"getId(...)");
                    issueParentAssociationWrapper = new IssueParentAssociationWrapper(l2, mRI, MriExtensionsKt.mri$default(entityType2, l4, null, 2, null), IssueParentAssociationType.PARENT_LINK);
                } else {
                    issueParentAssociationWrapper = null;
                }
                return issueParentAssociationWrapper;
            }
        }));
    }

    private final Sequence<IssueParentAssociationWrapper> getParentLink(Issue issue2) {
        Sequence sequence;
        Long parentIssueId = this.rawIssuePropertiesReader.parentId(issue2);
        if (parentIssueId != null) {
            Object[] objectArray = new IssueParentAssociationWrapper[1];
            Long l = issue2.getId();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
            long l2 = ((Number)l).longValue();
            EntityType entityType = com.atlassian.migration.jira.core.Issue.Companion.getEntityType();
            Long l3 = issue2.getId();
            Intrinsics.checkNotNullExpressionValue((Object)l3, (String)"getId(...)");
            objectArray[0] = new IssueParentAssociationWrapper(l2, MriExtensionsKt.mri$default(entityType, l3, null, 2, null), MriExtensionsKt.mri$default(com.atlassian.migration.jira.core.Issue.Companion.getEntityType(), parentIssueId, null, 2, null), IssueParentAssociationType.PARENT_LINK);
            sequence = SequencesKt.sequenceOf((Object[])objectArray);
        } else {
            sequence = SequencesKt.emptySequence();
        }
        return sequence;
    }

    public static final /* synthetic */ Sequence access$getParentLink(ParentLinkReader $this, Issue issue2) {
        return $this.getParentLink(issue2);
    }

    public static final /* synthetic */ Sequence access$getChildLinks(ParentLinkReader $this, Issue issue2, Boolean migrateArchivedIssues) {
        return $this.getChildLinks(issue2, migrateArchivedIssues);
    }

    public static final /* synthetic */ RawIssuePropertiesReader access$getRawIssuePropertiesReader$p(ParentLinkReader $this) {
        return $this.rawIssuePropertiesReader;
    }
}

