/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.amcyclient;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.migration.MigrationServicesConfiguration;
import com.atlassian.jira.migration.amcyclient.VendorConfigDto;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.context.RequestContextBuilder;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.httpclient.AbstractPluginHttpClientKt;
import com.atlassian.jira.migration.httpclient.MigrationPluginHttpClientGson;
import com.atlassian.jira.migration.httpclient.MigrationPluginHttpRequest;
import com.atlassian.jira.migration.httpclient.exceptions.UnexpectedStatusCodeException;
import com.atlassian.jira.migration.platform.GsonFactory;
import com.atlassian.migration.app.AppMigrationServiceClientKt;
import java.net.URI;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B'\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000eH\u0002J$\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000eJ\u001c\u0010\u001c\u001a\u00020\u0016*\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u000eH\u0002R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/atlassian/jira/migration/amcyclient/AmcyClient;", "", "migrationServicesConfiguration", "Lcom/atlassian/jira/migration/MigrationServicesConfiguration;", "gsonFactory", "Lcom/atlassian/jira/migration/platform/GsonFactory;", "requestContextBuilder", "Lcom/atlassian/jira/migration/context/RequestContextBuilder;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "(Lcom/atlassian/jira/migration/MigrationServicesConfiguration;Lcom/atlassian/jira/migration/platform/GsonFactory;Lcom/atlassian/jira/migration/context/RequestContextBuilder;Lcom/atlassian/jira/migration/discovery/DiscoveryService;)V", "httpClient", "Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpClientGson;", "userAgentString", "", "(Lcom/atlassian/jira/migration/MigrationServicesConfiguration;Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpClientGson;Ljava/lang/String;Lcom/atlassian/jira/migration/discovery/DiscoveryService;)V", "baseUrl", "Ljava/net/URI;", "execute", "Ljava/util/Optional;", "Lcom/atlassian/jira/migration/amcyclient/VendorConfigDto;", "requestConfig", "Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpRequest;", "getContainerToken", "cloudId", "getVendorConfigForCloudAppKey", "serverAppKey", "cloudAppKey", "withDefaultHeaders", "containerToken", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAmcyClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AmcyClient.kt\ncom/atlassian/jira/migration/amcyclient/AmcyClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n1#2:95\n*E\n"})
public final class AmcyClient {
    @NotNull
    private final MigrationPluginHttpClientGson httpClient;
    @NotNull
    private final String userAgentString;
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final URI baseUrl;

    @VisibleForTesting
    public AmcyClient(@NotNull MigrationServicesConfiguration migrationServicesConfiguration, @NotNull MigrationPluginHttpClientGson httpClient, @NotNull String userAgentString, @NotNull DiscoveryService discoveryService) {
        Intrinsics.checkNotNullParameter((Object)migrationServicesConfiguration, (String)"migrationServicesConfiguration");
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)userAgentString, (String)"userAgentString");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        this.httpClient = httpClient;
        this.userAgentString = userAgentString;
        this.discoveryService = discoveryService;
        this.baseUrl = migrationServicesConfiguration.getAppMigrationTransformDefinitionURI();
    }

    @Inject
    public AmcyClient(@NotNull MigrationServicesConfiguration migrationServicesConfiguration, @NotNull GsonFactory gsonFactory, @NotNull RequestContextBuilder requestContextBuilder, @NotNull DiscoveryService discoveryService) {
        Intrinsics.checkNotNullParameter((Object)migrationServicesConfiguration, (String)"migrationServicesConfiguration");
        Intrinsics.checkNotNullParameter((Object)gsonFactory, (String)"gsonFactory");
        Intrinsics.checkNotNullParameter((Object)requestContextBuilder, (String)"requestContextBuilder");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        this(migrationServicesConfiguration, new MigrationPluginHttpClientGson(gsonFactory.createGson()), requestContextBuilder.getUserAgent(), discoveryService);
    }

    private final String getContainerToken(String cloudId2) {
        CloudSite cloudSite2 = this.discoveryService.retrieveCloudSiteForCloudId(cloudId2);
        if (cloudSite2 == null) {
            boolean bl = false;
            String string = "Failed to find cloudSite entry for requested cloudId: " + cloudId2;
            throw new IllegalArgumentException(string.toString());
        }
        return cloudSite2.getContainerToken();
    }

    @NotNull
    public final Optional<VendorConfigDto> getVendorConfigForCloudAppKey(@NotNull String serverAppKey, @NotNull String cloudAppKey, @NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)serverAppKey, (String)"serverAppKey");
        Intrinsics.checkNotNullParameter((Object)cloudAppKey, (String)"cloudAppKey");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        URI uRI = AbstractPluginHttpClientKt.prepareURI$default(this.baseUrl, '/' + serverAppKey + '/' + cloudAppKey, new String[0], null, 8, null).build(new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"build(...)");
        return this.execute(this.withDefaultHeaders(new MigrationPluginHttpRequest("GET", uRI, null, null, null, null, 60, null), cloudId2, this.getContainerToken(cloudId2)));
    }

    private final MigrationPluginHttpRequest withDefaultHeaders(MigrationPluginHttpRequest $this$withDefaultHeaders, String cloudId2, String containerToken) {
        MigrationPluginHttpRequest migrationPluginHttpRequest;
        MigrationPluginHttpRequest $this$withDefaultHeaders_u24lambda_u241 = migrationPluginHttpRequest = $this$withDefaultHeaders;
        boolean bl = false;
        $this$withDefaultHeaders_u24lambda_u241.authorization("Bearer " + containerToken);
        $this$withDefaultHeaders_u24lambda_u241.addHeader("Cloud-Id", cloudId2);
        $this$withDefaultHeaders_u24lambda_u241.addUserAgent(this.userAgentString);
        $this$withDefaultHeaders_u24lambda_u241.acceptsJson();
        $this$withDefaultHeaders_u24lambda_u241.contentTypeJson();
        return migrationPluginHttpRequest;
    }

    private final Optional<VendorConfigDto> execute(MigrationPluginHttpRequest requestConfig) {
        try {
            Optional<VendorConfigDto> optional = Optional.of(this.httpClient.execute(requestConfig, VendorConfigDto.class));
            Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
            return optional;
        }
        catch (UnexpectedStatusCodeException unexpectedStatusCodeException) {
            if (unexpectedStatusCodeException.getStatusCode() == 404) {
                Optional<VendorConfigDto> optional = Optional.empty();
                Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
                return optional;
            }
            throw AppMigrationServiceClientKt.handleHttpServiceException((int)unexpectedStatusCodeException.getStatusCode(), (RuntimeException)unexpectedStatusCodeException);
        }
    }
}

