/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.analytics;

import com.atlassian.cmpt.analytics.AnalyticsProduct;
import com.atlassian.jira.migration.MigrationServicesConfiguration;
import com.atlassian.jira.migration.analytics.AnalyticsResult;
import com.atlassian.jira.migration.analytics.MigrationAnalyticsEvent;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.httpclient.MigrationPluginHttpClient;
import com.atlassian.jira.migration.httpclient.MigrationPluginHttpRequest;
import com.atlassian.jira.migration.httpclient.MigrationUserAgentProvider;
import com.atlassian.jira.migration.httpclient.exceptions.HttpCommunicationException;
import com.atlassian.jira.migration.httpclient.exceptions.HttpProtocolException;
import com.atlassian.jira.migration.httpclient.exceptions.UnexpectedStatusCodeException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B\u001f\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ$\u0010\u000e\u001a\u00020\u000f\"\u0004\b\u0000\u0010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0002J\u001c\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dJ\u0014\u0010\u001f\u001a\u00020\u0012*\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/atlassian/jira/migration/analytics/AnalyticsClient;", "", "migrationServicesConfiguration", "Lcom/atlassian/jira/migration/MigrationServicesConfiguration;", "userAgentProvider", "Lcom/atlassian/jira/migration/httpclient/MigrationUserAgentProvider;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/jira/migration/MigrationServicesConfiguration;Lcom/atlassian/jira/migration/httpclient/MigrationUserAgentProvider;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "httpClient", "Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpClient;", "(Lcom/atlassian/jira/migration/MigrationServicesConfiguration;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpClient;)V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "execute", "Lcom/atlassian/jira/migration/analytics/AnalyticsResult;", "T", "request", "Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpRequest;", "responseClass", "Ljava/lang/Class;", "getMigrationAnalyticsEndpoint", "Ljava/net/URI;", "resolveMigrationAnalyticsEndpoint", "baseURI", "sendEvents", "containerToken", "", "dbEvents", "", "Lcom/atlassian/jira/migration/analytics/MigrationAnalyticsEvent;", "withDefaultHeaders", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAnalyticsClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalyticsClient.kt\ncom/atlassian/jira/migration/analytics/AnalyticsClient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,116:1\n1603#2,9:117\n1855#2:126\n1856#2:130\n1612#2:131\n1#3:127\n1#3:129\n51#4:128\n*S KotlinDebug\n*F\n+ 1 AnalyticsClient.kt\ncom/atlassian/jira/migration/analytics/AnalyticsClient\n*L\n52#1:117,9\n52#1:126\n52#1:130\n52#1:131\n52#1:129\n53#1:128\n*E\n"})
public final class AnalyticsClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationServicesConfiguration migrationServicesConfiguration;
    @NotNull
    private final MigrationPluginHttpClient httpClient;
    @NotNull
    private final ObjectMapper objectMapper;
    private static final Logger log = LoggerFactory.getLogger(AnalyticsClient.class);

    public AnalyticsClient(@NotNull MigrationServicesConfiguration migrationServicesConfiguration, @NotNull ObjectMapperFactory objectMapperFactory, @NotNull MigrationPluginHttpClient httpClient) {
        Intrinsics.checkNotNullParameter((Object)migrationServicesConfiguration, (String)"migrationServicesConfiguration");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        this.migrationServicesConfiguration = migrationServicesConfiguration;
        this.httpClient = httpClient;
        this.objectMapper = objectMapperFactory.createObjectMapper();
        URI migrationAnalyticEndpoint = this.getMigrationAnalyticsEndpoint();
        log.info("Migration analytics service base url: " + migrationAnalyticEndpoint);
    }

    @Inject
    public AnalyticsClient(@NotNull MigrationServicesConfiguration migrationServicesConfiguration, @NotNull MigrationUserAgentProvider userAgentProvider, @NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)migrationServicesConfiguration, (String)"migrationServicesConfiguration");
        Intrinsics.checkNotNullParameter((Object)userAgentProvider, (String)"userAgentProvider");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        this(migrationServicesConfiguration, objectMapperFactory, new MigrationPluginHttpClient(userAgentProvider, objectMapperFactory.createObjectMapper()));
    }

    private final URI getMigrationAnalyticsEndpoint() {
        URI baseURI = this.migrationServicesConfiguration.getMigrationAnalyticsServiceBaseURI();
        return this.resolveMigrationAnalyticsEndpoint(baseURI);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AnalyticsResult sendEvents(@NotNull String containerToken, @NotNull List<? extends MigrationAnalyticsEvent> dbEvents) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter(dbEvents, (String)"dbEvents");
        Iterable $this$mapNotNull$iv = dbEvents;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Map map;
            Object $this$sendEvents_u24lambda_u243_u24lambda_u240;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            MigrationAnalyticsEvent dbEvent = (MigrationAnalyticsEvent)element$iv$iv;
            boolean bl2 = false;
            Object object = this;
            try {
                $this$sendEvents_u24lambda_u243_u24lambda_u240 = object;
                boolean bl3 = false;
                boolean $i$f$jacksonTypeRef = false;
                $this$sendEvents_u24lambda_u243_u24lambda_u240 = Result.constructor-impl((Object)((Map)((AnalyticsClient)$this$sendEvents_u24lambda_u243_u24lambda_u240).objectMapper.readValue(dbEvent.getEvent(), (TypeReference)new TypeReference<Map<String, ? extends Object>>(){})));
            }
            catch (Throwable bl3) {
                $this$sendEvents_u24lambda_u243_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl3));
            }
            object = $this$sendEvents_u24lambda_u243_u24lambda_u240;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Object it = $this$sendEvents_u24lambda_u243_u24lambda_u240 = throwable;
                boolean bl4 = false;
                log.warn("Skipping analytics event that couldn't be deserialized: " + it);
            }
            Map map2 = (Map)(Result.isFailure-impl((Object)object) ? null : object);
            if (map2 != null) {
                Map it = map2;
                boolean bl5 = false;
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"eventType", (Object)dbEvent.getEventType()), TuplesKt.to((Object)"event", (Object)it)};
                map = MapsKt.mapOf((Pair[])pairArray);
            } else {
                map = null;
            }
            if (map == null) continue;
            Map it$iv$iv = map;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List events = (List)destination$iv$iv;
        return this.execute(this.withDefaultHeaders(new MigrationPluginHttpRequest("POST", this.getMigrationAnalyticsEndpoint(), null, events, null, null, 52, null), containerToken), Boolean.TYPE);
    }

    private final MigrationPluginHttpRequest withDefaultHeaders(MigrationPluginHttpRequest $this$withDefaultHeaders, String containerToken) {
        block0: {
            Object object;
            log.debug("Requesting: {}", (Object)$this$withDefaultHeaders.getUri());
            $this$withDefaultHeaders.authorization("Bearer " + containerToken);
            Object object2 = $this$withDefaultHeaders.getBody();
            if (object2 == null) break block0;
            Object $this$withDefaultHeaders_u24lambda_u244 = object = object2;
            boolean bl = false;
            $this$withDefaultHeaders.contentTypeJson();
        }
        return $this$withDefaultHeaders.acceptsJson();
    }

    private final <T> AnalyticsResult execute(MigrationPluginHttpRequest request, Class<T> responseClass) {
        AnalyticsResult analyticsResult;
        try {
            this.httpClient.execute(request, responseClass);
            analyticsResult = AnalyticsResult.Success.INSTANCE;
        }
        catch (UnexpectedStatusCodeException e) {
            AnalyticsResult analyticsResult2;
            if (e.getStatusCode() == 401) {
                analyticsResult2 = AnalyticsResult.UnauthorizedError.INSTANCE;
            } else {
                log.warn("AnalyticsClient Unexpected statues code", (Throwable)e);
                analyticsResult2 = AnalyticsResult.UnhandledError.INSTANCE;
            }
            analyticsResult = analyticsResult2;
        }
        catch (HttpProtocolException e) {
            log.warn("AnalyticsClient protocol violation error", (Throwable)e);
            analyticsResult = AnalyticsResult.UnhandledError.INSTANCE;
        }
        catch (HttpCommunicationException e) {
            log.warn("AnalyticsClient failed to send a request to server", (Throwable)e);
            analyticsResult = AnalyticsResult.UnhandledError.INSTANCE;
        }
        return analyticsResult;
    }

    private final URI resolveMigrationAnalyticsEndpoint(URI baseURI) {
        URI uRI = baseURI.resolve("/migration/analytics/" + AnalyticsProduct.JIRA.getProductNameV2() + "/event");
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"resolve(...)");
        return uRI;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/analytics/AnalyticsClient$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

