/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.analytics;

import com.atlassian.jira.migration.analytics.AnalyticsClient;
import com.atlassian.jira.migration.analytics.AnalyticsEventDispatcher;
import com.atlassian.jira.migration.analytics.AnalyticsEventDispatcherKt;
import com.atlassian.jira.migration.analytics.AnalyticsEventRepository;
import com.atlassian.jira.migration.analytics.AnalyticsEventService;
import com.atlassian.jira.migration.analytics.AnalyticsResult;
import com.atlassian.jira.migration.analytics.MigrationAnalyticsEvent;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import io.prometheus.metrics.core.metrics.Histogram;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0007J\b\u0010\u000f\u001a\u00020\u000eH\u0007J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010\u0014\u001a\u00020\u000e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\"\u0010\u0018\u001a\u00020\u000e*\u00020\u00192\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/atlassian/jira/migration/analytics/AnalyticsEventDispatcher;", "Lcom/atlassian/scheduler/JobRunner;", "analyticsClient", "Lcom/atlassian/jira/migration/analytics/AnalyticsClient;", "analyticsEventRepository", "Lcom/atlassian/jira/migration/analytics/AnalyticsEventRepository;", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "schedulerService", "Lcom/atlassian/scheduler/SchedulerService;", "analyticsEventService", "Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;", "(Lcom/atlassian/jira/migration/analytics/AnalyticsClient;Lcom/atlassian/jira/migration/analytics/AnalyticsEventRepository;Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/scheduler/SchedulerService;Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;)V", "cleanup", "", "postConstruct", "runJob", "Lcom/atlassian/scheduler/JobRunnerResponse;", "jobRunnerRequest", "Lcom/atlassian/scheduler/JobRunnerRequest;", "sendEventAndClean", "events", "", "Lcom/atlassian/jira/migration/analytics/MigrationAnalyticsEvent;", "deleteIfSuccess", "Lcom/atlassian/jira/migration/analytics/AnalyticsResult;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAnalyticsEventDispatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalyticsEventDispatcher.kt\ncom/atlassian/jira/migration/analytics/AnalyticsEventDispatcher\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,149:1\n1313#2,2:150\n179#2,2:152\n*S KotlinDebug\n*F\n+ 1 AnalyticsEventDispatcher.kt\ncom/atlassian/jira/migration/analytics/AnalyticsEventDispatcher\n*L\n102#1:150,2\n114#1:152,2\n*E\n"})
public final class AnalyticsEventDispatcher
implements JobRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnalyticsClient analyticsClient;
    @NotNull
    private final AnalyticsEventRepository analyticsEventRepository;
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;
    @NotNull
    private final SchedulerService schedulerService;
    @NotNull
    private final AnalyticsEventService analyticsEventService;
    @NotNull
    private static final JobRunnerKey JOB_RUNNER_KEY;
    @NotNull
    private static final JobId JOB_ID;
    private static final Logger log;

    @Inject
    public AnalyticsEventDispatcher(@NotNull AnalyticsClient analyticsClient, @NotNull AnalyticsEventRepository analyticsEventRepository, @NotNull CloudSiteRepository cloudSiteRepository, @NotNull SchedulerService schedulerService, @NotNull AnalyticsEventService analyticsEventService) {
        Intrinsics.checkNotNullParameter((Object)analyticsClient, (String)"analyticsClient");
        Intrinsics.checkNotNullParameter((Object)analyticsEventRepository, (String)"analyticsEventRepository");
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)schedulerService, (String)"schedulerService");
        Intrinsics.checkNotNullParameter((Object)analyticsEventService, (String)"analyticsEventService");
        this.analyticsClient = analyticsClient;
        this.analyticsEventRepository = analyticsEventRepository;
        this.cloudSiteRepository = cloudSiteRepository;
        this.schedulerService = schedulerService;
        this.analyticsEventService = analyticsEventService;
    }

    @PostConstruct
    public final void postConstruct() {
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)this);
        this.schedulerService.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)TimeUnit.HOURS.toMillis(1L), (Date)Date.from(Instant.now().plus(Duration.ofMinutes(5L))))));
        log.info("Successfully registered analytics event dispatcher job " + JOB_RUNNER_KEY);
    }

    @Nullable
    public JobRunnerResponse runJob(@NotNull JobRunnerRequest jobRunnerRequest) {
        JobRunnerResponse jobRunnerResponse;
        Intrinsics.checkNotNullParameter((Object)jobRunnerRequest, (String)"jobRunnerRequest");
        long startTime = System.nanoTime();
        log.info("Analytics event dispatching job started at " + Instant.now() + " jobId=" + jobRunnerRequest.getJobId());
        Histogram histogram = AnalyticsEventDispatcherKt.getAnalyticsTimingHistogram();
        if (this.analyticsEventService.isUserNotAgreed()) {
            jobRunnerResponse = JobRunnerResponse.success((String)"User has not agreed with sending analytics");
        } else {
            JobRunnerResponse jobRunnerResponse2;
            JobRunnerResponse jobRunnerResponse3 = jobRunnerResponse2 = this.sendEventAndClean(jobRunnerRequest);
            Histogram histogram2 = histogram;
            boolean bl = false;
            long elapsedTime2 = System.nanoTime() - startTime;
            log.info("Analytics event dispatching job Id=" + jobRunnerRequest.getJobId() + " finished at " + Instant.now() + ", total time taken " + TimeUnit.SECONDS.convert(elapsedTime2, TimeUnit.NANOSECONDS) + " seconds.");
            histogram = histogram2;
            jobRunnerResponse = jobRunnerResponse2;
        }
        return jobRunnerResponse;
    }

    private final JobRunnerResponse sendEventAndClean(JobRunnerRequest jobRunnerRequest) {
        Sequence $this$forEach$iv = SequencesKt.chunked(this.analyticsEventRepository.availableEvents(), (int)100);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List events = (List)element$iv;
            boolean bl = false;
            this.sendEventAndClean(events, jobRunnerRequest);
        }
        JobRunnerResponse jobRunnerResponse = JobRunnerResponse.success((String)"Analytics event dispatching job finished without sending events due to valid container token missing");
        Intrinsics.checkNotNullExpressionValue((Object)jobRunnerResponse, (String)"success(...)");
        return jobRunnerResponse;
    }

    private final void sendEventAndClean(List<? extends MigrationAnalyticsEvent> events, JobRunnerRequest jobRunnerRequest) {
        Sequence $this$firstOrNull$iv = SequencesKt.map((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.cloudSiteRepository.findAll()), (Function1)((Function1)sendEventAndClean.2.INSTANCE)), (Function1)((Function1)new Function1<String, AnalyticsResult>(this, events, jobRunnerRequest){
            final /* synthetic */ AnalyticsEventDispatcher this$0;
            final /* synthetic */ List<MigrationAnalyticsEvent> $events;
            final /* synthetic */ JobRunnerRequest $jobRunnerRequest;
            {
                this.this$0 = $receiver;
                this.$events = $events;
                this.$jobRunnerRequest = $jobRunnerRequest;
                super(1);
            }

            @NotNull
            public final AnalyticsResult invoke(@NotNull String containerToken) {
                Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
                AnalyticsResult analyticsResult = AnalyticsEventDispatcher.access$getAnalyticsClient$p(this.this$0).sendEvents(containerToken, this.$events);
                AnalyticsEventDispatcher analyticsEventDispatcher = this.this$0;
                List<MigrationAnalyticsEvent> list = this.$events;
                JobRunnerRequest jobRunnerRequest = this.$jobRunnerRequest;
                AnalyticsResult $this$invoke_u24lambda_u240 = analyticsResult;
                boolean bl = false;
                AnalyticsEventDispatcher.access$deleteIfSuccess(analyticsEventDispatcher, $this$invoke_u24lambda_u240, list, jobRunnerRequest);
                return analyticsResult;
            }
        }));
        boolean $i$f$firstOrNull = false;
        for (Object element$iv : $this$firstOrNull$iv) {
            AnalyticsResult it = (AnalyticsResult)element$iv;
            boolean bl = false;
            if (!(it instanceof AnalyticsResult.Success)) continue;
            break;
        }
    }

    private final void deleteIfSuccess(AnalyticsResult $this$deleteIfSuccess, List<? extends MigrationAnalyticsEvent> events, JobRunnerRequest jobRunnerRequest) {
        AnalyticsResult analyticsResult = $this$deleteIfSuccess;
        if (Intrinsics.areEqual((Object)analyticsResult, (Object)AnalyticsResult.Success.INSTANCE)) {
            this.analyticsEventRepository.deleteEvents(events);
            AnalyticsEventDispatcherKt.access$getEventsSent$p().inc((double)events.size());
        } else if (Intrinsics.areEqual((Object)analyticsResult, (Object)AnalyticsResult.UnauthorizedError.INSTANCE)) {
            log.warn("Analytics event dispatching job, trying another container token jobId=" + jobRunnerRequest.getJobId());
            AnalyticsEventDispatcherKt.access$getEventsFailed$p().inc((double)events.size());
        } else if (Intrinsics.areEqual((Object)analyticsResult, (Object)AnalyticsResult.UnhandledError.INSTANCE)) {
            log.warn("Analytics event dispatching job error jobId=" + jobRunnerRequest.getJobId());
            AnalyticsEventDispatcherKt.access$getEventsFailed$p().inc((double)events.size());
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @PreDestroy
    public final void cleanup() {
        this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
        log.info("Successfully unregistered analytics even dispatcher job " + JOB_RUNNER_KEY);
    }

    public static final /* synthetic */ AnalyticsClient access$getAnalyticsClient$p(AnalyticsEventDispatcher $this) {
        return $this.analyticsClient;
    }

    public static final /* synthetic */ void access$deleteIfSuccess(AnalyticsEventDispatcher $this, AnalyticsResult $receiver, List events, JobRunnerRequest jobRunnerRequest) {
        $this.deleteIfSuccess($receiver, events, jobRunnerRequest);
    }

    static {
        JobRunnerKey jobRunnerKey = JobRunnerKey.of((String)"jira-migration-analytics-events-dispatcher-job-key");
        Intrinsics.checkNotNull((Object)jobRunnerKey);
        JOB_RUNNER_KEY = jobRunnerKey;
        JobId jobId = JobId.of((String)"jira-migration-analytics-events-dispatcher-job-id");
        Intrinsics.checkNotNull((Object)jobId);
        JOB_ID = jobId;
        log = LoggerFactory.getLogger(AnalyticsEventDispatcher.class);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/jira/migration/analytics/AnalyticsEventDispatcher$Companion;", "", "()V", "JOB_ID", "Lcom/atlassian/scheduler/config/JobId;", "getJOB_ID", "()Lcom/atlassian/scheduler/config/JobId;", "JOB_RUNNER_KEY", "Lcom/atlassian/scheduler/config/JobRunnerKey;", "getJOB_RUNNER_KEY", "()Lcom/atlassian/scheduler/config/JobRunnerKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JobRunnerKey getJOB_RUNNER_KEY() {
            return JOB_RUNNER_KEY;
        }

        @NotNull
        public final JobId getJOB_ID() {
            return JOB_ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

