/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.analytics;

import com.atlassian.analytics.api.services.AnalyticsConfigService;
import com.atlassian.jira.migration.analytics.AnalyticsClient;
import com.atlassian.jira.migration.analytics.AnalyticsEventRepository;
import com.atlassian.jira.migration.analytics.MigrationAnalyticsEvent;
import com.atlassian.jira.migration.containerToken.ContainerTokenValidator;
import com.atlassian.jira.migration.legal.LegalService;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0006\u0010\u0012\u001a\u00020\u000eJ\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/atlassian/jira/migration/analytics/AnalyticsEventMrcService;", "", "analyticsEventRepository", "Lcom/atlassian/jira/migration/analytics/AnalyticsEventRepository;", "containerTokenValidator", "Lcom/atlassian/jira/migration/containerToken/ContainerTokenValidator;", "analyticsConfigService", "Lcom/atlassian/analytics/api/services/AnalyticsConfigService;", "legalService", "Lcom/atlassian/jira/migration/legal/LegalService;", "analyticsClient", "Lcom/atlassian/jira/migration/analytics/AnalyticsClient;", "(Lcom/atlassian/jira/migration/analytics/AnalyticsEventRepository;Lcom/atlassian/jira/migration/containerToken/ContainerTokenValidator;Lcom/atlassian/analytics/api/services/AnalyticsConfigService;Lcom/atlassian/jira/migration/legal/LegalService;Lcom/atlassian/jira/migration/analytics/AnalyticsClient;)V", "deleteEvents", "", "events", "", "Lcom/atlassian/jira/migration/analytics/MigrationAnalyticsEvent;", "flushAllAnalytics", "isUserNotAgreed", "", "sendEvents", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAnalyticsEventMrcService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalyticsEventMrcService.kt\ncom/atlassian/jira/migration/analytics/AnalyticsEventMrcService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,56:1\n1855#2,2:57\n*S KotlinDebug\n*F\n+ 1 AnalyticsEventMrcService.kt\ncom/atlassian/jira/migration/analytics/AnalyticsEventMrcService\n*L\n38#1:57,2\n*E\n"})
public class AnalyticsEventMrcService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnalyticsEventRepository analyticsEventRepository;
    @NotNull
    private final ContainerTokenValidator containerTokenValidator;
    @NotNull
    private final AnalyticsConfigService analyticsConfigService;
    @NotNull
    private final LegalService legalService;
    @NotNull
    private final AnalyticsClient analyticsClient;
    private static final Logger log = LoggerFactory.getLogger(AnalyticsEventMrcService.class);
    private static final int CHUNK_SIZE = 100;

    @Inject
    public AnalyticsEventMrcService(@NotNull AnalyticsEventRepository analyticsEventRepository, @NotNull ContainerTokenValidator containerTokenValidator, @NotNull AnalyticsConfigService analyticsConfigService, @NotNull LegalService legalService, @NotNull AnalyticsClient analyticsClient) {
        Intrinsics.checkNotNullParameter((Object)analyticsEventRepository, (String)"analyticsEventRepository");
        Intrinsics.checkNotNullParameter((Object)containerTokenValidator, (String)"containerTokenValidator");
        Intrinsics.checkNotNullParameter((Object)analyticsConfigService, (String)"analyticsConfigService");
        Intrinsics.checkNotNullParameter((Object)legalService, (String)"legalService");
        Intrinsics.checkNotNullParameter((Object)analyticsClient, (String)"analyticsClient");
        this.analyticsEventRepository = analyticsEventRepository;
        this.containerTokenValidator = containerTokenValidator;
        this.analyticsConfigService = analyticsConfigService;
        this.legalService = legalService;
        this.analyticsClient = analyticsClient;
    }

    public final void flushAllAnalytics() {
        List events = SequencesKt.toList(this.analyticsEventRepository.availableEvents());
        if (this.isUserNotAgreed()) {
            log.debug("User has not agreed with sending analytics");
        } else {
            this.sendEvents(events);
        }
        this.deleteEvents(events);
    }

    /*
     * WARNING - void declaration
     */
    private final void sendEvents(List<? extends MigrationAnalyticsEvent> events) {
        try {
            String containerToken;
            String string = containerToken = this.containerTokenValidator.getValidContainerToken();
            if (string != null) {
                void $this$forEach$iv;
                String it = string;
                boolean bl = false;
                log.debug("Sending all analytic events to cloud.");
                Iterable iterable = CollectionsKt.chunked((Iterable)events, (int)100);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    List chunk = (List)element$iv;
                    boolean bl2 = false;
                    this.analyticsClient.sendEvents(it, chunk);
                }
            }
        }
        catch (Exception e) {
            log.warn("Could not send all analytic events: " + e);
        }
    }

    private final void deleteEvents(List<? extends MigrationAnalyticsEvent> events) {
        this.analyticsEventRepository.deleteEvents(events);
    }

    public final boolean isUserNotAgreed() {
        return !(this.analyticsConfigService.canCollectAnalytics() | this.legalService.isLegalOptIn());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/analytics/AnalyticsEventMrcService$Companion;", "", "()V", "CHUNK_SIZE", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

