/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.analytics;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.jira.migration.analytics.AnalyticsEventRepository;
import com.atlassian.jira.migration.analytics.MigrationAnalyticsEvent;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import net.java.ao.RawEntity;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0014\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fJ\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/jira/migration/analytics/AnalyticsEventRepository;", "", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "activeObjects", "Lcom/atlassian/activeobjects/external/ActiveObjects;", "(Lcom/atlassian/jira/migration/common/ObjectMapperFactory;Lcom/atlassian/activeobjects/external/ActiveObjects;)V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "availableEvents", "Lkotlin/sequences/Sequence;", "Lcom/atlassian/jira/migration/analytics/MigrationAnalyticsEvent;", "deleteEvents", "", "event", "", "save", "analyticsEvent", "Lcom/atlassian/cmpt/analytics/events/EventDto;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAnalyticsEventRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalyticsEventRepository.kt\ncom/atlassian/jira/migration/analytics/AnalyticsEventRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,63:1\n1855#2:64\n1856#2:67\n37#3,2:65\n*S KotlinDebug\n*F\n+ 1 AnalyticsEventRepository.kt\ncom/atlassian/jira/migration/analytics/AnalyticsEventRepository\n*L\n38#1:64\n38#1:67\n42#1:65,2\n*E\n"})
public final class AnalyticsEventRepository {
    @NotNull
    private final ActiveObjects activeObjects;
    @NotNull
    private final ObjectMapper objectMapper;

    @Inject
    public AnalyticsEventRepository(@NotNull ObjectMapperFactory objectMapperFactory, @NotNull ActiveObjects activeObjects) {
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        Intrinsics.checkNotNullParameter((Object)activeObjects, (String)"activeObjects");
        this.activeObjects = activeObjects;
        this.objectMapper = objectMapperFactory.createObjectMapper();
    }

    @NotNull
    public final MigrationAnalyticsEvent save(@NotNull EventDto analyticsEvent) {
        Intrinsics.checkNotNullParameter((Object)analyticsEvent, (String)"analyticsEvent");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"EVENT_TIMESTAMP", (Object)analyticsEvent.timestamp), TuplesKt.to((Object)"EVENT_TYPE", (Object)analyticsEvent.eventType), TuplesKt.to((Object)"EVENT", (Object)this.objectMapper.writeValueAsString((Object)analyticsEvent))};
        RawEntity rawEntity = this.activeObjects.create(MigrationAnalyticsEvent.class, MapsKt.mapOf((Pair[])pairArray));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntity, (String)"create(...)");
        return (MigrationAnalyticsEvent)rawEntity;
    }

    @NotNull
    public final Sequence<MigrationAnalyticsEvent> availableEvents() {
        RawEntity[] rawEntityArray = this.activeObjects.find(MigrationAnalyticsEvent.class);
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        return ArraysKt.asSequence((Object[])rawEntityArray);
    }

    public final void deleteEvents(@NotNull List<? extends MigrationAnalyticsEvent> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)event, (int)100);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List it = (List)element$iv;
            boolean bl = false;
            Collection $this$toTypedArray$iv = it;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            MigrationAnalyticsEvent[] migrationAnalyticsEventArray = thisCollection$iv.toArray(new MigrationAnalyticsEvent[0]);
            this.activeObjects.deleteWithSQL(MigrationAnalyticsEvent.class, CollectionsKt.joinToString$default((Iterable)it, null, (CharSequence)"ID IN (", (CharSequence)")", (int)0, null, (Function1)deleteEvents.1.1.INSTANCE, (int)25, null), (Object[])Arrays.copyOf(migrationAnalyticsEventArray, migrationAnalyticsEventArray.length));
        }
    }
}

