/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.analytics;

import com.atlassian.analytics.api.services.AnalyticsConfigService;
import com.atlassian.cmpt.analytics.events.CounterMetricEvent;
import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.EventValidationResult;
import com.atlassian.cmpt.analytics.events.GaugeMetricEvent;
import com.atlassian.cmpt.analytics.events.GenericOperationalEvent;
import com.atlassian.cmpt.analytics.events.GenericScreenEvent;
import com.atlassian.cmpt.analytics.events.GenericTrackEvent;
import com.atlassian.cmpt.analytics.events.GenericUiEvent;
import com.atlassian.cmpt.analytics.events.OperationalEventDto;
import com.atlassian.cmpt.analytics.events.ScreenEventDto;
import com.atlassian.cmpt.analytics.events.TimerMetricEvent;
import com.atlassian.cmpt.analytics.events.TrackEventDto;
import com.atlassian.cmpt.analytics.events.UiEventDto;
import com.atlassian.jira.migration.analytics.AnalyticsEventRepository;
import com.atlassian.jira.migration.analytics.MigrationAnalyticsEvent;
import com.atlassian.jira.migration.common.Sink;
import com.atlassian.jira.migration.legal.LegalService;
import com.atlassian.jira.migration.metadataaggregator.providers.JiraServerMetadataProvider;
import com.atlassian.jira.migration.sen.JiraSenInfo;
import com.atlassian.jira.migration.sen.SENSupplier;
import com.atlassian.jira.migration.version.JiraMigrationVersionService;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 !2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001!B7\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ$\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00022\u0012\u0010\u0013\u001a\u000e\u0012\u0002\b\u0003\u0012\u0006\b\u0001\u0012\u00020\u00020\u0014H\u0002J$\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00022\u0012\u0010\u0013\u001a\u000e\u0012\u0002\b\u0003\u0012\u0006\b\u0001\u0012\u00020\u00020\u0014H\u0002J\"\u0010\u0016\u001a\n \u0017*\u0004\u0018\u00010\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00022\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u001bJ\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u0002H\u0016J\u001c\u0010\u001f\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u00022\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;", "Lcom/atlassian/jira/migration/common/Sink;", "Lcom/atlassian/cmpt/analytics/events/EventDto;", "analyticsEventRepository", "Lcom/atlassian/jira/migration/analytics/AnalyticsEventRepository;", "analyticsConfigService", "Lcom/atlassian/analytics/api/services/AnalyticsConfigService;", "legalService", "Lcom/atlassian/jira/migration/legal/LegalService;", "senSupplier", "Lcom/atlassian/jira/migration/sen/SENSupplier;", "jiraMigrationVersionService", "Lcom/atlassian/jira/migration/version/JiraMigrationVersionService;", "jiraServerMetadataProvider", "Lcom/atlassian/jira/migration/metadataaggregator/providers/JiraServerMetadataProvider;", "(Lcom/atlassian/jira/migration/analytics/AnalyticsEventRepository;Lcom/atlassian/analytics/api/services/AnalyticsConfigService;Lcom/atlassian/jira/migration/legal/LegalService;Lcom/atlassian/jira/migration/sen/SENSupplier;Lcom/atlassian/jira/migration/version/JiraMigrationVersionService;Lcom/atlassian/jira/migration/metadataaggregator/providers/JiraServerMetadataProvider;)V", "addIsInternalContext", "", "event", "builder", "Lcom/atlassian/cmpt/analytics/events/EventDto$Builder;", "enrichEventWithServerContext", "enrichWithCommonAttributes", "kotlin.jvm.PlatformType", "email", "", "isUserAgreed", "", "isUserNotAgreed", "put", "data", "saveAnalyticsEvent", "Lcom/atlassian/jira/migration/analytics/MigrationAnalyticsEvent;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAnalyticsEventService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalyticsEventService.kt\ncom/atlassian/jira/migration/analytics/AnalyticsEventService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n1#2:114\n*E\n"})
public class AnalyticsEventService
implements Sink<EventDto> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnalyticsEventRepository analyticsEventRepository;
    @NotNull
    private final AnalyticsConfigService analyticsConfigService;
    @NotNull
    private final LegalService legalService;
    @NotNull
    private final SENSupplier senSupplier;
    @NotNull
    private final JiraMigrationVersionService jiraMigrationVersionService;
    @NotNull
    private final JiraServerMetadataProvider jiraServerMetadataProvider;
    @NotNull
    private static final Set<KClass<? extends EventDto>> eventsToEnrichWithServerContext;

    @Inject
    public AnalyticsEventService(@NotNull AnalyticsEventRepository analyticsEventRepository, @NotNull AnalyticsConfigService analyticsConfigService, @NotNull LegalService legalService, @NotNull SENSupplier senSupplier, @NotNull JiraMigrationVersionService jiraMigrationVersionService, @NotNull JiraServerMetadataProvider jiraServerMetadataProvider) {
        Intrinsics.checkNotNullParameter((Object)analyticsEventRepository, (String)"analyticsEventRepository");
        Intrinsics.checkNotNullParameter((Object)analyticsConfigService, (String)"analyticsConfigService");
        Intrinsics.checkNotNullParameter((Object)legalService, (String)"legalService");
        Intrinsics.checkNotNullParameter((Object)senSupplier, (String)"senSupplier");
        Intrinsics.checkNotNullParameter((Object)jiraMigrationVersionService, (String)"jiraMigrationVersionService");
        Intrinsics.checkNotNullParameter((Object)jiraServerMetadataProvider, (String)"jiraServerMetadataProvider");
        this.analyticsEventRepository = analyticsEventRepository;
        this.analyticsConfigService = analyticsConfigService;
        this.legalService = legalService;
        this.senSupplier = senSupplier;
        this.jiraMigrationVersionService = jiraMigrationVersionService;
        this.jiraServerMetadataProvider = jiraServerMetadataProvider;
    }

    @NotNull
    public MigrationAnalyticsEvent saveAnalyticsEvent(@NotNull EventDto event, @Nullable String email) {
        String string;
        EventDto eventDto;
        AnalyticsEventService analyticsEventService;
        AnalyticsEventRepository analyticsEventRepository;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        EventValidationResult $this$saveAnalyticsEvent_u24lambda_u241 = event.validate();
        boolean bl = false;
        if ($this$saveAnalyticsEvent_u24lambda_u241.isValid()) {
            analyticsEventRepository = this.analyticsEventRepository;
            analyticsEventService = this;
            eventDto = event;
            String string2 = email;
            if (string2 != null) {
                CharSequence charSequence;
                CharSequence charSequence2 = string2;
                if (StringsKt.isBlank((CharSequence)charSequence2)) {
                    EventDto eventDto2 = eventDto;
                    AnalyticsEventService analyticsEventService2 = analyticsEventService;
                    AnalyticsEventRepository analyticsEventRepository2 = analyticsEventRepository;
                    boolean bl2 = false;
                    Object var10_10 = null;
                    analyticsEventRepository = analyticsEventRepository2;
                    analyticsEventService = analyticsEventService2;
                    eventDto = eventDto2;
                    charSequence = var10_10;
                } else {
                    charSequence = charSequence2;
                }
                string = (String)charSequence;
            } else {
                string = null;
            }
        } else {
            throw new IllegalArgumentException("Analytics event validation failed. Details: " + $this$saveAnalyticsEvent_u24lambda_u241.getErrorsAsString());
        }
        EventDto eventDto3 = analyticsEventService.enrichWithCommonAttributes(eventDto, string);
        Intrinsics.checkNotNullExpressionValue((Object)eventDto3, (String)"enrichWithCommonAttributes(...)");
        return analyticsEventRepository.save(eventDto3);
    }

    public static /* synthetic */ MigrationAnalyticsEvent saveAnalyticsEvent$default(AnalyticsEventService analyticsEventService, EventDto eventDto, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: saveAnalyticsEvent");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return analyticsEventService.saveAnalyticsEvent(eventDto, string);
    }

    public final boolean isUserNotAgreed() {
        return !this.isUserAgreed();
    }

    public final boolean isUserAgreed() {
        return this.analyticsConfigService.canCollectAnalytics() | this.legalService.isLegalOptIn();
    }

    private final EventDto enrichWithCommonAttributes(EventDto event, String email) {
        EventDto.Builder builder;
        EventDto eventDto = event;
        if (eventDto instanceof ScreenEventDto) {
            builder = (EventDto.Builder)new GenericScreenEvent.Builder((ScreenEventDto)event);
        } else if (eventDto instanceof UiEventDto) {
            builder = (EventDto.Builder)new GenericUiEvent.Builder((UiEventDto)event);
        } else if (eventDto instanceof TrackEventDto) {
            builder = (EventDto.Builder)new GenericTrackEvent.Builder((TrackEventDto)event);
        } else if (eventDto instanceof OperationalEventDto) {
            builder = (EventDto.Builder)new GenericOperationalEvent.Builder((OperationalEventDto)event);
        } else if (eventDto instanceof CounterMetricEvent) {
            Double d = ((CounterMetricEvent)event).value;
            builder = (EventDto.Builder)new CounterMetricEvent.Builder(((CounterMetricEvent)event).name, Double.valueOf(d == null ? 1.0 : d)).tags(((CounterMetricEvent)event).tags);
        } else if (eventDto instanceof TimerMetricEvent) {
            TimerMetricEvent.Builder builder2 = new TimerMetricEvent.Builder(((TimerMetricEvent)event).name);
            Double d = ((TimerMetricEvent)event).value;
            Intrinsics.checkNotNullExpressionValue((Object)d, (String)"value");
            builder = (EventDto.Builder)((TimerMetricEvent.Builder)builder2.value(((Number)d).doubleValue())).tags(((TimerMetricEvent)event).tags);
        } else if (eventDto instanceof GaugeMetricEvent) {
            Double d = ((GaugeMetricEvent)event).value;
            builder = (EventDto.Builder)new GaugeMetricEvent.Builder(((GaugeMetricEvent)event).name, Double.valueOf(d == null ? 1.0 : d)).tags(((GaugeMetricEvent)event).tags);
        } else {
            throw new IllegalArgumentException("Failed to create a builder from event " + event);
        }
        EventDto $this$enrichWithCommonAttributes_u24lambda_u242 = eventDto = builder;
        boolean bl = false;
        JiraSenInfo senInfo = this.senSupplier.getSens();
        $this$enrichWithCommonAttributes_u24lambda_u242.email(email);
        $this$enrichWithCommonAttributes_u24lambda_u242.jiraCoreSen(senInfo.getJiraCoreSen());
        $this$enrichWithCommonAttributes_u24lambda_u242.jiraSoftwareSen(senInfo.getJiraSoftwareSen());
        $this$enrichWithCommonAttributes_u24lambda_u242.jiraServicedeskSen(senInfo.getJiraServicedeskSen());
        $this$enrichWithCommonAttributes_u24lambda_u242.pluginVersion(this.jiraMigrationVersionService.getPluginVersion());
        Intrinsics.checkNotNull((Object)$this$enrichWithCommonAttributes_u24lambda_u242);
        this.addIsInternalContext(event, (EventDto.Builder<?, ? extends EventDto>)$this$enrichWithCommonAttributes_u24lambda_u242);
        this.enrichEventWithServerContext(event, (EventDto.Builder<?, ? extends EventDto>)$this$enrichWithCommonAttributes_u24lambda_u242);
        return eventDto.build();
    }

    private final void addIsInternalContext(EventDto event, EventDto.Builder<?, ? extends EventDto> builder) {
        block0: {
            if (!(event instanceof UiEventDto) && !(event instanceof ScreenEventDto)) break block0;
            builder.addAttribute("isInternalContext", (Object)(this.jiraMigrationVersionService.isTestVersion() || Intrinsics.areEqual((Object)this.senSupplier.getFirstSen(), (Object)"SEN-500") ? 1 : 0));
        }
    }

    private final void enrichEventWithServerContext(EventDto event, EventDto.Builder<?, ? extends EventDto> builder) {
        block0: {
            if (!eventsToEnrichWithServerContext.contains(Reflection.getOrCreateKotlinClass(event.getClass()))) break block0;
            builder.addAttribute("serverId", (Object)this.jiraServerMetadataProvider.getServerId()).addAttribute("licenses", this.jiraServerMetadataProvider.getLicenseDetails());
        }
    }

    @Override
    public void put(@NotNull EventDto data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        AnalyticsEventService.saveAnalyticsEvent$default(this, data2, null, 2, null);
    }

    static {
        Object[] objectArray = new KClass[]{Reflection.getOrCreateKotlinClass(UiEventDto.class), Reflection.getOrCreateKotlinClass(ScreenEventDto.class), Reflection.getOrCreateKotlinClass(TrackEventDto.class), Reflection.getOrCreateKotlinClass(OperationalEventDto.class)};
        eventsToEnrichWithServerContext = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/analytics/AnalyticsEventService$Companion;", "", "()V", "eventsToEnrichWithServerContext", "", "Lkotlin/reflect/KClass;", "Lcom/atlassian/cmpt/analytics/events/EventDto;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

