/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.analytics;

import com.atlassian.cmpt.analytics.events.CounterMetricEvent;
import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.GaugeMetricEvent;
import com.atlassian.cmpt.analytics.events.TimerMetricEvent;
import com.atlassian.jira.migration.analytics.AnalyticsEventService;
import com.atlassian.jira.migration.analytics.rollout.CodePathExecuted;
import com.atlassian.jira.migration.analytics.rollout.RolloutFlagType;
import com.atlassian.jira.migration.analytics.rollout.RolloutResult;
import com.atlassian.jira.migration.orchestratorclient.tasks.MigrationTaskType;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProgressUnit;
import com.atlassian.jira.migration.sen.SENSupplier;
import com.atlassian.jira.migration.tracking.utils.TimeProvider;
import com.atlassian.jira.migration.version.JiraMigrationVersionService;
import com.google.common.annotations.VisibleForTesting;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b!\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\r\b\u0007\u0018\u0000 g2\u00020\u0001:\u0003ghiB'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020.H\u0007J\u001e\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\f2\u0006\u00102\u001a\u0002032\u0006\u0010-\u001a\u00020.J\u0018\u00104\u001a\u0002002\u0006\u00105\u001a\u0002062\b\b\u0002\u00107\u001a\u000208J<\u00109\u001a\u0002002\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\f2\u0006\u0010=\u001a\u00020\f2\u0006\u0010>\u001a\u00020\f2\n\b\u0002\u0010?\u001a\u0004\u0018\u00010\f2\b\b\u0002\u00107\u001a\u000208J \u0010@\u001a\u0002002\u0006\u0010-\u001a\u00020\f2\u0006\u0010A\u001a\u00020\f2\b\b\u0002\u00107\u001a\u000208J \u0010B\u001a\u0002002\u0006\u0010C\u001a\u00020\f2\u0006\u0010<\u001a\u00020\f2\b\b\u0002\u00107\u001a\u000208J\u0018\u0010D\u001a\u0002002\u0006\u0010<\u001a\u00020\f2\b\b\u0002\u00107\u001a\u000208J\u0018\u0010E\u001a\u0002002\u0006\u0010<\u001a\u00020\f2\b\b\u0002\u00107\u001a\u000208J(\u0010F\u001a\u0002002\u0006\u0010G\u001a\u00020\f2\u0006\u0010=\u001a\u00020\f2\u0006\u0010H\u001a\u0002062\b\b\u0002\u00107\u001a\u000208J\u001e\u0010I\u001a\u0002002\u0006\u0010J\u001a\u00020K2\u0006\u00102\u001a\u0002032\u0006\u0010-\u001a\u00020.J \u0010L\u001a\u0002002\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\f2\b\b\u0002\u00107\u001a\u000208J(\u0010L\u001a\u0002002\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\f2\b\b\u0002\u00107\u001a\u0002082\u0006\u0010M\u001a\u00020NJG\u0010O\u001a\u0002002\u0006\u0010<\u001a\u00020P2\u0006\u0010Q\u001a\u00020\f2\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u0002062\u0006\u0010U\u001a\u00020V2\b\b\u0002\u0010W\u001a\u00020\f2\b\u0010X\u001a\u0004\u0018\u000103\u00a2\u0006\u0002\u0010YJ,\u0010Z\u001a\u0002002\u0006\u0010J\u001a\u00020K2\u0006\u0010[\u001a\u0002082\u0014\b\u0002\u0010\\\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0]J \u0010^\u001a\u0002002\u0006\u0010_\u001a\u00020\f2\u0006\u0010-\u001a\u00020\f2\b\b\u0002\u00107\u001a\u000208J>\u0010`\u001a\u0002002\u0006\u0010J\u001a\u00020K2\u0006\u0010<\u001a\u00020\f2\u0006\u0010a\u001a\u0002032\b\b\u0002\u0010b\u001a\u0002032\u0014\b\u0002\u0010c\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0]J,\u0010d\u001a\u0002002\u0006\u0010J\u001a\u00020K2\u0006\u0010[\u001a\u0002032\u0014\b\u0002\u0010\\\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0]J\u0012\u0010e\u001a\u00020\f2\b\b\u0002\u0010f\u001a\u000203H\u0007R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006j"}, d2={"Lcom/atlassian/jira/migration/analytics/MetricsEventService;", "", "jiraMigrationVersionService", "Lcom/atlassian/jira/migration/version/JiraMigrationVersionService;", "analyticsEventService", "Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;", "senSupplier", "Lcom/atlassian/jira/migration/sen/SENSupplier;", "timeProvider", "Lcom/atlassian/jira/migration/tracking/utils/TimeProvider;", "(Lcom/atlassian/jira/migration/version/JiraMigrationVersionService;Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;Lcom/atlassian/jira/migration/sen/SENSupplier;Lcom/atlassian/jira/migration/tracking/utils/TimeProvider;)V", "BUCKET_0_250", "", "BUCKET_10001_17500", "BUCKET_1001_5000", "BUCKET_17501_25000", "BUCKET_25001_50000", "BUCKET_251_500", "BUCKET_50001_PLUS", "BUCKET_5001_10000", "BUCKET_501_1000", "CLOUD_ID", "ENDPOINT", "HTTP_1xx", "HTTP_2xx", "HTTP_3xx", "HTTP_4xx", "HTTP_5xx", "HTTP_xxx", "JIRA", "MIGRATION_CREATOR", "MIGRATION_TASK_TYPE", "PLAN_STATUS", "PREFLIGHT_CHECK_TYPE", "PRE_MIGRATION_REPORT_FF", "PRODUCT", "RESULT", "SIZE", "STATUS", "UNIQUE_PROJECT_IDENTIFIER", "UNIT", "VERSION", "migrationID", "transferID", "maskHttpStatusCode", "status", "", "sendEventForApiPerformance", "", "endpoint", "timeTaken", "", "sendEventForArPlanIncluded", "included", "", "value", "", "sendEventForAttachmentUploadStatus", "migrationTaskType", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/MigrationTaskType;", "result", "cloudId", "migrationId", "transferId", "sendEventForPlanStatus", "migrationCreator", "sendEventForPreflightChecks", "checkType", "sendEventForPreflightProjectErrorDownload", "sendEventForProject", "sendEventForProjectExportHit", "uniqueProjectIdentifier", "preMigrationReportFeatureFlag", "sendEventForPublicPlan", "operationType", "Lcom/atlassian/jira/migration/analytics/MetricsEventService$OperationType;", "sendEventForTask", "unit", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/ProgressUnit;", "sendFFExecutionResult", "Lcom/atlassian/jira/migration/analytics/rollout/RolloutResult;", "featureFlagKey", "featureFlagType", "Lcom/atlassian/jira/migration/analytics/rollout/RolloutFlagType;", "jvmEnabledOverride", "codeExecuted", "Lcom/atlassian/jira/migration/analytics/rollout/CodePathExecuted;", "exceptionClassName", "startTimeMs", "(Lcom/atlassian/jira/migration/analytics/rollout/RolloutResult;Ljava/lang/String;Lcom/atlassian/jira/migration/analytics/rollout/RolloutFlagType;ZLcom/atlassian/jira/migration/analytics/rollout/CodePathExecuted;Ljava/lang/String;Ljava/lang/Long;)V", "sendGaugeEvent", "eventValue", "dimensions", "", "sendMigrationTaskStatusForPlan", "taskType", "sendTimeForOperation", "time", "count", "extraTags", "sendTimerEvent", "sizeToBucket", "size", "Companion", "MetricName", "OperationType", "jira-migration-plugin"})
public final class MetricsEventService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JiraMigrationVersionService jiraMigrationVersionService;
    @NotNull
    private final AnalyticsEventService analyticsEventService;
    @NotNull
    private final SENSupplier senSupplier;
    @NotNull
    private final TimeProvider timeProvider;
    @NotNull
    private final String VERSION;
    @NotNull
    private final String PRODUCT;
    @NotNull
    private final String JIRA;
    @NotNull
    private final String RESULT;
    @NotNull
    private final String SIZE;
    @NotNull
    private final String UNIT;
    @NotNull
    private final String migrationID;
    @NotNull
    private final String transferID;
    @NotNull
    private final String UNIQUE_PROJECT_IDENTIFIER;
    @NotNull
    private final String PRE_MIGRATION_REPORT_FF;
    @NotNull
    private final String CLOUD_ID;
    @NotNull
    private final String PLAN_STATUS;
    @NotNull
    private final String STATUS;
    @NotNull
    private final String ENDPOINT;
    @NotNull
    private final String MIGRATION_CREATOR;
    @NotNull
    private final String BUCKET_0_250;
    @NotNull
    private final String BUCKET_251_500;
    @NotNull
    private final String BUCKET_501_1000;
    @NotNull
    private final String BUCKET_1001_5000;
    @NotNull
    private final String BUCKET_5001_10000;
    @NotNull
    private final String BUCKET_10001_17500;
    @NotNull
    private final String BUCKET_17501_25000;
    @NotNull
    private final String BUCKET_25001_50000;
    @NotNull
    private final String BUCKET_50001_PLUS;
    @NotNull
    private final String HTTP_1xx;
    @NotNull
    private final String HTTP_2xx;
    @NotNull
    private final String HTTP_3xx;
    @NotNull
    private final String HTTP_4xx;
    @NotNull
    private final String HTTP_5xx;
    @NotNull
    private final String HTTP_xxx;
    @NotNull
    private final String PREFLIGHT_CHECK_TYPE;
    @NotNull
    private final String MIGRATION_TASK_TYPE;
    @NotNull
    public static final String EXPORT_COMPRESSION_KEY = "export_compression";
    @NotNull
    public static final String DATA_GENERATION_TYPE_KEY = "data_generation_type";
    @NotNull
    public static final String DATA_GENERATION_TYPE_UNDEFINED = "undefined";
    @NotNull
    public static final String LZ4_TAG = "LZ4";
    @NotNull
    public static final String ZIP_TAG = "ZIP";

    @Inject
    public MetricsEventService(@NotNull JiraMigrationVersionService jiraMigrationVersionService, @NotNull AnalyticsEventService analyticsEventService, @NotNull SENSupplier senSupplier, @NotNull TimeProvider timeProvider) {
        Intrinsics.checkNotNullParameter((Object)jiraMigrationVersionService, (String)"jiraMigrationVersionService");
        Intrinsics.checkNotNullParameter((Object)analyticsEventService, (String)"analyticsEventService");
        Intrinsics.checkNotNullParameter((Object)senSupplier, (String)"senSupplier");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        this.jiraMigrationVersionService = jiraMigrationVersionService;
        this.analyticsEventService = analyticsEventService;
        this.senSupplier = senSupplier;
        this.timeProvider = timeProvider;
        this.VERSION = "version";
        this.PRODUCT = "product";
        this.JIRA = "jira";
        this.RESULT = "result";
        this.SIZE = "size";
        this.UNIT = "unit";
        this.migrationID = "migration_ID";
        this.transferID = "transfer_ID";
        this.UNIQUE_PROJECT_IDENTIFIER = "unique_project_identifier";
        this.PRE_MIGRATION_REPORT_FF = "pre_migration_report_feature_flag";
        this.CLOUD_ID = "cloud_ID";
        this.PLAN_STATUS = "planStatus";
        this.STATUS = "status";
        this.ENDPOINT = "endpoint";
        this.MIGRATION_CREATOR = "migrationCreator";
        this.BUCKET_0_250 = "0-250";
        this.BUCKET_251_500 = "251-500";
        this.BUCKET_501_1000 = "501-1000";
        this.BUCKET_1001_5000 = "1001-5000";
        this.BUCKET_5001_10000 = "5001-10000";
        this.BUCKET_10001_17500 = "10001-17500";
        this.BUCKET_17501_25000 = "17501-25000";
        this.BUCKET_25001_50000 = "25001-50000";
        this.BUCKET_50001_PLUS = "50001+";
        this.HTTP_1xx = "1xx";
        this.HTTP_2xx = "2xx";
        this.HTTP_3xx = "3xx";
        this.HTTP_4xx = "4xx";
        this.HTTP_5xx = "5xx";
        this.HTTP_xxx = "xxx";
        this.PREFLIGHT_CHECK_TYPE = "checktype";
        this.MIGRATION_TASK_TYPE = "tasktype";
    }

    public final void sendFFExecutionResult(@NotNull RolloutResult result2, @NotNull String featureFlagKey, @NotNull RolloutFlagType featureFlagType, boolean jvmEnabledOverride, @NotNull CodePathExecuted codeExecuted, @NotNull String exceptionClassName, @Nullable Long startTimeMs) {
        Intrinsics.checkNotNullParameter((Object)((Object)result2), (String)"result");
        Intrinsics.checkNotNullParameter((Object)featureFlagKey, (String)"featureFlagKey");
        Intrinsics.checkNotNullParameter((Object)((Object)featureFlagType), (String)"featureFlagType");
        Intrinsics.checkNotNullParameter((Object)((Object)codeExecuted), (String)"codeExecuted");
        Intrinsics.checkNotNullParameter((Object)exceptionClassName, (String)"exceptionClassName");
        MetricsEventService metricsEventService = this;
        try {
            MetricsEventService $this$sendFFExecutionResult_u24lambda_u240 = metricsEventService;
            boolean bl = false;
            Pair[] pairArray = new Pair[8];
            String string = result2.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            pairArray[0] = TuplesKt.to((Object)"result", (Object)string);
            pairArray[1] = TuplesKt.to((Object)"feature_flag_key", (Object)featureFlagKey);
            String string2 = featureFlagType.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            pairArray[2] = TuplesKt.to((Object)"feature_flag_type", (Object)string2);
            pairArray[3] = TuplesKt.to((Object)"jvm_enabled_override", (Object)String.valueOf(jvmEnabledOverride));
            String string3 = codeExecuted.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            pairArray[4] = TuplesKt.to((Object)"code_executed", (Object)string3);
            pairArray[5] = TuplesKt.to((Object)"exception_class_name", (Object)exceptionClassName);
            pairArray[6] = TuplesKt.to((Object)"is_test_instance", (Object)String.valueOf($this$sendFFExecutionResult_u24lambda_u240.jiraMigrationVersionService.isTestVersion() || Intrinsics.areEqual((Object)$this$sendFFExecutionResult_u24lambda_u240.senSupplier.getFirstSen(), (Object)"SEN-500")));
            pairArray[7] = TuplesKt.to((Object)"version", (Object)$this$sendFFExecutionResult_u24lambda_u240.jiraMigrationVersionService.getPluginVersion());
            Map tags = MapsKt.mapOf((Pair[])pairArray);
            AnalyticsEventService analyticsEventService = $this$sendFFExecutionResult_u24lambda_u240.analyticsEventService;
            CounterMetricEvent counterMetricEvent = ((CounterMetricEvent.Builder)new CounterMetricEvent.Builder(MetricName.MIGRATION_ROLLOUT_SERVICE_EXECUTION_METRIC.getValue(), Double.valueOf(1.0)).tags(tags)).build();
            Intrinsics.checkNotNullExpressionValue((Object)counterMetricEvent, (String)"build(...)");
            AnalyticsEventService.saveAnalyticsEvent$default(analyticsEventService, (EventDto)counterMetricEvent, null, 2, null);
            if (startTimeMs != null) {
                AnalyticsEventService analyticsEventService2 = $this$sendFFExecutionResult_u24lambda_u240.analyticsEventService;
                TimerMetricEvent timerMetricEvent = ((TimerMetricEvent.Builder)new TimerMetricEvent.Builder(MetricName.MIGRATION_ROLLOUT_SERVICE_TIME_METRIC.getValue(), Long.valueOf($this$sendFFExecutionResult_u24lambda_u240.timeProvider.now().toEpochMilli() - startTimeMs)).tags(tags)).build();
                Intrinsics.checkNotNullExpressionValue((Object)timerMetricEvent, (String)"build(...)");
                AnalyticsEventService.saveAnalyticsEvent$default(analyticsEventService2, (EventDto)timerMetricEvent, null, 2, null);
            }
            Object object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public static /* synthetic */ void sendFFExecutionResult$default(MetricsEventService metricsEventService, RolloutResult rolloutResult, String string, RolloutFlagType rolloutFlagType, boolean bl, CodePathExecuted codePathExecuted, String string2, Long l, int n, Object object) {
        if ((n & 0x20) != 0) {
            string2 = "none";
        }
        metricsEventService.sendFFExecutionResult(rolloutResult, string, rolloutFlagType, bl, codePathExecuted, string2, l);
    }

    public final void sendEventForPlanStatus(@NotNull String status, @NotNull String migrationCreator, double value) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)migrationCreator, (String)"migrationCreator");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)this.PLAN_STATUS, (Object)status), TuplesKt.to((Object)this.VERSION, (Object)this.jiraMigrationVersionService.getPluginVersion()), TuplesKt.to((Object)this.PRODUCT, (Object)this.JIRA), TuplesKt.to((Object)this.MIGRATION_CREATOR, (Object)migrationCreator)};
        CounterMetricEvent counterMetricEvent = ((CounterMetricEvent.Builder)new CounterMetricEvent.Builder(MetricName.PLAN_STATUS_COUNT.getValue(), Double.valueOf(value)).tags(MapsKt.mapOf((Pair[])pairArray))).build();
        Intrinsics.checkNotNullExpressionValue((Object)counterMetricEvent, (String)"build(...)");
        AnalyticsEventService.saveAnalyticsEvent$default(this.analyticsEventService, (EventDto)counterMetricEvent, null, 2, null);
    }

    public static /* synthetic */ void sendEventForPlanStatus$default(MetricsEventService metricsEventService, String string, String string2, double d, int n, Object object) {
        if ((n & 4) != 0) {
            d = 1.0;
        }
        metricsEventService.sendEventForPlanStatus(string, string2, d);
    }

    public final void sendMigrationTaskStatusForPlan(@NotNull String taskType, @NotNull String status, double value) {
        Intrinsics.checkNotNullParameter((Object)taskType, (String)"taskType");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)this.MIGRATION_TASK_TYPE, (Object)taskType), TuplesKt.to((Object)this.RESULT, (Object)status), TuplesKt.to((Object)this.VERSION, (Object)this.jiraMigrationVersionService.getPluginVersion()), TuplesKt.to((Object)this.PRODUCT, (Object)this.JIRA)};
        CounterMetricEvent counterMetricEvent = ((CounterMetricEvent.Builder)new CounterMetricEvent.Builder(MetricName.MIGRATION_TASK_STATUS_COUNT.getValue(), Double.valueOf(value)).tags(MapsKt.mapOf((Pair[])pairArray))).build();
        Intrinsics.checkNotNullExpressionValue((Object)counterMetricEvent, (String)"build(...)");
        AnalyticsEventService.saveAnalyticsEvent$default(this.analyticsEventService, (EventDto)counterMetricEvent, null, 2, null);
    }

    public static /* synthetic */ void sendMigrationTaskStatusForPlan$default(MetricsEventService metricsEventService, String string, String string2, double d, int n, Object object) {
        if ((n & 4) != 0) {
            d = 1.0;
        }
        metricsEventService.sendMigrationTaskStatusForPlan(string, string2, d);
    }

    public final void sendEventForProject(@NotNull String result2, double value) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)this.RESULT, (Object)result2), TuplesKt.to((Object)this.VERSION, (Object)this.jiraMigrationVersionService.getPluginVersion()), TuplesKt.to((Object)this.PRODUCT, (Object)this.JIRA)};
        CounterMetricEvent counterMetricEvent = ((CounterMetricEvent.Builder)new CounterMetricEvent.Builder(MetricName.PROJECT_MIGRATION_COUNT.getValue(), Double.valueOf(value)).tags(MapsKt.mapOf((Pair[])pairArray))).build();
        Intrinsics.checkNotNullExpressionValue((Object)counterMetricEvent, (String)"build(...)");
        AnalyticsEventService.saveAnalyticsEvent$default(this.analyticsEventService, (EventDto)counterMetricEvent, null, 2, null);
    }

    public static /* synthetic */ void sendEventForProject$default(MetricsEventService metricsEventService, String string, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 1.0;
        }
        metricsEventService.sendEventForProject(string, d);
    }

    public final void sendEventForArPlanIncluded(boolean included, double value) {
        String ALL_PLANS_SELECTED = "all";
        String NONE_PLANS_SELECTED = "none";
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)this.RESULT, (Object)(included ? ALL_PLANS_SELECTED : NONE_PLANS_SELECTED)), TuplesKt.to((Object)this.VERSION, (Object)this.jiraMigrationVersionService.getPluginVersion()), TuplesKt.to((Object)this.PRODUCT, (Object)this.JIRA)};
        CounterMetricEvent counterMetricEvent = ((CounterMetricEvent.Builder)new CounterMetricEvent.Builder(MetricName.MIGRATION_WITH_AR_PLANS_COUNT.getValue(), Double.valueOf(value)).tags(MapsKt.mapOf((Pair[])pairArray))).build();
        Intrinsics.checkNotNullExpressionValue((Object)counterMetricEvent, (String)"build(...)");
        AnalyticsEventService.saveAnalyticsEvent$default(this.analyticsEventService, (EventDto)counterMetricEvent, null, 2, null);
    }

    public static /* synthetic */ void sendEventForArPlanIncluded$default(MetricsEventService metricsEventService, boolean bl, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 1.0;
        }
        metricsEventService.sendEventForArPlanIncluded(bl, d);
    }

    public final void sendEventForTask(@NotNull MigrationTaskType migrationTaskType, @NotNull String result2, double value) {
        Intrinsics.checkNotNullParameter((Object)((Object)migrationTaskType), (String)"migrationTaskType");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)this.RESULT, (Object)result2), TuplesKt.to((Object)this.MIGRATION_TASK_TYPE, (Object)migrationTaskType.getTaskTypeName()), TuplesKt.to((Object)this.VERSION, (Object)this.jiraMigrationVersionService.getPluginVersion()), TuplesKt.to((Object)this.PRODUCT, (Object)this.JIRA)};
        CounterMetricEvent counterMetricEvent = ((CounterMetricEvent.Builder)new CounterMetricEvent.Builder(MetricName.MIGRATION_TASK_METRIC.getValue(), Double.valueOf(value)).tags(MapsKt.mapOf((Pair[])pairArray))).build();
        Intrinsics.checkNotNullExpressionValue((Object)counterMetricEvent, (String)"build(...)");
        AnalyticsEventService.saveAnalyticsEvent$default(this.analyticsEventService, (EventDto)counterMetricEvent, null, 2, null);
    }

    public static /* synthetic */ void sendEventForTask$default(MetricsEventService metricsEventService, MigrationTaskType migrationTaskType, String string, double d, int n, Object object) {
        if ((n & 4) != 0) {
            d = 1.0;
        }
        metricsEventService.sendEventForTask(migrationTaskType, string, d);
    }

    public final void sendEventForTask(@NotNull MigrationTaskType migrationTaskType, @NotNull String result2, double value, @NotNull ProgressUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)migrationTaskType), (String)"migrationTaskType");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)this.RESULT, (Object)result2), TuplesKt.to((Object)this.MIGRATION_TASK_TYPE, (Object)migrationTaskType.getTaskTypeName()), TuplesKt.to((Object)this.VERSION, (Object)this.jiraMigrationVersionService.getPluginVersion()), TuplesKt.to((Object)this.PRODUCT, (Object)this.JIRA), TuplesKt.to((Object)this.UNIT, (Object)unit.toString())};
        CounterMetricEvent counterMetricEvent = ((CounterMetricEvent.Builder)new CounterMetricEvent.Builder(MetricName.MIGRATION_TASK_METRIC.getValue(), Double.valueOf(value)).tags(MapsKt.mapOf((Pair[])pairArray))).build();
        Intrinsics.checkNotNullExpressionValue((Object)counterMetricEvent, (String)"build(...)");
        AnalyticsEventService.saveAnalyticsEvent$default(this.analyticsEventService, (EventDto)counterMetricEvent, null, 2, null);
    }

    public static /* synthetic */ void sendEventForTask$default(MetricsEventService metricsEventService, MigrationTaskType migrationTaskType, String string, double d, ProgressUnit progressUnit, int n, Object object) {
        if ((n & 4) != 0) {
            d = 1.0;
        }
        metricsEventService.sendEventForTask(migrationTaskType, string, d, progressUnit);
    }

    /*
     * WARNING - void declaration
     */
    public final void sendEventForAttachmentUploadStatus(@NotNull MigrationTaskType migrationTaskType, @NotNull String result2, @NotNull String cloudId2, @NotNull String migrationId, @Nullable String transferId, double value) {
        void $this$sendEventForAttachmentUploadStatus_u24lambda_u241;
        Map map;
        Intrinsics.checkNotNullParameter((Object)((Object)migrationTaskType), (String)"migrationTaskType");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Map map2 = map = MapsKt.createMapBuilder();
        CounterMetricEvent.Builder builder = new CounterMetricEvent.Builder(MetricName.MIGRATION_ATTACHMENT_UPLOAD_TASK_METRIC.getValue(), Double.valueOf(value));
        AnalyticsEventService analyticsEventService = this.analyticsEventService;
        boolean bl = false;
        $this$sendEventForAttachmentUploadStatus_u24lambda_u241.put(this.RESULT, result2);
        $this$sendEventForAttachmentUploadStatus_u24lambda_u241.put(this.MIGRATION_TASK_TYPE, migrationTaskType.getTaskTypeName());
        $this$sendEventForAttachmentUploadStatus_u24lambda_u241.put(this.VERSION, this.jiraMigrationVersionService.getPluginVersion());
        $this$sendEventForAttachmentUploadStatus_u24lambda_u241.put(this.PRODUCT, this.JIRA);
        $this$sendEventForAttachmentUploadStatus_u24lambda_u241.put(this.CLOUD_ID, cloudId2);
        $this$sendEventForAttachmentUploadStatus_u24lambda_u241.put(this.migrationID, migrationId);
        if (transferId != null) {
            $this$sendEventForAttachmentUploadStatus_u24lambda_u241.put(this.transferID, transferId);
        }
        Unit unit = Unit.INSTANCE;
        CounterMetricEvent counterMetricEvent = ((CounterMetricEvent.Builder)builder.tags(MapsKt.build((Map)map))).build();
        Intrinsics.checkNotNullExpressionValue((Object)counterMetricEvent, (String)"build(...)");
        AnalyticsEventService.saveAnalyticsEvent$default(analyticsEventService, (EventDto)counterMetricEvent, null, 2, null);
    }

    public static /* synthetic */ void sendEventForAttachmentUploadStatus$default(MetricsEventService metricsEventService, MigrationTaskType migrationTaskType, String string, String string2, String string3, String string4, double d, int n, Object object) {
        if ((n & 0x10) != 0) {
            string4 = null;
        }
        if ((n & 0x20) != 0) {
            d = 1.0;
        }
        metricsEventService.sendEventForAttachmentUploadStatus(migrationTaskType, string, string2, string3, string4, d);
    }

    public final void sendEventForPreflightChecks(@NotNull String checkType, @NotNull String result2, double value) {
        Intrinsics.checkNotNullParameter((Object)checkType, (String)"checkType");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)this.RESULT, (Object)result2), TuplesKt.to((Object)this.PREFLIGHT_CHECK_TYPE, (Object)checkType), TuplesKt.to((Object)this.VERSION, (Object)this.jiraMigrationVersionService.getPluginVersion()), TuplesKt.to((Object)this.PRODUCT, (Object)this.JIRA)};
        CounterMetricEvent counterMetricEvent = ((CounterMetricEvent.Builder)new CounterMetricEvent.Builder(MetricName.PREFLIGHT_CHECK_METRIC.getValue(), Double.valueOf(value)).tags(MapsKt.mapOf((Pair[])pairArray))).build();
        Intrinsics.checkNotNullExpressionValue((Object)counterMetricEvent, (String)"build(...)");
        AnalyticsEventService.saveAnalyticsEvent$default(this.analyticsEventService, (EventDto)counterMetricEvent, null, 2, null);
    }

    public static /* synthetic */ void sendEventForPreflightChecks$default(MetricsEventService metricsEventService, String string, String string2, double d, int n, Object object) {
        if ((n & 4) != 0) {
            d = 1.0;
        }
        metricsEventService.sendEventForPreflightChecks(string, string2, d);
    }

    public final void sendEventForPreflightProjectErrorDownload(@NotNull String result2, double value) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)this.RESULT, (Object)result2), TuplesKt.to((Object)this.VERSION, (Object)this.jiraMigrationVersionService.getPluginVersion()), TuplesKt.to((Object)this.PRODUCT, (Object)this.JIRA)};
        CounterMetricEvent counterMetricEvent = ((CounterMetricEvent.Builder)new CounterMetricEvent.Builder(MetricName.PREFLIGHT_PROJECT_EXPORT_ERROR_DOWNLOAD_METRIC.getValue(), Double.valueOf(value)).tags(MapsKt.mapOf((Pair[])pairArray))).build();
        Intrinsics.checkNotNullExpressionValue((Object)counterMetricEvent, (String)"build(...)");
        AnalyticsEventService.saveAnalyticsEvent$default(this.analyticsEventService, (EventDto)counterMetricEvent, null, 2, null);
    }

    public static /* synthetic */ void sendEventForPreflightProjectErrorDownload$default(MetricsEventService metricsEventService, String string, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 1.0;
        }
        metricsEventService.sendEventForPreflightProjectErrorDownload(string, d);
    }

    public final void sendTimeForOperation(@NotNull OperationType operationType, @NotNull String result2, long time, long count2, @NotNull Map<String, String> extraTags) {
        Intrinsics.checkNotNullParameter((Object)((Object)operationType), (String)"operationType");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter(extraTags, (String)"extraTags");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)this.RESULT, (Object)result2), TuplesKt.to((Object)this.SIZE, (Object)this.sizeToBucket(count2)), TuplesKt.to((Object)this.VERSION, (Object)this.jiraMigrationVersionService.getPluginVersion()), TuplesKt.to((Object)this.PRODUCT, (Object)this.JIRA)};
        TimerMetricEvent timerMetricEvent = ((TimerMetricEvent.Builder)new TimerMetricEvent.Builder(operationType.getMetric().getValue(), Long.valueOf(time)).tags(MapsKt.plus((Map)MapsKt.mapOf((Pair[])pairArray), extraTags))).build();
        Intrinsics.checkNotNullExpressionValue((Object)timerMetricEvent, (String)"build(...)");
        AnalyticsEventService.saveAnalyticsEvent$default(this.analyticsEventService, (EventDto)timerMetricEvent, null, 2, null);
    }

    public static /* synthetic */ void sendTimeForOperation$default(MetricsEventService metricsEventService, OperationType operationType, String string, long l, long l2, Map map, int n, Object object) {
        if ((n & 8) != 0) {
            l2 = 0L;
        }
        if ((n & 0x10) != 0) {
            map = MapsKt.emptyMap();
        }
        metricsEventService.sendTimeForOperation(operationType, string, l, l2, map);
    }

    public final void sendEventForApiPerformance(@NotNull String endpoint, long timeTaken2, int status) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)this.STATUS, (Object)this.maskHttpStatusCode(status)), TuplesKt.to((Object)this.ENDPOINT, (Object)endpoint), TuplesKt.to((Object)this.VERSION, (Object)this.jiraMigrationVersionService.getPluginVersion()), TuplesKt.to((Object)this.PRODUCT, (Object)this.JIRA)};
        TimerMetricEvent timerMetricEvent = ((TimerMetricEvent.Builder)new TimerMetricEvent.Builder(OperationType.JCMA_API_PERFORMANCE.getMetric().getValue(), Long.valueOf(timeTaken2)).tags(MapsKt.mapOf((Pair[])pairArray))).build();
        Intrinsics.checkNotNullExpressionValue((Object)timerMetricEvent, (String)"build(...)");
        AnalyticsEventService.saveAnalyticsEvent$default(this.analyticsEventService, (EventDto)timerMetricEvent, null, 2, null);
    }

    public final void sendTimerEvent(@NotNull OperationType operationType, long eventValue, @NotNull Map<String, String> dimensions) {
        Intrinsics.checkNotNullParameter((Object)((Object)operationType), (String)"operationType");
        Intrinsics.checkNotNullParameter(dimensions, (String)"dimensions");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)this.VERSION, (Object)this.jiraMigrationVersionService.getPluginVersion()), TuplesKt.to((Object)this.PRODUCT, (Object)this.JIRA)};
        TimerMetricEvent timerMetricEvent = ((TimerMetricEvent.Builder)new TimerMetricEvent.Builder(operationType.getMetric().getValue(), Long.valueOf(eventValue)).tags(MapsKt.plus((Map)MapsKt.mapOf((Pair[])pairArray), dimensions))).build();
        Intrinsics.checkNotNullExpressionValue((Object)timerMetricEvent, (String)"build(...)");
        AnalyticsEventService.saveAnalyticsEvent$default(this.analyticsEventService, (EventDto)timerMetricEvent, null, 2, null);
    }

    public static /* synthetic */ void sendTimerEvent$default(MetricsEventService metricsEventService, OperationType operationType, long l, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        metricsEventService.sendTimerEvent(operationType, l, map);
    }

    public final void sendEventForPublicPlan(@NotNull OperationType operationType, long timeTaken2, int status) {
        Intrinsics.checkNotNullParameter((Object)((Object)operationType), (String)"operationType");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)this.STATUS, (Object)this.maskHttpStatusCode(status)), TuplesKt.to((Object)this.VERSION, (Object)this.jiraMigrationVersionService.getPluginVersion()), TuplesKt.to((Object)this.PRODUCT, (Object)this.JIRA)};
        TimerMetricEvent timerMetricEvent = ((TimerMetricEvent.Builder)new TimerMetricEvent.Builder(operationType.getMetric().getValue(), Long.valueOf(timeTaken2)).tags(MapsKt.mapOf((Pair[])pairArray))).build();
        Intrinsics.checkNotNullExpressionValue((Object)timerMetricEvent, (String)"build(...)");
        AnalyticsEventService.saveAnalyticsEvent$default(this.analyticsEventService, (EventDto)timerMetricEvent, null, 2, null);
    }

    public final void sendGaugeEvent(@NotNull OperationType operationType, double eventValue, @NotNull Map<String, String> dimensions) {
        Intrinsics.checkNotNullParameter((Object)((Object)operationType), (String)"operationType");
        Intrinsics.checkNotNullParameter(dimensions, (String)"dimensions");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)this.VERSION, (Object)this.jiraMigrationVersionService.getPluginVersion()), TuplesKt.to((Object)this.PRODUCT, (Object)this.JIRA)};
        GaugeMetricEvent gaugeMetricEvent = ((GaugeMetricEvent.Builder)new GaugeMetricEvent.Builder(operationType.getMetric().getValue(), Double.valueOf(eventValue)).tags(MapsKt.plus((Map)MapsKt.mapOf((Pair[])pairArray), dimensions))).build();
        Intrinsics.checkNotNullExpressionValue((Object)gaugeMetricEvent, (String)"build(...)");
        AnalyticsEventService.saveAnalyticsEvent$default(this.analyticsEventService, (EventDto)gaugeMetricEvent, null, 2, null);
    }

    public static /* synthetic */ void sendGaugeEvent$default(MetricsEventService metricsEventService, OperationType operationType, double d, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        metricsEventService.sendGaugeEvent(operationType, d, map);
    }

    public final void sendEventForProjectExportHit(@NotNull String uniqueProjectIdentifier, @NotNull String cloudId2, boolean preMigrationReportFeatureFlag, double value) {
        Intrinsics.checkNotNullParameter((Object)uniqueProjectIdentifier, (String)"uniqueProjectIdentifier");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)this.UNIQUE_PROJECT_IDENTIFIER, (Object)uniqueProjectIdentifier), TuplesKt.to((Object)this.CLOUD_ID, (Object)cloudId2), TuplesKt.to((Object)this.PRE_MIGRATION_REPORT_FF, (Object)String.valueOf(preMigrationReportFeatureFlag)), TuplesKt.to((Object)this.PRODUCT, (Object)this.JIRA)};
        CounterMetricEvent counterMetricEvent = ((CounterMetricEvent.Builder)new CounterMetricEvent.Builder(MetricName.PROJECT_EXPORT_HIT_COUNT.getValue(), Double.valueOf(value)).tags(MapsKt.mapOf((Pair[])pairArray))).build();
        Intrinsics.checkNotNullExpressionValue((Object)counterMetricEvent, (String)"build(...)");
        AnalyticsEventService.saveAnalyticsEvent$default(this.analyticsEventService, (EventDto)counterMetricEvent, null, 2, null);
    }

    public static /* synthetic */ void sendEventForProjectExportHit$default(MetricsEventService metricsEventService, String string, String string2, boolean bl, double d, int n, Object object) {
        if ((n & 8) != 0) {
            d = 1.0;
        }
        metricsEventService.sendEventForProjectExportHit(string, string2, bl, d);
    }

    @VisibleForTesting
    @NotNull
    public final String sizeToBucket(long size) {
        String string;
        block1: {
            long l;
            block6: {
                block5: {
                    block4: {
                        block3: {
                            block2: {
                                block0: {
                                    l = size;
                                    boolean bl = 0L <= l ? l < 251L : false;
                                    if (!bl) break block0;
                                    string = this.BUCKET_0_250;
                                    break block1;
                                }
                                boolean bl = 251L <= l ? l < 501L : false;
                                if (!bl) break block2;
                                string = this.BUCKET_251_500;
                                break block1;
                            }
                            boolean bl = 501L <= l ? l < 1001L : false;
                            if (!bl) break block3;
                            string = this.BUCKET_501_1000;
                            break block1;
                        }
                        boolean bl = 1001L <= l ? l < 5001L : false;
                        if (!bl) break block4;
                        string = this.BUCKET_1001_5000;
                        break block1;
                    }
                    boolean bl = 5001L <= l ? l < 10001L : false;
                    if (!bl) break block5;
                    string = this.BUCKET_5001_10000;
                    break block1;
                }
                boolean bl = 10001L <= l ? l < 17501L : false;
                if (!bl) break block6;
                string = this.BUCKET_10001_17500;
                break block1;
            }
            string = (17501L <= l ? l < 25001L : false) ? this.BUCKET_17501_25000 : ((25001L <= l ? l < 50001L : false) ? this.BUCKET_25001_50000 : this.BUCKET_50001_PLUS);
        }
        return string;
    }

    public static /* synthetic */ String sizeToBucket$default(MetricsEventService metricsEventService, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = 0L;
        }
        return metricsEventService.sizeToBucket(l);
    }

    @VisibleForTesting
    @NotNull
    public final String maskHttpStatusCode(int status) {
        String string;
        block1: {
            int n;
            block3: {
                block2: {
                    block0: {
                        n = status;
                        boolean bl = 100 <= n ? n < 200 : false;
                        if (!bl) break block0;
                        string = this.HTTP_1xx;
                        break block1;
                    }
                    boolean bl = 200 <= n ? n < 300 : false;
                    if (!bl) break block2;
                    string = this.HTTP_2xx;
                    break block1;
                }
                boolean bl = 300 <= n ? n < 400 : false;
                if (!bl) break block3;
                string = this.HTTP_3xx;
                break block1;
            }
            string = (400 <= n ? n < 500 : false) ? this.HTTP_4xx : ((500 <= n ? n < 600 : false) ? this.HTTP_5xx : this.HTTP_xxx);
        }
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/atlassian/jira/migration/analytics/MetricsEventService$Companion;", "", "()V", "DATA_GENERATION_TYPE_KEY", "", "DATA_GENERATION_TYPE_UNDEFINED", "EXPORT_COMPRESSION_KEY", "LZ4_TAG", "ZIP_TAG", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b1\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$j\u0002\b%j\u0002\b&j\u0002\b'j\u0002\b(j\u0002\b)j\u0002\b*j\u0002\b+j\u0002\b,j\u0002\b-j\u0002\b.j\u0002\b/j\u0002\b0j\u0002\b1j\u0002\b2j\u0002\b3\u00a8\u00064"}, d2={"Lcom/atlassian/jira/migration/analytics/MetricsEventService$MetricName;", "", "value", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getValue", "()Ljava/lang/String;", "PREFLIGHT_CHECK_METRIC", "PREFLIGHT_PROJECT_EXPORT_ERROR_DOWNLOAD_METRIC", "MIGRATION_TASK_METRIC", "PROJECT_MIGRATION_COUNT", "PROJECT_EXPORT_HIT_COUNT", "PLAN_STATUS_COUNT", "MIGRATION_TASK_STATUS_COUNT", "MIGRATION_WITH_AR_PLANS_COUNT", "OPERATION_PROJECT_EXPORT_METRIC", "OPERATION_PROJECT_PUBLISH_TOMBSTONE_MAPPING_METRIC", "OPERATION_PROJECT_UPLOAD_DELETED_USER_MAPPING_METRIC", "OPERATION_PROJECT_UPLOAD_METRIC", "OPERATION_PROJECT_MEDIA_ID_GENERATION_METRIC", "OPERATION_AVATAR_MEDIA_ID_GENERATION_METRIC", "OPERATION_ATTACHMENTS_UPLOAD_METRIC", "OPERATION_ATTACHMENTS_LINKING_METRIC", "OPERATION_USER_EXPORT_METRIC", "OPERATION_USER_FILTER_METRIC", "OPERATION_USER_FILTER_DUPLICATE_METRIC", "OPERATION_USER_UPLOAD_DATA_METRIC", "OPERATION_USER_EXPORT_MAPPINGS_METRIC", "OPERATION_USER_UPLOAD_MAPPINGS_METRIC", "OPERATION_USER_PUBLISH_TOMBSTONE_MAPPINGS_METRIC", "OPERATION_PROJECT_USERS_GROUPS_EXPORT", "OPERATION_USERS_AND_GROUPS_MIGRATION_METRIC", "JCMA_API_PERFORMANCE_METRIC", "OPERATION_SITE_MEDIA_ID_GENERATION_METRIC", "OPERATION_SITE_AVATAR_ID_GENERATION_METRIC", "OPERATION_SITE_ATTACHMENT_UPLOAD_METRIC", "OPERATION_SITE_EXPORT_DURATION_METRIC", "OPERATION_ENRICH_SITE_EXPORT_DURATION_METRIC", "OPERATION_APP_WORKFLOWRULE_EXPORT_DURATION_METRIC", "OPERATION_SITE_UPLOAD_DURATION_METRIC", "OPERATION_SITE_DUPLICATE_AND_INVALID_EMAIL_GENERATION_METRIC", "OPERATION_PROJECT_ISSUE_EXPORT_METRIC", "OPERATION_ASSESSMENT_QUERY_GAUGE_METRIC", "OPERATION_PROJECT_ISSUE_ACTUAL_EXPORT_METRIC", "OPERATION_SITE_USERS_METADATA_EXPORT_DURATION_METRIC", "PUBLIC_PLAN_SAVE_STATUS_METRIC", "PUBLIC_PLAN_SCHEDULE_CHECKS_METRIC", "PUBLIC_PLAN_MIGRATION_STARTED_METRIC", "OPERATION_MCC_RELATIONS_ANALYSIS", "MIGRATION_ATTACHMENT_UPLOAD_TASK_METRIC", "MIGRATION_ROLLOUT_SERVICE_EXECUTION_METRIC", "MIGRATION_ROLLOUT_SERVICE_TIME_METRIC", "jira-migration-plugin"})
    public static final class MetricName
    extends Enum<MetricName> {
        @NotNull
        private final String value;
        public static final /* enum */ MetricName PREFLIGHT_CHECK_METRIC = new MetricName("migrations.sli.preflight.check");
        public static final /* enum */ MetricName PREFLIGHT_PROJECT_EXPORT_ERROR_DOWNLOAD_METRIC = new MetricName("migrations.sli.preflight.project.export.error.download");
        public static final /* enum */ MetricName MIGRATION_TASK_METRIC = new MetricName("migrations.sli.task.status");
        public static final /* enum */ MetricName PROJECT_MIGRATION_COUNT = new MetricName("migrations.sli.project.migration");
        public static final /* enum */ MetricName PROJECT_EXPORT_HIT_COUNT = new MetricName("migrations.op.project.export.hit");
        public static final /* enum */ MetricName PLAN_STATUS_COUNT = new MetricName("migrations.sli.plan.status");
        public static final /* enum */ MetricName MIGRATION_TASK_STATUS_COUNT = new MetricName("migrations.sli.plan.task.status");
        public static final /* enum */ MetricName MIGRATION_WITH_AR_PLANS_COUNT = new MetricName("migrations.sli.ar.plan.included");
        public static final /* enum */ MetricName OPERATION_PROJECT_EXPORT_METRIC = new MetricName("migrations.op.project.export.time");
        public static final /* enum */ MetricName OPERATION_PROJECT_PUBLISH_TOMBSTONE_MAPPING_METRIC = new MetricName("migrations.op.project.publish.tombstone.mappings.time");
        public static final /* enum */ MetricName OPERATION_PROJECT_UPLOAD_DELETED_USER_MAPPING_METRIC = new MetricName("migrations.op.project.upload.deleted.user.mappings.time");
        public static final /* enum */ MetricName OPERATION_PROJECT_UPLOAD_METRIC = new MetricName("migrations.op.project.upload.time");
        public static final /* enum */ MetricName OPERATION_PROJECT_MEDIA_ID_GENERATION_METRIC = new MetricName("migrations.op.project.media.id.generation.time");
        public static final /* enum */ MetricName OPERATION_AVATAR_MEDIA_ID_GENERATION_METRIC = new MetricName("migrations.op.avatar.media.id.generation.time");
        public static final /* enum */ MetricName OPERATION_ATTACHMENTS_UPLOAD_METRIC = new MetricName("migrations.op.attachments.upload.time");
        public static final /* enum */ MetricName OPERATION_ATTACHMENTS_LINKING_METRIC = new MetricName("migrations.op.attachments.linking.time");
        public static final /* enum */ MetricName OPERATION_USER_EXPORT_METRIC = new MetricName("migrations.op.user.export.time");
        public static final /* enum */ MetricName OPERATION_USER_FILTER_METRIC = new MetricName("migrations.op.user.filter.time");
        public static final /* enum */ MetricName OPERATION_USER_FILTER_DUPLICATE_METRIC = new MetricName("migrations.op.user.filter.duplicate.time");
        public static final /* enum */ MetricName OPERATION_USER_UPLOAD_DATA_METRIC = new MetricName("migrations.op.user.upload.data.time");
        public static final /* enum */ MetricName OPERATION_USER_EXPORT_MAPPINGS_METRIC = new MetricName("migrations.op.user.export.mappings.time");
        public static final /* enum */ MetricName OPERATION_USER_UPLOAD_MAPPINGS_METRIC = new MetricName("migrations.op.user.upload.mappings.time");
        public static final /* enum */ MetricName OPERATION_USER_PUBLISH_TOMBSTONE_MAPPINGS_METRIC = new MetricName("migrations.op.user.publish.tombstone.mappings.time");
        public static final /* enum */ MetricName OPERATION_PROJECT_USERS_GROUPS_EXPORT = new MetricName("migration.op.project.user.group.export.time");
        public static final /* enum */ MetricName OPERATION_USERS_AND_GROUPS_MIGRATION_METRIC = new MetricName("migrations.op.project.user.groups.migration.time");
        public static final /* enum */ MetricName JCMA_API_PERFORMANCE_METRIC = new MetricName("migrations.sli.jcma.api.time");
        public static final /* enum */ MetricName OPERATION_SITE_MEDIA_ID_GENERATION_METRIC = new MetricName("migrations.op.site.media.id.generation.time");
        public static final /* enum */ MetricName OPERATION_SITE_AVATAR_ID_GENERATION_METRIC = new MetricName("migrations.op.site.avatar.media.id.generation.time");
        public static final /* enum */ MetricName OPERATION_SITE_ATTACHMENT_UPLOAD_METRIC = new MetricName("migrations.op.site.attachments.upload.time");
        public static final /* enum */ MetricName OPERATION_SITE_EXPORT_DURATION_METRIC = new MetricName("migrations.op.site.export.time");
        public static final /* enum */ MetricName OPERATION_ENRICH_SITE_EXPORT_DURATION_METRIC = new MetricName("migrations.op.site.export.enrich.time");
        public static final /* enum */ MetricName OPERATION_APP_WORKFLOWRULE_EXPORT_DURATION_METRIC = new MetricName("migrations.op.app.workflorrule.time");
        public static final /* enum */ MetricName OPERATION_SITE_UPLOAD_DURATION_METRIC = new MetricName("migrations.op.site.export.upload.time");
        public static final /* enum */ MetricName OPERATION_SITE_DUPLICATE_AND_INVALID_EMAIL_GENERATION_METRIC = new MetricName("migrations.op.site.invalidduplicate.email.generation.time");
        public static final /* enum */ MetricName OPERATION_PROJECT_ISSUE_EXPORT_METRIC = new MetricName("migrations.op.issue.export.time");
        public static final /* enum */ MetricName OPERATION_ASSESSMENT_QUERY_GAUGE_METRIC = new MetricName("migrations.op.assessment.query.time");
        public static final /* enum */ MetricName OPERATION_PROJECT_ISSUE_ACTUAL_EXPORT_METRIC = new MetricName("migrations.op.issue.actual.export.time");
        public static final /* enum */ MetricName OPERATION_SITE_USERS_METADATA_EXPORT_DURATION_METRIC = new MetricName("migrations.op.site.users.metadata.generation.time");
        public static final /* enum */ MetricName PUBLIC_PLAN_SAVE_STATUS_METRIC = new MetricName("migrations.mapi.jira.s2c.attachjob.timer");
        public static final /* enum */ MetricName PUBLIC_PLAN_SCHEDULE_CHECKS_METRIC = new MetricName("migrations.mapi.jira.s2c.executechecks.timer");
        public static final /* enum */ MetricName PUBLIC_PLAN_MIGRATION_STARTED_METRIC = new MetricName("migrations.mapi.jira.s2c.migrationstarted.timer");
        public static final /* enum */ MetricName OPERATION_MCC_RELATIONS_ANALYSIS = new MetricName("migrations.op.mcc.relations.analysis.time");
        public static final /* enum */ MetricName MIGRATION_ATTACHMENT_UPLOAD_TASK_METRIC = new MetricName("migrations.attachment.upload.task.status");
        public static final /* enum */ MetricName MIGRATION_ROLLOUT_SERVICE_EXECUTION_METRIC = new MetricName("migrations.jcma.rollout.service.code.executed");
        public static final /* enum */ MetricName MIGRATION_ROLLOUT_SERVICE_TIME_METRIC = new MetricName("migrations.jcma.rollout.service.code.timer");
        private static final /* synthetic */ MetricName[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private MetricName(String value) {
            this.value = value;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        public static MetricName[] values() {
            return (MetricName[])$VALUES.clone();
        }

        public static MetricName valueOf(String value) {
            return Enum.valueOf(MetricName.class, value);
        }

        @NotNull
        public static EnumEntries<MetricName> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = metricNameArray = new MetricName[]{MetricName.PREFLIGHT_CHECK_METRIC, MetricName.PREFLIGHT_PROJECT_EXPORT_ERROR_DOWNLOAD_METRIC, MetricName.MIGRATION_TASK_METRIC, MetricName.PROJECT_MIGRATION_COUNT, MetricName.PROJECT_EXPORT_HIT_COUNT, MetricName.PLAN_STATUS_COUNT, MetricName.MIGRATION_TASK_STATUS_COUNT, MetricName.MIGRATION_WITH_AR_PLANS_COUNT, MetricName.OPERATION_PROJECT_EXPORT_METRIC, MetricName.OPERATION_PROJECT_PUBLISH_TOMBSTONE_MAPPING_METRIC, MetricName.OPERATION_PROJECT_UPLOAD_DELETED_USER_MAPPING_METRIC, MetricName.OPERATION_PROJECT_UPLOAD_METRIC, MetricName.OPERATION_PROJECT_MEDIA_ID_GENERATION_METRIC, MetricName.OPERATION_AVATAR_MEDIA_ID_GENERATION_METRIC, MetricName.OPERATION_ATTACHMENTS_UPLOAD_METRIC, MetricName.OPERATION_ATTACHMENTS_LINKING_METRIC, MetricName.OPERATION_USER_EXPORT_METRIC, MetricName.OPERATION_USER_FILTER_METRIC, MetricName.OPERATION_USER_FILTER_DUPLICATE_METRIC, MetricName.OPERATION_USER_UPLOAD_DATA_METRIC, MetricName.OPERATION_USER_EXPORT_MAPPINGS_METRIC, MetricName.OPERATION_USER_UPLOAD_MAPPINGS_METRIC, MetricName.OPERATION_USER_PUBLISH_TOMBSTONE_MAPPINGS_METRIC, MetricName.OPERATION_PROJECT_USERS_GROUPS_EXPORT, MetricName.OPERATION_USERS_AND_GROUPS_MIGRATION_METRIC, MetricName.JCMA_API_PERFORMANCE_METRIC, MetricName.OPERATION_SITE_MEDIA_ID_GENERATION_METRIC, MetricName.OPERATION_SITE_AVATAR_ID_GENERATION_METRIC, MetricName.OPERATION_SITE_ATTACHMENT_UPLOAD_METRIC, MetricName.OPERATION_SITE_EXPORT_DURATION_METRIC, MetricName.OPERATION_ENRICH_SITE_EXPORT_DURATION_METRIC, MetricName.OPERATION_APP_WORKFLOWRULE_EXPORT_DURATION_METRIC, MetricName.OPERATION_SITE_UPLOAD_DURATION_METRIC, MetricName.OPERATION_SITE_DUPLICATE_AND_INVALID_EMAIL_GENERATION_METRIC, MetricName.OPERATION_PROJECT_ISSUE_EXPORT_METRIC, MetricName.OPERATION_ASSESSMENT_QUERY_GAUGE_METRIC, MetricName.OPERATION_PROJECT_ISSUE_ACTUAL_EXPORT_METRIC, MetricName.OPERATION_SITE_USERS_METADATA_EXPORT_DURATION_METRIC, MetricName.PUBLIC_PLAN_SAVE_STATUS_METRIC, MetricName.PUBLIC_PLAN_SCHEDULE_CHECKS_METRIC, MetricName.PUBLIC_PLAN_MIGRATION_STARTED_METRIC, MetricName.OPERATION_MCC_RELATIONS_ANALYSIS, MetricName.MIGRATION_ATTACHMENT_UPLOAD_TASK_METRIC, MetricName.MIGRATION_ROLLOUT_SERVICE_EXECUTION_METRIC, MetricName.MIGRATION_ROLLOUT_SERVICE_TIME_METRIC};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b&\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$j\u0002\b%j\u0002\b&j\u0002\b'j\u0002\b(\u00a8\u0006)"}, d2={"Lcom/atlassian/jira/migration/analytics/MetricsEventService$OperationType;", "", "metric", "Lcom/atlassian/jira/migration/analytics/MetricsEventService$MetricName;", "(Ljava/lang/String;ILcom/atlassian/jira/migration/analytics/MetricsEventService$MetricName;)V", "getMetric", "()Lcom/atlassian/jira/migration/analytics/MetricsEventService$MetricName;", "PROJECT_EXPORT", "PROJECT_PUBLISH_TOMBSTONE_MAPPINGS", "PROJECT_UPLOAD_DELETED_USER_MAPPING", "PROJECT_UPLOAD", "PROJECT_MEDIA_ID_GENERATION", "AVATAR_MEDIA_ID_GENERATION", "ATTACHMENTS_UPLOAD", "ATTACHMENTS_LINKING", "USER_EXPORT", "USER_FILTER", "USER_FILTER_DUPLICATE", "USER_UPLOAD_DATA", "USER_EXPORT_MAPPINGS", "USER_UPLOAD_MAPPINGS", "USER_PUBLISH_TOMBSTONE_MAPPINGS", "PROJECT_USERS_GROUPS_EXPORT", "USERS_AND_GROUPS_MIGRATION", "JCMA_API_PERFORMANCE", "SITE_MEDIA_ID_GENERATION", "SITE_AVATAR_ID_GENERATION", "SITE_DUPLICATE_AND_INVALID_EMAIL_GENERATION", "SITE_ATTACHMENT_UPLOAD", "SITE_EXPORT_DURATION", "SITE_UPLOAD_DURATION", "SITE_ENRICH_SITE_EXPORT_DURATION", "PROJECT_ISSUE_EXPORT", "ASSESSMENT_QUERY_GAUGE", "SITE_APP_WORFLOWRULE_EXPORT", "PROJECT_ISSUE_ACTUAL_EXPORT", "SITE_USERS_METADATA_EXPORT", "PUBLIC_PLAN_SAVE_STATUS_METRIC", "PUBLIC_PLAN_SCHEDULE_CHECKS_METRIC", "PUBLIC_PLAN_MIGRATION_STARTED_METRIC", "MCC_RELATIONS_ANALYSIS", "jira-migration-plugin"})
    public static final class OperationType
    extends Enum<OperationType> {
        @NotNull
        private final MetricName metric;
        public static final /* enum */ OperationType PROJECT_EXPORT = new OperationType(MetricName.OPERATION_PROJECT_EXPORT_METRIC);
        public static final /* enum */ OperationType PROJECT_PUBLISH_TOMBSTONE_MAPPINGS = new OperationType(MetricName.OPERATION_PROJECT_PUBLISH_TOMBSTONE_MAPPING_METRIC);
        public static final /* enum */ OperationType PROJECT_UPLOAD_DELETED_USER_MAPPING = new OperationType(MetricName.OPERATION_PROJECT_UPLOAD_DELETED_USER_MAPPING_METRIC);
        public static final /* enum */ OperationType PROJECT_UPLOAD = new OperationType(MetricName.OPERATION_PROJECT_UPLOAD_METRIC);
        public static final /* enum */ OperationType PROJECT_MEDIA_ID_GENERATION = new OperationType(MetricName.OPERATION_PROJECT_MEDIA_ID_GENERATION_METRIC);
        public static final /* enum */ OperationType AVATAR_MEDIA_ID_GENERATION = new OperationType(MetricName.OPERATION_AVATAR_MEDIA_ID_GENERATION_METRIC);
        public static final /* enum */ OperationType ATTACHMENTS_UPLOAD = new OperationType(MetricName.OPERATION_ATTACHMENTS_UPLOAD_METRIC);
        public static final /* enum */ OperationType ATTACHMENTS_LINKING = new OperationType(MetricName.OPERATION_ATTACHMENTS_LINKING_METRIC);
        public static final /* enum */ OperationType USER_EXPORT = new OperationType(MetricName.OPERATION_USER_EXPORT_METRIC);
        public static final /* enum */ OperationType USER_FILTER = new OperationType(MetricName.OPERATION_USER_FILTER_METRIC);
        public static final /* enum */ OperationType USER_FILTER_DUPLICATE = new OperationType(MetricName.OPERATION_USER_FILTER_DUPLICATE_METRIC);
        public static final /* enum */ OperationType USER_UPLOAD_DATA = new OperationType(MetricName.OPERATION_USER_UPLOAD_DATA_METRIC);
        public static final /* enum */ OperationType USER_EXPORT_MAPPINGS = new OperationType(MetricName.OPERATION_USER_EXPORT_MAPPINGS_METRIC);
        public static final /* enum */ OperationType USER_UPLOAD_MAPPINGS = new OperationType(MetricName.OPERATION_USER_UPLOAD_MAPPINGS_METRIC);
        public static final /* enum */ OperationType USER_PUBLISH_TOMBSTONE_MAPPINGS = new OperationType(MetricName.OPERATION_USER_PUBLISH_TOMBSTONE_MAPPINGS_METRIC);
        public static final /* enum */ OperationType PROJECT_USERS_GROUPS_EXPORT = new OperationType(MetricName.OPERATION_PROJECT_USERS_GROUPS_EXPORT);
        public static final /* enum */ OperationType USERS_AND_GROUPS_MIGRATION = new OperationType(MetricName.OPERATION_USERS_AND_GROUPS_MIGRATION_METRIC);
        public static final /* enum */ OperationType JCMA_API_PERFORMANCE = new OperationType(MetricName.JCMA_API_PERFORMANCE_METRIC);
        public static final /* enum */ OperationType SITE_MEDIA_ID_GENERATION = new OperationType(MetricName.OPERATION_SITE_MEDIA_ID_GENERATION_METRIC);
        public static final /* enum */ OperationType SITE_AVATAR_ID_GENERATION = new OperationType(MetricName.OPERATION_SITE_AVATAR_ID_GENERATION_METRIC);
        public static final /* enum */ OperationType SITE_DUPLICATE_AND_INVALID_EMAIL_GENERATION = new OperationType(MetricName.OPERATION_SITE_DUPLICATE_AND_INVALID_EMAIL_GENERATION_METRIC);
        public static final /* enum */ OperationType SITE_ATTACHMENT_UPLOAD = new OperationType(MetricName.OPERATION_SITE_ATTACHMENT_UPLOAD_METRIC);
        public static final /* enum */ OperationType SITE_EXPORT_DURATION = new OperationType(MetricName.OPERATION_SITE_EXPORT_DURATION_METRIC);
        public static final /* enum */ OperationType SITE_UPLOAD_DURATION = new OperationType(MetricName.OPERATION_SITE_UPLOAD_DURATION_METRIC);
        public static final /* enum */ OperationType SITE_ENRICH_SITE_EXPORT_DURATION = new OperationType(MetricName.OPERATION_ENRICH_SITE_EXPORT_DURATION_METRIC);
        public static final /* enum */ OperationType PROJECT_ISSUE_EXPORT = new OperationType(MetricName.OPERATION_PROJECT_ISSUE_EXPORT_METRIC);
        public static final /* enum */ OperationType ASSESSMENT_QUERY_GAUGE = new OperationType(MetricName.OPERATION_ASSESSMENT_QUERY_GAUGE_METRIC);
        public static final /* enum */ OperationType SITE_APP_WORFLOWRULE_EXPORT = new OperationType(MetricName.OPERATION_APP_WORKFLOWRULE_EXPORT_DURATION_METRIC);
        public static final /* enum */ OperationType PROJECT_ISSUE_ACTUAL_EXPORT = new OperationType(MetricName.OPERATION_PROJECT_ISSUE_ACTUAL_EXPORT_METRIC);
        public static final /* enum */ OperationType SITE_USERS_METADATA_EXPORT = new OperationType(MetricName.OPERATION_SITE_USERS_METADATA_EXPORT_DURATION_METRIC);
        public static final /* enum */ OperationType PUBLIC_PLAN_SAVE_STATUS_METRIC = new OperationType(MetricName.PUBLIC_PLAN_SAVE_STATUS_METRIC);
        public static final /* enum */ OperationType PUBLIC_PLAN_SCHEDULE_CHECKS_METRIC = new OperationType(MetricName.PUBLIC_PLAN_SCHEDULE_CHECKS_METRIC);
        public static final /* enum */ OperationType PUBLIC_PLAN_MIGRATION_STARTED_METRIC = new OperationType(MetricName.PUBLIC_PLAN_MIGRATION_STARTED_METRIC);
        public static final /* enum */ OperationType MCC_RELATIONS_ANALYSIS = new OperationType(MetricName.OPERATION_MCC_RELATIONS_ANALYSIS);
        private static final /* synthetic */ OperationType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private OperationType(MetricName metric) {
            this.metric = metric;
        }

        @NotNull
        public final MetricName getMetric() {
            return this.metric;
        }

        public static OperationType[] values() {
            return (OperationType[])$VALUES.clone();
        }

        public static OperationType valueOf(String value) {
            return Enum.valueOf(OperationType.class, value);
        }

        @NotNull
        public static EnumEntries<OperationType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = operationTypeArray = new OperationType[]{OperationType.PROJECT_EXPORT, OperationType.PROJECT_PUBLISH_TOMBSTONE_MAPPINGS, OperationType.PROJECT_UPLOAD_DELETED_USER_MAPPING, OperationType.PROJECT_UPLOAD, OperationType.PROJECT_MEDIA_ID_GENERATION, OperationType.AVATAR_MEDIA_ID_GENERATION, OperationType.ATTACHMENTS_UPLOAD, OperationType.ATTACHMENTS_LINKING, OperationType.USER_EXPORT, OperationType.USER_FILTER, OperationType.USER_FILTER_DUPLICATE, OperationType.USER_UPLOAD_DATA, OperationType.USER_EXPORT_MAPPINGS, OperationType.USER_UPLOAD_MAPPINGS, OperationType.USER_PUBLISH_TOMBSTONE_MAPPINGS, OperationType.PROJECT_USERS_GROUPS_EXPORT, OperationType.USERS_AND_GROUPS_MIGRATION, OperationType.JCMA_API_PERFORMANCE, OperationType.SITE_MEDIA_ID_GENERATION, OperationType.SITE_AVATAR_ID_GENERATION, OperationType.SITE_DUPLICATE_AND_INVALID_EMAIL_GENERATION, OperationType.SITE_ATTACHMENT_UPLOAD, OperationType.SITE_EXPORT_DURATION, OperationType.SITE_UPLOAD_DURATION, OperationType.SITE_ENRICH_SITE_EXPORT_DURATION, OperationType.PROJECT_ISSUE_EXPORT, OperationType.ASSESSMENT_QUERY_GAUGE, OperationType.SITE_APP_WORFLOWRULE_EXPORT, OperationType.PROJECT_ISSUE_ACTUAL_EXPORT, OperationType.SITE_USERS_METADATA_EXPORT, OperationType.PUBLIC_PLAN_SAVE_STATUS_METRIC, OperationType.PUBLIC_PLAN_SCHEDULE_CHECKS_METRIC, OperationType.PUBLIC_PLAN_MIGRATION_STARTED_METRIC, OperationType.MCC_RELATIONS_ANALYSIS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

