/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.analytics;

import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.events.MigAssetStats;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUserGroupMigrationData;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJQ\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0002\u0010\u0019J\u001e\u0010\u001a\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/atlassian/jira/migration/analytics/MigAssetStatsService;", "", "jiraHome", "Lcom/atlassian/jira/config/util/JiraHome;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "(Lcom/atlassian/jira/config/util/JiraHome;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;Lcom/atlassian/jira/migration/events/MigrationEventBus;)V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "publishDiskStats", "", "migrationId", "", "migrationScopeId", "publishProjectAssetMetrics", "chunkFile", "Ljava/io/File;", "assetType", "Lcom/atlassian/jira/migration/events/MigAssetStats$StatsType;", "projectKey", "projectId", "", "issueCount", "(Ljava/lang/String;Ljava/lang/String;Ljava/io/File;Lcom/atlassian/jira/migration/events/MigAssetStats$StatsType;Ljava/lang/String;Ljava/lang/Long;Ljava/lang/Long;)V", "publishUserGroupChunkMetric", "jiraUserGroupMigrationData", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUserGroupMigrationData;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nMigAssetStatsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigAssetStatsService.kt\ncom/atlassian/jira/migration/analytics/MigAssetStatsService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n1#2:114\n*E\n"})
public final class MigAssetStatsService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JiraHome jiraHome;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final ObjectMapper objectMapper;
    private static final Logger log = LoggerFactory.getLogger(MigAssetStatsService.class);

    @Inject
    public MigAssetStatsService(@NotNull JiraHome jiraHome, @NotNull ObjectMapperFactory objectMapperFactory, @NotNull MigrationEventBus migrationEventBus) {
        Intrinsics.checkNotNullParameter((Object)jiraHome, (String)"jiraHome");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        this.jiraHome = jiraHome;
        this.migrationEventBus = migrationEventBus;
        this.objectMapper = objectMapperFactory.createObjectMapper();
    }

    /*
     * WARNING - void declaration
     */
    public final void publishProjectAssetMetrics(@NotNull String migrationId, @NotNull String migrationScopeId2, @Nullable File chunkFile, @NotNull MigAssetStats.StatsType assetType, @Nullable String projectKey, @Nullable Long projectId, @Nullable Long issueCount) {
        Long l;
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)migrationScopeId2, (String)"migrationScopeId");
        Intrinsics.checkNotNullParameter((Object)((Object)assetType), (String)"assetType");
        String string = migrationId;
        String string2 = migrationScopeId2;
        File file2 = chunkFile;
        if (file2 != null) {
            void it;
            File file3 = file2;
            String string3 = string2;
            String string4 = string;
            boolean bl = false;
            Long l2 = it.length();
            string = string4;
            string2 = string3;
            l = l2;
        } else {
            l = null;
        }
        Long l3 = issueCount;
        Long l4 = projectId;
        String string5 = projectKey;
        Long l5 = null;
        Long l6 = null;
        MigAssetStats.StatsType statsType = assetType;
        Long l7 = l;
        String string6 = string2;
        String string7 = string;
        MigAssetStats migAssetsStats = new MigAssetStats(string7, string6, l7, statsType, l6, l5, string5, l4, l3);
        this.migrationEventBus.post(migAssetsStats);
    }

    public static /* synthetic */ void publishProjectAssetMetrics$default(MigAssetStatsService migAssetStatsService, String string, String string2, File file2, MigAssetStats.StatsType statsType, String string3, Long l, Long l2, int n, Object object) {
        if ((n & 0x10) != 0) {
            string3 = null;
        }
        if ((n & 0x20) != 0) {
            l = null;
        }
        if ((n & 0x40) != 0) {
            l2 = null;
        }
        migAssetStatsService.publishProjectAssetMetrics(string, string2, file2, statsType, string3, l, l2);
    }

    public final void publishUserGroupChunkMetric(@NotNull String migrationId, @NotNull String migrationScopeId2, @NotNull JiraUserGroupMigrationData jiraUserGroupMigrationData) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
            Intrinsics.checkNotNullParameter((Object)migrationScopeId2, (String)"migrationScopeId");
            Intrinsics.checkNotNullParameter((Object)jiraUserGroupMigrationData, (String)"jiraUserGroupMigrationData");
            File userGroupMigChunk = null;
            try {
                userGroupMigChunk = File.createTempFile(UUID.randomUUID().toString(), UUID.randomUUID().toString());
                this.objectMapper.writeValue(userGroupMigChunk, (Object)jiraUserGroupMigrationData);
            }
            catch (JsonProcessingException jsonProcessingException) {
                log.error("Encountered Json Processing Exception writing User Group File |" + (Object)((Object)jsonProcessingException) + '|');
            }
            catch (IOException exception) {
                log.error("Error creating User Group file |" + exception + '|');
            }
            MigAssetStatsService.publishProjectAssetMetrics$default(this, migrationId, migrationScopeId2, userGroupMigChunk, MigAssetStats.StatsType.USERS_GROUPS, null, null, null, 112, null);
            File file2 = userGroupMigChunk;
            if (file2 == null) break block3;
            file2.delete();
        }
    }

    public final void publishDiskStats(@NotNull String migrationId, @NotNull String migrationScopeId2) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)migrationScopeId2, (String)"migrationScopeId");
        Long totalDiskSpace = null;
        Long freeDiskSpace = null;
        try {
            Path jiraHomePath = Paths.get(this.jiraHome.getHome().getAbsolutePath(), new String[0]);
            totalDiskSpace = Files.getFileStore(jiraHomePath).getTotalSpace();
            freeDiskSpace = Files.getFileStore(jiraHomePath).getUsableSpace();
        }
        catch (IOException ioException) {
            log.error("Error Encountered calculating Disk Metric |" + ioException + '|');
        }
        MigAssetStats migAssetStats = new MigAssetStats(migrationId, migrationScopeId2, null, MigAssetStats.StatsType.DISK, totalDiskSpace, freeDiskSpace, null, null, null);
        this.migrationEventBus.post(migAssetStats);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/analytics/MigAssetStatsService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

