/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.analytics;

import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.jdmccservice.JdmccService;
import com.atlassian.jira.migration.jiraservice.JiraExtensionsKt;
import com.atlassian.jira.migration.migration.Migration;
import com.atlassian.jira.migration.migration.MigrationProtocol;
import com.atlassian.jira.migration.shadow.event.MigrationCompletionStatusEvent;
import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import com.atlassian.migration.api.ContainerToken;
import com.google.common.eventbus.Subscribe;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\fH\u0007J\b\u0010\u0015\u001a\u00020\fH\u0007J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/jira/migration/analytics/MigrationCompletionStatusEventHandler;", "", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "jiraThreadLocalUtil", "Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;", "jdmccService", "Lcom/atlassian/jira/migration/jdmccservice/JdmccService;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "(Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;Lcom/atlassian/jira/migration/jdmccservice/JdmccService;Lcom/atlassian/jira/migration/discovery/DiscoveryService;)V", "deregisterDataMovement", "", "event", "Lcom/atlassian/jira/migration/shadow/event/MigrationCompletionStatusEvent;", "migration", "Lcom/atlassian/jira/migration/migration/Migration;", "getValidContainerToken", "", "migrationId", "postConstruct", "preDestroy", "receive", "Companion", "jira-migration-plugin"})
public final class MigrationCompletionStatusEventHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final JiraThreadLocalUtil jiraThreadLocalUtil;
    @NotNull
    private final JdmccService jdmccService;
    @NotNull
    private final DiscoveryService discoveryService;
    private static final Logger log4jLogger = Logger.getLogger(MigrationCompletionStatusEventHandler.class);
    @NotNull
    private static final String SUCCESS = "SUCCESS";
    @NotNull
    private static final String FAILED = "FAILED";

    @Inject
    public MigrationCompletionStatusEventHandler(@NotNull MigrationEventBus migrationEventBus, @NotNull JiraThreadLocalUtil jiraThreadLocalUtil, @NotNull JdmccService jdmccService, @NotNull DiscoveryService discoveryService) {
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)jiraThreadLocalUtil, (String)"jiraThreadLocalUtil");
        Intrinsics.checkNotNullParameter((Object)jdmccService, (String)"jdmccService");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        this.migrationEventBus = migrationEventBus;
        this.jiraThreadLocalUtil = jiraThreadLocalUtil;
        this.jdmccService = jdmccService;
        this.discoveryService = discoveryService;
    }

    @PostConstruct
    public final void postConstruct() {
        this.migrationEventBus.register(this);
    }

    @Subscribe
    public final void receive(@NotNull MigrationCompletionStatusEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Logger logger2 = log4jLogger;
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"log4jLogger");
        JiraExtensionsKt.wrap(this.jiraThreadLocalUtil, logger2, (Function0)new Function0<Unit>(this, event){
            final /* synthetic */ MigrationCompletionStatusEventHandler this$0;
            final /* synthetic */ MigrationCompletionStatusEvent $event;
            {
                this.this$0 = $receiver;
                this.$event = $event;
                super(0);
            }

            public final void invoke() {
                block3: {
                    Migration migration;
                    block2: {
                        Migration migration2 = migration = MigrationCompletionStatusEventHandler.access$getDiscoveryService$p(this.this$0).findByMigrationId(this.$event.getMigrationId());
                        if ((migration2 != null ? migration2.getProtocol() : null) == MigrationProtocol.V3_5) break block2;
                        Migration migration3 = migration;
                        if ((migration3 != null ? migration3.getProtocol() : null) == MigrationProtocol.V4) break block2;
                        Migration migration4 = migration;
                        if ((migration4 != null ? migration4.getProtocol() : null) != MigrationProtocol.V3) break block3;
                    }
                    MigrationCompletionStatusEventHandler.access$deregisterDataMovement(this.this$0, this.$event, migration);
                }
            }
        });
    }

    @PreDestroy
    public final void preDestroy() {
        this.migrationEventBus.unregister(this);
    }

    private final void deregisterDataMovement(MigrationCompletionStatusEvent event, Migration migration) {
        try {
            if (migration.getDataMovementId() == null) {
                log4jLogger.warn((Object)("Could not find data movement for migration: " + event.getMigrationId() + ". Skipping de-registration"));
            } else {
                String status = event.isMigrationCompletedSuccessfully() ? SUCCESS : FAILED;
                String string = migration.getDataMovementId();
                Intrinsics.checkNotNull((Object)string);
                this.jdmccService.deregisterDataMovement(string, status, new ContainerToken(this.getValidContainerToken(event.getMigrationId())));
            }
        }
        catch (Exception e) {
            log4jLogger.warn((Object)("Could not de-register data movement for migrationId: " + event.getMigrationId()));
        }
    }

    private final String getValidContainerToken(String migrationId) {
        Object object = DiscoveryService.retrieveCloudSiteFor$default(this.discoveryService, migrationId, false, 2, null);
        if (object == null || (object = object.getContainerToken()) == null) {
            throw new IllegalStateException("Cloud site not found".toString());
        }
        return object;
    }

    public static final /* synthetic */ DiscoveryService access$getDiscoveryService$p(MigrationCompletionStatusEventHandler $this) {
        return $this.discoveryService;
    }

    public static final /* synthetic */ void access$deregisterDataMovement(MigrationCompletionStatusEventHandler $this, MigrationCompletionStatusEvent event, Migration migration) {
        $this.deregisterDataMovement(event, migration);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/atlassian/jira/migration/analytics/MigrationCompletionStatusEventHandler$Companion;", "", "()V", "FAILED", "", "SUCCESS", "log4jLogger", "Lorg/apache/log4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

