/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.analytics;

import com.atlassian.cmpt.analytics.AnalyticsSubProduct;
import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.GenericOperationalEvent;
import com.atlassian.cmpt.analytics.events.OperationalEventDto;
import com.atlassian.jira.migration.analytics.AnalyticsEventService;
import com.atlassian.jira.migration.cloud.CloudProductManager;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.MigrationPhaseEvent;
import com.atlassian.jira.migration.migration.Migration;
import com.atlassian.jira.migration.migration.MigrationRepository;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.plan.PlanRepository;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.eventbus.Subscribe;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B?\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0013\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\b\u0010\u001e\u001a\u00020\u001dH\u0007J\b\u0010\u001f\u001a\u00020\u001dH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/atlassian/jira/migration/analytics/MigrationProgressAnalyticsEventHandler;", "", "analyticsEventService", "Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "migrationRepository", "Lcom/atlassian/jira/migration/migration/MigrationRepository;", "planRepository", "Lcom/atlassian/jira/migration/plan/PlanRepository;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "cloudProductManager", "Lcom/atlassian/jira/migration/cloud/CloudProductManager;", "jiraThreadLocalUtil", "Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;", "(Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/migration/MigrationRepository;Lcom/atlassian/jira/migration/plan/PlanRepository;Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/jira/migration/cloud/CloudProductManager;Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;)V", "enrichEvent", "Lcom/atlassian/cmpt/analytics/events/EventDto;", "event", "Lcom/atlassian/jira/migration/events/MigrationPhaseEvent;", "getProjectType", "", "kotlin.jvm.PlatformType", "projectKey", "getSubProductForProjectEvent", "Lcom/atlassian/cmpt/analytics/AnalyticsSubProduct;", "Lcom/atlassian/cmpt/analytics/events/OperationalEventDto;", "onUserAndGroupMigrationStart", "", "postConstruct", "preDestroy", "Companion", "jira-migration-plugin"})
public final class MigrationProgressAnalyticsEventHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnalyticsEventService analyticsEventService;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final MigrationRepository migrationRepository;
    @NotNull
    private final PlanRepository planRepository;
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final CloudProductManager cloudProductManager;
    @NotNull
    private final JiraThreadLocalUtil jiraThreadLocalUtil;
    private static final Logger log4jLogger = Logger.getLogger(MigrationProgressAnalyticsEventHandler.class);

    @Inject
    public MigrationProgressAnalyticsEventHandler(@NotNull AnalyticsEventService analyticsEventService, @NotNull MigrationEventBus migrationEventBus, @NotNull MigrationRepository migrationRepository, @NotNull PlanRepository planRepository, @NotNull ProjectManager projectManager, @NotNull CloudProductManager cloudProductManager, @NotNull JiraThreadLocalUtil jiraThreadLocalUtil) {
        Intrinsics.checkNotNullParameter((Object)analyticsEventService, (String)"analyticsEventService");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)migrationRepository, (String)"migrationRepository");
        Intrinsics.checkNotNullParameter((Object)planRepository, (String)"planRepository");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)cloudProductManager, (String)"cloudProductManager");
        Intrinsics.checkNotNullParameter((Object)jiraThreadLocalUtil, (String)"jiraThreadLocalUtil");
        this.analyticsEventService = analyticsEventService;
        this.migrationEventBus = migrationEventBus;
        this.migrationRepository = migrationRepository;
        this.planRepository = planRepository;
        this.projectManager = projectManager;
        this.cloudProductManager = cloudProductManager;
        this.jiraThreadLocalUtil = jiraThreadLocalUtil;
    }

    @PostConstruct
    public final void postConstruct() {
        this.migrationEventBus.register(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    public final void onUserAndGroupMigrationStart(@NotNull MigrationPhaseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        try {
            this.jiraThreadLocalUtil.preCall();
            AnalyticsEventService.saveAnalyticsEvent$default(this.analyticsEventService, this.enrichEvent(event), null, 2, null);
        }
        finally {
            this.jiraThreadLocalUtil.postCall(log4jLogger);
        }
    }

    private final EventDto enrichEvent(MigrationPhaseEvent event) {
        Object it;
        GenericOperationalEvent.Builder builder;
        GenericOperationalEvent.Builder builder2;
        GenericOperationalEvent operationalEvent = event.asOperationalEvent();
        GenericOperationalEvent.Builder $this$enrichEvent_u24lambda_u242 = builder2 = (builder = new GenericOperationalEvent.Builder((OperationalEventDto)operationalEvent));
        boolean bl = false;
        Object v = operationalEvent.attributes.get("migrationId");
        if (v != null) {
            it = v;
            boolean bl2 = false;
            Intrinsics.checkNotNull(it, (String)"null cannot be cast to non-null type kotlin.String");
            String migrationId = (String)it;
            Migration migration = this.migrationRepository.findByMigrationId(migrationId);
            if (migration == null) {
                throw new IllegalStateException(("Migration id=" + migrationId + " not found").toString());
            }
            Migration migration2 = migration;
            Plan plan2 = this.planRepository.get(migration2.getPlanId());
            if (plan2 == null) {
                throw new IllegalStateException(("Plan for migration id=" + migrationId + " not found").toString());
            }
            Plan plan3 = plan2;
            $this$enrichEvent_u24lambda_u242.contextContainer("planId", plan3.getId());
            GenericOperationalEvent.Builder cfr_ignored_0 = (GenericOperationalEvent.Builder)$this$enrichEvent_u24lambda_u242.addAttribute("scopedUsers", (Object)plan3.getScopedUsersEnabled());
        }
        AnalyticsSubProduct analyticsSubProduct = this.getSubProductForProjectEvent((OperationalEventDto)operationalEvent);
        if (analyticsSubProduct != null) {
            it = analyticsSubProduct;
            boolean bl3 = false;
            $this$enrichEvent_u24lambda_u242.subProduct(it);
        }
        GenericOperationalEvent genericOperationalEvent = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)genericOperationalEvent, (String)"build(...)");
        return (EventDto)genericOperationalEvent;
    }

    @VisibleForTesting
    @Nullable
    public final AnalyticsSubProduct getSubProductForProjectEvent(@NotNull OperationalEventDto event) {
        AnalyticsSubProduct analyticsSubProduct;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String string = event.cloudId;
        if (string != null) {
            String cloudId2 = string;
            boolean bl = false;
            Object v = event.attributes.get("project");
            if (v != null) {
                Object it = v;
                boolean bl2 = false;
                Intrinsics.checkNotNull(it, (String)"null cannot be cast to non-null type kotlin.String");
                String projectType = this.getProjectType((String)it);
                Intrinsics.checkNotNull((Object)projectType);
                analyticsSubProduct = this.cloudProductManager.getSubProductByProjectTypeForCloud(cloudId2, projectType);
            } else {
                analyticsSubProduct = null;
            }
        } else {
            analyticsSubProduct = null;
        }
        return analyticsSubProduct;
    }

    private final String getProjectType(String projectKey) {
        return this.projectManager.getProjectObjByKey(projectKey).getProjectTypeKey().getKey();
    }

    @PreDestroy
    public final void preDestroy() {
        this.migrationEventBus.unregister(this);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/analytics/MigrationProgressAnalyticsEventHandler$Companion;", "", "()V", "log4jLogger", "Lorg/apache/log4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

