/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.analytics;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.jira.migration.GroupedThreadFactory;
import com.atlassian.jira.migration.analytics.AnalyticsEventService;
import com.atlassian.jira.migration.events.RdsScalingEvent;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/analytics/RdsScalingEventHandler;", "", "analyticsEventService", "Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;", "executor", "Ljava/util/concurrent/ExecutorService;", "(Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;Ljava/util/concurrent/ExecutorService;)V", "sendEventAsync", "", "command", "Ljava/lang/Runnable;", "sendRdsScalingEvent", "rdsScalingEvent", "Lcom/atlassian/jira/migration/events/RdsScalingEvent;", "shutdown", "Companion", "jira-migration-plugin"})
public final class RdsScalingEventHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnalyticsEventService analyticsEventService;
    @NotNull
    private final ExecutorService executor;
    private static final Logger log = LoggerFactory.getLogger(RdsScalingEventHandler.class);

    @Inject
    public RdsScalingEventHandler(@NotNull AnalyticsEventService analyticsEventService, @NotNull ExecutorService executor) {
        Intrinsics.checkNotNullParameter((Object)analyticsEventService, (String)"analyticsEventService");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.analyticsEventService = analyticsEventService;
        this.executor = executor;
    }

    public /* synthetic */ RdsScalingEventHandler(AnalyticsEventService analyticsEventService, ExecutorService executorService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ExecutorService executorService2 = Executors.newCachedThreadPool(new GroupedThreadFactory("RdsScalingEventHandler"));
            Intrinsics.checkNotNullExpressionValue((Object)executorService2, (String)"newCachedThreadPool(...)");
            executorService = executorService2;
        }
        this(analyticsEventService, executorService);
    }

    public final void sendEventAsync(@NotNull Runnable command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Object object = this;
        try {
            RdsScalingEventHandler $this$sendEventAsync_u24lambda_u241 = object;
            boolean bl = false;
            $this$sendEventAsync_u24lambda_u241.executor.execute(() -> RdsScalingEventHandler.sendEventAsync$lambda$1$lambda$0(command));
            return;
        }
        catch (Throwable bl) {
            block2: {
                Object object2;
                object = object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                if (throwable == null) break block2;
                Object exception = object2 = throwable;
                boolean bl2 = false;
                log.error("Failed to send event async, Reason : " + ((Throwable)exception).getMessage() + '.');
            }
            return;
        }
    }

    public final void sendRdsScalingEvent(@NotNull RdsScalingEvent rdsScalingEvent) {
        Intrinsics.checkNotNullParameter((Object)rdsScalingEvent, (String)"rdsScalingEvent");
        this.sendEventAsync(() -> RdsScalingEventHandler.sendRdsScalingEvent$lambda$3(this, rdsScalingEvent));
        log.info("Sent RDS Scaling Event for migration plan:" + rdsScalingEvent.getPlanId());
    }

    @PreDestroy
    public final void shutdown() {
        this.executor.shutdownNow();
    }

    private static final void sendEventAsync$lambda$1$lambda$0(Runnable $command) {
        Intrinsics.checkNotNullParameter((Object)$command, (String)"$command");
        $command.run();
    }

    private static final void sendRdsScalingEvent$lambda$3(RdsScalingEventHandler this$0, RdsScalingEvent $rdsScalingEvent) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$rdsScalingEvent, (String)"$rdsScalingEvent");
        AnalyticsEventService.saveAnalyticsEvent$default(this$0.analyticsEventService, (EventDto)$rdsScalingEvent.asOperationalEvent(), null, 2, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/analytics/RdsScalingEventHandler$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

