/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.analytics;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.jira.migration.analytics.AnalyticsEventService;
import com.atlassian.jira.migration.events.ReconEvent;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/analytics/ReconEventHandler;", "", "analyticsEventService", "Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;", "(Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;)V", "sendEntityReconEvent", "", "reconEvent", "Lcom/atlassian/jira/migration/events/ReconEvent;", "sendReconEvent", "Companion", "jira-migration-plugin"})
public final class ReconEventHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnalyticsEventService analyticsEventService;
    private static final Logger log = LoggerFactory.getLogger(ReconEventHandler.class);

    @Inject
    public ReconEventHandler(@NotNull AnalyticsEventService analyticsEventService) {
        Intrinsics.checkNotNullParameter((Object)analyticsEventService, (String)"analyticsEventService");
        this.analyticsEventService = analyticsEventService;
    }

    public final void sendReconEvent(@NotNull ReconEvent reconEvent) {
        Intrinsics.checkNotNullParameter((Object)reconEvent, (String)"reconEvent");
        AnalyticsEventService.saveAnalyticsEvent$default(this.analyticsEventService, (EventDto)reconEvent.asOperationalEvent(), null, 2, null);
        log.info("Sent Recon Event for migration cloudId:" + reconEvent.getCloudId() + " executionId:" + reconEvent.getExecutionId());
    }

    public final void sendEntityReconEvent(@NotNull ReconEvent reconEvent) {
        Intrinsics.checkNotNullParameter((Object)reconEvent, (String)"reconEvent");
        AnalyticsEventService.saveAnalyticsEvent$default(this.analyticsEventService, (EventDto)reconEvent.asEntityOperationalEvent(), null, 2, null);
        log.info("Sent Recon Entity Event for migration cloudId:" + reconEvent.getCloudId() + " executionId:" + reconEvent.getExecutionId() + " entity:" + reconEvent.getEntity());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/analytics/ReconEventHandler$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

