/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.analytics;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.GenericOperationalEvent;
import com.atlassian.cmpt.analytics.events.def.JiraInstanceAnalysisEvent;
import com.atlassian.jira.migration.analytics.AnalyticsEventService;
import com.atlassian.jira.migration.analytics.ServerAnalysisService;
import com.atlassian.jira.migration.common.PluginAccessorExtensionsKt;
import com.atlassian.jira.migration.crypto.SecretKeyConfigHandler;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.serverdataextractors.AttachmentStatsDto;
import com.atlassian.jira.migration.serverdataextractors.JiraServerStatsReader;
import com.atlassian.jira.migration.serverdataextractors.PortletConfigurationDto;
import com.atlassian.jira.migration.serverdataextractors.UserSubset;
import com.atlassian.jira.migration.version.AdvancedRoadmapsVersionService;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 %2\u00020\u0001:\u0001%BO\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014B[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0018J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001aJ\u0006\u0010\u001c\u001a\u00020\u001aJ\b\u0010\u001d\u001a\u00020\u001aH\u0002J\b\u0010\u001e\u001a\u00020\u001aH\u0002J\b\u0010\u001f\u001a\u00020\u001aH\u0007J\b\u0010 \u001a\u00020\u001aH\u0007J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/atlassian/jira/migration/analytics/ServerAnalysisEventJobRunner;", "Lcom/atlassian/scheduler/JobRunner;", "analyticsEventService", "Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;", "schedulerService", "Lcom/atlassian/scheduler/SchedulerService;", "jiraServerStatsReader", "Lcom/atlassian/jira/migration/serverdataextractors/JiraServerStatsReader;", "serverAnalysisService", "Lcom/atlassian/jira/migration/analytics/ServerAnalysisService;", "advancedRoadmapsVersionService", "Lcom/atlassian/jira/migration/version/AdvancedRoadmapsVersionService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "licenseHandler", "Lcom/atlassian/sal/api/license/LicenseHandler;", "secretKeyConfigHandler", "Lcom/atlassian/jira/migration/crypto/SecretKeyConfigHandler;", "pluginAccessor", "Lcom/atlassian/plugin/PluginAccessor;", "(Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;Lcom/atlassian/scheduler/SchedulerService;Lcom/atlassian/jira/migration/serverdataextractors/JiraServerStatsReader;Lcom/atlassian/jira/migration/analytics/ServerAnalysisService;Lcom/atlassian/jira/migration/version/AdvancedRoadmapsVersionService;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/sal/api/license/LicenseHandler;Lcom/atlassian/jira/migration/crypto/SecretKeyConfigHandler;Lcom/atlassian/plugin/PluginAccessor;)V", "instantSupplier", "Ljava/util/function/Supplier;", "Ljava/time/Instant;", "(Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;Lcom/atlassian/scheduler/SchedulerService;Lcom/atlassian/jira/migration/serverdataextractors/JiraServerStatsReader;Lcom/atlassian/jira/migration/analytics/ServerAnalysisService;Lcom/atlassian/jira/migration/version/AdvancedRoadmapsVersionService;Ljava/util/function/Supplier;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/sal/api/license/LicenseHandler;Lcom/atlassian/jira/migration/crypto/SecretKeyConfigHandler;Lcom/atlassian/plugin/PluginAccessor;)V", "analyseAssetsAndSaveEvents", "", "analyseDashboardsAndSaveEvent", "analyseGadgetsAndSaveEvent", "analyseInstanceAndSaveEvent", "analyseUserClassificationsAndSaveEvent", "cleanup", "postConstruct", "runJob", "Lcom/atlassian/scheduler/JobRunnerResponse;", "request", "Lcom/atlassian/scheduler/JobRunnerRequest;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nServerAnalysisEventJobRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerAnalysisEventJobRunner.kt\ncom/atlassian/jira/migration/analytics/ServerAnalysisEventJobRunner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,315:1\n1855#2,2:316\n*S KotlinDebug\n*F\n+ 1 ServerAnalysisEventJobRunner.kt\ncom/atlassian/jira/migration/analytics/ServerAnalysisEventJobRunner\n*L\n189#1:316,2\n*E\n"})
public final class ServerAnalysisEventJobRunner
implements JobRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnalyticsEventService analyticsEventService;
    @NotNull
    private final SchedulerService schedulerService;
    @NotNull
    private final JiraServerStatsReader jiraServerStatsReader;
    @NotNull
    private final ServerAnalysisService serverAnalysisService;
    @NotNull
    private final AdvancedRoadmapsVersionService advancedRoadmapsVersionService;
    @NotNull
    private final Supplier<Instant> instantSupplier;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final LicenseHandler licenseHandler;
    @NotNull
    private final SecretKeyConfigHandler secretKeyConfigHandler;
    @NotNull
    private final PluginAccessor pluginAccessor;
    @NotNull
    private static final JobRunnerKey JOB_RUNNER_KEY;
    @NotNull
    private static final JobId JOB_ID;
    @NotNull
    public static final String ISSUE_LINK_TYPES_COUNT = "issueLinkTypesCount";
    @NotNull
    public static final String DEP_ISSUE_LINK_TYPES_COUNT = "depIssueLinkTypesCount";
    @NotNull
    public static final String DEP_ISSUE_LINK_TYPES_JOIN_ISSUE_LINK_TYPES_EXECUTION_TIME = "depIssueLinkTypesJoinIssueLinkTypesExecutionTime";
    @NotNull
    public static final String USER_CLASSIFICATION_METRICS = "userClassificationMetrics";
    @NotNull
    public static final String DASHBOARD_COUNT_METRICS = "dashboardCountMetrics";
    @NotNull
    public static final String ASSETS_COUNT_METRICS = "assetsCountMetrics";
    @NotNull
    public static final String DASHBOARD_COUNT = "dashboardCount";
    @NotNull
    public static final String ASSETS_OBJ_SCHEMA_COUNT = "assetObjSchemaCount";
    @NotNull
    public static final String ASSETS_OBJ_TYPE_COUNT = "assetObjTypeCount";
    @NotNull
    public static final String ASSETS_OBJ_COUNT = "assetObjCount";
    @NotNull
    public static final String ASSETS_ATTR_OBJ_TYPE_AVG_COUNT = "assetAttrObjTypeAvgCount";
    @NotNull
    public static final String ASSETS_ATTR_OBJ_TYPE_MAX_COUNT = "assetAttrObjTypeMaxCount";
    @NotNull
    public static final String ASSETS_UNIQUE_ATTR_OBJ_TYPE_AVG_COUNT = "assetUniqueAttrObjTypeAvgCount";
    @NotNull
    public static final String ASSETS_UNIQUE_ATTR_OBJ_TYPE_MAX_COUNT = "assetUniqueAttrObjTypeMaxCount";
    @NotNull
    public static final String ASSETS_ISSUE_LINK_TOTAL_COUNT = "assetIssueLinkTotalCount";
    @NotNull
    public static final String ASSETS_ISSUE_LINK_MAX_COUNT = "assetIssueLinkMaxCount";
    @NotNull
    public static final String ISSUE_ASSETS_LINK_TOTAL_COUNT = "issueAssetLinkTotalCount";
    @NotNull
    public static final String ISSUE_ASSETS_LINK_MAX_COUNT = "issueAssetLinkMaxCount";
    @NotNull
    public static final String ASSETS_SCHEMA_WITH_ISSUES_LINKED_COUNT = "assetSchemaWithIssuesLinkedCount";
    @NotNull
    public static final String ASSETS_OBJECTS_PER_CF_PER_ISSUE_MAX_COUNT = "assetObjectsPerCFPerIssueMaxCount";
    @NotNull
    public static final String GADGETS_COUNT = "gadgetsCount";
    @NotNull
    public static final String GADGET_KEY_METRICS = "gadgetKeyMetrics";
    @NotNull
    public static final String GADGET_KEYS = "gadgetKeys";
    @NotNull
    public static final String SECRET_KEY_LOCATION = "secretKeyLocation";
    private static final Logger log;

    public ServerAnalysisEventJobRunner(@NotNull AnalyticsEventService analyticsEventService, @NotNull SchedulerService schedulerService, @NotNull JiraServerStatsReader jiraServerStatsReader, @NotNull ServerAnalysisService serverAnalysisService, @NotNull AdvancedRoadmapsVersionService advancedRoadmapsVersionService, @NotNull Supplier<Instant> instantSupplier, @NotNull MigrationFeatures migrationFeatures, @NotNull LicenseHandler licenseHandler, @NotNull SecretKeyConfigHandler secretKeyConfigHandler, @NotNull PluginAccessor pluginAccessor) {
        Intrinsics.checkNotNullParameter((Object)analyticsEventService, (String)"analyticsEventService");
        Intrinsics.checkNotNullParameter((Object)schedulerService, (String)"schedulerService");
        Intrinsics.checkNotNullParameter((Object)jiraServerStatsReader, (String)"jiraServerStatsReader");
        Intrinsics.checkNotNullParameter((Object)serverAnalysisService, (String)"serverAnalysisService");
        Intrinsics.checkNotNullParameter((Object)advancedRoadmapsVersionService, (String)"advancedRoadmapsVersionService");
        Intrinsics.checkNotNullParameter(instantSupplier, (String)"instantSupplier");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)licenseHandler, (String)"licenseHandler");
        Intrinsics.checkNotNullParameter((Object)secretKeyConfigHandler, (String)"secretKeyConfigHandler");
        Intrinsics.checkNotNullParameter((Object)pluginAccessor, (String)"pluginAccessor");
        this.analyticsEventService = analyticsEventService;
        this.schedulerService = schedulerService;
        this.jiraServerStatsReader = jiraServerStatsReader;
        this.serverAnalysisService = serverAnalysisService;
        this.advancedRoadmapsVersionService = advancedRoadmapsVersionService;
        this.instantSupplier = instantSupplier;
        this.migrationFeatures = migrationFeatures;
        this.licenseHandler = licenseHandler;
        this.secretKeyConfigHandler = secretKeyConfigHandler;
        this.pluginAccessor = pluginAccessor;
    }

    @Inject
    public ServerAnalysisEventJobRunner(@NotNull AnalyticsEventService analyticsEventService, @NotNull SchedulerService schedulerService, @NotNull JiraServerStatsReader jiraServerStatsReader, @NotNull ServerAnalysisService serverAnalysisService, @NotNull AdvancedRoadmapsVersionService advancedRoadmapsVersionService, @NotNull MigrationFeatures migrationFeatures, @NotNull LicenseHandler licenseHandler, @NotNull SecretKeyConfigHandler secretKeyConfigHandler, @NotNull PluginAccessor pluginAccessor) {
        Intrinsics.checkNotNullParameter((Object)analyticsEventService, (String)"analyticsEventService");
        Intrinsics.checkNotNullParameter((Object)schedulerService, (String)"schedulerService");
        Intrinsics.checkNotNullParameter((Object)jiraServerStatsReader, (String)"jiraServerStatsReader");
        Intrinsics.checkNotNullParameter((Object)serverAnalysisService, (String)"serverAnalysisService");
        Intrinsics.checkNotNullParameter((Object)advancedRoadmapsVersionService, (String)"advancedRoadmapsVersionService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)licenseHandler, (String)"licenseHandler");
        Intrinsics.checkNotNullParameter((Object)secretKeyConfigHandler, (String)"secretKeyConfigHandler");
        Intrinsics.checkNotNullParameter((Object)pluginAccessor, (String)"pluginAccessor");
        this(analyticsEventService, schedulerService, jiraServerStatsReader, serverAnalysisService, advancedRoadmapsVersionService, ServerAnalysisEventJobRunner::_init_$lambda$0, migrationFeatures, licenseHandler, secretKeyConfigHandler, pluginAccessor);
    }

    @PostConstruct
    public final void postConstruct() {
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)this);
        this.schedulerService.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)TimeUnit.DAYS.toMillis(7L), (Date)Date.from(Instant.now().plus(Duration.ofMinutes(10L))))));
        log.info("Successfully registered server analysis job {}. " + JOB_RUNNER_KEY);
    }

    @PreDestroy
    public final void cleanup() {
        this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
        log.info("Successfully unregistered server analysis job " + JOB_RUNNER_KEY);
    }

    @Nullable
    public JobRunnerResponse runJob(@NotNull JobRunnerRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        long startTime = System.nanoTime();
        this.analyseInstanceAndSaveEvent();
        if (!this.migrationFeatures.getDisablePortalCustomersClassificationAnalytics()) {
            this.analyseUserClassificationsAndSaveEvent();
        }
        if (!this.migrationFeatures.getDisableAssetsAnalytics() && PluginAccessorExtensionsKt.hasAssetsInstalled(this.pluginAccessor)) {
            this.analyseAssetsAndSaveEvents();
        }
        this.analyseDashboardsAndSaveEvent();
        this.analyseGadgetsAndSaveEvent();
        log.debug("instance analysis took " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime) + "ms");
        return JobRunnerResponse.success();
    }

    private final void analyseInstanceAndSaveEvent() {
        long usersCount = this.jiraServerStatsReader.getAllUsersCount(UserSubset.ALLUSERS);
        long groupsCount = this.jiraServerStatsReader.getAllGroupsCount();
        long countOfIssues = this.jiraServerStatsReader.calculateNumberOfIssues();
        long countOfAttachments = this.jiraServerStatsReader.calculateNumberOfAttachments();
        long sizeOfAttachments = this.jiraServerStatsReader.calculateSizeOfAttachments();
        JiraServerStatsReader jiraServerStatsReader = this.jiraServerStatsReader;
        long l = usersCount + groupsCount;
        AttachmentStatsDto attachmentStatsDto = new AttachmentStatsDto(countOfAttachments, sizeOfAttachments);
        long estimatedTimeInSeconds = JiraServerStatsReader.estimatedMigrationTimeSeconds$default(jiraServerStatsReader, countOfIssues, attachmentStatsDto, l, 0L, true, 8, null);
        String secretKeyLocation = this.migrationFeatures.getEnableTokenEncryption() ? this.secretKeyConfigHandler.getSecretKeyLocation() : "None";
        JiraInstanceAnalysisEvent event = ((JiraInstanceAnalysisEvent.Builder)((JiraInstanceAnalysisEvent.Builder)((JiraInstanceAnalysisEvent.Builder)((JiraInstanceAnalysisEvent.Builder)new JiraInstanceAnalysisEvent.Builder(this.instantSupplier.get().toEpochMilli()).withDeploymentInfo(this.jiraServerStatsReader.isClustered(), this.jiraServerStatsReader.getNumberOfClusterNodes()).withDbInfo(this.jiraServerStatsReader.databaseProductName(), this.jiraServerStatsReader.databaseProductVersion()).withLdapInfo(this.serverAnalysisService.hasLdap()).estimatedMigrationTimeInSeconds(estimatedTimeInSeconds).numberOfProjects(this.jiraServerStatsReader.calculateNumberOfProjects()).numberOfIssues(countOfIssues).numberOfAttachments(countOfAttachments).attachmentsSizeInBytes(sizeOfAttachments).numberOfGroups(groupsCount).numberOfActiveUsers(this.jiraServerStatsReader.getAllUsersCount(UserSubset.ACTIVE)).numberOfInactiveUsers(this.jiraServerStatsReader.getAllUsersCount(UserSubset.INACTIVE)).withArVersion(this.advancedRoadmapsVersionService.getPluginVersion()).addAttribute(ISSUE_LINK_TYPES_COUNT, (Object)this.jiraServerStatsReader.calculateNumberOfIssueLinkTypes())).addAttribute(DEP_ISSUE_LINK_TYPES_COUNT, (Object)this.jiraServerStatsReader.calculateNumberOfDependencyIssueLinkTypes())).addAttribute(DEP_ISSUE_LINK_TYPES_JOIN_ISSUE_LINK_TYPES_EXECUTION_TIME, (Object)this.serverAnalysisService.calculateExecutionTimeForGetDependencyIssueLinkTypes())).addAttribute(SECRET_KEY_LOCATION, (Object)secretKeyLocation)).build();
        Intrinsics.checkNotNull((Object)event);
        AnalyticsEventService.saveAnalyticsEvent$default(this.analyticsEventService, (EventDto)event, null, 2, null);
    }

    public final void analyseDashboardsAndSaveEvent() {
        try {
            GenericOperationalEvent genericOperationalEvent = ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(Instant.now().toEpochMilli()).action("logged")).actionSubject(DASHBOARD_COUNT_METRICS, DASHBOARD_COUNT_METRICS)).contextContainer("serverId", this.licenseHandler.getServerId())).cloudId("")).source("JCMA")).addAttribute(DASHBOARD_COUNT, (Object)this.jiraServerStatsReader.calculateNumberOfPortalPage())).addAttribute(GADGETS_COUNT, (Object)this.jiraServerStatsReader.calculateNumberOfPortletConfiguration())).build();
            Intrinsics.checkNotNullExpressionValue((Object)genericOperationalEvent, (String)"build(...)");
            AnalyticsEventService.saveAnalyticsEvent$default(this.analyticsEventService, (EventDto)genericOperationalEvent, null, 2, null);
        }
        catch (Exception e) {
            log.warn("Failed to capture event for Dashboards due to Exception " + e);
        }
    }

    public final void analyseGadgetsAndSaveEvent() {
        try {
            List<PortletConfigurationDto> gadgetsInServer = this.jiraServerStatsReader.getAllPortletConfiguration();
            List gadgetKeysInServer = null;
            gadgetKeysInServer = new ArrayList();
            Iterable $this$forEach$iv = gadgetsInServer;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PortletConfigurationDto it = (PortletConfigurationDto)element$iv;
                boolean bl = false;
                String string = it.getGadgetXml();
                if (string == null) {
                    string = it.getCompleteModuleKey();
                }
                gadgetKeysInServer.add(string);
            }
            GenericOperationalEvent genericOperationalEvent = ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(Instant.now().toEpochMilli()).action("logged")).actionSubject(GADGET_KEY_METRICS, GADGET_KEY_METRICS)).contextContainer("serverId", this.licenseHandler.getServerId())).cloudId("")).source("JCMA")).addAttribute(GADGET_KEYS, (Object)gadgetKeysInServer)).build();
            Intrinsics.checkNotNullExpressionValue((Object)genericOperationalEvent, (String)"build(...)");
            AnalyticsEventService.saveAnalyticsEvent$default(this.analyticsEventService, (EventDto)genericOperationalEvent, null, 2, null);
        }
        catch (Exception e) {
            log.warn("Failed to capture event for gadget keys due to Exception " + e);
        }
    }

    private final void analyseUserClassificationsAndSaveEvent() {
        try {
            GenericOperationalEvent genericOperationalEvent = ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(Instant.now().toEpochMilli()).action("logged")).actionSubject(USER_CLASSIFICATION_METRICS, USER_CLASSIFICATION_METRICS)).contextContainer("migration", "")).cloudId("")).source("JCMA")).addAttribute(USER_CLASSIFICATION_METRICS, (Object)this.serverAnalysisService.getUserClassificationMetrics())).build();
            Intrinsics.checkNotNullExpressionValue((Object)genericOperationalEvent, (String)"build(...)");
            AnalyticsEventService.saveAnalyticsEvent$default(this.analyticsEventService, (EventDto)genericOperationalEvent, null, 2, null);
        }
        catch (Exception e) {
            log.warn("Failed to capture userClassificationMetrics due to Exception " + e);
        }
    }

    public final void analyseAssetsAndSaveEvents() {
        try {
            log.info("Fetching Assets Data for analytics");
            long totalObjectSchemaCount = this.jiraServerStatsReader.calculateNumberOfObjectSchema();
            long totalObjectTypeCount = this.jiraServerStatsReader.calculateNumberOfObjectType();
            long totalObjectCount = this.jiraServerStatsReader.calculateNumberOfObject();
            Pair<Long, Double> maxAndAvgAttrPerObjType = this.jiraServerStatsReader.calculateMaxAndAvgNumberOfAttrPerObjectType();
            Pair<Long, Double> maxAndAvgUniqueAttrPerObjType = this.jiraServerStatsReader.calculateMaxAndAvgNumberOfUniqueAttrPerObjectType();
            Pair<Long, Long> totalAndMaxNumberOfObjectIssueLink = this.jiraServerStatsReader.calculateTotalAndMaxNumberOfObjectIssueLink();
            Pair<Long, Long> totalAndMaxNumberOfIssueObjectLink = this.jiraServerStatsReader.calculateTotalAndMaxNumberOfIssueObjectLink();
            Long countOfDistinctObjSchemaLinkedToJiraIssues = this.jiraServerStatsReader.calculateCountOfDistinctObjSchemaLinkedToJiraIssues();
            long maxObjectsPerCFPerIssue = this.jiraServerStatsReader.calculateMaxNumberOfObjectsPerCustomFieldPerIssue();
            GenericOperationalEvent genericOperationalEvent = ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(Instant.now().toEpochMilli()).action("logged")).actionSubject(ASSETS_COUNT_METRICS, ASSETS_COUNT_METRICS)).contextContainer("serverId", this.licenseHandler.getServerId())).cloudId("")).source("JCMA")).addAttribute(ASSETS_OBJ_SCHEMA_COUNT, (Object)totalObjectSchemaCount)).addAttribute(ASSETS_OBJ_TYPE_COUNT, (Object)totalObjectTypeCount)).addAttribute(ASSETS_OBJ_COUNT, (Object)totalObjectCount)).addAttribute(ASSETS_ATTR_OBJ_TYPE_AVG_COUNT, maxAndAvgAttrPerObjType.getSecond())).addAttribute(ASSETS_ATTR_OBJ_TYPE_MAX_COUNT, maxAndAvgAttrPerObjType.getFirst())).addAttribute(ASSETS_UNIQUE_ATTR_OBJ_TYPE_AVG_COUNT, maxAndAvgUniqueAttrPerObjType.getSecond())).addAttribute(ASSETS_UNIQUE_ATTR_OBJ_TYPE_MAX_COUNT, maxAndAvgUniqueAttrPerObjType.getFirst())).addAttribute(ASSETS_ISSUE_LINK_TOTAL_COUNT, totalAndMaxNumberOfObjectIssueLink.getFirst())).addAttribute(ASSETS_ISSUE_LINK_MAX_COUNT, totalAndMaxNumberOfObjectIssueLink.getSecond())).addAttribute(ISSUE_ASSETS_LINK_TOTAL_COUNT, totalAndMaxNumberOfIssueObjectLink.getFirst())).addAttribute(ISSUE_ASSETS_LINK_MAX_COUNT, totalAndMaxNumberOfIssueObjectLink.getSecond())).addAttribute(ASSETS_SCHEMA_WITH_ISSUES_LINKED_COUNT, (Object)countOfDistinctObjSchemaLinkedToJiraIssues)).addAttribute(ASSETS_OBJECTS_PER_CF_PER_ISSUE_MAX_COUNT, (Object)maxObjectsPerCFPerIssue)).build();
            Intrinsics.checkNotNullExpressionValue((Object)genericOperationalEvent, (String)"build(...)");
            AnalyticsEventService.saveAnalyticsEvent$default(this.analyticsEventService, (EventDto)genericOperationalEvent, null, 2, null);
        }
        catch (Exception e) {
            log.warn("Failed to capture event for Assets due to Exception " + e);
        }
    }

    private static final Instant _init_$lambda$0() {
        return Instant.now();
    }

    static {
        JobRunnerKey jobRunnerKey = JobRunnerKey.of((String)"jira-migration-analytics-server-analysis-job-key");
        Intrinsics.checkNotNull((Object)jobRunnerKey);
        JOB_RUNNER_KEY = jobRunnerKey;
        JobId jobId = JobId.of((String)"jira-migration-analytics-server-analysis-job-id");
        Intrinsics.checkNotNull((Object)jobId);
        JOB_ID = jobId;
        log = LoggerFactory.getLogger(ServerAnalysisEventJobRunner.class);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010$\u001a\n &*\u0004\u0018\u00010%0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/atlassian/jira/migration/analytics/ServerAnalysisEventJobRunner$Companion;", "", "()V", "ASSETS_ATTR_OBJ_TYPE_AVG_COUNT", "", "ASSETS_ATTR_OBJ_TYPE_MAX_COUNT", "ASSETS_COUNT_METRICS", "ASSETS_ISSUE_LINK_MAX_COUNT", "ASSETS_ISSUE_LINK_TOTAL_COUNT", "ASSETS_OBJECTS_PER_CF_PER_ISSUE_MAX_COUNT", "ASSETS_OBJ_COUNT", "ASSETS_OBJ_SCHEMA_COUNT", "ASSETS_OBJ_TYPE_COUNT", "ASSETS_SCHEMA_WITH_ISSUES_LINKED_COUNT", "ASSETS_UNIQUE_ATTR_OBJ_TYPE_AVG_COUNT", "ASSETS_UNIQUE_ATTR_OBJ_TYPE_MAX_COUNT", "DASHBOARD_COUNT", "DASHBOARD_COUNT_METRICS", "DEP_ISSUE_LINK_TYPES_COUNT", "DEP_ISSUE_LINK_TYPES_JOIN_ISSUE_LINK_TYPES_EXECUTION_TIME", "GADGETS_COUNT", "GADGET_KEYS", "GADGET_KEY_METRICS", "ISSUE_ASSETS_LINK_MAX_COUNT", "ISSUE_ASSETS_LINK_TOTAL_COUNT", "ISSUE_LINK_TYPES_COUNT", "JOB_ID", "Lcom/atlassian/scheduler/config/JobId;", "getJOB_ID", "()Lcom/atlassian/scheduler/config/JobId;", "JOB_RUNNER_KEY", "Lcom/atlassian/scheduler/config/JobRunnerKey;", "getJOB_RUNNER_KEY", "()Lcom/atlassian/scheduler/config/JobRunnerKey;", "SECRET_KEY_LOCATION", "USER_CLASSIFICATION_METRICS", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JobRunnerKey getJOB_RUNNER_KEY() {
            return JOB_RUNNER_KEY;
        }

        @NotNull
        public final JobId getJOB_ID() {
            return JOB_ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

