/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.analytics;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.jira.migration.export.db.advancedroadmaps.DependencyIssueLinkTypesDataReader;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraGroupReader;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUserReader;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JsmCustomerReaderAnalytics;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UserClassificationMetrics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\r\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/jira/migration/analytics/ServerAnalysisService;", "", "directoryManager", "Lcom/atlassian/crowd/manager/directory/DirectoryManager;", "jiraGroupReader", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraGroupReader;", "jiraUserReader", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUserReader;", "jsmCustomerReaderAnalytics", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JsmCustomerReaderAnalytics;", "dependencyIssueLinkTypesDataReader", "Lcom/atlassian/jira/migration/export/db/advancedroadmaps/DependencyIssueLinkTypesDataReader;", "(Lcom/atlassian/crowd/manager/directory/DirectoryManager;Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraGroupReader;Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUserReader;Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JsmCustomerReaderAnalytics;Lcom/atlassian/jira/migration/export/db/advancedroadmaps/DependencyIssueLinkTypesDataReader;)V", "calculateExecutionTimeForGetDependencyIssueLinkTypes", "", "()Ljava/lang/Long;", "getUserClassificationMetrics", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/UserClassificationMetrics;", "hasLdap", "", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nServerAnalysisService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerAnalysisService.kt\ncom/atlassian/jira/migration/analytics/ServerAnalysisService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,52:1\n766#2:53\n857#2,2:54\n1549#2:56\n1620#2,3:57\n1747#2,3:60\n17#3,6:63\n*S KotlinDebug\n*F\n+ 1 ServerAnalysisService.kt\ncom/atlassian/jira/migration/analytics/ServerAnalysisService\n*L\n28#1:53\n28#1:54,2\n29#1:56\n29#1:57,3\n30#1:60,3\n37#1:63,6\n*E\n"})
public final class ServerAnalysisService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DirectoryManager directoryManager;
    @NotNull
    private final JiraGroupReader jiraGroupReader;
    @NotNull
    private final JiraUserReader jiraUserReader;
    @NotNull
    private final JsmCustomerReaderAnalytics jsmCustomerReaderAnalytics;
    @NotNull
    private final DependencyIssueLinkTypesDataReader dependencyIssueLinkTypesDataReader;
    @NotNull
    private static final Set<DirectoryType> LDAP_DIRECTORY_TYPES;
    @NotNull
    private static final Logger log;

    @Inject
    public ServerAnalysisService(@NotNull DirectoryManager directoryManager, @NotNull JiraGroupReader jiraGroupReader, @NotNull JiraUserReader jiraUserReader, @NotNull JsmCustomerReaderAnalytics jsmCustomerReaderAnalytics, @NotNull DependencyIssueLinkTypesDataReader dependencyIssueLinkTypesDataReader) {
        Intrinsics.checkNotNullParameter((Object)directoryManager, (String)"directoryManager");
        Intrinsics.checkNotNullParameter((Object)jiraGroupReader, (String)"jiraGroupReader");
        Intrinsics.checkNotNullParameter((Object)jiraUserReader, (String)"jiraUserReader");
        Intrinsics.checkNotNullParameter((Object)jsmCustomerReaderAnalytics, (String)"jsmCustomerReaderAnalytics");
        Intrinsics.checkNotNullParameter((Object)dependencyIssueLinkTypesDataReader, (String)"dependencyIssueLinkTypesDataReader");
        this.directoryManager = directoryManager;
        this.jiraGroupReader = jiraGroupReader;
        this.jiraUserReader = jiraUserReader;
        this.jsmCustomerReaderAnalytics = jsmCustomerReaderAnalytics;
        this.dependencyIssueLinkTypesDataReader = dependencyIssueLinkTypesDataReader;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean hasLdap() {
        boolean bl;
        block5: {
            void $this$mapTo$iv$iv;
            Directory it;
            Iterable $this$filterTo$iv$iv;
            List list = this.directoryManager.findAllDirectories();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findAllDirectories(...)");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Directory)element$iv$iv;
                boolean bl2 = false;
                if (!it.isActive()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Directory)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(it.getType());
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    DirectoryType it2 = (DirectoryType)element$iv;
                    boolean bl4 = false;
                    if (!LDAP_DIRECTORY_TYPES.contains(it2)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final UserClassificationMetrics getUserClassificationMetrics() {
        return this.jsmCustomerReaderAnalytics.getUserClassificationMetrics(this.jiraUserReader.allUsers(), this.jiraGroupReader.allGroups());
    }

    @Nullable
    public final Long calculateExecutionTimeForGetDependencyIssueLinkTypes() {
        Long l;
        try {
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            this.dependencyIssueLinkTypesDataReader.getDependencyIssueLinkTypes();
            l = System.currentTimeMillis() - start$iv;
        }
        catch (Exception ex) {
            log.info("Failed to fetch execution time for dependency issue link types with: " + ex);
            l = null;
        }
        return l;
    }

    static {
        Object[] objectArray = new DirectoryType[]{DirectoryType.CONNECTOR, DirectoryType.DELEGATING, DirectoryType.CUSTOM};
        LDAP_DIRECTORY_TYPES = SetsKt.setOf((Object[])objectArray);
        Logger logger2 = LoggerFactory.getLogger(ServerAnalysisService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/analytics/ServerAnalysisService$Companion;", "", "()V", "LDAP_DIRECTORY_TYPES", "", "Lcom/atlassian/crowd/embedded/api/DirectoryType;", "log", "Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

