/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.analytics.crossproject.service;

import com.atlassian.jira.migration.dashboardstats.EntityType;
import com.atlassian.jira.migration.dashboardstats.ExportStats;
import com.atlassian.jira.migration.events.CrossProjectRapidViewFilterMissingProjectSelectionCheckStatsEvent;
import com.atlassian.jira.migration.events.DashboardsMissingProjectSelectionCheckStatsEvent;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.crossproject.CrossProjectEntityMigrationStatsEvent;
import com.atlassian.jira.migration.events.crossproject.CrossProjectRapidViewFilterExportTimeEvent;
import com.atlassian.jira.migration.events.crossproject.CrossProjectRapidViewFilterTaskListStatsEvent;
import com.atlassian.jira.migration.events.crossproject.DashboardChildrenEntitiesStatsEvent;
import com.atlassian.jira.migration.events.crossproject.DashboardEntityMigrationStatsEvent;
import com.atlassian.jira.migration.events.crossproject.DashboardsExportTimeEvent;
import com.atlassian.jira.migration.events.crossproject.GadgetConfigurationExceptionEvent;
import com.atlassian.jira.migration.export.framework.ExportContext;
import com.atlassian.jira.migration.export.framework.ExportMode;
import com.atlassian.jira.migration.orchestratorclient.tasks.EntityCounts;
import com.atlassian.jira.migration.plan.CrossProjectBoardAndFiltersMigrationMode;
import com.atlassian.jira.migration.plan.DashboardsMigrationMode;
import com.atlassian.jira.migration.progress.MigrationTaskStatus;
import com.atlassian.jira.migration.progress.TaskList;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ&\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nJ.\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J.\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u000eJ*\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0!2\u0006\u0010$\u001a\u00020\u000eJ(\u0010%\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010&\u001a\u0004\u0018\u00010'J7\u0010(\u001a\u00020\u00062\b\u0010)\u001a\u0004\u0018\u00010\u000e2\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u000e2\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\u0002\u0010,J&\u0010-\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010&\u001a\u00020'J6\u0010.\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\n2\u0006\u00102\u001a\u00020\n2\u0006\u00103\u001a\u00020\n2\u0006\u00104\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/atlassian/jira/migration/analytics/crossproject/service/CrossProjectEntityStatsEventService;", "", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "(Lcom/atlassian/jira/migration/events/MigrationEventBus;)V", "sendCrossProjectEntityMigrationStatsEvent", "", "taskList", "Lcom/atlassian/jira/migration/progress/TaskList;", "migrationId", "", "cloudId", "sendCrossProjectRapidViewFilterExportTimeEvent", "timeTakenInMillisToExportCrossProjectRapidViews", "", "timeTakenInMillisToExportCrossProjectFilters", "sendCrossProjectRapidViewFilterMissingProjectSelectionCheckStatsEvent", "preflightCheckExecutionId", "uniqueId", "timeTakenToComplete", "success", "", "crossProjectBoardAndFiltersMigrationMode", "Lcom/atlassian/jira/migration/plan/CrossProjectBoardAndFiltersMigrationMode;", "sendCrossProjectRapidViewFilterTaskListStatsEvent", "timeTakenToFetchCrossProjectRapidViews", "timeTakenToFetchCrossProjectFilters", "crossProjectRapidViewCount", "crossProjectFilterCount", "sendDashboardChildrenEntitiesStatsEvent", "ctx", "Lcom/atlassian/jira/migration/export/framework/ExportContext;", "statsMap", "", "Lcom/atlassian/jira/migration/dashboardstats/EntityType;", "Lcom/atlassian/jira/migration/dashboardstats/ExportStats;", "portalPageId", "sendDashboardEntityMigrationStatsEvent", "dashboardsMigrationMode", "Lcom/atlassian/jira/migration/plan/DashboardsMigrationMode;", "sendDashboardsExportTimeEvent", "timeTakenInMillisToExportDashboards", "totalDashboardsExported", "totalDashboards", "(Ljava/lang/Long;JJLcom/atlassian/jira/migration/plan/DashboardsMigrationMode;Lcom/atlassian/jira/migration/export/framework/ExportContext;)V", "sendDashboardsMissingProjectSelectionCheckStatsEvent", "sendGadgetConfigurationExceptionEvent", "exportMode", "Lcom/atlassian/jira/migration/export/framework/ExportMode;", "gadgetId", "gadgetName", "dashboardId", "exceptionType", "jira-migration-plugin"})
public final class CrossProjectEntityStatsEventService {
    @NotNull
    private final MigrationEventBus migrationEventBus;

    @Inject
    public CrossProjectEntityStatsEventService(@NotNull MigrationEventBus migrationEventBus) {
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        this.migrationEventBus = migrationEventBus;
    }

    public final void sendCrossProjectRapidViewFilterExportTimeEvent(long timeTakenInMillisToExportCrossProjectRapidViews, long timeTakenInMillisToExportCrossProjectFilters, @NotNull String cloudId2, @NotNull String migrationId) {
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        this.migrationEventBus.post(new CrossProjectRapidViewFilterExportTimeEvent(cloudId2, migrationId, timeTakenInMillisToExportCrossProjectRapidViews, timeTakenInMillisToExportCrossProjectFilters));
    }

    public final void sendCrossProjectRapidViewFilterMissingProjectSelectionCheckStatsEvent(@NotNull String preflightCheckExecutionId, @NotNull String uniqueId, long timeTakenToComplete, boolean success, @NotNull CrossProjectBoardAndFiltersMigrationMode crossProjectBoardAndFiltersMigrationMode) {
        Intrinsics.checkNotNullParameter((Object)preflightCheckExecutionId, (String)"preflightCheckExecutionId");
        Intrinsics.checkNotNullParameter((Object)uniqueId, (String)"uniqueId");
        Intrinsics.checkNotNullParameter((Object)((Object)crossProjectBoardAndFiltersMigrationMode), (String)"crossProjectBoardAndFiltersMigrationMode");
        this.migrationEventBus.post(new CrossProjectRapidViewFilterMissingProjectSelectionCheckStatsEvent(preflightCheckExecutionId, uniqueId, timeTakenToComplete, success, crossProjectBoardAndFiltersMigrationMode));
    }

    public final void sendCrossProjectEntityMigrationStatsEvent(@NotNull TaskList taskList2, @NotNull String migrationId, @NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)taskList2, (String)"taskList");
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Map<String, EntityCounts> crossProjectEntityCountsMap = new MigrationTaskStatus(taskList2, false, null, null, 14, null).getCrossProjectEntityTypeCounts();
        EntityCounts crossProjectRapidViewsEntityCounts = crossProjectEntityCountsMap.get("jira/classic/software:rapidView");
        EntityCounts crossProjectFilterEntityCounts = crossProjectEntityCountsMap.get("jira:filter");
        this.migrationEventBus.post(new CrossProjectEntityMigrationStatsEvent(cloudId2, migrationId, crossProjectRapidViewsEntityCounts, crossProjectFilterEntityCounts));
    }

    public final void sendCrossProjectRapidViewFilterTaskListStatsEvent(@NotNull CrossProjectBoardAndFiltersMigrationMode crossProjectBoardAndFiltersMigrationMode, long timeTakenToFetchCrossProjectRapidViews, long timeTakenToFetchCrossProjectFilters, long crossProjectRapidViewCount, long crossProjectFilterCount) {
        Intrinsics.checkNotNullParameter((Object)((Object)crossProjectBoardAndFiltersMigrationMode), (String)"crossProjectBoardAndFiltersMigrationMode");
        this.migrationEventBus.post(new CrossProjectRapidViewFilterTaskListStatsEvent(crossProjectBoardAndFiltersMigrationMode, timeTakenToFetchCrossProjectRapidViews, timeTakenToFetchCrossProjectFilters, crossProjectRapidViewCount, crossProjectFilterCount));
    }

    public final void sendDashboardEntityMigrationStatsEvent(@NotNull TaskList taskList2, @NotNull String migrationId, @NotNull String cloudId2, @Nullable DashboardsMigrationMode dashboardsMigrationMode) {
        Intrinsics.checkNotNullParameter((Object)taskList2, (String)"taskList");
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Map<String, EntityCounts> crossProjectEntityCountsMap = new MigrationTaskStatus(taskList2, false, null, null, 14, null).getCrossProjectEntityTypeCounts();
        EntityCounts portalPageEntityCounts = crossProjectEntityCountsMap.get("jira:portalPage");
        EntityCounts portletConfigurationEntityCounts = crossProjectEntityCountsMap.get("jira:portletConfiguration");
        EntityCounts portalPageSharePermissionEntityCounts = crossProjectEntityCountsMap.get("jira:portalPageSharePermission");
        this.migrationEventBus.post(new DashboardEntityMigrationStatsEvent(cloudId2, migrationId, portalPageEntityCounts, portletConfigurationEntityCounts, portalPageSharePermissionEntityCounts, dashboardsMigrationMode));
    }

    public final void sendDashboardsExportTimeEvent(@Nullable Long timeTakenInMillisToExportDashboards, long totalDashboardsExported, long totalDashboards, @Nullable DashboardsMigrationMode dashboardsMigrationMode, @NotNull ExportContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.migrationEventBus.post(new DashboardsExportTimeEvent(timeTakenInMillisToExportDashboards, totalDashboardsExported, totalDashboards, ctx.getMigrationTaskMetadata().getCloudId(), ctx.getMigrationId(), dashboardsMigrationMode, ctx.getExportMode()));
    }

    public final void sendDashboardsMissingProjectSelectionCheckStatsEvent(@NotNull String preflightCheckExecutionId, long timeTakenToComplete, boolean success, @NotNull DashboardsMigrationMode dashboardsMigrationMode) {
        Intrinsics.checkNotNullParameter((Object)preflightCheckExecutionId, (String)"preflightCheckExecutionId");
        Intrinsics.checkNotNullParameter((Object)((Object)dashboardsMigrationMode), (String)"dashboardsMigrationMode");
        this.migrationEventBus.post(new DashboardsMissingProjectSelectionCheckStatsEvent(preflightCheckExecutionId, timeTakenToComplete, success, dashboardsMigrationMode));
    }

    public final void sendGadgetConfigurationExceptionEvent(@NotNull String migrationId, @NotNull ExportMode exportMode, @NotNull String gadgetId, @NotNull String gadgetName, @NotNull String dashboardId, @NotNull String exceptionType) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)((Object)exportMode), (String)"exportMode");
        Intrinsics.checkNotNullParameter((Object)gadgetId, (String)"gadgetId");
        Intrinsics.checkNotNullParameter((Object)gadgetName, (String)"gadgetName");
        Intrinsics.checkNotNullParameter((Object)dashboardId, (String)"dashboardId");
        Intrinsics.checkNotNullParameter((Object)exceptionType, (String)"exceptionType");
        this.migrationEventBus.post(new GadgetConfigurationExceptionEvent(migrationId, exportMode, gadgetId, gadgetName, dashboardId, exceptionType));
    }

    public final void sendDashboardChildrenEntitiesStatsEvent(@NotNull ExportContext ctx, @NotNull Map<EntityType, ExportStats> statsMap, long portalPageId) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter(statsMap, (String)"statsMap");
        this.migrationEventBus.post(new DashboardChildrenEntitiesStatsEvent(ctx, statsMap, portalPageId));
    }
}

