/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.analytics.errordispatcher;

import com.atlassian.jira.migration.analytics.errordispatcher.ExportError;
import com.atlassian.jira.migration.analytics.errordispatcher.ExportErrorDispatcher;
import com.atlassian.jira.migration.analytics.errordispatcher.ExportErrorRepository;
import com.atlassian.jira.migration.analytics.errordispatcher.ExportErrorUploader;
import com.atlassian.jira.migration.analytics.errordispatcher.MigrationExportErrorUploader;
import com.atlassian.jira.migration.analytics.errordispatcher.ScopeExportErrorUploader;
import com.atlassian.jira.migration.common.StringExtensionsKt;
import com.atlassian.scheduler.JobRunnerResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJf\u0010\u0010\u001a,\u0012(\u0012&\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\n\u0012\u0004\u0012\u00020\f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r0\u00110\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\n2$\u0010\t\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r0\u000b0\nH\u0002J\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\nH\u0002J\u0006\u0010\u0015\u001a\u00020\u0016J2\u0010\u0017\u001a\u00020\u00142\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\n2\u0006\u0010\u0018\u001a\u00020\f2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\t\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/atlassian/jira/migration/analytics/errordispatcher/ExportErrorDispatcher;", "", "exportErrorRepository", "Lcom/atlassian/jira/migration/analytics/errordispatcher/ExportErrorRepository;", "migrationExportErrorUploader", "Lcom/atlassian/jira/migration/analytics/errordispatcher/MigrationExportErrorUploader;", "scopeExportErrorUploader", "Lcom/atlassian/jira/migration/analytics/errordispatcher/ScopeExportErrorUploader;", "(Lcom/atlassian/jira/migration/analytics/errordispatcher/ExportErrorRepository;Lcom/atlassian/jira/migration/analytics/errordispatcher/MigrationExportErrorUploader;Lcom/atlassian/jira/migration/analytics/errordispatcher/ScopeExportErrorUploader;)V", "uploaderWithMigrationIdentifierList", "", "Lkotlin/Pair;", "Lcom/atlassian/jira/migration/analytics/errordispatcher/ExportErrorUploader;", "Lkotlin/reflect/KMutableProperty1;", "Lcom/atlassian/jira/migration/analytics/errordispatcher/ExportError;", "", "groupEventsByMigrationIdentifier", "Lkotlin/Triple;", "events", "handleEvents", "", "processExportErrors", "Lcom/atlassian/scheduler/JobRunnerResponse;", "sendEventAndClean", "errorUploader", "migrationIdentifier", "Lkotlin/Function1;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nExportErrorDispatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExportErrorDispatcher.kt\ncom/atlassian/jira/migration/analytics/errordispatcher/ExportErrorDispatcher\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,70:1\n1313#2,2:71\n1855#3,2:73\n1477#3:75\n1502#3,3:76\n1505#3,3:86\n1855#3,2:89\n1549#3:91\n1620#3,2:92\n766#3:94\n857#3,2:95\n1622#3:97\n372#4,7:79\n*S KotlinDebug\n*F\n+ 1 ExportErrorDispatcher.kt\ncom/atlassian/jira/migration/analytics/errordispatcher/ExportErrorDispatcher\n*L\n25#1:71,2\n32#1:73,2\n37#1:75\n37#1:76,3\n37#1:86,3\n39#1:89,2\n59#1:91\n59#1:92,2\n60#1:94\n60#1:95,2\n59#1:97\n37#1:79,7\n*E\n"})
public final class ExportErrorDispatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExportErrorRepository exportErrorRepository;
    @NotNull
    private final MigrationExportErrorUploader migrationExportErrorUploader;
    @NotNull
    private final ScopeExportErrorUploader scopeExportErrorUploader;
    @NotNull
    private final List<Pair<ExportErrorUploader, KMutableProperty1<ExportError, String>>> uploaderWithMigrationIdentifierList;
    private static final Logger log = LoggerFactory.getLogger(ExportErrorDispatcher.class);
    private static final int MAX_NUMBER_ERRORS_IN_CHUNK = 100;

    @Inject
    public ExportErrorDispatcher(@NotNull ExportErrorRepository exportErrorRepository, @NotNull MigrationExportErrorUploader migrationExportErrorUploader, @NotNull ScopeExportErrorUploader scopeExportErrorUploader) {
        Intrinsics.checkNotNullParameter((Object)exportErrorRepository, (String)"exportErrorRepository");
        Intrinsics.checkNotNullParameter((Object)migrationExportErrorUploader, (String)"migrationExportErrorUploader");
        Intrinsics.checkNotNullParameter((Object)scopeExportErrorUploader, (String)"scopeExportErrorUploader");
        this.exportErrorRepository = exportErrorRepository;
        this.migrationExportErrorUploader = migrationExportErrorUploader;
        this.scopeExportErrorUploader = scopeExportErrorUploader;
        Object[] objectArray = new Pair[]{new Pair((Object)this.scopeExportErrorUploader, (Object)uploaderWithMigrationIdentifierList.1.INSTANCE), new Pair((Object)this.migrationExportErrorUploader, (Object)uploaderWithMigrationIdentifierList.2.INSTANCE)};
        this.uploaderWithMigrationIdentifierList = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final JobRunnerResponse processExportErrors() {
        Sequence<ExportError> sequenceOfSavedErrors = this.exportErrorRepository.availableErrors();
        Sequence $this$forEach$iv = SequencesKt.chunked(sequenceOfSavedErrors, (int)100);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List p0 = (List)element$iv;
            boolean bl = false;
            this.handleEvents(p0);
        }
        JobRunnerResponse jobRunnerResponse = JobRunnerResponse.success((String)String.valueOf(SequencesKt.count(sequenceOfSavedErrors)));
        Intrinsics.checkNotNullExpressionValue((Object)jobRunnerResponse, (String)"success(...)");
        return jobRunnerResponse;
    }

    private final void handleEvents(List<? extends ExportError> events) {
        Iterable $this$forEach$iv = this.groupEventsByMigrationIdentifier(events, this.uploaderWithMigrationIdentifierList);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Triple it = (Triple)element$iv;
            boolean bl = false;
            this.sendEventAndClean((List)it.getFirst(), (ExportErrorUploader)it.getSecond(), (Function1<? super ExportError, String>)((Function1)it.getThird()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void sendEventAndClean(List<? extends ExportError> events, ExportErrorUploader errorUploader, Function1<? super ExportError, String> migrationIdentifier) {
        void $this$forEach$iv;
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv;
        Iterable iterable = events;
        boolean $i$f$groupBy = false;
        Iterator iterator2 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            ExportError it = (ExportError)element$iv$iv;
            boolean bl = false;
            Triple key$iv$iv = new Triple((Object)it.getCloudId(), migrationIdentifier.invoke((Object)it), (Object)it.getSource());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            Object object2 = this;
            try {
                ExportErrorDispatcher $this$sendEventAndClean_u24lambda_u244_u24lambda_u242 = object2;
                boolean bl3 = false;
                errorUploader.uploadErrorToMCS((String)((Triple)it.getKey()).getFirst(), (String)((Triple)it.getKey()).getSecond(), (String)((Triple)it.getKey()).getThird(), (List)it.getValue());
                $this$sendEventAndClean_u24lambda_u244_u24lambda_u242.exportErrorRepository.deleteErrors((List)it.getValue());
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl3) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl3));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) continue;
            Object error = object = throwable;
            boolean bl4 = false;
            log.warn("Error while processing migration error logs", (Throwable)error);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Triple<List<ExportError>, ExportErrorUploader, KMutableProperty1<ExportError, String>>> groupEventsByMigrationIdentifier(List<? extends ExportError> events, List<? extends Pair<? extends ExportErrorUploader, ? extends KMutableProperty1<ExportError, String>>> uploaderWithMigrationIdentifierList2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = uploaderWithMigrationIdentifierList2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void service;
            void $this$filterTo$iv$iv;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv = events;
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ExportError it = (ExportError)element$iv$iv;
                boolean bl2 = false;
                if (!StringExtensionsKt.isNotNullOrBlank((String)((KMutableProperty1)service.getSecond()).invoke((Object)it))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List filteredEvents = (List)destination$iv$iv2;
            collection.add(new Triple((Object)filteredEvents, service.getFirst(), service.getSecond()));
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/analytics/errordispatcher/ExportErrorDispatcher$Companion;", "", "()V", "MAX_NUMBER_ERRORS_IN_CHUNK", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

