/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.analytics.errordispatcher;

import com.atlassian.jira.migration.analytics.errordispatcher.ExportErrorDispatcher;
import com.atlassian.jira.migration.legal.LegalService;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u000b\u001a\u00020\nH\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/jira/migration/analytics/errordispatcher/ExportErrorJobManager;", "Lcom/atlassian/scheduler/JobRunner;", "legalService", "Lcom/atlassian/jira/migration/legal/LegalService;", "schedulerService", "Lcom/atlassian/scheduler/SchedulerService;", "exportErrorDispatcher", "Lcom/atlassian/jira/migration/analytics/errordispatcher/ExportErrorDispatcher;", "(Lcom/atlassian/jira/migration/legal/LegalService;Lcom/atlassian/scheduler/SchedulerService;Lcom/atlassian/jira/migration/analytics/errordispatcher/ExportErrorDispatcher;)V", "cleanup", "", "postConstruct", "runJob", "Lcom/atlassian/scheduler/JobRunnerResponse;", "jobRunnerRequest", "Lcom/atlassian/scheduler/JobRunnerRequest;", "Companion", "jira-migration-plugin"})
public final class ExportErrorJobManager
implements JobRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LegalService legalService;
    @NotNull
    private final SchedulerService schedulerService;
    @NotNull
    private final ExportErrorDispatcher exportErrorDispatcher;
    private static final Logger log = LoggerFactory.getLogger(ExportErrorJobManager.class);
    private static final long JOB_RUN_INTERVAL = 10L;
    @NotNull
    private static final JobRunnerKey JOB_RUNNER_KEY;
    @NotNull
    private static final JobId JOB_ID;

    @Inject
    public ExportErrorJobManager(@NotNull LegalService legalService, @NotNull SchedulerService schedulerService, @NotNull ExportErrorDispatcher exportErrorDispatcher) {
        Intrinsics.checkNotNullParameter((Object)legalService, (String)"legalService");
        Intrinsics.checkNotNullParameter((Object)schedulerService, (String)"schedulerService");
        Intrinsics.checkNotNullParameter((Object)exportErrorDispatcher, (String)"exportErrorDispatcher");
        this.legalService = legalService;
        this.schedulerService = schedulerService;
        this.exportErrorDispatcher = exportErrorDispatcher;
    }

    @PostConstruct
    public final void postConstruct() {
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)this);
        this.schedulerService.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)TimeUnit.MINUTES.toMillis(10L), (Date)Date.from(Instant.now().plus(Duration.ofMinutes(10L))))));
        log.info("Successfully registered export error dispatcher job " + JOB_RUNNER_KEY + '.');
    }

    @Nullable
    public JobRunnerResponse runJob(@NotNull JobRunnerRequest jobRunnerRequest) {
        JobRunnerResponse jobRunnerResponse;
        Intrinsics.checkNotNullParameter((Object)jobRunnerRequest, (String)"jobRunnerRequest");
        long startTime = System.nanoTime();
        log.info("Export error dispatching job started at " + Instant.now() + " jobId=" + jobRunnerRequest.getJobId() + '.');
        if (!this.legalService.isLegalOptIn()) {
            jobRunnerResponse = JobRunnerResponse.success((String)"User has not agreed with sending errors.");
        } else {
            JobRunnerResponse jobRunnerResponse2;
            JobRunnerResponse it = jobRunnerResponse2 = this.exportErrorDispatcher.processExportErrors();
            boolean bl = false;
            long elapsedTime2 = System.nanoTime() - startTime;
            log.info("Export error dispatching job Id=" + jobRunnerRequest.getJobId() + " finished at " + Instant.now() + ", total time taken " + TimeUnit.SECONDS.convert(elapsedTime2, TimeUnit.NANOSECONDS) + " seconds. Successfully dispatched errors: " + it.getMessage());
            jobRunnerResponse = jobRunnerResponse2;
        }
        return jobRunnerResponse;
    }

    @PreDestroy
    public final void cleanup() {
        this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
        log.info("Successfully unregistered export error dispatcher job " + JOB_RUNNER_KEY + '.');
    }

    static {
        JobRunnerKey jobRunnerKey = JobRunnerKey.of((String)"jira-export-errors-dispatcher-job-key");
        Intrinsics.checkNotNull((Object)jobRunnerKey);
        JOB_RUNNER_KEY = jobRunnerKey;
        JobId jobId = JobId.of((String)"jira-export-errors-dispatcher-job-id");
        Intrinsics.checkNotNull((Object)jobId);
        JOB_ID = jobId;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/analytics/errordispatcher/ExportErrorJobManager$Companion;", "", "()V", "JOB_ID", "Lcom/atlassian/scheduler/config/JobId;", "getJOB_ID", "()Lcom/atlassian/scheduler/config/JobId;", "JOB_RUNNER_KEY", "Lcom/atlassian/scheduler/config/JobRunnerKey;", "getJOB_RUNNER_KEY", "()Lcom/atlassian/scheduler/config/JobRunnerKey;", "JOB_RUN_INTERVAL", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JobRunnerKey getJOB_RUNNER_KEY() {
            return JOB_RUNNER_KEY;
        }

        @NotNull
        public final JobId getJOB_ID() {
            return JOB_ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

