/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.analytics.errordispatcher;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.migration.analytics.errordispatcher.ExportError;
import com.atlassian.jira.migration.analytics.errordispatcher.ExportErrorDto;
import com.atlassian.jira.migration.analytics.errordispatcher.ExportErrorRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import net.java.ao.RawEntity;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0014\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bJ\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/analytics/errordispatcher/ExportErrorRepository;", "", "activeObjects", "Lcom/atlassian/activeobjects/external/ActiveObjects;", "(Lcom/atlassian/activeobjects/external/ActiveObjects;)V", "availableErrors", "Lkotlin/sequences/Sequence;", "Lcom/atlassian/jira/migration/analytics/errordispatcher/ExportError;", "deleteErrors", "", "errors", "", "save", "exportError", "Lcom/atlassian/jira/migration/analytics/errordispatcher/ExportErrorDto;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nExportErrorRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExportErrorRepository.kt\ncom/atlassian/jira/migration/analytics/errordispatcher/ExportErrorRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,89:1\n1549#2:90\n1620#2,3:91\n1855#2:94\n1856#2:97\n37#3,2:95\n*S KotlinDebug\n*F\n+ 1 ExportErrorRepository.kt\ncom/atlassian/jira/migration/analytics/errordispatcher/ExportErrorRepository\n*L\n36#1:90\n36#1:91,3\n38#1:94\n38#1:97\n42#1:95,2\n*E\n"})
public final class ExportErrorRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ActiveObjects activeObjects;
    private static final int MAX_NUMBER_ERRORS_IN_CHUNK = 100;

    @Inject
    public ExportErrorRepository(@NotNull ActiveObjects activeObjects) {
        Intrinsics.checkNotNullParameter((Object)activeObjects, (String)"activeObjects");
        this.activeObjects = activeObjects;
    }

    @NotNull
    public final ExportError save(@NotNull ExportErrorDto exportError) {
        Intrinsics.checkNotNullParameter((Object)exportError, (String)"exportError");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"ERROR_TIMESTAMP", (Object)exportError.getErrorTimestamp()), TuplesKt.to((Object)"CLOUD_ID", (Object)exportError.getCloudId()), TuplesKt.to((Object)"MIGRATION_ID", (Object)exportError.getMigrationId()), TuplesKt.to((Object)"MIGRATION_SCOPE_ID", (Object)exportError.getMigrationScopeId()), TuplesKt.to((Object)"SOURCE", (Object)exportError.getSource()), TuplesKt.to((Object)"ERROR", (Object)exportError.getError())};
        RawEntity rawEntity = this.activeObjects.create(ExportError.class, MapsKt.mapOf((Pair[])pairArray));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntity, (String)"create(...)");
        return (ExportError)rawEntity;
    }

    @NotNull
    public final Sequence<ExportError> availableErrors() {
        RawEntity[] rawEntityArray = this.activeObjects.find(ExportError.class);
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        return ArraysKt.asSequence((Object[])rawEntityArray);
    }

    /*
     * WARNING - void declaration
     */
    public final void deleteErrors(@NotNull List<? extends ExportError> errors) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(errors, (String)"errors");
        Iterable $this$map$iv = errors;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ExportError exportError = (ExportError)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getID());
        }
        Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)100);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List it = (List)element$iv;
            boolean bl = false;
            Collection $this$toTypedArray$iv = it;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Integer[] integerArray = thisCollection$iv.toArray(new Integer[0]);
            this.activeObjects.deleteWithSQL(ExportError.class, CollectionsKt.joinToString$default((Iterable)it, null, (CharSequence)"ID IN (", (CharSequence)")", (int)0, null, (Function1)deleteErrors.2.1.INSTANCE, (int)25, null), (Object[])Arrays.copyOf(integerArray, integerArray.length));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/analytics/errordispatcher/ExportErrorRepository$Companion;", "", "()V", "MAX_NUMBER_ERRORS_IN_CHUNK", "", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

