/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.analytics.errordispatcher;

import com.atlassian.jira.migration.analytics.errordispatcher.ExportError;
import com.atlassian.jira.migration.analytics.errordispatcher.ExportErrorUploader;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.common.LocalFileDataOutput;
import com.atlassian.jira.migration.platform.PlatformService;
import com.atlassian.jira.migration.platform.PlatformUploadServiceInterface;
import com.atlassian.jira.migration.utils.FileNameUtils;
import com.atlassian.migration.api.ContainerToken;
import com.atlassian.migration.api.MigrationId;
import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.Instant;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ.\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J&\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/atlassian/jira/migration/analytics/errordispatcher/MigrationExportErrorUploader;", "Lcom/atlassian/jira/migration/analytics/errordispatcher/ExportErrorUploader;", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "platformService", "Lcom/atlassian/jira/migration/platform/PlatformService;", "localFileDataOutput", "Lcom/atlassian/jira/migration/common/LocalFileDataOutput;", "(Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/jira/migration/platform/PlatformService;Lcom/atlassian/jira/migration/common/LocalFileDataOutput;)V", "uploadErrorToMCS", "", "cloudId", "", "migrationIdentifier", "source", "errors", "", "Lcom/atlassian/jira/migration/analytics/errordispatcher/ExportError;", "writeLogsToFile", "Ljava/nio/file/Path;", "migrationId", "filename", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nMigrationExportErrorUploader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrationExportErrorUploader.kt\ncom/atlassian/jira/migration/analytics/errordispatcher/MigrationExportErrorUploader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n1855#2,2:69\n*S KotlinDebug\n*F\n+ 1 MigrationExportErrorUploader.kt\ncom/atlassian/jira/migration/analytics/errordispatcher/MigrationExportErrorUploader\n*L\n56#1:69,2\n*E\n"})
public final class MigrationExportErrorUploader
implements ExportErrorUploader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;
    @NotNull
    private final PlatformService platformService;
    @NotNull
    private final LocalFileDataOutput localFileDataOutput;
    private static final Logger log = LoggerFactory.getLogger(MigrationExportErrorUploader.class);
    @NotNull
    private static final String FILETYPE = ".txt";

    @Inject
    public MigrationExportErrorUploader(@NotNull CloudSiteRepository cloudSiteRepository, @NotNull PlatformService platformService, @NotNull LocalFileDataOutput localFileDataOutput) {
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        Intrinsics.checkNotNullParameter((Object)((Object)localFileDataOutput), (String)"localFileDataOutput");
        this.cloudSiteRepository = cloudSiteRepository;
        this.platformService = platformService;
        this.localFileDataOutput = localFileDataOutput;
    }

    @Override
    public void uploadErrorToMCS(@NotNull String cloudId2, @NotNull String migrationIdentifier, @NotNull String source, @NotNull List<? extends ExportError> errors) {
        block2: {
            Unit unit;
            Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
            Intrinsics.checkNotNullParameter((Object)migrationIdentifier, (String)"migrationIdentifier");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter(errors, (String)"errors");
            CloudSite cloudSite2 = this.cloudSiteRepository.getSite(cloudId2);
            if (cloudSite2 != null) {
                CloudSite cloudSite3 = cloudSite2;
                boolean bl = false;
                Instant time = Instant.now();
                String filename = FileNameUtils.makeFilenameCrossPlatformCompatible((String)(source + "-export-error-stacktrace-" + time + FILETYPE));
                Path filePath = this.writeLogsToFile(migrationIdentifier, filename, errors);
                PlatformUploadServiceInterface platformUploadServiceInterface = this.platformService;
                ContainerToken containerToken = new ContainerToken(cloudSite3.getContainerToken());
                MigrationId migrationId = new MigrationId(migrationIdentifier);
                File file2 = filePath.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
                PlatformUploadServiceInterface.DefaultImpls.uploadMultiPart$default(platformUploadServiceInterface, containerToken, migrationId, filename, "logs", file2, 0, null, 96, null);
                LocalFileDataOutput.deleteHandlingExceptions$default(this.localFileDataOutput, filePath, null, 2, null);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block2;
            log.warn("Failed to find cloud site entry for requested cloudId: " + cloudId2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final Path writeLogsToFile(String migrationId, String filename, List<? extends ExportError> errors) {
        Path migrationLogDir = this.localFileDataOutput.migrationLogDirectory(migrationId);
        Path file2 = migrationLogDir.resolve(filename);
        File file3 = file2.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"toFile(...)");
        Object object = file3;
        Object object2 = Charsets.UTF_8;
        File file4 = object;
        int n = 8192;
        Object object3 = file4;
        object3 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object2);
        object = new PrintWriter(object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n));
        object2 = null;
        try {
            PrintWriter out = (PrintWriter)object;
            boolean bl = false;
            Iterable $this$forEach$iv = errors;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ExportError it = (ExportError)element$iv;
                boolean bl2 = false;
                out.println(it.getError());
            }
            file4 = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        Intrinsics.checkNotNull((Object)file2);
        return file2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/analytics/errordispatcher/MigrationExportErrorUploader$Companion;", "", "()V", "FILETYPE", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

