/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.analytics.prometheus;

import com.atlassian.jira.migration.analytics.prometheus.CloseableSink;
import com.atlassian.jira.migration.analytics.prometheus.PrometheusMetricSnapshotDiskStorage;
import com.atlassian.jira.migration.common.Sink;
import com.atlassian.jira.migration.platform.PlatformUploadPayload;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/jira/migration/analytics/prometheus/BufferedSnapshotSink;", "Lcom/atlassian/jira/migration/analytics/prometheus/CloseableSink;", "Lcom/atlassian/jira/migration/platform/PlatformUploadPayload;", "threshold", "", "localSink", "Lcom/atlassian/jira/migration/analytics/prometheus/PrometheusMetricSnapshotDiskStorage;", "remoteSink", "Lcom/atlassian/jira/migration/common/Sink;", "(JLcom/atlassian/jira/migration/analytics/prometheus/PrometheusMetricSnapshotDiskStorage;Lcom/atlassian/jira/migration/common/Sink;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "close", "", "payload", "put", "data", "jira-migration-plugin"})
public final class BufferedSnapshotSink
implements CloseableSink<PlatformUploadPayload> {
    private final long threshold;
    @NotNull
    private final PrometheusMetricSnapshotDiskStorage localSink;
    @NotNull
    private final Sink<PlatformUploadPayload> remoteSink;
    private final Logger log;

    public BufferedSnapshotSink(long threshold, @NotNull PrometheusMetricSnapshotDiskStorage localSink, @NotNull Sink<PlatformUploadPayload> remoteSink) {
        Intrinsics.checkNotNullParameter((Object)localSink, (String)"localSink");
        Intrinsics.checkNotNullParameter(remoteSink, (String)"remoteSink");
        this.threshold = threshold;
        this.localSink = localSink;
        this.remoteSink = remoteSink;
        this.log = LoggerFactory.getLogger(BufferedSnapshotSink.class);
    }

    public final Logger getLog() {
        return this.log;
    }

    @Override
    public void put(@NotNull PlatformUploadPayload data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        this.localSink.put(data2);
        if (this.threshold <= (long)this.localSink.getNumberOfFiles()) {
            byte[] zipped = this.localSink.zipSnapshots();
            if (zipped == null) {
                return;
            }
            this.remoteSink.put(new PlatformUploadPayload(zipped, data2.getFileName(), data2.getPrefix(), data2.getContainerToken(), data2.getMigrationId()));
        }
    }

    @Override
    public void close(@NotNull PlatformUploadPayload payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        byte[] byArray = this.localSink.zipSnapshots();
        if (byArray != null) {
            byte[] it = byArray;
            boolean bl = false;
            this.remoteSink.put(new PlatformUploadPayload(it, payload.getFileName(), payload.getPrefix(), payload.getContainerToken(), payload.getMigrationId()));
        }
        this.log.info("BufferedSnapshotSink closed");
    }
}

