/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.analytics.prometheus;

import com.atlassian.jira.migration.analytics.AnalyticsEventService;
import com.atlassian.jira.migration.analytics.prometheus.CloseableSink;
import com.atlassian.jira.migration.analytics.prometheus.PrometheusMetricPollerInterface;
import com.atlassian.jira.migration.analytics.prometheus.PrometheusMetricPollerKt;
import com.atlassian.jira.migration.common.StringExtensionsKt;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.platform.PlatformUploadPayload;
import com.atlassian.jira.migration.tracking.utils.SystemTimeProvider;
import com.atlassian.jira.migration.tracking.utils.TimeProvider;
import com.atlassian.migration.api.ContainerToken;
import com.atlassian.migration.api.MigrationId;
import io.prometheus.metrics.core.datapoints.CounterDataPoint;
import io.prometheus.metrics.expositionformats.PrometheusTextFormatWriter;
import io.prometheus.metrics.model.registry.PrometheusRegistry;
import io.prometheus.metrics.model.snapshots.MetricSnapshots;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eBW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u001bH\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/atlassian/jira/migration/analytics/prometheus/PrometheusMetricPoller;", "Lcom/atlassian/jira/migration/analytics/prometheus/PrometheusMetricPollerInterface;", "containerToken", "Lcom/atlassian/migration/api/ContainerToken;", "migrationId", "Lcom/atlassian/migration/api/MigrationId;", "payloadSink", "Lcom/atlassian/jira/migration/analytics/prometheus/CloseableSink;", "Lcom/atlassian/jira/migration/platform/PlatformUploadPayload;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "analyticsEventService", "Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;", "prometheusRegistry", "Lio/prometheus/metrics/model/registry/PrometheusRegistry;", "timeProvider", "Lcom/atlassian/jira/migration/tracking/utils/TimeProvider;", "uuidProvider", "Lkotlin/Function0;", "", "(Lcom/atlassian/migration/api/ContainerToken;Lcom/atlassian/migration/api/MigrationId;Lcom/atlassian/jira/migration/analytics/prometheus/CloseableSink;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;Lio/prometheus/metrics/model/registry/PrometheusRegistry;Lcom/atlassian/jira/migration/tracking/utils/TimeProvider;Lkotlin/jvm/functions/Function0;)V", "index", "", "shouldRun", "", "uuid", "process", "", "run", "stop", "Companion", "jira-migration-plugin"})
public final class PrometheusMetricPoller
implements PrometheusMetricPollerInterface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ContainerToken containerToken;
    @NotNull
    private final MigrationId migrationId;
    @NotNull
    private final CloseableSink<PlatformUploadPayload> payloadSink;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final AnalyticsEventService analyticsEventService;
    @NotNull
    private final PrometheusRegistry prometheusRegistry;
    @NotNull
    private final TimeProvider timeProvider;
    private boolean shouldRun;
    private int index;
    @NotNull
    private final String uuid;
    @NotNull
    private static final Logger log;

    public PrometheusMetricPoller(@NotNull ContainerToken containerToken, @NotNull MigrationId migrationId, @NotNull CloseableSink<PlatformUploadPayload> payloadSink, @NotNull MigrationFeatures migrationFeatures, @NotNull AnalyticsEventService analyticsEventService, @NotNull PrometheusRegistry prometheusRegistry, @NotNull TimeProvider timeProvider, @NotNull Function0<String> uuidProvider) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter(payloadSink, (String)"payloadSink");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)analyticsEventService, (String)"analyticsEventService");
        Intrinsics.checkNotNullParameter((Object)prometheusRegistry, (String)"prometheusRegistry");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        Intrinsics.checkNotNullParameter(uuidProvider, (String)"uuidProvider");
        this.containerToken = containerToken;
        this.migrationId = migrationId;
        this.payloadSink = payloadSink;
        this.migrationFeatures = migrationFeatures;
        this.analyticsEventService = analyticsEventService;
        this.prometheusRegistry = prometheusRegistry;
        this.timeProvider = timeProvider;
        this.shouldRun = true;
        this.uuid = (String)uuidProvider.invoke();
    }

    public /* synthetic */ PrometheusMetricPoller(ContainerToken containerToken, MigrationId migrationId, CloseableSink closeableSink, MigrationFeatures migrationFeatures, AnalyticsEventService analyticsEventService, PrometheusRegistry prometheusRegistry, TimeProvider timeProvider, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            PrometheusRegistry prometheusRegistry2 = PrometheusRegistry.defaultRegistry;
            Intrinsics.checkNotNullExpressionValue((Object)prometheusRegistry2, (String)"defaultRegistry");
            prometheusRegistry = prometheusRegistry2;
        }
        if ((n & 0x40) != 0) {
            timeProvider = new SystemTimeProvider();
        }
        if ((n & 0x80) != 0) {
            function0 = 1.INSTANCE;
        }
        this(containerToken, migrationId, closeableSink, migrationFeatures, analyticsEventService, prometheusRegistry, timeProvider, (Function0<String>)function0);
    }

    @Override
    public void process() {
        MetricSnapshots metricSnapshots = this.prometheusRegistry.scrape();
        Intrinsics.checkNotNullExpressionValue((Object)metricSnapshots, (String)"scrape(...)");
        MetricSnapshots scrape = metricSnapshots;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        new PrometheusTextFormatWriter(false).write((OutputStream)byteArrayOutputStream, scrape);
        String metrics = byteArrayOutputStream.toString("UTF-8");
        long currentTimeSeconds = this.timeProvider.now().getEpochSecond();
        StringWriter output = new StringWriter();
        Intrinsics.checkNotNull((Object)metrics);
        for (String readLine : TextStreamsKt.readLines((Reader)new StringReader(metrics))) {
            if (!StringsKt.startsWith$default((String)readLine, (String)"#", (boolean)false, (int)2, null)) {
                String string;
                List<String> split = StringExtensionsKt.splitBy(readLine, " ");
                String name = CollectionsKt.joinToString$default((Iterable)split.subList(0, split.size() - 1), (CharSequence)" ", null, null, (int)(split.size() - 1), null, null, (int)54, null);
                String value = (String)CollectionsKt.last(split);
                if (StringsKt.contains$default((CharSequence)name, (CharSequence)"{", (boolean)false, (int)2, null)) {
                    List<String> nameSplit = StringExtensionsKt.splitBy(name, "{");
                    string = nameSplit.get(0) + "{instance=\"" + this.uuid + "\",job=\"" + this.migrationId + "\"," + nameSplit.get(1);
                } else {
                    string = name + "{instance=\"" + this.uuid + "\",job=\"" + this.migrationId + "\"}";
                }
                String lineWithInstanceAndJob = string;
                Appendable appendable = ((Appendable)output).append(lineWithInstanceAndJob + ' ' + value + ' ' + currentTimeSeconds);
                Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append(...)");
                continue;
            }
            Appendable appendable = ((Appendable)output).append(readLine);
            Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append(...)");
        }
        ContainerToken containerToken = this.containerToken;
        MigrationId migrationId = this.migrationId;
        String string = output.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = string;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] byArray2 = byArray;
        int n = this.index;
        this.index = n + 1;
        string2 = this.uuid + '_' + n;
        this.payloadSink.put(new PlatformUploadPayload(byArray2, string2, "prometheus", containerToken, migrationId));
    }

    @Override
    public void run() {
        log.info("Starting Prometheus metric poller. User currently consents to metrics being sent: {}", (Object)this.analyticsEventService.isUserAgreed());
        Instant instant = this.timeProvider.now();
        Long l = Long.getLong("jcma.poll_metric_timeout.seconds", Duration.ofHours(72L).getSeconds());
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getLong(...)");
        Instant maxRunTime = instant.plus(((Number)l).longValue(), ChronoUnit.SECONDS);
        while (this.timeProvider.now().isBefore(maxRunTime) && this.shouldRun) {
            try {
                if (this.analyticsEventService.isUserAgreed()) {
                    this.process();
                    String[] stringArray = new String[]{this.migrationId.toString()};
                    ((CounterDataPoint)PrometheusMetricPollerKt.access$getSuccessExportCounter$p().labelValues(stringArray)).inc();
                }
            }
            catch (Exception e) {
                String[] stringArray = new String[]{this.migrationId.toString()};
                ((CounterDataPoint)PrometheusMetricPollerKt.access$getFailedExportCounter$p().labelValues(stringArray)).inc();
            }
            this.timeProvider.sleep((long)this.migrationFeatures.getMetricPollIntervalInSecs(), TimeUnit.SECONDS);
        }
    }

    @Override
    public void stop() {
        this.shouldRun = false;
        if (this.analyticsEventService.isUserAgreed()) {
            ContainerToken containerToken = this.containerToken;
            MigrationId migrationId = this.migrationId;
            byte[] byArray = new byte[]{};
            int n = this.index;
            this.index = n + 1;
            String string = this.uuid + '_' + n;
            this.payloadSink.close(new PlatformUploadPayload(byArray, string, "prometheus", containerToken, migrationId));
        }
    }

    static {
        Logger logger2 = LoggerFactory.getLogger(PrometheusMetricPoller.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        log = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/analytics/prometheus/PrometheusMetricPoller$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

