/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.analytics.prometheus;

import com.atlassian.jira.migration.analytics.prometheus.FileIOHelper;
import com.atlassian.jira.migration.analytics.prometheus.PrometheusMetricSnapshotStorageInterface;
import com.atlassian.jira.migration.common.Sink;
import com.atlassian.jira.migration.platform.PlatformUploadPayload;
import com.atlassian.migration.api.MigrationId;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/jira/migration/analytics/prometheus/PrometheusMetricSnapshotDiskStorage;", "Lcom/atlassian/jira/migration/analytics/prometheus/PrometheusMetricSnapshotStorageInterface;", "Lcom/atlassian/jira/migration/common/Sink;", "Lcom/atlassian/jira/migration/platform/PlatformUploadPayload;", "migrationId", "Lcom/atlassian/migration/api/MigrationId;", "directory", "Ljava/io/File;", "fileIOHelper", "Lcom/atlassian/jira/migration/analytics/prometheus/FileIOHelper;", "(Lcom/atlassian/migration/api/MigrationId;Ljava/io/File;Lcom/atlassian/jira/migration/analytics/prometheus/FileIOHelper;)V", "getNumberOfFiles", "", "put", "", "data", "writeSnapshots", "snapshots", "", "zipSnapshots", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPrometheusMetricSnapshotDiskStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrometheusMetricSnapshotDiskStorage.kt\ncom/atlassian/jira/migration/analytics/prometheus/PrometheusMetricSnapshotDiskStorage\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,83:1\n13309#2,2:84\n13309#2,2:86\n*S KotlinDebug\n*F\n+ 1 PrometheusMetricSnapshotDiskStorage.kt\ncom/atlassian/jira/migration/analytics/prometheus/PrometheusMetricSnapshotDiskStorage\n*L\n47#1:84,2\n60#1:86,2\n*E\n"})
public final class PrometheusMetricSnapshotDiskStorage
implements PrometheusMetricSnapshotStorageInterface,
Sink<PlatformUploadPayload> {
    @NotNull
    private final MigrationId migrationId;
    @NotNull
    private final File directory;
    @NotNull
    private final FileIOHelper fileIOHelper;

    public PrometheusMetricSnapshotDiskStorage(@NotNull MigrationId migrationId, @NotNull File directory, @NotNull FileIOHelper fileIOHelper) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)fileIOHelper, (String)"fileIOHelper");
        this.migrationId = migrationId;
        this.directory = directory;
        this.fileIOHelper = fileIOHelper;
    }

    public /* synthetic */ PrometheusMetricSnapshotDiskStorage(MigrationId migrationId, File file2, FileIOHelper fileIOHelper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            fileIOHelper = new FileIOHelper();
        }
        this(migrationId, file2, fileIOHelper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeSnapshots(@NotNull byte[] snapshots) {
        Intrinsics.checkNotNullParameter((Object)snapshots, (String)"snapshots");
        long timestamp = System.currentTimeMillis();
        File file2 = this.fileIOHelper.createTempFile(this.migrationId + "-prometheus-snapshot-" + timestamp, ".tmp", this.directory);
        Closeable closeable = this.fileIOHelper.fileOutputStream(file2);
        Throwable throwable = null;
        try {
            OutputStream it = (OutputStream)closeable;
            boolean bl = false;
            it.write(snapshots);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public byte[] zipSnapshots() {
        Object object;
        block22: {
            File[] fileArray;
            int n;
            File[] fileArray2;
            if (!this.directory.exists() || (fileArray2 = this.directory.listFiles()) == null || fileArray2.length == 0) {
                return null;
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            object = new ZipOutputStream(outputStream);
            Throwable throwable = null;
            try {
                Unit unit;
                File[] fileArray3;
                ZipOutputStream zipOut = (ZipOutputStream)object;
                boolean bl = false;
                if (fileArray3 != null) {
                    fileArray3 = this.directory.listFiles();
                    Intrinsics.checkNotNull((Object)fileArray3);
                    File[] $this$forEach$iv = fileArray3;
                    boolean $i$f$forEach = false;
                    int n2 = $this$forEach$iv.length;
                    for (n = 0; n < n2; ++n) {
                        File element$iv;
                        File file2 = element$iv = $this$forEach$iv[n];
                        boolean bl2 = false;
                        Intrinsics.checkNotNull((Object)file2);
                        Closeable closeable = this.fileIOHelper.fileInputStream(file2);
                        Throwable throwable2 = null;
                        try {
                            InputStream inputStream = (InputStream)closeable;
                            boolean bl3 = false;
                            ZipEntry zipEntry = new ZipEntry(file2.getName());
                            zipOut.putNextEntry(zipEntry);
                            ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)zipOut, (int)0, (int)2, null);
                            zipOut.closeEntry();
                            Unit unit2 = Unit.INSTANCE;
                            continue;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                        }
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                zipOut = unit;
            }
            catch (Throwable zipOut) {
                throwable = zipOut;
                throw zipOut;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = outputStream;
            throwable = null;
            try {
                Object it = (ByteArrayOutputStream)object;
                boolean bl = false;
                it = ((ByteArrayOutputStream)it).toByteArray();
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            Object it = object = it;
            boolean bl = false;
            if (fileArray == null) break block22;
            fileArray = this.directory.listFiles();
            Intrinsics.checkNotNull((Object)fileArray);
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File it2 = element$iv = $this$forEach$iv[i];
                boolean bl4 = false;
                it2.delete();
            }
        }
        return object;
    }

    public final int getNumberOfFiles() {
        File[] fileArray = this.directory.listFiles();
        return fileArray != null ? fileArray.length : 0;
    }

    @Override
    public void put(@NotNull PlatformUploadPayload data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        this.writeSnapshots(data2.getPayload());
    }
}

