/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.analytics.prometheus;

import com.atlassian.jira.cluster.ClusterMessagingService;
import com.atlassian.jira.migration.analytics.prometheus.PrometheusMetricsManager;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.features.StatsigFx3Gates;
import com.atlassian.migration.api.MigrationId;
import com.google.gson.Gson;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0010B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/jira/migration/analytics/prometheus/PrometheusMetricsExportTrigger;", "", "clusterMessagingService", "Lcom/atlassian/jira/cluster/ClusterMessagingService;", "manager", "Lcom/atlassian/jira/migration/analytics/prometheus/PrometheusMetricsManager;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/cluster/ClusterMessagingService;Lcom/atlassian/jira/migration/analytics/prometheus/PrometheusMetricsManager;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "start", "", "cloudId", "", "migrationId", "Lcom/atlassian/migration/api/MigrationId;", "stop", "PrometheusMetricPollerOperation", "jira-migration-plugin"})
public final class PrometheusMetricsExportTrigger {
    @NotNull
    private final ClusterMessagingService clusterMessagingService;
    @NotNull
    private final PrometheusMetricsManager manager;
    @NotNull
    private final MigrationFeatures migrationFeatures;

    @Inject
    public PrometheusMetricsExportTrigger(@NotNull ClusterMessagingService clusterMessagingService, @NotNull PrometheusMetricsManager manager, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)clusterMessagingService, (String)"clusterMessagingService");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.clusterMessagingService = clusterMessagingService;
        this.manager = manager;
        this.migrationFeatures = migrationFeatures;
    }

    public final void start(@NotNull String cloudId2, @NotNull MigrationId migrationId) {
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        this.migrationFeatures.buildRolloutWithStatsigFeature(StatsigFx3Gates.ENABLE_PROMETHEUS_EXPORT).withJvmEnabledOverride("jcma.export_prometheus.enabled").whenEnabled(() -> PrometheusMetricsExportTrigger.start$lambda$0(this, cloudId2, migrationId)).run();
    }

    public final void stop(@NotNull String migrationId) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        this.migrationFeatures.buildRolloutWithStatsigFeature(StatsigFx3Gates.ENABLE_PROMETHEUS_EXPORT).withJvmEnabledOverride("jcma.export_prometheus.enabled").whenEnabled(() -> PrometheusMetricsExportTrigger.stop$lambda$1(this, migrationId)).run();
    }

    private static final Unit start$lambda$0(PrometheusMetricsExportTrigger this$0, String $cloudId, MigrationId $migrationId) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$cloudId, (String)"$cloudId");
        Intrinsics.checkNotNullParameter((Object)$migrationId, (String)"$migrationId");
        this$0.manager.start($cloudId, $migrationId);
        ClusterMessagingService clusterMessagingService = this$0.clusterMessagingService;
        Gson gson = new Gson();
        String string = $migrationId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        clusterMessagingService.sendRemote("jcmaMetricExporter", gson.toJson((Object)new PrometheusMetricPollerOperation("start", $cloudId, string)));
        return Unit.INSTANCE;
    }

    private static final Unit stop$lambda$1(PrometheusMetricsExportTrigger this$0, String $migrationId) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$migrationId, (String)"$migrationId");
        this$0.manager.stop(new MigrationId($migrationId));
        this$0.clusterMessagingService.sendRemote("jcmaMetricExporter", new Gson().toJson((Object)new PrometheusMetricPollerOperation("stop", null, $migrationId.toString())));
        return Unit.INSTANCE;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J)\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/jira/migration/analytics/prometheus/PrometheusMetricsExportTrigger$PrometheusMetricPollerOperation;", "", "state", "", "cloudId", "migrationId", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getCloudId", "()Ljava/lang/String;", "getMigrationId", "getState", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "jira-migration-plugin"})
    public static final class PrometheusMetricPollerOperation {
        @NotNull
        private final String state;
        @Nullable
        private final String cloudId;
        @NotNull
        private final String migrationId;

        public PrometheusMetricPollerOperation(@NotNull String state, @Nullable String cloudId2, @NotNull String migrationId) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
            this.state = state;
            this.cloudId = cloudId2;
            this.migrationId = migrationId;
        }

        @NotNull
        public final String getState() {
            return this.state;
        }

        @Nullable
        public final String getCloudId() {
            return this.cloudId;
        }

        @NotNull
        public final String getMigrationId() {
            return this.migrationId;
        }

        @NotNull
        public final String component1() {
            return this.state;
        }

        @Nullable
        public final String component2() {
            return this.cloudId;
        }

        @NotNull
        public final String component3() {
            return this.migrationId;
        }

        @NotNull
        public final PrometheusMetricPollerOperation copy(@NotNull String state, @Nullable String cloudId2, @NotNull String migrationId) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
            return new PrometheusMetricPollerOperation(state, cloudId2, migrationId);
        }

        public static /* synthetic */ PrometheusMetricPollerOperation copy$default(PrometheusMetricPollerOperation prometheusMetricPollerOperation, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = prometheusMetricPollerOperation.state;
            }
            if ((n & 2) != 0) {
                string2 = prometheusMetricPollerOperation.cloudId;
            }
            if ((n & 4) != 0) {
                string3 = prometheusMetricPollerOperation.migrationId;
            }
            return prometheusMetricPollerOperation.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "PrometheusMetricPollerOperation(state=" + this.state + ", cloudId=" + this.cloudId + ", migrationId=" + this.migrationId + ')';
        }

        public int hashCode() {
            int result2 = this.state.hashCode();
            result2 = result2 * 31 + (this.cloudId == null ? 0 : this.cloudId.hashCode());
            result2 = result2 * 31 + this.migrationId.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PrometheusMetricPollerOperation)) {
                return false;
            }
            PrometheusMetricPollerOperation prometheusMetricPollerOperation = (PrometheusMetricPollerOperation)other;
            if (!Intrinsics.areEqual((Object)this.state, (Object)prometheusMetricPollerOperation.state)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.cloudId, (Object)prometheusMetricPollerOperation.cloudId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.migrationId, (Object)prometheusMetricPollerOperation.migrationId);
        }
    }
}

