/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.analytics.prometheus;

import com.atlassian.jira.cluster.ClusterMessageConsumer;
import com.atlassian.jira.cluster.ClusterMessagingService;
import com.atlassian.jira.migration.analytics.AnalyticsEventService;
import com.atlassian.jira.migration.analytics.prometheus.BufferedSnapshotSink;
import com.atlassian.jira.migration.analytics.prometheus.CloseableSink;
import com.atlassian.jira.migration.analytics.prometheus.PrometheusMetricPoller;
import com.atlassian.jira.migration.analytics.prometheus.PrometheusMetricPollerInterface;
import com.atlassian.jira.migration.analytics.prometheus.PrometheusMetricSnapshotDiskStorage;
import com.atlassian.jira.migration.analytics.prometheus.PrometheusMetricsExportTrigger;
import com.atlassian.jira.migration.analytics.prometheus.PrometheusMetricsExportTriggerKt;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.common.ExecutorService;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.platform.PlatformUploadPayload;
import com.atlassian.jira.migration.platform.PlatformUploadService;
import com.atlassian.migration.api.ContainerToken;
import com.atlassian.migration.api.MigrationId;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.gson.Gson;
import io.prometheus.metrics.core.datapoints.CounterDataPoint;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\b\u0007\u0018\u00002\u00020\u0001B7\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eB[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012$\u0010\u000f\u001a \u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\u00150\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0007J&\u0010\u001e\u001a\u00020\u001d2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001b2\b\u0010 \u001a\u0004\u0018\u00010\u001b2\b\u0010!\u001a\u0004\u0018\u00010\u001bH\u0016J\b\u0010\"\u001a\u00020\u001dH\u0007J\u0016\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u0012J\u000e\u0010&\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u0012R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u000f\u001a \u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\u00150\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00150\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/atlassian/jira/migration/analytics/prometheus/PrometheusMetricsManager;", "Lcom/atlassian/jira/cluster/ClusterMessageConsumer;", "platformService", "Lcom/atlassian/jira/migration/platform/PlatformUploadService;", "executorService", "Lcom/atlassian/jira/migration/common/ExecutorService;", "clusterMessagingService", "Lcom/atlassian/jira/cluster/ClusterMessagingService;", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "analyticsEventService", "Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;", "(Lcom/atlassian/jira/migration/platform/PlatformUploadService;Lcom/atlassian/jira/migration/common/ExecutorService;Lcom/atlassian/jira/cluster/ClusterMessagingService;Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;)V", "createPoller", "Lkotlin/Function3;", "Lcom/atlassian/migration/api/ContainerToken;", "Lcom/atlassian/migration/api/MigrationId;", "Lcom/atlassian/jira/migration/analytics/prometheus/CloseableSink;", "Lcom/atlassian/jira/migration/platform/PlatformUploadPayload;", "Lcom/atlassian/jira/migration/analytics/prometheus/PrometheusMetricPollerInterface;", "(Lcom/atlassian/jira/migration/platform/PlatformUploadService;Lcom/atlassian/jira/migration/common/ExecutorService;Lkotlin/jvm/functions/Function3;Lcom/atlassian/jira/cluster/ClusterMessagingService;Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;)V", "executor", "Lcom/google/common/util/concurrent/ListeningExecutorService;", "runners", "Ljava/util/concurrent/ConcurrentHashMap;", "", "cleanup", "", "receive", "channel", "message", "senderId", "setup", "start", "cloudId", "migrationId", "stop", "jira-migration-plugin"})
public final class PrometheusMetricsManager
implements ClusterMessageConsumer {
    @NotNull
    private final PlatformUploadService platformService;
    @NotNull
    private final Function3<ContainerToken, MigrationId, CloseableSink<PlatformUploadPayload>, PrometheusMetricPollerInterface> createPoller;
    @NotNull
    private final ClusterMessagingService clusterMessagingService;
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final AnalyticsEventService analyticsEventService;
    @NotNull
    private final ListeningExecutorService executor;
    @NotNull
    private final ConcurrentHashMap<String, PrometheusMetricPollerInterface> runners;

    public PrometheusMetricsManager(@NotNull PlatformUploadService platformService, @NotNull ExecutorService executorService, @NotNull Function3<? super ContainerToken, ? super MigrationId, ? super CloseableSink<PlatformUploadPayload>, ? extends PrometheusMetricPollerInterface> createPoller, @NotNull ClusterMessagingService clusterMessagingService, @NotNull CloudSiteRepository cloudSiteRepository, @NotNull MigrationFeatures migrationFeatures, @NotNull AnalyticsEventService analyticsEventService) {
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        Intrinsics.checkNotNullParameter(createPoller, (String)"createPoller");
        Intrinsics.checkNotNullParameter((Object)clusterMessagingService, (String)"clusterMessagingService");
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)analyticsEventService, (String)"analyticsEventService");
        this.platformService = platformService;
        this.createPoller = createPoller;
        this.clusterMessagingService = clusterMessagingService;
        this.cloudSiteRepository = cloudSiteRepository;
        this.migrationFeatures = migrationFeatures;
        this.analyticsEventService = analyticsEventService;
        this.executor = executorService.executor();
        this.runners = new ConcurrentHashMap();
    }

    @Inject
    public PrometheusMetricsManager(@NotNull PlatformUploadService platformService, @NotNull ExecutorService executorService, @NotNull ClusterMessagingService clusterMessagingService, @NotNull CloudSiteRepository cloudSiteRepository, final @NotNull MigrationFeatures migrationFeatures, final @NotNull AnalyticsEventService analyticsEventService) {
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        Intrinsics.checkNotNullParameter((Object)clusterMessagingService, (String)"clusterMessagingService");
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)analyticsEventService, (String)"analyticsEventService");
        this(platformService, executorService, (Function3<? super ContainerToken, ? super MigrationId, ? super CloseableSink<PlatformUploadPayload>, ? extends PrometheusMetricPollerInterface>)((Function3)new Function3<ContainerToken, MigrationId, CloseableSink<PlatformUploadPayload>, PrometheusMetricPoller>(){

            @NotNull
            public final PrometheusMetricPoller invoke(@NotNull ContainerToken containerToken, @NotNull MigrationId migrationId, @NotNull CloseableSink<PlatformUploadPayload> sink) {
                Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
                Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
                Intrinsics.checkNotNullParameter(sink, (String)"sink");
                return new PrometheusMetricPoller(containerToken, migrationId, sink, migrationFeatures, analyticsEventService, null, null, null, 224, null);
            }
        }), clusterMessagingService, cloudSiteRepository, migrationFeatures, analyticsEventService);
    }

    @PostConstruct
    public final void setup() {
        this.clusterMessagingService.registerListener("jcmaMetricExporter", (ClusterMessageConsumer)this);
    }

    @PreDestroy
    public final void cleanup() {
        this.clusterMessagingService.unregisterListener("jcmaMetricExporter", (ClusterMessageConsumer)this);
    }

    public void receive(@Nullable String channel, @Nullable String message, @Nullable String senderId) {
        Gson gson = new Gson();
        String string = message;
        Intrinsics.checkNotNull((Object)string);
        PrometheusMetricsExportTrigger.PrometheusMetricPollerOperation obj = (PrometheusMetricsExportTrigger.PrometheusMetricPollerOperation)gson.fromJson(string, PrometheusMetricsExportTrigger.PrometheusMetricPollerOperation.class);
        String string2 = obj.getState();
        if (Intrinsics.areEqual((Object)string2, (Object)"start")) {
            String string3 = obj.getCloudId();
            Intrinsics.checkNotNull((Object)string3);
            this.start(string3, new MigrationId(obj.getMigrationId()));
        } else if (Intrinsics.areEqual((Object)string2, (Object)"stop")) {
            this.stop(new MigrationId(obj.getMigrationId()));
        }
    }

    public final void start(@NotNull String cloudId2, @NotNull MigrationId migrationId) {
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        CloudSite cloudSite2 = this.cloudSiteRepository.getSite(cloudId2);
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path = Files.createTempDirectory(migrationId.toString(), Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempDirectory(...)");
        File file2 = path.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
        PrometheusMetricSnapshotDiskStorage localSink = new PrometheusMetricSnapshotDiskStorage(migrationId, file2, null, 4, null);
        long exportFreq = (long)this.migrationFeatures.getMetricExportIntervalInSecs();
        long pollTime = (long)this.migrationFeatures.getMetricPollIntervalInSecs();
        CloudSite cloudSite3 = cloudSite2;
        Intrinsics.checkNotNull((Object)cloudSite3);
        PrometheusMetricPollerInterface prometheusMetricPoller = (PrometheusMetricPollerInterface)this.createPoller.invoke((Object)new ContainerToken(cloudSite3.getContainerToken()), (Object)migrationId, (Object)new BufferedSnapshotSink(exportFreq / pollTime, localSink, this.platformService));
        PrometheusMetricPollerInterface res = this.runners.putIfAbsent(migrationId.toString(), prometheusMetricPoller);
        if (res == null) {
            this.executor.submit((Runnable)prometheusMetricPoller);
            String[] stringArray = new String[]{"start"};
            ((CounterDataPoint)PrometheusMetricsExportTriggerKt.access$getPrometheusPollerCounter$p().labelValues(stringArray)).inc();
        }
    }

    public final void stop(@NotNull MigrationId migrationId) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        PrometheusMetricPollerInterface prometheusMetricPollerInterface = this.runners.remove(migrationId.toString());
        if (prometheusMetricPollerInterface != null) {
            prometheusMetricPollerInterface.stop();
        }
        String[] stringArray = new String[]{"stop"};
        ((CounterDataPoint)PrometheusMetricsExportTriggerKt.access$getPrometheusPollerCounter$p().labelValues(stringArray)).inc();
    }
}

