/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.analytics.rest;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.EventType;
import com.atlassian.cmpt.analytics.events.GenericScreenEvent;
import com.atlassian.cmpt.analytics.events.GenericTrackEvent;
import com.atlassian.cmpt.analytics.events.GenericUiEvent;
import com.atlassian.jira.migration.analytics.AnalyticsEventService;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.SysadminOnlyResourceFilter;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.Locale;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="mas")
@ResourceFilters(value={SysadminOnlyResourceFilter.class})
@SystemAdminOnly
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ$\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/atlassian/jira/migration/analytics/rest/AnalyticsResource;", "", "analyticsEventService", "Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;", "userManager", "Lcom/atlassian/sal/api/user/UserManager;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;Lcom/atlassian/sal/api/user/UserManager;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "handleFeAnalyticsEvents", "Ljavax/ws/rs/core/Response;", "rawEventType", "", "rawEvent", "request", "Ljavax/servlet/http/HttpServletRequest;", "jira-migration-plugin"})
public final class AnalyticsResource {
    @NotNull
    private final AnalyticsEventService analyticsEventService;
    @NotNull
    private final UserManager userManager;
    @NotNull
    private final ObjectMapper objectMapper;

    @Inject
    public AnalyticsResource(@NotNull AnalyticsEventService analyticsEventService, @NotNull UserManager userManager, @NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)analyticsEventService, (String)"analyticsEventService");
        Intrinsics.checkNotNullParameter((Object)userManager, (String)"userManager");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        this.analyticsEventService = analyticsEventService;
        this.userManager = userManager;
        this.objectMapper = objectMapperFactory.createObjectMapper();
    }

    @POST
    @Path(value="/event/{eventType}")
    @NotNull
    public final Response handleFeAnalyticsEvents(@PathParam(value="eventType") @NotNull String rawEventType, @NotNull String rawEvent, @Context @NotNull HttpServletRequest request) {
        EventDto eventDto;
        Intrinsics.checkNotNullParameter((Object)rawEventType, (String)"rawEventType");
        Intrinsics.checkNotNullParameter((Object)rawEvent, (String)"rawEvent");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String string = ((Object)StringsKt.trim((CharSequence)rawEventType)).toString();
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        switch (WhenMappings.$EnumSwitchMapping$0[EventType.valueOf((String)string2).ordinal()]) {
            case 1: {
                eventDto = (EventDto)this.objectMapper.readValue(rawEvent, GenericUiEvent.class);
                break;
            }
            case 2: {
                eventDto = (EventDto)this.objectMapper.readValue(rawEvent, GenericScreenEvent.class);
                break;
            }
            case 3: {
                eventDto = (EventDto)this.objectMapper.readValue(rawEvent, GenericTrackEvent.class);
                break;
            }
            case 4: {
                throw new IllegalArgumentException("FE should not send Operational analytics events");
            }
            case 5: {
                throw new IllegalArgumentException("FE should not send Metric analytics events");
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        EventDto event = eventDto;
        Intrinsics.checkNotNull((Object)event);
        UserProfile userProfile = this.userManager.getRemoteUser(request);
        this.analyticsEventService.saveAnalyticsEvent(event, userProfile != null ? userProfile.getEmail() : null);
        Response response2 = Response.ok().build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EventType.values().length];
            try {
                nArray[EventType.UI.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventType.SCREEN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventType.TRACK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventType.OPERATIONAL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventType.METRIC.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

