/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.analytics.rest;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.GenericOperationalEvent;
import com.atlassian.jira.migration.analytics.AnalyticsEventService;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.SysadminOnlyResourceFilter;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="ctt")
@ResourceFilters(value={SysadminOnlyResourceFilter.class})
@SystemAdminOnly
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0014B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/jira/migration/analytics/rest/CTTAnalyticsResource;", "", "analyticsEventService", "Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;", "userManager", "Lcom/atlassian/sal/api/user/UserManager;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;Lcom/atlassian/sal/api/user/UserManager;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "handleCttAnalyticsEvent", "Ljavax/ws/rs/core/Response;", "rawEvent", "", "request", "Ljavax/servlet/http/HttpServletRequest;", "OperationalEvent", "jira-migration-plugin"})
public final class CTTAnalyticsResource {
    @NotNull
    private final AnalyticsEventService analyticsEventService;
    @NotNull
    private final UserManager userManager;
    private final Logger log;
    @NotNull
    private final ObjectMapper objectMapper;

    @Inject
    public CTTAnalyticsResource(@NotNull AnalyticsEventService analyticsEventService, @NotNull UserManager userManager, @NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)analyticsEventService, (String)"analyticsEventService");
        Intrinsics.checkNotNullParameter((Object)userManager, (String)"userManager");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        this.analyticsEventService = analyticsEventService;
        this.userManager = userManager;
        this.log = LoggerFactory.getLogger(CTTAnalyticsResource.class);
        this.objectMapper = objectMapperFactory.createObjectMapper();
    }

    @POST
    @Path(value="/event")
    @NotNull
    public final Response handleCttAnalyticsEvent(@QueryParam(value="event") @NotNull String rawEvent, @Context @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)rawEvent, (String)"rawEvent");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            OperationalEvent operationalEvent = (OperationalEvent)this.objectMapper.readValue(rawEvent, OperationalEvent.class);
            GenericOperationalEvent.Builder genericOperationalEventBuilder = (GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(operationalEvent.getTimestamp()).action(operationalEvent.getAction())).actionSubject(operationalEvent.getActionSubject());
            for (Map.Entry<String, Object> entry : operationalEvent.getAttributes().entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                genericOperationalEventBuilder.addAttribute(key, value);
            }
            GenericOperationalEvent genericOperationalEvent = genericOperationalEventBuilder.build();
            Intrinsics.checkNotNull((Object)genericOperationalEvent);
            UserProfile userProfile = this.userManager.getRemoteUser(request);
            this.analyticsEventService.saveAnalyticsEvent((EventDto)genericOperationalEvent, userProfile != null ? userProfile.getEmail() : null);
        }
        catch (Exception ex) {
            this.log.error("Exception occurred while sending analytic for event from cloud transition tools: " + ex);
        }
        Response response2 = Response.ok().build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u0015\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\bH\u00c6\u0003J=\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/atlassian/jira/migration/analytics/rest/CTTAnalyticsResource$OperationalEvent;", "", "timestamp", "", "action", "", "actionSubject", "attributes", "", "(JLjava/lang/String;Ljava/lang/String;Ljava/util/Map;)V", "getAction", "()Ljava/lang/String;", "getActionSubject", "getAttributes", "()Ljava/util/Map;", "getTimestamp", "()J", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "jira-migration-plugin"})
    public static final class OperationalEvent {
        private final long timestamp;
        @NotNull
        private final String action;
        @NotNull
        private final String actionSubject;
        @NotNull
        private final Map<String, Object> attributes;

        public OperationalEvent(long timestamp, @NotNull String action, @NotNull String actionSubject, @NotNull Map<String, ? extends Object> attributes) {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            Intrinsics.checkNotNullParameter((Object)actionSubject, (String)"actionSubject");
            Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
            this.timestamp = timestamp;
            this.action = action;
            this.actionSubject = actionSubject;
            this.attributes = attributes;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        @NotNull
        public final String getAction() {
            return this.action;
        }

        @NotNull
        public final String getActionSubject() {
            return this.actionSubject;
        }

        @NotNull
        public final Map<String, Object> getAttributes() {
            return this.attributes;
        }

        public final long component1() {
            return this.timestamp;
        }

        @NotNull
        public final String component2() {
            return this.action;
        }

        @NotNull
        public final String component3() {
            return this.actionSubject;
        }

        @NotNull
        public final Map<String, Object> component4() {
            return this.attributes;
        }

        @NotNull
        public final OperationalEvent copy(long timestamp, @NotNull String action, @NotNull String actionSubject, @NotNull Map<String, ? extends Object> attributes) {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            Intrinsics.checkNotNullParameter((Object)actionSubject, (String)"actionSubject");
            Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
            return new OperationalEvent(timestamp, action, actionSubject, attributes);
        }

        public static /* synthetic */ OperationalEvent copy$default(OperationalEvent operationalEvent, long l, String string, String string2, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                l = operationalEvent.timestamp;
            }
            if ((n & 2) != 0) {
                string = operationalEvent.action;
            }
            if ((n & 4) != 0) {
                string2 = operationalEvent.actionSubject;
            }
            if ((n & 8) != 0) {
                map = operationalEvent.attributes;
            }
            return operationalEvent.copy(l, string, string2, map);
        }

        @NotNull
        public String toString() {
            return "OperationalEvent(timestamp=" + this.timestamp + ", action=" + this.action + ", actionSubject=" + this.actionSubject + ", attributes=" + this.attributes + ')';
        }

        public int hashCode() {
            int result2 = Long.hashCode(this.timestamp);
            result2 = result2 * 31 + this.action.hashCode();
            result2 = result2 * 31 + this.actionSubject.hashCode();
            result2 = result2 * 31 + ((Object)this.attributes).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OperationalEvent)) {
                return false;
            }
            OperationalEvent operationalEvent = (OperationalEvent)other;
            if (this.timestamp != operationalEvent.timestamp) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.action, (Object)operationalEvent.action)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.actionSubject, (Object)operationalEvent.actionSubject)) {
                return false;
            }
            return Intrinsics.areEqual(this.attributes, operationalEvent.attributes);
        }
    }
}

