/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.analytics.user;

import com.atlassian.jira.migration.analytics.user.UserEmailAnalyticsService;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0007J\b\u0010\t\u001a\u00020\bH\u0007J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/jira/migration/analytics/user/UserEmailAnalyticsScheduledRunner;", "Lcom/atlassian/scheduler/JobRunner;", "userEmailAnalyticsService", "Lcom/atlassian/jira/migration/analytics/user/UserEmailAnalyticsService;", "schedulerService", "Lcom/atlassian/scheduler/SchedulerService;", "(Lcom/atlassian/jira/migration/analytics/user/UserEmailAnalyticsService;Lcom/atlassian/scheduler/SchedulerService;)V", "cleanup", "", "postConstruct", "runJob", "Lcom/atlassian/scheduler/JobRunnerResponse;", "jobRunnerRequest", "Lcom/atlassian/scheduler/JobRunnerRequest;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nUserEmailAnalyticsScheduledRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserEmailAnalyticsScheduledRunner.kt\ncom/atlassian/jira/migration/analytics/user/UserEmailAnalyticsScheduledRunner\n+ 2 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,76:1\n31#2,6:77\n*S KotlinDebug\n*F\n+ 1 UserEmailAnalyticsScheduledRunner.kt\ncom/atlassian/jira/migration/analytics/user/UserEmailAnalyticsScheduledRunner\n*L\n55#1:77,6\n*E\n"})
public final class UserEmailAnalyticsScheduledRunner
implements JobRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UserEmailAnalyticsService userEmailAnalyticsService;
    @NotNull
    private final SchedulerService schedulerService;
    @NotNull
    private static final String EVERY_SUNDAY_1AM = "0 0 1 ? * SUN *";
    private static final Logger log = LoggerFactory.getLogger(UserEmailAnalyticsScheduledRunner.class);
    @NotNull
    private static final JobId JOB_ID;
    @NotNull
    private static final JobRunnerKey JOB_RUNNER_KEY;

    @Inject
    public UserEmailAnalyticsScheduledRunner(@NotNull UserEmailAnalyticsService userEmailAnalyticsService, @NotNull SchedulerService schedulerService) {
        Intrinsics.checkNotNullParameter((Object)userEmailAnalyticsService, (String)"userEmailAnalyticsService");
        Intrinsics.checkNotNullParameter((Object)schedulerService, (String)"schedulerService");
        this.userEmailAnalyticsService = userEmailAnalyticsService;
        this.schedulerService = schedulerService;
    }

    @PostConstruct
    public final void postConstruct() {
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)this);
        SchedulerService $this$postConstruct_u24lambda_u240 = this.schedulerService;
        boolean bl = false;
        $this$postConstruct_u24lambda_u240.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forCronExpression((String)EVERY_SUNDAY_1AM)));
        log.info("Successfully registered user email event collector job " + JOB_RUNNER_KEY);
    }

    @Nullable
    public JobRunnerResponse runJob(@NotNull JobRunnerRequest jobRunnerRequest) {
        Intrinsics.checkNotNullParameter((Object)jobRunnerRequest, (String)"jobRunnerRequest");
        log.info("User email analytics event collector job started at " + Instant.now() + " jobId=" + jobRunnerRequest.getJobId());
        boolean $i$f$measureNanoTime = false;
        long start$iv = System.nanoTime();
        boolean bl = false;
        UserEmailAnalyticsService.collectAndSavePendingEvents$default(this.userEmailAnalyticsService, 0, 1, null);
        long elapsedTimeNanos = System.nanoTime() - start$iv;
        log.info("User email analytics event collector job Id=" + jobRunnerRequest.getJobId() + " finished at " + Instant.now() + ", \n            \" total time taken " + TimeUnit.SECONDS.convert(elapsedTimeNanos, TimeUnit.NANOSECONDS) + " seconds");
        return JobRunnerResponse.success((String)"User email analytics event collector job finished successfully");
    }

    @PreDestroy
    public final void cleanup() {
        this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
        log.info("Successfully unregistered user email event collector job " + JOB_RUNNER_KEY);
    }

    static {
        JobId jobId = JobId.of((String)"jira-migration-user-email-analytics-events-collector-job-id");
        Intrinsics.checkNotNull((Object)jobId);
        JOB_ID = jobId;
        JobRunnerKey jobRunnerKey = JobRunnerKey.of((String)"jira-migration-user-email-analytics-events-collector-job-key");
        Intrinsics.checkNotNull((Object)jobRunnerKey);
        JOB_RUNNER_KEY = jobRunnerKey;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/analytics/user/UserEmailAnalyticsScheduledRunner$Companion;", "", "()V", "EVERY_SUNDAY_1AM", "", "JOB_ID", "Lcom/atlassian/scheduler/config/JobId;", "getJOB_ID", "()Lcom/atlassian/scheduler/config/JobId;", "JOB_RUNNER_KEY", "Lcom/atlassian/scheduler/config/JobRunnerKey;", "getJOB_RUNNER_KEY", "()Lcom/atlassian/scheduler/config/JobRunnerKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JobId getJOB_ID() {
            return JOB_ID;
        }

        @NotNull
        public final JobRunnerKey getJOB_RUNNER_KEY() {
            return JOB_RUNNER_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

