/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.analytics.user;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.def.DetectedUserEmailOperationalEvent;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.migration.analytics.AnalyticsEventService;
import com.atlassian.jira.migration.analytics.user.UserEmailAnalyticsEventHistoryRepository;
import com.atlassian.jira.migration.analytics.user.UserEmailAnalyticsService;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.common.StringExtensionsKt;
import com.atlassian.jira.migration.serverdataextractors.usergroup.JiraUsersAndGroupsService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 %2\u00020\u0001:\u0001%B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eJ0\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00110\u00102\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u0010H\u0002J<\u0010\u0017\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00100\u00110\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u00102\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\u0010H\u0002J$\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00120\u00102\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\u0010H\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0013H\u0002J*\u0010\u001f\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0018\u0010 \u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020!0\u00110\u0010H\u0002J.\u0010\"\u001a \u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00100\u0011\u0012\u0004\u0012\u00020\u001d0#2\u0006\u0010$\u001a\u00020\u000eH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/atlassian/jira/migration/analytics/user/UserEmailAnalyticsService;", "", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "jiraUsersAndGroupsService", "Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUsersAndGroupsService;", "userEmailAnalyticsEventHistoryRepository", "Lcom/atlassian/jira/migration/analytics/user/UserEmailAnalyticsEventHistoryRepository;", "analyticsService", "Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;", "(Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/jira/migration/serverdataextractors/usergroup/JiraUsersAndGroupsService;Lcom/atlassian/jira/migration/analytics/user/UserEmailAnalyticsEventHistoryRepository;Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;)V", "collectAndSavePendingEvents", "", "eventLimit", "", "createEvent", "", "Lkotlin/Pair;", "Lcom/atlassian/crowd/embedded/api/User;", "Lcom/atlassian/cmpt/analytics/events/def/DetectedUserEmailOperationalEvent;", "cloudId", "", "user", "generateUnprocessedUsersForClouds", "Lkotlin/sequences/Sequence;", "cloudIds", "users", "getUnprocessedUsers", "hasValidEmailHash", "", "event", "processEvents", "usersToEvents", "Lcom/atlassian/cmpt/analytics/events/EventDto;", "withinTotalEventLimit", "Lkotlin/Function1;", "limit", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nUserEmailAnalyticsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserEmailAnalyticsService.kt\ncom/atlassian/jira/migration/analytics/user/UserEmailAnalyticsService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1549#2:89\n1620#2,3:90\n1549#2:95\n1620#2,3:96\n1549#2:99\n1620#2,3:100\n766#2:103\n857#2,2:104\n1549#2:106\n1620#2,3:107\n766#2:110\n857#2,2:111\n1855#2,2:113\n1549#2:115\n1620#2,3:116\n614#3:93\n1#4:94\n*S KotlinDebug\n*F\n+ 1 UserEmailAnalyticsService.kt\ncom/atlassian/jira/migration/analytics/user/UserEmailAnalyticsService\n*L\n24#1:89\n24#1:90,3\n52#1:95\n52#1:96,3\n53#1:99\n53#1:100,3\n61#1:103\n61#1:104,2\n65#1:106\n65#1:107,3\n70#1:110\n70#1:111,2\n75#1:113,2\n78#1:115\n78#1:116,3\n29#1:93\n*E\n"})
public final class UserEmailAnalyticsService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;
    @NotNull
    private final JiraUsersAndGroupsService jiraUsersAndGroupsService;
    @NotNull
    private final UserEmailAnalyticsEventHistoryRepository userEmailAnalyticsEventHistoryRepository;
    @NotNull
    private final AnalyticsEventService analyticsService;
    private static final Logger log = LoggerFactory.getLogger(UserEmailAnalyticsService.class);

    @Inject
    public UserEmailAnalyticsService(@NotNull CloudSiteRepository cloudSiteRepository, @NotNull JiraUsersAndGroupsService jiraUsersAndGroupsService, @NotNull UserEmailAnalyticsEventHistoryRepository userEmailAnalyticsEventHistoryRepository, @NotNull AnalyticsEventService analyticsService) {
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)jiraUsersAndGroupsService, (String)"jiraUsersAndGroupsService");
        Intrinsics.checkNotNullParameter((Object)userEmailAnalyticsEventHistoryRepository, (String)"userEmailAnalyticsEventHistoryRepository");
        Intrinsics.checkNotNullParameter((Object)analyticsService, (String)"analyticsService");
        this.cloudSiteRepository = cloudSiteRepository;
        this.jiraUsersAndGroupsService = jiraUsersAndGroupsService;
        this.userEmailAnalyticsEventHistoryRepository = userEmailAnalyticsEventHistoryRepository;
        this.analyticsService = analyticsService;
    }

    /*
     * WARNING - void declaration
     */
    public final void collectAndSavePendingEvents(int eventLimit) {
        int n;
        Iterator $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.cloudSiteRepository.findAll();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object item$iv$iv = iterator2.next();
            CloudSite cloudSite2 = (CloudSite)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getCloudId());
        }
        List cloudIds = (List)destination$iv$iv;
        Sequence $this$sortedByDescending$iv = SequencesKt.filter((Sequence)JiraUsersAndGroupsService.allUsersForMigrationExceptJsmCustomers$default(this.jiraUsersAndGroupsService, null, 1, null), (Function1)collectAndSavePendingEvents.1.INSTANCE);
        int $i$f$sortedByDescending = 0;
        Sequence sequence = SequencesKt.onEach((Sequence)SequencesKt.takeWhile((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.chunked((Sequence)SequencesKt.distinctBy((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                User it = (User)b;
                boolean bl = false;
                Comparable comparable = Boolean.valueOf(it.isActive());
                it = (User)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Boolean.valueOf(it.isActive()));
            }
        }), (Function1)collectAndSavePendingEvents.3.INSTANCE), (int)100), (Function1)((Function1)new Function1<List<? extends User>, Sequence<? extends Pair<? extends String, ? extends List<? extends User>>>>(this, (List<String>)cloudIds){
            final /* synthetic */ UserEmailAnalyticsService this$0;
            final /* synthetic */ List<String> $cloudIds;
            {
                this.this$0 = $receiver;
                this.$cloudIds = $cloudIds;
                super(1);
            }

            @NotNull
            public final Sequence<Pair<String, List<User>>> invoke(@NotNull List<? extends User> users2) {
                Intrinsics.checkNotNullParameter(users2, (String)"users");
                return UserEmailAnalyticsService.access$generateUnprocessedUsersForClouds(this.this$0, this.$cloudIds, users2);
            }
        })), this.withinTotalEventLimit(eventLimit)), (Function1)((Function1)new Function1<Pair<? extends String, ? extends List<? extends User>>, Unit>(this){
            final /* synthetic */ UserEmailAnalyticsService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Pair<String, ? extends List<? extends User>> pair) {
                Intrinsics.checkNotNullParameter(pair, (String)"<name for destructuring parameter 0>");
                String cloudId2 = (String)pair.component1();
                List users2 = (List)pair.component2();
                UserEmailAnalyticsService.access$processEvents(this.this$0, cloudId2, UserEmailAnalyticsService.access$createEvent(this.this$0, cloudId2, users2));
            }
        }));
        $i$f$sortedByDescending = 0;
        for (Object e : sequence) {
            Pair pair = (Pair)e;
            int n2 = $i$f$sortedByDescending;
            boolean bl = false;
            List users2 = (List)pair.component2();
            int n3 = users2.size();
            $i$f$sortedByDescending = n2 + n3;
        }
        int it = n = $i$f$sortedByDescending;
        boolean bl = false;
        log.info("Finish generating user email events at limit = " + eventLimit + ", processed = " + it);
    }

    public static /* synthetic */ void collectAndSavePendingEvents$default(UserEmailAnalyticsService userEmailAnalyticsService, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 200000;
        }
        userEmailAnalyticsService.collectAndSavePendingEvents(n);
    }

    private final Function1<Pair<String, ? extends List<? extends User>>, Boolean> withinTotalEventLimit(int limit) {
        Ref.IntRef count2 = new Ref.IntRef();
        return (Function1)new Function1<Pair<? extends String, ? extends List<? extends User>>, Boolean>(count2, limit){
            final /* synthetic */ Ref.IntRef $count;
            final /* synthetic */ int $limit;
            {
                this.$count = $count;
                this.$limit = $limit;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Pair<String, ? extends List<? extends User>> cloudIdWithUsers) {
                Intrinsics.checkNotNullParameter(cloudIdWithUsers, (String)"cloudIdWithUsers");
                Pair<String, ? extends List<? extends User>> pair = cloudIdWithUsers;
                Ref.IntRef intRef = this.$count;
                int n = this.$limit;
                Pair<String, ? extends List<? extends User>> pair2 = pair;
                boolean bl = false;
                List users2 = (List)pair2.component2();
                intRef.element += users2.size();
                return n >= intRef.element;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final Sequence<Pair<String, List<User>>> generateUnprocessedUsersForClouds(List<String> cloudIds, List<? extends User> users2) {
        Collection collection;
        String string;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = cloudIds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it, users2));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            string = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String cloudId2 = (String)string.component1();
            List users3 = (List)string.component2();
            collection.add(TuplesKt.to((Object)cloudId2, this.getUnprocessedUsers(cloudId2, users3)));
        }
        return CollectionsKt.asSequence((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final List<User> getUnprocessedUsers(String cloudId2, List<? extends User> users2) {
        void $this$filterTo$iv$iv;
        Set processedEmails = CollectionsKt.toSet((Iterable)this.userEmailAnalyticsEventHistoryRepository.findAlreadyTrackedUserEmails(cloudId2, users2));
        Iterable $this$filter$iv = users2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            User it = (User)element$iv$iv;
            boolean bl = false;
            if (!(!processedEmails.contains(it.getEmailAddress()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<User, DetectedUserEmailOperationalEvent>> createEvent(String cloudId2, List<? extends User> user) {
        void $this$filterTo$iv$iv;
        User user2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = user;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            user2 = (User)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it, (Object)((DetectedUserEmailOperationalEvent.Builder)new DetectedUserEmailOperationalEvent.Builder(System.currentTimeMillis(), it.getEmailAddress()).userStatus(it.isActive()).cloudId(cloudId2)).build()));
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            user2 = (Pair)element$iv$iv;
            boolean bl = false;
            DetectedUserEmailOperationalEvent event = (DetectedUserEmailOperationalEvent)user2.component2();
            Intrinsics.checkNotNull((Object)event);
            if (!this.hasValidEmailHash(event)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean hasValidEmailHash(DetectedUserEmailOperationalEvent event) {
        return StringExtensionsKt.isNotNullOrBlank(event.actionSubjectId);
    }

    /*
     * WARNING - void declaration
     */
    private final void processEvents(String cloudId2, List<? extends Pair<? extends User, ? extends EventDto>> usersToEvents) {
        Collection<User> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable $this$forEach$iv = usersToEvents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            EventDto event = (EventDto)pair.component2();
            AnalyticsEventService.saveAnalyticsEvent$default(this.analyticsService, event, null, 2, null);
        }
        $this$forEach$iv = usersToEvents;
        String string = cloudId2;
        UserEmailAnalyticsEventHistoryRepository userEmailAnalyticsEventHistoryRepository = this.userEmailAnalyticsEventHistoryRepository;
        boolean $i$f$map = false;
        Iterator iterator2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((User)it.getFirst());
        }
        collection = (List)destination$iv$iv;
        userEmailAnalyticsEventHistoryRepository.createUserEmailEventHistoryFor(string, (List<? extends User>)collection);
    }

    public static final /* synthetic */ Sequence access$generateUnprocessedUsersForClouds(UserEmailAnalyticsService $this, List cloudIds, List users2) {
        return $this.generateUnprocessedUsersForClouds(cloudIds, users2);
    }

    public static final /* synthetic */ void access$processEvents(UserEmailAnalyticsService $this, String cloudId2, List usersToEvents) {
        $this.processEvents(cloudId2, usersToEvents);
    }

    public static final /* synthetic */ List access$createEvent(UserEmailAnalyticsService $this, String cloudId2, List user) {
        return $this.createEvent(cloudId2, user);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/analytics/user/UserEmailAnalyticsService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

