/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.app;

import com.atlassian.jira.migration.app.AppCustomFieldGetter;
import com.atlassian.jira.migration.app.AppWorkflowRuleGetter;
import com.atlassian.jira.migration.app.CloudMigrationRegistrar;
import com.atlassian.jira.migration.platform.PlatformService;
import com.atlassian.migration.api.CloudId;
import com.atlassian.migration.api.MigrationId;
import com.atlassian.migration.app.dto.AppContainerDetails;
import com.atlassian.migration.app.dto.ConnectAppCustomField;
import com.atlassian.migration.app.dto.ConnectWorkflowRule;
import com.atlassian.migration.app.dto.ServerAddonCustomField;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Primary;

@Named
@Primary
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0014\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010H\u0016J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/atlassian/jira/migration/app/AppEntitiesGetterImpl;", "Lcom/atlassian/jira/migration/app/AppCustomFieldGetter;", "Lcom/atlassian/jira/migration/app/AppWorkflowRuleGetter;", "cloudMigrationRegistrar", "Lcom/atlassian/jira/migration/app/CloudMigrationRegistrar;", "platformService", "Lcom/atlassian/jira/migration/platform/PlatformService;", "(Lcom/atlassian/jira/migration/app/CloudMigrationRegistrar;Lcom/atlassian/jira/migration/platform/PlatformService;)V", "findAllAppContainers", "", "Lcom/atlassian/migration/app/dto/AppContainerDetails;", "findAppContainersFromMigration", "cloudId", "", "migrationId", "retrieveAllAppCustomFields", "", "Lcom/atlassian/migration/app/dto/ServerAddonCustomField;", "Lcom/atlassian/migration/app/dto/ConnectAppCustomField;", "retrieveAllAppWorkflowRules", "", "Lcom/atlassian/migration/app/dto/ConnectWorkflowRule;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAppEntitiesGetterImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppEntitiesGetterImpl.kt\ncom/atlassian/jira/migration/app/AppEntitiesGetterImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,49:1\n1855#2,2:50\n215#3,2:52\n*S KotlinDebug\n*F\n+ 1 AppEntitiesGetterImpl.kt\ncom/atlassian/jira/migration/app/AppEntitiesGetterImpl\n*L\n39#1:50,2\n43#1:52,2\n*E\n"})
public final class AppEntitiesGetterImpl
implements AppCustomFieldGetter,
AppWorkflowRuleGetter {
    @NotNull
    private final CloudMigrationRegistrar cloudMigrationRegistrar;
    @NotNull
    private final PlatformService platformService;

    @Inject
    public AppEntitiesGetterImpl(@NotNull CloudMigrationRegistrar cloudMigrationRegistrar, @NotNull PlatformService platformService) {
        Intrinsics.checkNotNullParameter((Object)((Object)cloudMigrationRegistrar), (String)"cloudMigrationRegistrar");
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        this.cloudMigrationRegistrar = cloudMigrationRegistrar;
        this.platformService = platformService;
    }

    @Override
    @NotNull
    public Map<ServerAddonCustomField, ConnectAppCustomField> retrieveAllAppCustomFields() {
        return this.cloudMigrationRegistrar.getConnectCustomFieldMappings(this.findAllAppContainers());
    }

    @Override
    @NotNull
    public List<ConnectWorkflowRule> retrieveAllAppWorkflowRules(@NotNull String migrationId, @NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        return this.cloudMigrationRegistrar.getConnectWorkFlowRules(this.findAppContainersFromMigration(cloudId2, migrationId));
    }

    private final Set<AppContainerDetails> findAppContainersFromMigration(String cloudId2, String migrationId) {
        return this.platformService.getAppContainers(new CloudId(cloudId2), new MigrationId(migrationId));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<AppContainerDetails> findAllAppContainers() {
        Set registeredServerKeys = this.cloudMigrationRegistrar.getRegisteredServerKeys();
        Map serverToCloudKeys = new LinkedHashMap();
        for (String registeredServerKey : registeredServerKeys) {
            void $this$forEach$iv;
            Iterable iterable = this.cloudMigrationRegistrar.getRegisteredCloudKeys(registeredServerKey);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                serverToCloudKeys.put(registeredServerKey, it);
            }
        }
        Set containers = new LinkedHashSet();
        Map $this$forEach$iv = serverToCloudKeys;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator2.next();
            boolean bl = false;
            containers.add(new AppContainerDetails((String)it.getKey(), (String)it.getValue(), ""));
        }
        return containers;
    }
}

