/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.app;

import com.atlassian.jira.migration.execution.LithiumAppMigrationsHelper;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.migration.Migration;
import com.atlassian.jira.migration.migration.MigrationRepository;
import com.atlassian.migration.app.AppMigrationDarkFeatures;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\b\u0010\u0016\u001a\u00020\u000eH\u0016J\b\u0010\u0017\u001a\u00020\u000eH\u0016R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/jira/migration/app/AppMigrationDarkFeaturesImpl;", "Lcom/atlassian/migration/app/AppMigrationDarkFeatures;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "migrationRepository", "Lcom/atlassian/jira/migration/migration/MigrationRepository;", "lithiumAppMigrationsHelper", "Lcom/atlassian/jira/migration/execution/LithiumAppMigrationsHelper;", "(Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/migration/MigrationRepository;Lcom/atlassian/jira/migration/execution/LithiumAppMigrationsHelper;)V", "appMigrationUploadChunkSize", "", "getAppMigrationUploadChunkSize", "()D", "isAppVendorCheckMaaFilteringEnabled", "", "()Z", "isRecipeExecutionEnabled", "isAMPyWorkplanEnabledForApp", "migrationId", "", "serverAppKey", "isEntityPropertyGenerationEnabledForApp", "isFileCachingEnabled", "multiPartUploadParallelModeEnabled", "jira-migration-plugin"})
public final class AppMigrationDarkFeaturesImpl
implements AppMigrationDarkFeatures {
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final MigrationRepository migrationRepository;
    @NotNull
    private final LithiumAppMigrationsHelper lithiumAppMigrationsHelper;

    public AppMigrationDarkFeaturesImpl(@NotNull MigrationFeatures migrationFeatures, @NotNull MigrationRepository migrationRepository, @NotNull LithiumAppMigrationsHelper lithiumAppMigrationsHelper) {
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)migrationRepository, (String)"migrationRepository");
        Intrinsics.checkNotNullParameter((Object)lithiumAppMigrationsHelper, (String)"lithiumAppMigrationsHelper");
        this.migrationFeatures = migrationFeatures;
        this.migrationRepository = migrationRepository;
        this.lithiumAppMigrationsHelper = lithiumAppMigrationsHelper;
    }

    public boolean isAppVendorCheckMaaFilteringEnabled() {
        return this.migrationFeatures.getEnableAppVendorChecksFilter();
    }

    public double getAppMigrationUploadChunkSize() {
        return this.migrationFeatures.getAppMigrationUploadChunkMbSize();
    }

    public boolean multiPartUploadParallelModeEnabled() {
        return true;
    }

    public boolean isRecipeExecutionEnabled() {
        return this.migrationFeatures.getEnableRecipeExecutionForAppMigrations();
    }

    public boolean isAMPyWorkplanEnabledForApp(@NotNull String migrationId, @NotNull String serverAppKey) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)serverAppKey, (String)"serverAppKey");
        Migration migration = this.migrationRepository.findByMigrationId(migrationId);
        if (migration == null) {
            return false;
        }
        Migration migration2 = migration;
        return this.lithiumAppMigrationsHelper.isAMPyEnabledForApp(migration2.getPlanId(), serverAppKey);
    }

    public boolean isEntityPropertyGenerationEnabledForApp(@NotNull String serverAppKey) {
        Intrinsics.checkNotNullParameter((Object)serverAppKey, (String)"serverAppKey");
        return this.migrationFeatures.enableEntityPropertyGenerationForApp(serverAppKey);
    }

    public boolean isFileCachingEnabled() {
        return true;
    }
}

