/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.app;

import com.atlassian.jira.migration.amsclient.CloudTypeMismatchException;
import com.atlassian.jira.migration.app.CloudMigrationRegistrar;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.cloud.CloudType;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.plan.PlanRepository;
import com.atlassian.jira.migration.platform.CreateMigrationResponse;
import com.atlassian.jira.migration.platform.PlatformService;
import com.atlassian.jira.migration.setup.migrationsettings.CloudTypeSettingRetrievalService;
import com.atlassian.migration.api.ContainerToken;
import com.atlassian.migration.api.MigrationId;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00132\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0018J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0011H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/atlassian/jira/migration/app/AppMigrationDevelopmentService;", "", "registrar", "Lcom/atlassian/jira/migration/app/CloudMigrationRegistrar;", "planStore", "Lcom/atlassian/jira/migration/plan/PlanRepository;", "platformService", "Lcom/atlassian/jira/migration/platform/PlatformService;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "cloudTypeSettingRetrievalService", "Lcom/atlassian/jira/migration/setup/migrationsettings/CloudTypeSettingRetrievalService;", "(Lcom/atlassian/jira/migration/app/CloudMigrationRegistrar;Lcom/atlassian/jira/migration/plan/PlanRepository;Lcom/atlassian/jira/migration/platform/PlatformService;Lcom/atlassian/jira/migration/discovery/DiscoveryService;Lcom/atlassian/jira/migration/setup/migrationsettings/CloudTypeSettingRetrievalService;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getCloudSite", "Lcom/atlassian/jira/migration/cloud/CloudSite;", "cloudId", "", "rerunAppMigrationForPlan", "", "planId", "serverAppKeys", "", "validateCloudType", "cloudSite", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAppMigrationDevelopmentService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppMigrationDevelopmentService.kt\ncom/atlassian/jira/migration/app/AppMigrationDevelopmentService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n1#2:62\n*E\n"})
public final class AppMigrationDevelopmentService {
    @NotNull
    private final CloudMigrationRegistrar registrar;
    @NotNull
    private final PlanRepository planStore;
    @NotNull
    private final PlatformService platformService;
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final CloudTypeSettingRetrievalService cloudTypeSettingRetrievalService;
    private final Logger log;

    @Inject
    public AppMigrationDevelopmentService(@NotNull CloudMigrationRegistrar registrar, @NotNull PlanRepository planStore, @NotNull PlatformService platformService, @NotNull DiscoveryService discoveryService, @NotNull CloudTypeSettingRetrievalService cloudTypeSettingRetrievalService) {
        Intrinsics.checkNotNullParameter((Object)((Object)registrar), (String)"registrar");
        Intrinsics.checkNotNullParameter((Object)planStore, (String)"planStore");
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)cloudTypeSettingRetrievalService, (String)"cloudTypeSettingRetrievalService");
        this.registrar = registrar;
        this.planStore = planStore;
        this.platformService = platformService;
        this.discoveryService = discoveryService;
        this.cloudTypeSettingRetrievalService = cloudTypeSettingRetrievalService;
        this.log = LoggerFactory.getLogger(AppMigrationDevelopmentService.class);
    }

    public final void rerunAppMigrationForPlan(@NotNull String planId) {
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        this.rerunAppMigrationForPlan(planId, null);
    }

    public final void rerunAppMigrationForPlan(@NotNull String planId, @Nullable Set<String> serverAppKeys) {
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        this.log.info("Triggering app migration for planId: " + planId);
        Plan plan2 = this.planStore.get(planId);
        Intrinsics.checkNotNull((Object)plan2);
        Plan plan3 = plan2;
        CloudSite cloudSite2 = this.getCloudSite(plan3.getCloudId());
        this.validateCloudType(cloudSite2);
        ContainerToken containerToken = new ContainerToken(cloudSite2.getContainerToken());
        CreateMigrationResponse migration = this.platformService.publishMigrationDetailsForAppMigrationDevLoop(plan3, containerToken);
        PlatformService.registerContainers$default(this.platformService, containerToken, migration.getMigrationId(), plan3, false, 8, null);
        MigrationId migrationId = migration.getMigrationId();
        Set set = serverAppKeys;
        if (set == null) {
            set = this.registrar.getRegisteredServerKeys();
        }
        this.registrar.registerAppContainers(containerToken, planId, migrationId, set);
        String string = plan3.getCloudId();
        String string2 = migration.getMigrationId().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        this.registrar.startMigration(string, string2);
    }

    private final void validateCloudType(CloudSite cloudSite2) {
        boolean isFedRampMode;
        Map<CloudType, Boolean> map = this.cloudTypeSettingRetrievalService.getSetting();
        boolean bl = isFedRampMode = map != null ? map.getOrDefault((Object)CloudType.FEDRAMP, false) : false;
        if (isFedRampMode && CloudType.STANDARD == cloudSite2.getCloudType()) {
            throw new CloudTypeMismatchException("Triggering app migration for STANDARD cloud site not allowed in FedRAMP mode.");
        }
        if (!isFedRampMode && CloudType.FEDRAMP == cloudSite2.getCloudType()) {
            throw new CloudTypeMismatchException("Triggering app migration for FEDRAMP cloud site not allowed in STANDARD mode.");
        }
    }

    private final CloudSite getCloudSite(String cloudId2) {
        CloudSite cloudSite2 = this.discoveryService.retrieveCloudSiteForCloudId(cloudId2);
        if (cloudSite2 == null) {
            boolean bl = false;
            String string = "Failed to find cloudSite entry for requested cloudId: " + cloudId2;
            throw new IllegalArgumentException(string.toString());
        }
        return cloudSite2;
    }
}

