/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.app;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.GenericOperationalEvent;
import com.atlassian.jira.migration.analytics.AnalyticsEventService;
import com.atlassian.jira.migration.app.CloudMigrationRegistrar;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.MigrationStatusUpdatedEvent;
import com.google.common.eventbus.Subscribe;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0001\"B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\b\u0010\u0017\u001a\u00020\u0014H\u0007J\b\u0010\u0018\u001a\u00020\u0014H\u0007J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J*\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u001e2\b\u0010!\u001a\u0004\u0018\u00010\u0010H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/atlassian/jira/migration/app/AppMigrationTrigger;", "", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "cloudMigrationRegistrar", "Lcom/atlassian/jira/migration/app/CloudMigrationRegistrar;", "clusterLockService", "Lcom/atlassian/beehive/ClusterLockService;", "cacheManager", "Lcom/atlassian/cache/CacheManager;", "analyticsEventService", "Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;", "(Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/app/CloudMigrationRegistrar;Lcom/atlassian/beehive/ClusterLockService;Lcom/atlassian/cache/CacheManager;Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;)V", "migrationIdProcessedCache", "Lcom/atlassian/cache/Cache;", "", "Ljava/time/Instant;", "checkTimeMigrationIdLastProcessed", "migrationId", "onMigrationStatusUpdate", "", "event", "Lcom/atlassian/jira/migration/events/MigrationStatusUpdatedEvent;", "postConstruct", "preDestroy", "preventDuplicateProcessing", "processEventWithLocking", "sendLockAnalytics", "cloudId", "isLockObtained", "", "sendMigrationIdCacheAnalytics", "isMigrationInCache", "dateTimeMigrationIdProcessed", "Companion", "jira-migration-plugin"})
public final class AppMigrationTrigger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final CloudMigrationRegistrar cloudMigrationRegistrar;
    @NotNull
    private final ClusterLockService clusterLockService;
    @NotNull
    private final CacheManager cacheManager;
    @NotNull
    private final AnalyticsEventService analyticsEventService;
    @NotNull
    private final Cache<String, Instant> migrationIdProcessedCache;
    @NotNull
    private static final String APP_MIGRATION_TRIGGER_LOCK_NAME = "com.atlassian.migration.app.AppMigrationTrigger";
    private static final long APP_MIGRATION_TRIGGER_TRY_LOCK_DURATION_IN_MINUTES = 2L;
    private static final long MIGRATION_ID_PROCESSED_CACHE_TTL_IN_MINUTES = 30L;
    private static final int MIGRATION_ID_PROCESSED_CACHE_MAX_ENTRIES = 10;
    private static final Logger log = LoggerFactory.getLogger(AppMigrationTrigger.class);

    @Inject
    public AppMigrationTrigger(@NotNull MigrationEventBus migrationEventBus, @NotNull CloudMigrationRegistrar cloudMigrationRegistrar, @NotNull ClusterLockService clusterLockService, @NotNull CacheManager cacheManager, @NotNull AnalyticsEventService analyticsEventService) {
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)((Object)cloudMigrationRegistrar), (String)"cloudMigrationRegistrar");
        Intrinsics.checkNotNullParameter((Object)clusterLockService, (String)"clusterLockService");
        Intrinsics.checkNotNullParameter((Object)cacheManager, (String)"cacheManager");
        Intrinsics.checkNotNullParameter((Object)analyticsEventService, (String)"analyticsEventService");
        this.migrationEventBus = migrationEventBus;
        this.cloudMigrationRegistrar = cloudMigrationRegistrar;
        this.clusterLockService = clusterLockService;
        this.cacheManager = cacheManager;
        this.analyticsEventService = analyticsEventService;
        Cache cache2 = this.cacheManager.getCache(AppMigrationTrigger.class.getName() + ".migration.id.processed", null, new CacheSettingsBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).maxEntries(10).replicateViaCopy().remote().build());
        Intrinsics.checkNotNullExpressionValue((Object)cache2, (String)"getCache(...)");
        this.migrationIdProcessedCache = cache2;
    }

    @PostConstruct
    public final void postConstruct() {
        this.migrationEventBus.register(this);
        this.migrationIdProcessedCache.removeAll();
    }

    @PreDestroy
    public final void preDestroy() {
        this.migrationEventBus.unregister(this);
        this.migrationIdProcessedCache.removeAll();
    }

    @Subscribe
    public final void onMigrationStatusUpdate(@NotNull MigrationStatusUpdatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getStatus() == MigrationStatusUpdatedEvent.Status.FINISHED) {
            this.processEventWithLocking(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processEventWithLocking(MigrationStatusUpdatedEvent event) {
        Instant timeMigrationIdWasProcessed;
        Instant instant;
        boolean isLockObtained;
        boolean bl;
        ClusterLock lock = this.clusterLockService.getLockForName(APP_MIGRATION_TRIGGER_LOCK_NAME);
        if (lock.tryLock(2L, TimeUnit.MINUTES)) {
            log.info("Obtained lock for migrationId: " + event.getMigrationId());
            bl = true;
        } else {
            log.warn("Lock was not obtained in 2 minutes for migrationId: " + event.getMigrationId());
            bl = isLockObtained = false;
        }
        if (isLockObtained) {
            Instant instant2;
            try {
                instant2 = this.preventDuplicateProcessing(event.getMigrationId());
            }
            finally {
                lock.unlock();
            }
            instant = instant2;
        } else {
            instant = timeMigrationIdWasProcessed = this.preventDuplicateProcessing(event.getMigrationId());
        }
        if (timeMigrationIdWasProcessed == null) {
            this.cloudMigrationRegistrar.startMigration(event.getCloudId(), event.getMigrationId());
        }
        this.sendLockAnalytics(event.getCloudId(), event.getMigrationId(), isLockObtained);
        this.sendMigrationIdCacheAnalytics(event.getCloudId(), event.getMigrationId(), timeMigrationIdWasProcessed != null, timeMigrationIdWasProcessed);
    }

    private final Instant preventDuplicateProcessing(String migrationId) {
        Instant timeMigrationIdWasProcessed = this.checkTimeMigrationIdLastProcessed(migrationId);
        if (timeMigrationIdWasProcessed == null) {
            log.info("Saving migrationId " + migrationId + " into cache");
            this.migrationIdProcessedCache.put((Object)migrationId, (Object)Instant.now());
        }
        return timeMigrationIdWasProcessed;
    }

    private final Instant checkTimeMigrationIdLastProcessed(String migrationId) {
        Instant timeMigrationIdProcessed = (Instant)this.migrationIdProcessedCache.get((Object)migrationId);
        if (timeMigrationIdProcessed == null) {
            log.info("migrationId " + migrationId + " was not found in cache");
        } else {
            log.info("migrationId " + migrationId + ", was already processed at " + timeMigrationIdProcessed);
        }
        return timeMigrationIdProcessed;
    }

    private final void sendLockAnalytics(String cloudId2, String migrationId, boolean isLockObtained) {
        try {
            GenericOperationalEvent.Builder eventBuilder = new GenericOperationalEvent.Builder(Instant.now().toEpochMilli());
            eventBuilder.cloudId(cloudId2);
            eventBuilder.action("executed");
            eventBuilder.actionSubject("appMigrationTriggerLock", migrationId);
            eventBuilder.addAttribute("isLockObtained", (Object)isLockObtained);
            GenericOperationalEvent genericOperationalEvent = eventBuilder.build();
            Intrinsics.checkNotNullExpressionValue((Object)genericOperationalEvent, (String)"build(...)");
            AnalyticsEventService.saveAnalyticsEvent$default(this.analyticsEventService, (EventDto)genericOperationalEvent, null, 2, null);
        }
        catch (Exception e) {
            log.warn("Unable to save 'appMigrationTriggerLock' analytic event", (Throwable)e);
        }
    }

    private final void sendMigrationIdCacheAnalytics(String cloudId2, String migrationId, boolean isMigrationInCache, Instant dateTimeMigrationIdProcessed) {
        try {
            GenericOperationalEvent.Builder eventBuilder = new GenericOperationalEvent.Builder(Instant.now().toEpochMilli());
            eventBuilder.cloudId(cloudId2);
            eventBuilder.action("executed");
            eventBuilder.actionSubject("appMigrationTriggerCache", migrationId);
            eventBuilder.addAttribute("isMigrationIdInCache", (Object)isMigrationInCache);
            Instant instant = dateTimeMigrationIdProcessed;
            if (instant != null) {
                Instant it = instant;
                boolean bl = false;
                GenericOperationalEvent.Builder cfr_ignored_0 = (GenericOperationalEvent.Builder)eventBuilder.addAttribute("dateTimeMigrationIdProcessed", (Object)DateTimeFormatter.ISO_INSTANT.format(dateTimeMigrationIdProcessed));
            }
            GenericOperationalEvent genericOperationalEvent = eventBuilder.build();
            Intrinsics.checkNotNullExpressionValue((Object)genericOperationalEvent, (String)"build(...)");
            AnalyticsEventService.saveAnalyticsEvent$default(this.analyticsEventService, (EventDto)genericOperationalEvent, null, 2, null);
        }
        catch (Exception e) {
            log.warn("Unable to save 'appMigrationTriggerCache' analytic event", (Throwable)e);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/jira/migration/app/AppMigrationTrigger$Companion;", "", "()V", "APP_MIGRATION_TRIGGER_LOCK_NAME", "", "APP_MIGRATION_TRIGGER_TRY_LOCK_DURATION_IN_MINUTES", "", "MIGRATION_ID_PROCESSED_CACHE_MAX_ENTRIES", "", "MIGRATION_ID_PROCESSED_CACHE_TTL_IN_MINUTES", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

