/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.app;

import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.guardrails.queries.App;
import com.atlassian.jira.migration.plan.Plan;
import java.util.Collection;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/jira/migration/app/AppProcessingControlService;", "", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "includesSupportedApps", "", "includedAppKeys", "", "", "shouldEnableProcessing", "plan", "Lcom/atlassian/jira/migration/plan/Plan;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAppProcessingControlService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppProcessingControlService.kt\ncom/atlassian/jira/migration/app/AppProcessingControlService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,26:1\n1747#2,3:27\n*S KotlinDebug\n*F\n+ 1 AppProcessingControlService.kt\ncom/atlassian/jira/migration/app/AppProcessingControlService\n*L\n24#1:27,3\n*E\n"})
public final class AppProcessingControlService {
    @NotNull
    private final MigrationFeatures migrationFeatures;

    @Inject
    public AppProcessingControlService(@NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.migrationFeatures = migrationFeatures;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean shouldEnableProcessing(@NotNull Plan plan2) {
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        if (!this.migrationFeatures.getEnableRecipeExecutionForAppMigrations()) return false;
        if (!plan2.isAppMigrationOptionIncluded()) return false;
        Set<String> set = plan2.getAppsMigrationOption().getIncludedApps();
        Intrinsics.checkNotNull(set);
        if (!this.includesSupportedApps(set)) return false;
        return true;
    }

    private final boolean includesSupportedApps(Set<String> includedAppKeys) {
        boolean bl;
        block3: {
            Set supportedApps = SetsKt.setOf((Object)App.XRAY.getAppKey());
            Iterable $this$any$iv = supportedApps;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!includedAppKeys.contains(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

