/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.app;

import com.atlassian.jira.exception.NotFoundException;
import com.atlassian.jira.migration.amsclient.DefaultAppMigrationServiceClient;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.plan.PlanRepository;
import com.atlassian.migration.app.dto.TransferLogEnablement;
import com.atlassian.migration.app.dto.TransferLogResponse;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\rJ\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/atlassian/jira/migration/app/AppTransferLogService;", "", "defaultAppMigrationServiceClient", "Lcom/atlassian/jira/migration/amsclient/DefaultAppMigrationServiceClient;", "planStore", "Lcom/atlassian/jira/migration/plan/PlanRepository;", "(Lcom/atlassian/jira/migration/amsclient/DefaultAppMigrationServiceClient;Lcom/atlassian/jira/migration/plan/PlanRepository;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getTransferLogCsv", "Lcom/atlassian/migration/app/dto/TransferLogResponse;", "planId", "", "containerId", "transferId", "isTransferLogsEnabled", "Lcom/atlassian/migration/app/dto/TransferLogEnablement;", "jira-migration-plugin"})
public final class AppTransferLogService {
    @NotNull
    private final DefaultAppMigrationServiceClient defaultAppMigrationServiceClient;
    @NotNull
    private final PlanRepository planStore;
    private final Logger log;

    @Inject
    public AppTransferLogService(@NotNull DefaultAppMigrationServiceClient defaultAppMigrationServiceClient, @NotNull PlanRepository planStore) {
        Intrinsics.checkNotNullParameter((Object)defaultAppMigrationServiceClient, (String)"defaultAppMigrationServiceClient");
        Intrinsics.checkNotNullParameter((Object)planStore, (String)"planStore");
        this.defaultAppMigrationServiceClient = defaultAppMigrationServiceClient;
        this.planStore = planStore;
        this.log = LoggerFactory.getLogger(AppTransferLogService.class);
    }

    @NotNull
    public final TransferLogResponse getTransferLogCsv(@NotNull String planId, @NotNull String containerId, @Nullable String transferId) {
        Plan plan2;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
                Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
                this.log.debug("Getting transfer log for plan " + planId + " and container " + containerId);
                plan2 = this.planStore.get(planId);
                if (plan2 == null) break block2;
                Plan it = plan2;
                boolean bl = false;
                String cloudId2 = it.getCloudId();
                TransferLogResponse response2 = this.defaultAppMigrationServiceClient.getTransferLogs(cloudId2, containerId, transferId);
                this.log.debug("Finished getting transfer logs with content disposition: " + response2.getContentDispositionHeader());
                TransferLogResponse transferLogResponse = response2;
                plan2 = transferLogResponse;
                if (transferLogResponse != null) break block3;
            }
            throw new NotFoundException("Plan was not found");
        }
        return plan2;
    }

    public static /* synthetic */ TransferLogResponse getTransferLogCsv$default(AppTransferLogService appTransferLogService, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        return appTransferLogService.getTransferLogCsv(string, string2, string3);
    }

    @NotNull
    public final TransferLogEnablement isTransferLogsEnabled(@NotNull String planId, @NotNull String containerId, @Nullable String transferId) {
        Plan plan2;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
                Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
                this.log.debug("Checking if transfer logs enabled for containerId: {} planId: {}", (Object)containerId, (Object)planId);
                plan2 = this.planStore.get(planId);
                if (plan2 == null) break block2;
                Plan it = plan2;
                boolean bl = false;
                String cloudId2 = it.getCloudId();
                TransferLogEnablement response2 = this.defaultAppMigrationServiceClient.isTransferLogEnabled(cloudId2, containerId, transferId);
                this.log.debug("Transfer logs enabled: {} with blockers: {}", (Object)response2.getEnabled(), (Object)response2.getBlockers());
                TransferLogEnablement transferLogEnablement = response2;
                plan2 = transferLogEnablement;
                if (transferLogEnablement != null) break block3;
            }
            throw new NotFoundException("Plan was not found");
        }
        return plan2;
    }

    public static /* synthetic */ TransferLogEnablement isTransferLogsEnabled$default(AppTransferLogService appTransferLogService, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        return appTransferLogService.isTransferLogsEnabled(string, string2, string3);
    }
}

