/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.app;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.GenericOperationalEvent;
import com.atlassian.jira.migration.common.Sink;
import com.atlassian.jira.migration.tracking.utils.TimeProvider;
import com.atlassian.migration.app.AppAnalyticsEventService;
import com.atlassian.migration.app.analytics.MultiPartUploadAnalyticEvent;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001d\b\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/jira/migration/app/AppUploadAnalyticsEventService;", "Lcom/atlassian/migration/app/AppAnalyticsEventService;", "analyticsEventSink", "Lcom/atlassian/jira/migration/common/Sink;", "Lcom/atlassian/cmpt/analytics/events/EventDto;", "timeProvider", "Lcom/atlassian/jira/migration/tracking/utils/TimeProvider;", "(Lcom/atlassian/jira/migration/common/Sink;Lcom/atlassian/jira/migration/tracking/utils/TimeProvider;)V", "sendEvent", "", "multiPartUploadAnalyticEvent", "Lcom/atlassian/migration/app/analytics/MultiPartUploadAnalyticEvent;", "jira-migration-plugin"})
public final class AppUploadAnalyticsEventService
implements AppAnalyticsEventService {
    @NotNull
    private final Sink<EventDto> analyticsEventSink;
    @NotNull
    private final TimeProvider timeProvider;

    @Inject
    public AppUploadAnalyticsEventService(@NotNull Sink<EventDto> analyticsEventSink, @NotNull TimeProvider timeProvider) {
        Intrinsics.checkNotNullParameter(analyticsEventSink, (String)"analyticsEventSink");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        this.analyticsEventSink = analyticsEventSink;
        this.timeProvider = timeProvider;
    }

    public void sendEvent(@NotNull MultiPartUploadAnalyticEvent multiPartUploadAnalyticEvent) {
        Intrinsics.checkNotNullParameter((Object)multiPartUploadAnalyticEvent, (String)"multiPartUploadAnalyticEvent");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"transferId", (Object)multiPartUploadAnalyticEvent.getTransferId()), TuplesKt.to((Object)"s3Key", (Object)multiPartUploadAnalyticEvent.getS3Key()), TuplesKt.to((Object)"sha256Sum", (Object)multiPartUploadAnalyticEvent.getSha256Sum()), TuplesKt.to((Object)"partIndex", (Object)multiPartUploadAnalyticEvent.getIndex()), TuplesKt.to((Object)"sizeKb", (Object)multiPartUploadAnalyticEvent.getSize()), TuplesKt.to((Object)"appKey", (Object)multiPartUploadAnalyticEvent.getAppKey()), TuplesKt.to((Object)"partUploadTimeSeconds", (Object)Float.valueOf(multiPartUploadAnalyticEvent.getUploadToS3ElapsedTime())), TuplesKt.to((Object)"urlGenerateTimeSeconds", (Object)Float.valueOf(multiPartUploadAnalyticEvent.getGetUrlElapsedTime())), TuplesKt.to((Object)"uploadTotalTimeSeconds", (Object)Float.valueOf(multiPartUploadAnalyticEvent.getTotalElapsedTime())), TuplesKt.to((Object)"parallelMode", (Object)multiPartUploadAnalyticEvent.getParallelMode()), TuplesKt.to((Object)"cachedUploadMode", (Object)multiPartUploadAnalyticEvent.getCachedUploadMode()), TuplesKt.to((Object)"uploadMode", (Object)multiPartUploadAnalyticEvent.getUploadMode()), TuplesKt.to((Object)"cacheHit", (Object)multiPartUploadAnalyticEvent.getCacheHit())};
        GenericOperationalEvent dto = ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(this.timeProvider.now().toEpochMilli()).action("uploaded")).actionSubject("appDataPart")).source("appDataPartUploaded")).cloudId(multiPartUploadAnalyticEvent.getCloudId())).contextContainer("migrationId", multiPartUploadAnalyticEvent.getMigrationId())).withAttributes(MapsKt.mapOf((Pair[])pairArray))).build();
        Intrinsics.checkNotNull((Object)dto);
        this.analyticsEventSink.put((EventDto)dto);
    }
}

