/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.app;

import com.atlassian.cmpt.analytics.events.EventDto;
import com.atlassian.cmpt.analytics.events.GenericOperationalEvent;
import com.atlassian.jira.migration.amsclient.DefaultAppMigrationServiceClient;
import com.atlassian.jira.migration.analytics.AnalyticsEventService;
import com.atlassian.jira.migration.app.AppUploadAnalyticsEventService;
import com.atlassian.jira.migration.app.CloudMigrationRegistrarKt;
import com.atlassian.jira.migration.app.ConnectWorkflowRule;
import com.atlassian.jira.migration.app.RecipeRequestTransformationService;
import com.atlassian.jira.migration.app.preload.AppDataPreloadGatewayImpl;
import com.atlassian.jira.migration.common.MigrationTaskMetadata;
import com.atlassian.jira.migration.execution.LithiumAppMigrationsHelper;
import com.atlassian.jira.migration.migration.Migration;
import com.atlassian.jira.migration.migration.MigrationRepository;
import com.atlassian.jira.migration.platform.AppContainer;
import com.atlassian.jira.migration.platform.PlatformService;
import com.atlassian.jira.migration.publicapi.client.MigrationClient;
import com.atlassian.migration.api.CloudId;
import com.atlassian.migration.api.ContainerToken;
import com.atlassian.migration.api.MigrationId;
import com.atlassian.migration.app.AbstractCloudMigrationRegistrar;
import com.atlassian.migration.app.AppAnalyticsEventService;
import com.atlassian.migration.app.AppMigrationDarkFeatures;
import com.atlassian.migration.app.AppMigrationServiceClient;
import com.atlassian.migration.app.cloudAssistantRegistrars.AppDataPreloadGateway;
import com.atlassian.migration.app.dto.AppContainerDetails;
import com.atlassian.migration.app.dto.ConnectAppCustomField;
import com.atlassian.migration.app.dto.ForgeAppCustomField;
import com.atlassian.migration.app.dto.ServerAddonCustomField;
import com.atlassian.migration.app.dto.ServerPluginCustomField;
import com.atlassian.migration.app.lio.model.RecipeExecutionRequest;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00d6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002Bg\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\u0006\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\u0002\u0010\u001bJ\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\b\b\u0002\u0010\u001f\u001a\u00020 H\u0002J \u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&H\u0016J\u0006\u0010'\u001a\u00020\u0004J\u001a\u0010(\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020+0)2\u0006\u0010,\u001a\u00020-J\u001e\u0010.\u001a\u0012\u0012\b\u0012\u00060\u001dj\u0002`/\u0012\u0004\u0012\u0002000)2\u0006\u0010,\u001a\u00020-J\u001a\u00101\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u0002030)2\u0006\u0010,\u001a\u00020-J$\u00104\u001a\u0012\u0012\b\u0012\u00060\u001dj\u0002`/\u0012\u0004\u0012\u0002000)2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u001d06J\b\u00107\u001a\u00020\"H\u0007J\b\u00108\u001a\u00020\"H\u0007J\u001a\u00109\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u001d2\b\u0010:\u001a\u0004\u0018\u00010;H\u0016J,\u0010<\u001a\u00020\"2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020@2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u001d06J\u0010\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020DH\u0016J$\u0010E\u001a\u00020\"2\u0012\u0010F\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u0002030)2\u0006\u0010#\u001a\u00020\u001dH\u0002J\u0016\u0010G\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u001dJ \u0010H\u001a\u0012\u0012\b\u0012\u00060\u001dj\u0002`/\u0012\u0004\u0012\u0002000I2\u0006\u0010J\u001a\u00020KH\u0002R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lcom/atlassian/jira/migration/app/CloudMigrationRegistrar;", "Lcom/atlassian/scheduler/JobRunner;", "Lcom/atlassian/migration/app/AbstractCloudMigrationRegistrar;", "appMigrationServiceClient", "Lcom/atlassian/jira/migration/amsclient/DefaultAppMigrationServiceClient;", "platformService", "Lcom/atlassian/jira/migration/platform/PlatformService;", "schedulerService", "Lcom/atlassian/scheduler/SchedulerService;", "appDataPreloadGatewayImpl", "Lcom/atlassian/jira/migration/app/preload/AppDataPreloadGatewayImpl;", "appUploadAnalyticsEventService", "Lcom/atlassian/jira/migration/app/AppUploadAnalyticsEventService;", "bundleContext", "Lorg/osgi/framework/BundleContext;", "appMigrationDarkFeatures", "Lcom/atlassian/migration/app/AppMigrationDarkFeatures;", "analyticsEventService", "Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;", "migrationClient", "Lcom/atlassian/jira/migration/publicapi/client/MigrationClient;", "recipeRequestTransformationService", "Lcom/atlassian/jira/migration/app/RecipeRequestTransformationService;", "lithiumAppMigrationsHelper", "Lcom/atlassian/jira/migration/execution/LithiumAppMigrationsHelper;", "migrationRepository", "Lcom/atlassian/jira/migration/migration/MigrationRepository;", "(Lcom/atlassian/jira/migration/amsclient/DefaultAppMigrationServiceClient;Lcom/atlassian/jira/migration/platform/PlatformService;Lcom/atlassian/scheduler/SchedulerService;Lcom/atlassian/jira/migration/app/preload/AppDataPreloadGatewayImpl;Lcom/atlassian/jira/migration/app/AppUploadAnalyticsEventService;Lorg/osgi/framework/BundleContext;Lcom/atlassian/migration/app/AppMigrationDarkFeatures;Lcom/atlassian/jira/migration/analytics/AnalyticsEventService;Lcom/atlassian/jira/migration/publicapi/client/MigrationClient;Lcom/atlassian/jira/migration/app/RecipeRequestTransformationService;Lcom/atlassian/jira/migration/execution/LithiumAppMigrationsHelper;Lcom/atlassian/jira/migration/migration/MigrationRepository;)V", "abbreviate", "", "transferId", "maxWidth", "", "executeRecipe", "", "cloudId", "migrationId", "recipeExecutionRequest", "Lcom/atlassian/migration/app/lio/model/RecipeExecutionRequest;", "getAppMigrationServiceClient", "getConnectAppCustomFields", "", "Lcom/atlassian/migration/app/dto/ServerAddonCustomField;", "Lcom/atlassian/migration/app/dto/ConnectAppCustomField;", "migrationTaskMetadata", "Lcom/atlassian/jira/migration/common/MigrationTaskMetadata;", "getConnectWorkFlowRulesMap", "Lcom/atlassian/jira/migration/common/ClassName;", "Lcom/atlassian/jira/migration/app/ConnectWorkflowRule;", "getForgeAppCustomFields", "Lcom/atlassian/migration/app/dto/ServerPluginCustomField;", "Lcom/atlassian/migration/app/dto/ForgeAppCustomField;", "getServerAppWorkFlowRulesMap", "serverKeys", "", "postConstruct", "preDestroy", "queueExecution", "date", "Ljava/util/Date;", "registerAppContainers", "containerToken", "Lcom/atlassian/migration/api/ContainerToken;", "planId", "Lcom/atlassian/migration/api/MigrationId;", "runJob", "Lcom/atlassian/scheduler/JobRunnerResponse;", "request", "Lcom/atlassian/scheduler/JobRunnerRequest;", "sendAnalyticsForForgeCFMappings", "mappings", "startMigration", "toClassWithRule", "Lkotlin/Pair;", "connectRule", "Lcom/atlassian/migration/app/dto/ConnectWorkflowRule;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nCloudMigrationRegistrar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloudMigrationRegistrar.kt\ncom/atlassian/jira/migration/app/CloudMigrationRegistrar\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,286:1\n1179#2,2:287\n1253#2,4:289\n1179#2,2:293\n1253#2,4:295\n1360#2:299\n1446#2,2:300\n1549#2:302\n1620#2,3:303\n1448#2,3:306\n*S KotlinDebug\n*F\n+ 1 CloudMigrationRegistrar.kt\ncom/atlassian/jira/migration/app/CloudMigrationRegistrar\n*L\n107#1:287,2\n107#1:289,4\n115#1:293,2\n115#1:295,4\n195#1:299\n195#1:300,2\n197#1:302\n197#1:303,3\n195#1:306,3\n*E\n"})
public class CloudMigrationRegistrar
extends AbstractCloudMigrationRegistrar
implements JobRunner {
    @NotNull
    private final DefaultAppMigrationServiceClient appMigrationServiceClient;
    @NotNull
    private final PlatformService platformService;
    @NotNull
    private final SchedulerService schedulerService;
    @NotNull
    private final AnalyticsEventService analyticsEventService;
    @NotNull
    private final MigrationClient migrationClient;
    @NotNull
    private final RecipeRequestTransformationService recipeRequestTransformationService;
    @NotNull
    private final LithiumAppMigrationsHelper lithiumAppMigrationsHelper;
    @NotNull
    private final MigrationRepository migrationRepository;

    @Inject
    public CloudMigrationRegistrar(@NotNull DefaultAppMigrationServiceClient appMigrationServiceClient, @NotNull PlatformService platformService, @NotNull SchedulerService schedulerService, @NotNull AppDataPreloadGatewayImpl appDataPreloadGatewayImpl, @NotNull AppUploadAnalyticsEventService appUploadAnalyticsEventService, @NotNull BundleContext bundleContext, @NotNull AppMigrationDarkFeatures appMigrationDarkFeatures, @NotNull AnalyticsEventService analyticsEventService, @NotNull MigrationClient migrationClient, @NotNull RecipeRequestTransformationService recipeRequestTransformationService, @NotNull LithiumAppMigrationsHelper lithiumAppMigrationsHelper, @NotNull MigrationRepository migrationRepository) {
        Intrinsics.checkNotNullParameter((Object)appMigrationServiceClient, (String)"appMigrationServiceClient");
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        Intrinsics.checkNotNullParameter((Object)schedulerService, (String)"schedulerService");
        Intrinsics.checkNotNullParameter((Object)appDataPreloadGatewayImpl, (String)"appDataPreloadGatewayImpl");
        Intrinsics.checkNotNullParameter((Object)appUploadAnalyticsEventService, (String)"appUploadAnalyticsEventService");
        Intrinsics.checkNotNullParameter((Object)bundleContext, (String)"bundleContext");
        Intrinsics.checkNotNullParameter((Object)appMigrationDarkFeatures, (String)"appMigrationDarkFeatures");
        Intrinsics.checkNotNullParameter((Object)analyticsEventService, (String)"analyticsEventService");
        Intrinsics.checkNotNullParameter((Object)migrationClient, (String)"migrationClient");
        Intrinsics.checkNotNullParameter((Object)recipeRequestTransformationService, (String)"recipeRequestTransformationService");
        Intrinsics.checkNotNullParameter((Object)lithiumAppMigrationsHelper, (String)"lithiumAppMigrationsHelper");
        Intrinsics.checkNotNullParameter((Object)migrationRepository, (String)"migrationRepository");
        super(bundleContext, appMigrationDarkFeatures, (AppMigrationServiceClient)appMigrationServiceClient, (AppAnalyticsEventService)appUploadAnalyticsEventService, null, (AppDataPreloadGateway)appDataPreloadGatewayImpl, 16, null);
        this.appMigrationServiceClient = appMigrationServiceClient;
        this.platformService = platformService;
        this.schedulerService = schedulerService;
        this.analyticsEventService = analyticsEventService;
        this.migrationClient = migrationClient;
        this.recipeRequestTransformationService = recipeRequestTransformationService;
        this.lithiumAppMigrationsHelper = lithiumAppMigrationsHelper;
        this.migrationRepository = migrationRepository;
    }

    public final void startMigration(@NotNull String cloudId2, @NotNull String migrationId) {
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Set<AppContainerDetails> appContainerDetails = this.platformService.getAppContainers(new CloudId(cloudId2), new MigrationId(UUID.fromString(migrationId)));
        Object[] objectArray = new Object[]{cloudId2, migrationId, appContainerDetails.size()};
        CloudMigrationRegistrarKt.access$getLog$p().debug("Starting app-migration for cloudId={}, migrationId={}, appContainerDetails.size={}", objectArray);
        super.startMigration(cloudId2, migrationId, appContainerDetails);
        Migration migration = this.migrationRepository.findByMigrationId(migrationId);
        if (migration == null) {
            return;
        }
        Migration migration2 = migration;
        for (AppContainerDetails appContainerDetail : appContainerDetails) {
            this.lithiumAppMigrationsHelper.forgetLithiumAppProperties(migration2.getPlanId(), appContainerDetail.getServerAppKey());
        }
    }

    @NotNull
    public final DefaultAppMigrationServiceClient getAppMigrationServiceClient() {
        return this.appMigrationServiceClient;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, ConnectWorkflowRule> getConnectWorkFlowRulesMap(@NotNull MigrationTaskMetadata migrationTaskMetadata2) {
        Intrinsics.checkNotNullParameter((Object)migrationTaskMetadata2, (String)"migrationTaskMetadata");
        if (!MigrationTaskMetadata.Companion.isDummyMigration(migrationTaskMetadata2)) {
            void $this$associateTo$iv$iv;
            Collection collection = this.platformService.getAppContainers(new CloudId(migrationTaskMetadata2.getCloudId()), new MigrationId(UUID.fromString(migrationTaskMetadata2.getMigrationId())));
            if (collection.isEmpty()) {
                boolean bl = false;
                return MapsKt.emptyMap();
            }
            Set appContainers = (Set)collection;
            Iterable $this$associate$iv = super.getConnectWorkFlowRules(appContainers);
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                com.atlassian.migration.app.dto.ConnectWorkflowRule p0 = (com.atlassian.migration.app.dto.ConnectWorkflowRule)element$iv$iv;
                boolean bl = false;
                Pair<String, ConnectWorkflowRule> pair = this.toClassWithRule(p0);
                map.put(pair.getFirst(), pair.getSecond());
            }
            return destination$iv$iv;
        }
        CloudMigrationRegistrarKt.access$getLog$p().info("Returning empty server to connect app workflow rules mapping for dummy migration task meta data");
        return MapsKt.emptyMap();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, ConnectWorkflowRule> getServerAppWorkFlowRulesMap(@NotNull Set<String> serverKeys) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter(serverKeys, (String)"serverKeys");
        Iterable $this$associate$iv = super.getServerAppWorkFlowRules(serverKeys);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            com.atlassian.migration.app.dto.ConnectWorkflowRule p0 = (com.atlassian.migration.app.dto.ConnectWorkflowRule)element$iv$iv;
            boolean bl = false;
            Pair<String, ConnectWorkflowRule> pair = this.toClassWithRule(p0);
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    private final Pair<String, ConnectWorkflowRule> toClassWithRule(com.atlassian.migration.app.dto.ConnectWorkflowRule connectRule) {
        com.atlassian.migration.app.dto.ConnectWorkflowRule $this$toClassWithRule_u24lambda_u242 = connectRule;
        boolean bl = false;
        return TuplesKt.to((Object)$this$toClassWithRule_u24lambda_u242.getServerClassName(), (Object)new ConnectWorkflowRule($this$toClassWithRule_u24lambda_u242.getServerAppKey(), $this$toClassWithRule_u24lambda_u242.getServerClassName(), $this$toClassWithRule_u24lambda_u242.getCloudAppKey(), $this$toClassWithRule_u24lambda_u242.getCloudWorkflowRuleKey()));
    }

    @NotNull
    public final Map<ServerAddonCustomField, ConnectAppCustomField> getConnectAppCustomFields(@NotNull MigrationTaskMetadata migrationTaskMetadata2) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)migrationTaskMetadata2, (String)"migrationTaskMetadata");
        if (!MigrationTaskMetadata.Companion.isDummyMigration(migrationTaskMetadata2)) {
            map = this.getConnectCustomFieldMappings(this.platformService.getAppContainers(new CloudId(migrationTaskMetadata2.getCloudId()), new MigrationId(UUID.fromString(migrationTaskMetadata2.getMigrationId()))));
        } else {
            CloudMigrationRegistrarKt.access$getLog$p().info("Returning empty server to connect app custom field mapping for dummy migration task meta data");
            map = MapsKt.emptyMap();
        }
        return map;
    }

    @NotNull
    public final Map<ServerPluginCustomField, ForgeAppCustomField> getForgeAppCustomFields(@NotNull MigrationTaskMetadata migrationTaskMetadata2) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)migrationTaskMetadata2, (String)"migrationTaskMetadata");
        if (MigrationTaskMetadata.Companion.isPreMigration(migrationTaskMetadata2)) {
            Map map2;
            try {
                map2 = this.getForgeCFMappings(migrationTaskMetadata2.getCloudId());
            }
            catch (Exception e) {
                CloudMigrationRegistrarKt.access$getLog$p().warn("Failed to get forge custom field mappings for pre-migration, returning empty map.", (Throwable)e);
                map2 = MapsKt.emptyMap();
            }
            map = map2;
        } else if (MigrationTaskMetadata.Companion.isDummyMigration(migrationTaskMetadata2)) {
            CloudMigrationRegistrarKt.access$getLog$p().info("Returning empty server to forge app custom field mappings for dummy migration task meta data.");
            map = MapsKt.emptyMap();
        } else {
            map = this.getForgeCFMappingsForContainers(this.platformService.getAppContainers(new CloudId(migrationTaskMetadata2.getCloudId()), new MigrationId(UUID.fromString(migrationTaskMetadata2.getMigrationId()))), migrationTaskMetadata2.getCloudId());
        }
        Map mappings = map;
        try {
            this.sendAnalyticsForForgeCFMappings(mappings, migrationTaskMetadata2.getCloudId());
        }
        catch (Exception e) {
            CloudMigrationRegistrarKt.access$getLog$p().warn("Failed to send analytic event for forge custom field mappings", (Throwable)e);
        }
        return mappings;
    }

    private final void sendAnalyticsForForgeCFMappings(Map<ServerPluginCustomField, ForgeAppCustomField> mappings, String cloudId2) {
        CloudMigrationRegistrarKt.access$getLog$p().info("Forge migration fetched mappings=" + mappings);
        GenericOperationalEvent event = ((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)((GenericOperationalEvent.Builder)new GenericOperationalEvent.Builder(Instant.now().toEpochMilli()).actionSubject("forgeCustomFieldMappings")).action("fetched")).cloudId(cloudId2)).withAttributes(MapsKt.mapOf((Pair)TuplesKt.to((Object)"mappings", mappings)))).build();
        Intrinsics.checkNotNull((Object)event);
        AnalyticsEventService.saveAnalyticsEvent$default(this.analyticsEventService, (EventDto)event, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void registerAppContainers(@NotNull ContainerToken containerToken, @NotNull String planId, @NotNull MigrationId migrationId, @NotNull Set<String> serverKeys) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter(serverKeys, (String)"serverKeys");
        if (!((Collection)serverKeys).isEmpty()) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            Iterable iterable = serverKeys;
            boolean $i$f$flatMap = false;
            void var8_7 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                String serverKey = (String)element$iv$iv;
                boolean bl = false;
                Iterable iterable2 = this.getRegisteredCloudKeys(serverKey);
                boolean $i$f$map = false;
                void var17_16 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void cloudKey;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"pluginVersion", (Object)this.platformService.getPluginVersion(serverKey)), TuplesKt.to((Object)"enableAMPyWorkplanForApp", (Object)this.lithiumAppMigrationsHelper.isAMPyEnabledForApp(planId, serverKey))};
                    Map map = MapsKt.mapOf((Pair[])pairArray);
                    collection.add(new AppContainer(null, null, map, null, null, null, serverKey, (String)cloudKey, 59, null));
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List appContainers = (List)destination$iv$iv;
            CloudMigrationRegistrarKt.access$getLog$p().info("Registering app-migration for appContainers {} for migrationId {}", (Object)appContainers, (Object)migrationId);
            this.platformService.registerContainers(containerToken, migrationId, appContainers);
        } else {
            CloudMigrationRegistrarKt.access$getLog$p().info("No app containers for app-migration for migrationId {}", (Object)migrationId);
        }
    }

    public void executeRecipe(@NotNull String cloudId2, @NotNull String migrationId, @NotNull RecipeExecutionRequest recipeExecutionRequest) {
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)recipeExecutionRequest, (String)"recipeExecutionRequest");
        CloudMigrationRegistrarKt.access$getLog$p().info("Executing recipe execution for recipe {}", (Object)recipeExecutionRequest.getName());
        this.migrationClient.executeRecipe(this.appMigrationServiceClient.getContainerTokenWithCloudTypeVerification(cloudId2), migrationId, this.recipeRequestTransformationService.transform(migrationId, recipeExecutionRequest));
    }

    public void queueExecution(@NotNull String transferId, @Nullable Date date) {
        Intrinsics.checkNotNullParameter((Object)transferId, (String)"transferId");
        CloudMigrationRegistrarKt.access$getLog$p().info("Queueing job for app-migration for transferId {}", (Object)CloudMigrationRegistrar.abbreviate$default(this, transferId, 0, 2, null));
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String jobId = string;
        try {
            HashMap parameters = new HashMap();
            ((Map)parameters).put("transferId", transferId);
            this.schedulerService.scheduleJob(JobId.of((String)jobId), JobConfig.forJobRunnerKey((JobRunnerKey)CloudMigrationRegistrarKt.access$getRUNNER_KEY$p()).withSchedule(Schedule.runOnce((Date)date)).withRunMode(RunMode.RUN_LOCALLY).withParameters((Map)parameters));
        }
        catch (SchedulerServiceException e) {
            throw new RuntimeException("Failed to queue new job for jobId " + jobId + " for app-migration for transferId " + CloudMigrationRegistrar.abbreviate$default(this, transferId, 0, 2, null) + ": " + e.getMessage());
        }
    }

    @NotNull
    public JobRunnerResponse runJob(@NotNull JobRunnerRequest request) {
        JobRunnerResponse jobRunnerResponse;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            String transferId = String.valueOf(request.getJobConfig().getParameters().get("transferId"));
            CloudMigrationRegistrarKt.access$getLog$p().info("Running job for app-migration for jobId {} and transferId {}", (Object)request.getJobId(), (Object)CloudMigrationRegistrar.abbreviate$default(this, transferId, 0, 2, null));
            this.executeTransfer(transferId);
            jobRunnerResponse = JobRunnerResponse.success();
            Intrinsics.checkNotNull((Object)jobRunnerResponse);
        }
        catch (Exception e) {
            JobRunnerResponse jobRunnerResponse2 = JobRunnerResponse.failed((String)("Failed to run job: " + e.getMessage()));
            Intrinsics.checkNotNull((Object)jobRunnerResponse2);
            jobRunnerResponse = jobRunnerResponse2;
        }
        return jobRunnerResponse;
    }

    private final String abbreviate(String transferId, int maxWidth) {
        return StringUtils.abbreviate((String)transferId, (int)maxWidth);
    }

    static /* synthetic */ String abbreviate$default(CloudMigrationRegistrar cloudMigrationRegistrar, String string, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: abbreviate");
        }
        if ((n2 & 2) != 0) {
            n = 21;
        }
        return cloudMigrationRegistrar.abbreviate(string, n);
    }

    @PostConstruct
    public final void postConstruct() {
        this.schedulerService.registerJobRunner(CloudMigrationRegistrarKt.access$getRUNNER_KEY$p(), (JobRunner)this);
    }

    @PreDestroy
    public final void preDestroy() {
        this.schedulerService.unregisterJobRunner(CloudMigrationRegistrarKt.access$getRUNNER_KEY$p());
    }
}

