/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.app;

import com.atlassian.jira.migration.analytics.prometheus.PrometheusMetricsExportTrigger;
import com.atlassian.jira.migration.events.AppMigrationStatusUpdatedEvent;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.MigrationStatusUpdatedEvent;
import com.atlassian.jira.migration.platform.PlatformService;
import com.atlassian.migration.api.CloudId;
import com.atlassian.migration.api.MigrationId;
import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0011H\u0007J\b\u0010\u0012\u001a\u00020\rH\u0007J\b\u0010\u0013\u001a\u00020\rH\u0007J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0015H\u0002R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/atlassian/jira/migration/app/PrometheusMetricExporterStopper;", "", "prometheusMetricsExportTrigger", "Lcom/atlassian/jira/migration/analytics/prometheus/PrometheusMetricsExportTrigger;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "platformService", "Lcom/atlassian/jira/migration/platform/PlatformService;", "(Lcom/atlassian/jira/migration/analytics/prometheus/PrometheusMetricsExportTrigger;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/platform/PlatformService;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "onAppMigrationStatusUpdate", "", "event", "Lcom/atlassian/jira/migration/events/AppMigrationStatusUpdatedEvent;", "onMigrationStatusUpdate", "Lcom/atlassian/jira/migration/events/MigrationStatusUpdatedEvent;", "postConstruct", "preDestroy", "shouldStopPollerOnEvent", "", "status", "Lcom/atlassian/jira/migration/events/MigrationStatusUpdatedEvent$Status;", "migrationHasApps", "jira-migration-plugin"})
public final class PrometheusMetricExporterStopper {
    @NotNull
    private final PrometheusMetricsExportTrigger prometheusMetricsExportTrigger;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final PlatformService platformService;
    private final Logger log;

    @Inject
    public PrometheusMetricExporterStopper(@NotNull PrometheusMetricsExportTrigger prometheusMetricsExportTrigger, @NotNull MigrationEventBus migrationEventBus, @NotNull PlatformService platformService) {
        Intrinsics.checkNotNullParameter((Object)prometheusMetricsExportTrigger, (String)"prometheusMetricsExportTrigger");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)platformService, (String)"platformService");
        this.prometheusMetricsExportTrigger = prometheusMetricsExportTrigger;
        this.migrationEventBus = migrationEventBus;
        this.platformService = platformService;
        this.log = LoggerFactory.getLogger(PrometheusMetricExporterStopper.class);
    }

    @PostConstruct
    public final void postConstruct() {
        this.migrationEventBus.register(this);
    }

    @PreDestroy
    public final void preDestroy() {
        this.migrationEventBus.unregister(this);
    }

    @Subscribe
    public final void onMigrationStatusUpdate(@NotNull MigrationStatusUpdatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        boolean migrationHasApps = false;
        try {
            migrationHasApps = !((Collection)this.platformService.getAppContainersWithStatus(new CloudId(event.getCloudId()), new MigrationId(event.getMigrationId()))).isEmpty();
        }
        catch (RuntimeException e) {
            this.log.error("Error while checking if migration has apps", (Throwable)e);
        }
        if (this.shouldStopPollerOnEvent(event.getStatus(), migrationHasApps)) {
            this.prometheusMetricsExportTrigger.stop(event.getMigrationId());
        }
    }

    @Subscribe
    public final void onAppMigrationStatusUpdate(@NotNull AppMigrationStatusUpdatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.prometheusMetricsExportTrigger.stop(event.getMigrationId());
    }

    private final boolean shouldStopPollerOnEvent(MigrationStatusUpdatedEvent.Status status, boolean migrationHasApps) {
        return status == MigrationStatusUpdatedEvent.Status.CANCELLED || status == MigrationStatusUpdatedEvent.Status.ERRORED || status == MigrationStatusUpdatedEvent.Status.FINISHED && !migrationHasApps;
    }
}

