/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.app;

import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.jiraservice.JiraMetadataService;
import com.atlassian.jira.migration.lio.model.AppRecipeContextV2;
import com.atlassian.jira.migration.lio.model.Command;
import com.atlassian.jira.migration.lio.model.Destination;
import com.atlassian.jira.migration.lio.model.Migration;
import com.atlassian.jira.migration.lio.model.PbPCommonContext;
import com.atlassian.jira.migration.lio.model.RecipeExecutionRequest;
import com.atlassian.jira.migration.lio.model.Source;
import com.atlassian.jira.migration.plan.ExecutionType;
import com.atlassian.migration.api.MigrationId;
import com.atlassian.migration.api.MigrationScopeId;
import com.atlassian.migration.app.lio.model.AppCommonContext;
import com.atlassian.migration.app.lio.model.AppRecipeContext;
import com.atlassian.migration.app.lio.model.RecipeContext;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/atlassian/jira/migration/app/RecipeRequestTransformationService;", "", "jiraMetadataService", "Lcom/atlassian/jira/migration/jiraservice/JiraMetadataService;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "(Lcom/atlassian/jira/migration/jiraservice/JiraMetadataService;Lcom/atlassian/jira/migration/discovery/DiscoveryService;)V", "createAppCommonContext", "Lcom/atlassian/jira/migration/lio/model/PbPCommonContext;", "migrationId", "", "appCommonContext", "Lcom/atlassian/migration/app/lio/model/AppCommonContext;", "createAppRecipeContext", "Lcom/atlassian/jira/migration/lio/model/AppRecipeContextV2;", "recipeContext", "Lcom/atlassian/migration/app/lio/model/RecipeContext;", "createDestination", "Lcom/atlassian/jira/migration/lio/model/Destination;", "migration", "Lcom/atlassian/migration/app/lio/model/Migration;", "createRecipeCommand", "Lcom/atlassian/jira/migration/lio/model/Command;", "appCommand", "Lcom/atlassian/migration/app/lio/model/Command;", "createSource", "Lcom/atlassian/jira/migration/lio/model/Source;", "fetchStartedBy", "transform", "Lcom/atlassian/jira/migration/lio/model/RecipeExecutionRequest;", "appRecipeExecutionRequest", "Lcom/atlassian/migration/app/lio/model/RecipeExecutionRequest;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nRecipeRequestTransformationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecipeRequestTransformationService.kt\ncom/atlassian/jira/migration/app/RecipeRequestTransformationService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n1#2:94\n*E\n"})
public final class RecipeRequestTransformationService {
    @NotNull
    private final JiraMetadataService jiraMetadataService;
    @NotNull
    private final DiscoveryService discoveryService;

    @Inject
    public RecipeRequestTransformationService(@NotNull JiraMetadataService jiraMetadataService, @NotNull DiscoveryService discoveryService) {
        Intrinsics.checkNotNullParameter((Object)jiraMetadataService, (String)"jiraMetadataService");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        this.jiraMetadataService = jiraMetadataService;
        this.discoveryService = discoveryService;
    }

    @NotNull
    public final RecipeExecutionRequest transform(@NotNull String migrationId, @NotNull com.atlassian.migration.app.lio.model.RecipeExecutionRequest appRecipeExecutionRequest) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)appRecipeExecutionRequest, (String)"appRecipeExecutionRequest");
        return new RecipeExecutionRequest(appRecipeExecutionRequest.getName(), appRecipeExecutionRequest.getId(), appRecipeExecutionRequest.getExecutionId(), this.createAppRecipeContext(appRecipeExecutionRequest.getContext()), this.createAppCommonContext(migrationId, appRecipeExecutionRequest.getCommonContext()), appRecipeExecutionRequest.getTags(), this.createRecipeCommand(appRecipeExecutionRequest.getCommand()), appRecipeExecutionRequest.getVersion());
    }

    private final AppRecipeContextV2 createAppRecipeContext(RecipeContext recipeContext) {
        Intrinsics.checkNotNull((Object)recipeContext, (String)"null cannot be cast to non-null type com.atlassian.migration.app.lio.model.AppRecipeContext");
        AppRecipeContext appRecipeContext = (AppRecipeContext)recipeContext;
        return new AppRecipeContextV2(appRecipeContext.getRecipeExecutionId(), appRecipeContext.getApps(), appRecipeContext.getMigrationProperties());
    }

    private final PbPCommonContext createAppCommonContext(String migrationId, AppCommonContext appCommonContext) {
        com.atlassian.migration.app.lio.model.Migration migration = appCommonContext.getMigration();
        MigrationId migrationId2 = new MigrationId(migrationId);
        MigrationScopeId migrationScopeId2 = new MigrationScopeId(migration.getScopeId());
        String string = migration.getType();
        String string2 = this.fetchStartedBy(migrationId);
        Source source = this.createSource();
        Destination destination = this.createDestination(migration);
        ExecutionType executionType = ExecutionType.MIGRATION;
        return new PbPCommonContext(new Migration(migrationId2, migrationScopeId2, string, executionType, false, source, destination, string2, null, false, 784, null));
    }

    private final Source createSource() {
        return new Source(null, null, this.jiraMetadataService.getJiraServerId(), 3, null);
    }

    private final Destination createDestination(com.atlassian.migration.app.lio.model.Migration migration) {
        com.atlassian.migration.app.lio.model.Destination destination = migration.getDestination();
        return new Destination(null, null, destination.getCloudId(), 3, null);
    }

    private final Command createRecipeCommand(com.atlassian.migration.app.lio.model.Command appCommand) {
        Command command;
        switch (WhenMappings.$EnumSwitchMapping$0[appCommand.ordinal()]) {
            case 1: {
                command = Command.START;
                break;
            }
            case 2: {
                command = Command.STOP;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return command;
    }

    private final String fetchStartedBy(String migrationId) {
        com.atlassian.jira.migration.migration.Migration migration = this.discoveryService.findByMigrationId(migrationId);
        if (migration == null) {
            boolean bl = false;
            String string = "Migration not found for id " + migrationId;
            throw new IllegalArgumentException(string.toString());
        }
        com.atlassian.jira.migration.migration.Migration migration2 = migration;
        String string = migration2.getStartedBy();
        if (string == null) {
            string = "unknown";
        }
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[com.atlassian.migration.app.lio.model.Command.values().length];
            try {
                nArray[com.atlassian.migration.app.lio.model.Command.START.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[com.atlassian.migration.app.lio.model.Command.STOP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

