/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.app.generator.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.migration.app.generator.EntityPropertiesGenerator;
import com.atlassian.jira.migration.app.generator.impl.EntityPropertyDetail;
import com.atlassian.jira.migration.export.db.core.EntityPropertyV4MigrationEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0005H\u0002J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\t\u001a\u00020\u0005H\u0002J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0016H\u0002J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0002R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/atlassian/jira/migration/app/generator/impl/XRayStaticEntityPropertiesGenerator;", "Lcom/atlassian/jira/migration/app/generator/EntityPropertiesGenerator;", "()V", "issueTypeToEntityProperties", "", "", "", "Lcom/atlassian/jira/migration/app/generator/impl/EntityPropertyDetail;", "createXrayIssueEntityProperty", "issueTypeName", "generate", "Lcom/atlassian/jira/migration/export/db/core/EntityPropertyV4MigrationEntity;", "cloudAppKey", "entity", "Lcom/atlassian/jira/issue/Issue;", "getEntityPropertyDetailForPreCondition", "getEntityPropertyDetailForTestExecution", "getEntityPropertyDetailForTestPlan", "getEntityPropertyDetailForTestSet", "getEntityPropertyDetails", "getEntityPropertyDetailsForTestDetails", "getEntityPropertyId", "", "index", "", "id", "getMappedIssueType", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nXRayStaticEntityPropertiesGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XRayStaticEntityPropertiesGenerator.kt\ncom/atlassian/jira/migration/app/generator/impl/XRayStaticEntityPropertiesGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,198:1\n1559#2:199\n1590#2,4:200\n*S KotlinDebug\n*F\n+ 1 XRayStaticEntityPropertiesGenerator.kt\ncom/atlassian/jira/migration/app/generator/impl/XRayStaticEntityPropertiesGenerator\n*L\n22#1:199\n22#1:200,4\n*E\n"})
public final class XRayStaticEntityPropertiesGenerator
implements EntityPropertiesGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, List<EntityPropertyDetail>> issueTypeToEntityProperties;
    @NotNull
    private static final String XRAY_CLOUD_APP_KEY = "com.xpandit.plugins.xray";
    @NotNull
    private static final String ISSUE_ENTITY_PROPERTY_NAME = "IssueProperty";
    private static final int ID_GENERATION_MULTIPLIER = 10;
    @NotNull
    private static final String TEST_DETAILS_PANEL_KEY = "com.xpandit.plugins.xray_xray-test-details-panel-new";
    @NotNull
    private static final String TEST_DETAILS_PLAN_PANEL_KEY = "com.xpandit.plugins.xray_xray-test-test-plans-panel-new";
    @NotNull
    private static final String TEST_DETAILS_RUNS_PANEL_KEY = "com.xpandit.plugins.xray_xray-test-test-runs-panel-new";
    @NotNull
    private static final String TEST_DETAILS_SET_PANEL_KEY = "com.xpandit.plugins.xray_xray-test-test-sets-panel-new";
    @NotNull
    private static final String TEST_DETAILS_PRECONDITION_PANEL_KEY = "com.xpandit.plugins.xray_xray-test-preconditions-panel-new";
    @NotNull
    private static final String TEST_EXEC_PANEL_KEY = "com.xpandit.plugins.xray_xray-test-exec-tests-panel-new";
    @NotNull
    private static final String TEST_PLAN_PANEL_KEY = "com.xpandit.plugins.xray_xray-tesplan-tests-panel-new";
    @NotNull
    private static final String TEST_PLAN_EXEC_PANEL_KEY = "com.xpandit.plugins.xray_xray-tesplan-testexecs-panel-new";
    @NotNull
    private static final String TEST_SET_PANEL_KEY = "com.xpandit.plugins.xray_xray-test-set-tests-panel-new";
    @NotNull
    private static final String TEST_SET_EXEC_PANEL_KEY = "com.xpandit.plugins.xray_xray-test-exec-tests-panel-new";
    @NotNull
    private static final String PRE_CONDITION_PANEL_KEY = "com.xpandit.plugins.xray_xray-pre-cond-details-panel-new";
    @NotNull
    private static final String PRE_CONDITION_TEST_PANEL_KEY = "com.xpandit.plugins.xray_xray-precondition-tests-panel-new";
    @NotNull
    private static final String TEST_DETAILS_ISSUE_TYPE = "Test";
    @NotNull
    private static final String TEST_EXEC_ISSUE_TYPE = "Test Execution";
    @NotNull
    private static final String TEST_PLAN_ISSUE_TYPE = "Test Plan";
    @NotNull
    private static final String TEST_SET_ISSUE_TYPE = "Test Set";
    @NotNull
    private static final String SUB_TEST_EXEC_ISSUE_TYPE = "Sub Test Execution";
    @NotNull
    private static final String PRE_CONDITION_ISSUE_TYPE = "Precondition";
    @NotNull
    private static final String XRAY_TEST_DETAILS_ISSUE_TYPE = "Xray Test";
    @NotNull
    private static final String XRAY_TEST_SET_ISSUE_TYPE = "Xray Test Set";
    @NotNull
    private static final String XRAY_TEST_EXEC_ISSUE_TYPE = "Xray Test Execution";
    @NotNull
    private static final String XRAY_PRE_CONDITION_ISSUE_TYPE = "Xray Precondition";
    @NotNull
    private static final String XRAY_TEST_PLAN_ISSUE_TYPE = "Xray Test Plan";
    @NotNull
    private static final String XRAY_SUB_TEST_EXEC_ISSUE_TYPE = "Xray Sub Test Execution";
    @NotNull
    private static final String XRAY_SERVER_PRECONDITION_ISSUE_TYPE = "Pre-Condition";
    @NotNull
    private static final String XRAY_ISSUE_TYPE_KEY = "xrayIssueType";
    @NotNull
    private static final Set<String> ALLOWED_ISSUE_TYPES;
    @NotNull
    private static final String PANEL_VALUE_JSON_PLACEHOLDER = "{\"added\": \"%s\"}";
    @NotNull
    private static final String XRAY_ISSUE_TYPE_JSON_PLACEHOLDER = "{\"name\": \"%s\"}";

    public XRayStaticEntityPropertiesGenerator() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)TEST_DETAILS_ISSUE_TYPE, this.getEntityPropertyDetailsForTestDetails()), TuplesKt.to((Object)TEST_EXEC_ISSUE_TYPE, this.getEntityPropertyDetailForTestExecution()), TuplesKt.to((Object)TEST_PLAN_ISSUE_TYPE, this.getEntityPropertyDetailForTestPlan()), TuplesKt.to((Object)TEST_SET_ISSUE_TYPE, this.getEntityPropertyDetailForTestSet()), TuplesKt.to((Object)PRE_CONDITION_ISSUE_TYPE, this.getEntityPropertyDetailForPreCondition())};
        this.issueTypeToEntityProperties = MapsKt.mapOf((Pair[])pairArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<EntityPropertyV4MigrationEntity> generate(@NotNull String cloudAppKey, @NotNull Issue entity) {
        Intrinsics.checkNotNullParameter((Object)cloudAppKey, (String)"cloudAppKey");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (Intrinsics.areEqual((Object)cloudAppKey, (Object)XRAY_CLOUD_APP_KEY)) {
            IssueType issueType = entity.getIssueType();
            if (CollectionsKt.contains((Iterable)ALLOWED_ISSUE_TYPES, (Object)(issueType != null ? issueType.getName() : null))) {
                void $this$mapIndexedTo$iv$iv;
                IssueType issueType2 = entity.getIssueType();
                Intrinsics.checkNotNull((Object)issueType2);
                String string = issueType2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                Iterable $this$mapIndexed$iv = this.getEntityPropertyDetails(string);
                boolean $i$f$mapIndexed = false;
                Iterable iterable = $this$mapIndexed$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    void detail;
                    void index;
                    int n;
                    if ((n = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    EntityPropertyDetail entityPropertyDetail = (EntityPropertyDetail)item$iv$iv;
                    int n2 = n;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Long l = entity.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
                    long l2 = this.getEntityPropertyId((int)index, ((Number)l).longValue());
                    Long l3 = entity.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)l3, (String)"getId(...)");
                    collection.add(new EntityPropertyV4MigrationEntity(l2, ((Number)l3).longValue(), ISSUE_ENTITY_PROPERTY_NAME, detail.getPropertyKey(), detail.getPropertyJsonValue(), com.atlassian.migration.jira.core.Issue.Companion.getEntityType(), com.atlassian.migration.jira.core.Issue.Companion.getEntityType().getType(), XRAY_CLOUD_APP_KEY, true));
                }
                return (List)destination$iv$iv;
            }
        }
        return CollectionsKt.emptyList();
    }

    private final List<EntityPropertyDetail> getEntityPropertyDetails(String issueTypeName) {
        String mappedIssueType = this.getMappedIssueType(issueTypeName);
        List<EntityPropertyDetail> list = this.issueTypeToEntityProperties.get(mappedIssueType);
        Intrinsics.checkNotNull(list);
        return CollectionsKt.plus((Collection)list, (Object)this.createXrayIssueEntityProperty(issueTypeName));
    }

    private final long getEntityPropertyId(int index, long id) {
        return id * (long)10 + (long)index;
    }

    private final EntityPropertyDetail createXrayIssueEntityProperty(String issueTypeName) {
        String string = XRAY_ISSUE_TYPE_JSON_PLACEHOLDER;
        Object[] objectArray = new Object[]{issueTypeName};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return new EntityPropertyDetail(XRAY_ISSUE_TYPE_KEY, string2);
    }

    private final String getMappedIssueType(String issueTypeName) {
        String string;
        switch (issueTypeName) {
            case "Xray Sub Test Execution": 
            case "Sub Test Execution": 
            case "Xray Test Execution": {
                string = TEST_EXEC_ISSUE_TYPE;
                break;
            }
            case "Xray Test": {
                string = TEST_DETAILS_ISSUE_TYPE;
                break;
            }
            case "Xray Test Set": {
                string = TEST_SET_ISSUE_TYPE;
                break;
            }
            case "Xray Precondition": 
            case "Pre-Condition": {
                string = PRE_CONDITION_ISSUE_TYPE;
                break;
            }
            case "Xray Test Plan": {
                string = TEST_PLAN_ISSUE_TYPE;
                break;
            }
            default: {
                string = issueTypeName;
            }
        }
        return string;
    }

    private final List<EntityPropertyDetail> getEntityPropertyDetailForPreCondition() {
        Object[] objectArray = new EntityPropertyDetail[2];
        String string = PANEL_VALUE_JSON_PLACEHOLDER;
        Object[] objectArray2 = new Object[]{PRE_CONDITION_PANEL_KEY};
        String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        objectArray[0] = new EntityPropertyDetail(PRE_CONDITION_PANEL_KEY, string2);
        string = PANEL_VALUE_JSON_PLACEHOLDER;
        objectArray2 = new Object[]{PRE_CONDITION_TEST_PANEL_KEY};
        String string3 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        objectArray[1] = new EntityPropertyDetail(PRE_CONDITION_TEST_PANEL_KEY, string3);
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final List<EntityPropertyDetail> getEntityPropertyDetailForTestSet() {
        Object[] objectArray = new EntityPropertyDetail[2];
        String string = PANEL_VALUE_JSON_PLACEHOLDER;
        Object[] objectArray2 = new Object[]{TEST_SET_PANEL_KEY};
        String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        objectArray[0] = new EntityPropertyDetail(TEST_SET_PANEL_KEY, string2);
        string = PANEL_VALUE_JSON_PLACEHOLDER;
        objectArray2 = new Object[]{"com.xpandit.plugins.xray_xray-test-exec-tests-panel-new"};
        String string3 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        objectArray[1] = new EntityPropertyDetail("com.xpandit.plugins.xray_xray-test-exec-tests-panel-new", string3);
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final List<EntityPropertyDetail> getEntityPropertyDetailForTestPlan() {
        Object[] objectArray = new EntityPropertyDetail[2];
        String string = PANEL_VALUE_JSON_PLACEHOLDER;
        Object[] objectArray2 = new Object[]{TEST_PLAN_PANEL_KEY};
        String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        objectArray[0] = new EntityPropertyDetail(TEST_PLAN_PANEL_KEY, string2);
        string = PANEL_VALUE_JSON_PLACEHOLDER;
        objectArray2 = new Object[]{TEST_PLAN_EXEC_PANEL_KEY};
        String string3 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        objectArray[1] = new EntityPropertyDetail(TEST_PLAN_EXEC_PANEL_KEY, string3);
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final List<EntityPropertyDetail> getEntityPropertyDetailForTestExecution() {
        String string = PANEL_VALUE_JSON_PLACEHOLDER;
        Object[] objectArray = new Object[]{"com.xpandit.plugins.xray_xray-test-exec-tests-panel-new"};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return CollectionsKt.listOf((Object)new EntityPropertyDetail("com.xpandit.plugins.xray_xray-test-exec-tests-panel-new", string2));
    }

    private final List<EntityPropertyDetail> getEntityPropertyDetailsForTestDetails() {
        Object[] objectArray = new EntityPropertyDetail[5];
        String string = PANEL_VALUE_JSON_PLACEHOLDER;
        Object[] objectArray2 = new Object[]{TEST_DETAILS_PANEL_KEY};
        String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        objectArray[0] = new EntityPropertyDetail(TEST_DETAILS_PANEL_KEY, string2);
        string = PANEL_VALUE_JSON_PLACEHOLDER;
        objectArray2 = new Object[]{TEST_DETAILS_PLAN_PANEL_KEY};
        String string3 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        objectArray[1] = new EntityPropertyDetail(TEST_DETAILS_PLAN_PANEL_KEY, string3);
        string = PANEL_VALUE_JSON_PLACEHOLDER;
        objectArray2 = new Object[]{TEST_DETAILS_RUNS_PANEL_KEY};
        String string4 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        objectArray[2] = new EntityPropertyDetail(TEST_DETAILS_RUNS_PANEL_KEY, string4);
        string = PANEL_VALUE_JSON_PLACEHOLDER;
        objectArray2 = new Object[]{TEST_DETAILS_SET_PANEL_KEY};
        String string5 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
        objectArray[3] = new EntityPropertyDetail(TEST_DETAILS_SET_PANEL_KEY, string5);
        string = PANEL_VALUE_JSON_PLACEHOLDER;
        objectArray2 = new Object[]{TEST_DETAILS_PRECONDITION_PANEL_KEY};
        String string6 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(...)");
        objectArray[4] = new EntityPropertyDetail(TEST_DETAILS_PRECONDITION_PANEL_KEY, string6);
        return CollectionsKt.listOf((Object[])objectArray);
    }

    static {
        Object[] objectArray = new String[]{TEST_DETAILS_ISSUE_TYPE, TEST_SET_ISSUE_TYPE, TEST_EXEC_ISSUE_TYPE, PRE_CONDITION_ISSUE_TYPE, TEST_PLAN_ISSUE_TYPE, SUB_TEST_EXEC_ISSUE_TYPE, XRAY_TEST_DETAILS_ISSUE_TYPE, XRAY_TEST_SET_ISSUE_TYPE, XRAY_TEST_EXEC_ISSUE_TYPE, XRAY_PRE_CONDITION_ISSUE_TYPE, XRAY_TEST_PLAN_ISSUE_TYPE, XRAY_SUB_TEST_EXEC_ISSUE_TYPE, XRAY_SERVER_PRECONDITION_ISSUE_TYPE};
        ALLOWED_ISSUE_TYPES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u001f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/atlassian/jira/migration/app/generator/impl/XRayStaticEntityPropertiesGenerator$Companion;", "", "()V", "ALLOWED_ISSUE_TYPES", "", "", "ID_GENERATION_MULTIPLIER", "", "ISSUE_ENTITY_PROPERTY_NAME", "PANEL_VALUE_JSON_PLACEHOLDER", "PRE_CONDITION_ISSUE_TYPE", "PRE_CONDITION_PANEL_KEY", "PRE_CONDITION_TEST_PANEL_KEY", "SUB_TEST_EXEC_ISSUE_TYPE", "TEST_DETAILS_ISSUE_TYPE", "TEST_DETAILS_PANEL_KEY", "TEST_DETAILS_PLAN_PANEL_KEY", "TEST_DETAILS_PRECONDITION_PANEL_KEY", "TEST_DETAILS_RUNS_PANEL_KEY", "TEST_DETAILS_SET_PANEL_KEY", "TEST_EXEC_ISSUE_TYPE", "TEST_EXEC_PANEL_KEY", "TEST_PLAN_EXEC_PANEL_KEY", "TEST_PLAN_ISSUE_TYPE", "TEST_PLAN_PANEL_KEY", "TEST_SET_EXEC_PANEL_KEY", "TEST_SET_ISSUE_TYPE", "TEST_SET_PANEL_KEY", "XRAY_CLOUD_APP_KEY", "XRAY_ISSUE_TYPE_JSON_PLACEHOLDER", "XRAY_ISSUE_TYPE_KEY", "XRAY_PRE_CONDITION_ISSUE_TYPE", "XRAY_SERVER_PRECONDITION_ISSUE_TYPE", "XRAY_SUB_TEST_EXEC_ISSUE_TYPE", "XRAY_TEST_DETAILS_ISSUE_TYPE", "XRAY_TEST_EXEC_ISSUE_TYPE", "XRAY_TEST_PLAN_ISSUE_TYPE", "XRAY_TEST_SET_ISSUE_TYPE", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

