/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.app.preload;

import com.atlassian.jira.migration.app.preload.AppDataPreloadGatewayImpl;
import com.atlassian.jira.migration.app.preload.AppDataPreloadGatewayImplKt;
import com.atlassian.jira.migration.app.preload.AppDataPreloadStatusRepository;
import com.atlassian.jira.migration.app.preload.PartialAppDataPreloadStatus;
import com.atlassian.jira.migration.app.preload.PreloadContextType;
import com.atlassian.migration.app.PreloadedAppDataDetails;
import com.atlassian.migration.app.cloudAssistantRegistrars.AppDataPreloadGateway;
import com.atlassian.migration.app.dto.AppTransferDetails;
import com.atlassian.migration.app.preload.PreloadContext;
import java.time.Duration;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/jira/migration/app/preload/AppDataPreloadGatewayImpl;", "Lcom/atlassian/migration/app/cloudAssistantRegistrars/AppDataPreloadGateway;", "appDataPreloadStatusRepository", "Lcom/atlassian/jira/migration/app/preload/AppDataPreloadStatusRepository;", "(Lcom/atlassian/jira/migration/app/preload/AppDataPreloadStatusRepository;)V", "getAllPreloadedAppData", "Lkotlin/sequences/Sequence;", "Lcom/atlassian/migration/app/PreloadedAppDataDetails;", "appTransferDetails", "Lcom/atlassian/migration/app/dto/AppTransferDetails;", "preloadContext", "Lcom/atlassian/migration/app/preload/PreloadContext;", "getPreloadedAppDataById", "appDataId", "", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAppDataPreloadGatewayImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppDataPreloadGatewayImpl.kt\ncom/atlassian/jira/migration/app/preload/AppDataPreloadGatewayImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1#2:59\n*E\n"})
public final class AppDataPreloadGatewayImpl
implements AppDataPreloadGateway {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AppDataPreloadStatusRepository appDataPreloadStatusRepository;

    @Inject
    public AppDataPreloadGatewayImpl(@NotNull AppDataPreloadStatusRepository appDataPreloadStatusRepository) {
        Intrinsics.checkNotNullParameter((Object)appDataPreloadStatusRepository, (String)"appDataPreloadStatusRepository");
        this.appDataPreloadStatusRepository = appDataPreloadStatusRepository;
    }

    @Nullable
    public PreloadedAppDataDetails getPreloadedAppDataById(@NotNull AppTransferDetails appTransferDetails, @NotNull String appDataId) {
        PreloadedAppDataDetails preloadedAppDataDetails;
        Intrinsics.checkNotNullParameter((Object)appTransferDetails, (String)"appTransferDetails");
        Intrinsics.checkNotNullParameter((Object)appDataId, (String)"appDataId");
        PartialAppDataPreloadStatus partialAppDataPreloadStatus = this.appDataPreloadStatusRepository.findByVendorIdAndCloudId(appDataId, appTransferDetails.getServerAppKey(), appTransferDetails.getCloudId());
        if (partialAppDataPreloadStatus != null) {
            PartialAppDataPreloadStatus it = partialAppDataPreloadStatus;
            boolean bl = false;
            preloadedAppDataDetails = new PreloadedAppDataDetails(it.getVendorFileId(), it.getS3Key(), it.getFailureReason(), it.getTransferId(), Long.valueOf(AppDataPreloadGatewayImpl.Companion.getPreloadExpiryTimeInEpochMillis(it.getCreatedAt())));
        } else {
            preloadedAppDataDetails = null;
        }
        return preloadedAppDataDetails;
    }

    @NotNull
    public Sequence<PreloadedAppDataDetails> getAllPreloadedAppData(@NotNull AppTransferDetails appTransferDetails, @NotNull PreloadContext preloadContext) {
        Intrinsics.checkNotNullParameter((Object)appTransferDetails, (String)"appTransferDetails");
        Intrinsics.checkNotNullParameter((Object)preloadContext, (String)"preloadContext");
        Pair pair = AppDataPreloadGatewayImplKt.access$getTypeAndValue(preloadContext);
        PreloadContextType type = (PreloadContextType)((Object)pair.component1());
        String value = (String)pair.component2();
        return SequencesKt.map((Sequence)AppDataPreloadStatusRepository.getAllPreloadedAppDataStatus$default(this.appDataPreloadStatusRepository, appTransferDetails.getServerAppKey(), appTransferDetails.getCloudId(), type, value, 0L, 16, null), (Function1)getAllPreloadedAppData.1.INSTANCE);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/app/preload/AppDataPreloadGatewayImpl$Companion;", "", "()V", "getPreloadExpiryTimeInEpochMillis", "", "preloadCreatedAtInEpochMilli", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        private final long getPreloadExpiryTimeInEpochMillis(long preloadCreatedAtInEpochMilli) {
            return preloadCreatedAtInEpochMilli + Duration.ofDays(28L).toMillis();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

