/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.app.preload;

import com.atlassian.jira.migration.amsclient.DefaultAppMigrationServiceClient;
import com.atlassian.jira.migration.amsclient.FinalizePreloadDataUploadRequest;
import com.atlassian.jira.migration.amsclient.FinalizePreloadEventRequest;
import com.atlassian.jira.migration.amsclient.GetPreloadDataUploadUrlRequest;
import com.atlassian.jira.migration.app.CloudMigrationRegistrar;
import com.atlassian.jira.migration.app.preload.AppDataPreloadStatus;
import com.atlassian.jira.migration.app.preload.AppDataPreloadStatusRepository;
import com.atlassian.jira.migration.app.preload.PartialAppDataPreloadStatus;
import com.atlassian.jira.migration.app.preload.TransferDetails;
import com.atlassian.jira.migration.app.preload.UploadedChunkDetails;
import com.atlassian.jira.migration.workers.attachments.preload.PreloadPrometheusMetricsKt;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.migration.app.dto.EnrichedAppDataDetails;
import com.atlassian.migration.app.dto.GetUrlResponse;
import com.atlassian.migration.app.dto.InitializeUploadResponse;
import com.atlassian.migration.app.preload.JiraProjectPreloadContext;
import com.atlassian.migration.app.preload.PreloadContext;
import com.atlassian.migration.app.preload.PreloadHeartbeat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ2\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J*\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bJ0\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u000fH\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\"\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u000fJ\u000e\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020&J*\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u000fJ0\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u000f2\b\b\u0002\u00100\u001a\u000201J\"\u00102\u001a\u00020\f2\u0006\u00103\u001a\u00020\u000f2\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u00020\f05R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/atlassian/jira/migration/app/preload/AppDataPreloadService;", "", "cloudMigrationRegistrar", "Lcom/atlassian/jira/migration/app/CloudMigrationRegistrar;", "appMigrationServiceClient", "Lcom/atlassian/jira/migration/amsclient/DefaultAppMigrationServiceClient;", "appDataPreloadStatusRepository", "Lcom/atlassian/jira/migration/app/preload/AppDataPreloadStatusRepository;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "(Lcom/atlassian/jira/migration/app/CloudMigrationRegistrar;Lcom/atlassian/jira/migration/amsclient/DefaultAppMigrationServiceClient;Lcom/atlassian/jira/migration/app/preload/AppDataPreloadStatusRepository;Lcom/atlassian/jira/project/ProjectManager;)V", "finalizePreload", "", "eTags", "", "", "digests", "initializePreload", "Lcom/atlassian/migration/app/dto/InitializeUploadResponse;", "transferDetails", "Lcom/atlassian/jira/migration/app/preload/TransferDetails;", "getAppDataForPreloadByProjectKey", "Lkotlin/sequences/Sequence;", "Lcom/atlassian/migration/app/dto/EnrichedAppDataDetails;", "preloadableApps", "projectKey", "preloadHeartbeat", "Lcom/atlassian/migration/app/preload/PreloadHeartbeat;", "getPreloadUrl", "Lcom/atlassian/migration/app/dto/GetUrlResponse;", "initializePreloadResponse", "chunkIndex", "contentLength", "contentSha256", "notifyFinalizedConnectEventForPreload", "s3Key", "saveAppDataPreloadStatus", "appDataPreloadStatus", "Lcom/atlassian/jira/migration/app/preload/AppDataPreloadStatus;", "shouldUploadByBatch", "ids", "serverAppKey", "cloudId", "uploadChunk", "Lcom/atlassian/jira/migration/app/preload/UploadedChunkDetails;", "chunkInBytes", "", "initializeUploadResponse", "index", "", "visitEachByMigrationIdOrderByCloudAppKey", "migrationId", "action", "Lkotlin/Function1;", "Lcom/atlassian/jira/migration/app/preload/PartialAppDataPreloadStatus;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAppDataPreloadService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppDataPreloadService.kt\ncom/atlassian/jira/migration/app/preload/AppDataPreloadService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,186:1\n1179#2,2:187\n1253#2,4:189\n766#2:193\n857#2,2:194\n*S KotlinDebug\n*F\n+ 1 AppDataPreloadService.kt\ncom/atlassian/jira/migration/app/preload/AppDataPreloadService\n*L\n137#1:187,2\n137#1:189,4\n138#1:193\n138#1:194,2\n*E\n"})
public final class AppDataPreloadService {
    @NotNull
    private final CloudMigrationRegistrar cloudMigrationRegistrar;
    @NotNull
    private final DefaultAppMigrationServiceClient appMigrationServiceClient;
    @NotNull
    private final AppDataPreloadStatusRepository appDataPreloadStatusRepository;
    @NotNull
    private final ProjectManager projectManager;

    @Inject
    public AppDataPreloadService(@NotNull CloudMigrationRegistrar cloudMigrationRegistrar, @NotNull DefaultAppMigrationServiceClient appMigrationServiceClient, @NotNull AppDataPreloadStatusRepository appDataPreloadStatusRepository, @NotNull ProjectManager projectManager) {
        Intrinsics.checkNotNullParameter((Object)((Object)cloudMigrationRegistrar), (String)"cloudMigrationRegistrar");
        Intrinsics.checkNotNullParameter((Object)appMigrationServiceClient, (String)"appMigrationServiceClient");
        Intrinsics.checkNotNullParameter((Object)appDataPreloadStatusRepository, (String)"appDataPreloadStatusRepository");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        this.cloudMigrationRegistrar = cloudMigrationRegistrar;
        this.appMigrationServiceClient = appMigrationServiceClient;
        this.appDataPreloadStatusRepository = appDataPreloadStatusRepository;
        this.projectManager = projectManager;
    }

    @NotNull
    public final Sequence<EnrichedAppDataDetails> getAppDataForPreloadByProjectKey(@NotNull List<String> preloadableApps, @NotNull String projectKey, @NotNull PreloadHeartbeat preloadHeartbeat) {
        Project project;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter(preloadableApps, (String)"preloadableApps");
                Intrinsics.checkNotNullParameter((Object)projectKey, (String)"projectKey");
                Intrinsics.checkNotNullParameter((Object)preloadHeartbeat, (String)"preloadHeartbeat");
                project = this.projectManager.getProjectObjByKey(projectKey);
                if (project == null) break block2;
                Project it = project;
                boolean bl = false;
                Long l = it.getId();
                Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
                Sequence sequence = this.cloudMigrationRegistrar.getAppDataForPreload((PreloadContext)new JiraProjectPreloadContext(((Number)l).longValue()), preloadHeartbeat, preloadableApps);
                project = sequence;
                if (sequence != null) break block3;
            }
            project = SequencesKt.emptySequence();
        }
        return project;
    }

    @NotNull
    public final InitializeUploadResponse initializePreload(@NotNull TransferDetails transferDetails) {
        Intrinsics.checkNotNullParameter((Object)transferDetails, (String)"transferDetails");
        TransferDetails $this$initializePreload_u24lambda_u241 = transferDetails;
        boolean bl = false;
        DefaultAppMigrationServiceClient defaultAppMigrationServiceClient = this.appMigrationServiceClient;
        String string = $this$initializePreload_u24lambda_u241.getTransferId();
        String string2 = $this$initializePreload_u24lambda_u241.getCloudId();
        String string3 = $this$initializePreload_u24lambda_u241.getCloudAppKey();
        InitializeUploadResponse initializePreloadResponse = defaultAppMigrationServiceClient.initializePreload(string2, string, string3);
        return initializePreloadResponse;
    }

    @NotNull
    public final UploadedChunkDetails uploadChunk(@NotNull byte[] chunkInBytes, @NotNull InitializeUploadResponse initializeUploadResponse, @NotNull TransferDetails transferDetails, @NotNull String contentSha256, int index) {
        Intrinsics.checkNotNullParameter((Object)chunkInBytes, (String)"chunkInBytes");
        Intrinsics.checkNotNullParameter((Object)initializeUploadResponse, (String)"initializeUploadResponse");
        Intrinsics.checkNotNullParameter((Object)transferDetails, (String)"transferDetails");
        Intrinsics.checkNotNullParameter((Object)contentSha256, (String)"contentSha256");
        GetUrlResponse url = this.getPreloadUrl(initializeUploadResponse, transferDetails, String.valueOf(index), String.valueOf(chunkInBytes.length), contentSha256);
        String string = url.getUrl();
        Intrinsics.checkNotNull((Object)string);
        String etag = this.appMigrationServiceClient.uploadToS3(string, contentSha256, chunkInBytes);
        return new UploadedChunkDetails(contentSha256, etag);
    }

    public static /* synthetic */ UploadedChunkDetails uploadChunk$default(AppDataPreloadService appDataPreloadService, byte[] byArray, InitializeUploadResponse initializeUploadResponse, TransferDetails transferDetails, String string, int n, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            n = 1;
        }
        return appDataPreloadService.uploadChunk(byArray, initializeUploadResponse, transferDetails, string, n);
    }

    private final GetUrlResponse getPreloadUrl(InitializeUploadResponse initializePreloadResponse, TransferDetails transferDetails, String chunkIndex, String contentLength, String contentSha256) {
        String string = initializePreloadResponse.getS3Key();
        String string2 = initializePreloadResponse.getUploadId();
        UUID uUID = UUID.fromString(transferDetails.getTransferId());
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
        GetPreloadDataUploadUrlRequest request = new GetPreloadDataUploadUrlRequest(string, string2, chunkIndex, uUID, transferDetails.getCloudId(), contentLength, contentSha256);
        GetUrlResponse url = this.appMigrationServiceClient.getMultipartPreloadUrl(transferDetails.getCloudId(), request);
        return url;
    }

    public final void finalizePreload(@NotNull List<String> eTags, @NotNull List<String> digests, @NotNull InitializeUploadResponse initializePreload, @NotNull TransferDetails transferDetails) {
        Intrinsics.checkNotNullParameter(eTags, (String)"eTags");
        Intrinsics.checkNotNullParameter(digests, (String)"digests");
        Intrinsics.checkNotNullParameter((Object)initializePreload, (String)"initializePreload");
        Intrinsics.checkNotNullParameter((Object)transferDetails, (String)"transferDetails");
        String string = initializePreload.getS3Key();
        String string2 = initializePreload.getUploadId();
        UUID uUID = UUID.fromString(transferDetails.getTransferId());
        Intrinsics.checkNotNull((Object)uUID);
        FinalizePreloadDataUploadRequest finalRequest = new FinalizePreloadDataUploadRequest(eTags, string, string2, uUID, digests);
        this.appMigrationServiceClient.finalizePreload(transferDetails.getCloudId(), finalRequest);
    }

    public final void notifyFinalizedConnectEventForPreload(@NotNull TransferDetails transferDetails, @NotNull String s3Key) {
        Intrinsics.checkNotNullParameter((Object)transferDetails, (String)"transferDetails");
        Intrinsics.checkNotNullParameter((Object)s3Key, (String)"s3Key");
        UUID uUID = UUID.fromString(transferDetails.getMigrationId());
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
        UUID uUID2 = UUID.fromString(transferDetails.getTransferId());
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"fromString(...)");
        FinalizePreloadEventRequest finalRequest = new FinalizePreloadEventRequest(uUID, uUID2, s3Key);
        this.appMigrationServiceClient.notifyConnectEventForFinalizedPreload(transferDetails.getCloudId(), finalRequest);
    }

    public final void visitEachByMigrationIdOrderByCloudAppKey(@NotNull String migrationId, @NotNull Function1<? super PartialAppDataPreloadStatus, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.appDataPreloadStatusRepository.visitEachByMigrationIdOrderByCloudAppKey(migrationId, action);
    }

    public final void saveAppDataPreloadStatus(@NotNull AppDataPreloadStatus appDataPreloadStatus) {
        Intrinsics.checkNotNullParameter((Object)appDataPreloadStatus, (String)"appDataPreloadStatus");
        this.appDataPreloadStatusRepository.saveAppDataPreloadStatusOrUpdate(appDataPreloadStatus);
    }

    @NotNull
    public final List<String> shouldUploadByBatch(@NotNull List<String> ids, @NotNull String serverAppKey, @NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Intrinsics.checkNotNullParameter((Object)serverAppKey, (String)"serverAppKey");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Object object = PreloadPrometheusMetricsKt.getTimingHistogram().timeChecked(() -> AppDataPreloadService.shouldUploadByBatch$lambda$4(this, ids, serverAppKey, cloudId2));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"timeChecked(...)");
        return (List)object;
    }

    /*
     * Unable to fully structure code
     */
    private static final List shouldUploadByBatch$lambda$4(AppDataPreloadService this$0, List $ids, String $serverAppKey, String $cloudId) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$ids, (String)"$ids");
        Intrinsics.checkNotNullParameter((Object)$serverAppKey, (String)"$serverAppKey");
        Intrinsics.checkNotNullParameter((Object)$cloudId, (String)"$cloudId");
        var5_4 = this$0.appDataPreloadStatusRepository.findByVendorIdAndCloudIdByBatch($ids, $serverAppKey, $cloudId);
        $i$f$associate = false;
        capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        var8_8 = $this$associate$iv;
        destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
        $i$f$associateTo = false;
        for (T element$iv$iv : $this$associateTo$iv$iv) {
            var13_15 = destination$iv$iv;
            it = (PartialAppDataPreloadStatus)element$iv$iv;
            $i$a$-associate-AppDataPreloadService$shouldUploadByBatch$1$preloadedFileResults$1 = false;
            var14_17 = TuplesKt.to((Object)it.getVendorFileId(), (Object)it.getUploaded());
            var13_15.put(var14_17.getFirst(), var14_17.getSecond());
        }
        preloadedFileResults = destination$iv$iv;
        $this$filter$iv = $ids;
        $i$f$filter = false;
        capacity$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            $i$a$-filter-AppDataPreloadService$shouldUploadByBatch$1$1 = false;
            if (!preloadedFileResults.containsKey(it)) ** GOTO lbl-1000
            v0 = preloadedFileResults.get(it);
            Intrinsics.checkNotNull(v0);
            if (!((Boolean)v0).booleanValue()) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = false;
            }
            if (!v1) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

