/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.app.preload;

import com.atlassian.jira.migration.app.preload.AppDataPreloadService;
import com.atlassian.jira.migration.app.preload.AppDataPreloadTrigger;
import com.atlassian.jira.migration.app.preload.PartialAppDataPreloadStatus;
import com.atlassian.jira.migration.app.preload.Sha256Calculator;
import com.atlassian.jira.migration.app.preload.TransferDetails;
import com.atlassian.jira.migration.app.preload.UploadedChunkDetails;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.events.MigrationStatusUpdatedEvent;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.lock.ExecutionStatus;
import com.atlassian.jira.migration.lock.MigrationClusterLockService;
import com.atlassian.jira.migration.lock.MigrationLockContext;
import com.atlassian.jira.migration.migration.Migration;
import com.atlassian.jira.migration.migration.MigrationRepository;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.plan.PlanRepository;
import com.atlassian.migration.app.dto.InitializeUploadResponse;
import com.google.common.eventbus.Subscribe;
import java.io.Closeable;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001eB7\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\b\u0010\u001a\u001a\u00020\u0017H\u0007J\b\u0010\u001b\u001a\u00020\u0017H\u0007J\u0016\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/atlassian/jira/migration/app/preload/AppDataPreloadTrigger;", "", "appDataPreloadService", "Lcom/atlassian/jira/migration/app/preload/AppDataPreloadService;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "migrationClusterLockService", "Lcom/atlassian/jira/migration/lock/MigrationClusterLockService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "migrationRepository", "Lcom/atlassian/jira/migration/migration/MigrationRepository;", "planRepository", "Lcom/atlassian/jira/migration/plan/PlanRepository;", "(Lcom/atlassian/jira/migration/app/preload/AppDataPreloadService;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/lock/MigrationClusterLockService;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/migration/MigrationRepository;Lcom/atlassian/jira/migration/plan/PlanRepository;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "isAppDataPreloadMigration", "", "migrationId", "", "onMigrationStatusUpdate", "", "event", "Lcom/atlassian/jira/migration/events/MigrationStatusUpdatedEvent;", "postConstruct", "preDestroy", "sendAppDataPreloadedNotification", "cloudId", "PreloadedDataAggregateAndDispatcherByCloudAppKey", "jira-migration-plugin"})
public final class AppDataPreloadTrigger {
    @NotNull
    private final AppDataPreloadService appDataPreloadService;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final MigrationClusterLockService migrationClusterLockService;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final MigrationRepository migrationRepository;
    @NotNull
    private final PlanRepository planRepository;
    private final Logger log;

    @Inject
    public AppDataPreloadTrigger(@NotNull AppDataPreloadService appDataPreloadService, @NotNull MigrationEventBus migrationEventBus, @NotNull MigrationClusterLockService migrationClusterLockService, @NotNull MigrationFeatures migrationFeatures, @NotNull MigrationRepository migrationRepository, @NotNull PlanRepository planRepository) {
        Intrinsics.checkNotNullParameter((Object)appDataPreloadService, (String)"appDataPreloadService");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)migrationClusterLockService, (String)"migrationClusterLockService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)migrationRepository, (String)"migrationRepository");
        Intrinsics.checkNotNullParameter((Object)planRepository, (String)"planRepository");
        this.appDataPreloadService = appDataPreloadService;
        this.migrationEventBus = migrationEventBus;
        this.migrationClusterLockService = migrationClusterLockService;
        this.migrationFeatures = migrationFeatures;
        this.migrationRepository = migrationRepository;
        this.planRepository = planRepository;
        this.log = LoggerFactory.getLogger(AppDataPreloadTrigger.class);
    }

    @PostConstruct
    public final void postConstruct() {
        this.migrationEventBus.register(this);
    }

    @PreDestroy
    public final void preDestroy() {
        this.migrationEventBus.unregister(this);
    }

    @Subscribe
    public final void onMigrationStatusUpdate(@NotNull MigrationStatusUpdatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.isMigrationCompleted()) {
            if (!this.migrationFeatures.getEnableAppDataPreload()) {
                this.log.info("Not performing app data preload EAP notification for migrationId: " + event.getMigrationId() + " (feature flag disabled)");
                return;
            }
            if (this.isAppDataPreloadMigration(event.getMigrationId())) {
                this.log.info("Not performing app data preload EAP notification for migrationId: " + event.getMigrationId() + " (plan is APP_DATA_PRELOAD)");
                return;
            }
            this.log.info("Migration status updated event received for migrationId: " + event.getMigrationId());
            String string = "com.atlassian.migration.app.AppDataPreloadTrigger.prefix:" + event.getMigrationId();
            String string2 = event.getMigrationId();
            ExecutionStatus result2 = this.migrationClusterLockService.executeWithLock(new MigrationLockContext(string2, string, 0L, null, 12, null), (Function1)new Function1<MigrationLockContext, Unit>(this, event){
                final /* synthetic */ AppDataPreloadTrigger this$0;
                final /* synthetic */ MigrationStatusUpdatedEvent $event;
                {
                    this.this$0 = $receiver;
                    this.$event = $event;
                    super(1);
                }

                public final void invoke(@NotNull MigrationLockContext it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.this$0.sendAppDataPreloadedNotification(this.$event.getCloudId(), this.$event.getMigrationId());
                }
            });
            if (result2 instanceof ExecutionStatus.Executed && Result.isFailure-impl((Object)((ExecutionStatus.Executed)result2).getResult-d1pmJ48())) {
                this.log.error("Failed to process migration status update event for migrationId: " + event.getMigrationId(), Result.exceptionOrNull-impl((Object)((ExecutionStatus.Executed)result2).getResult-d1pmJ48()));
            }
        }
    }

    private final boolean isAppDataPreloadMigration(String migrationId) {
        Plan plan2;
        Plan plan3;
        Migration migration = this.migrationRepository.findByMigrationId(migrationId);
        if (migration != null) {
            Migration migration2 = migration;
            boolean bl = false;
            plan3 = this.planRepository.get(migration2.getPlanId());
        } else {
            plan3 = null;
        }
        Plan plan4 = plan2 = plan3;
        return plan4 != null ? plan4.isAppDataPreload() : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendAppDataPreloadedNotification(@NotNull String cloudId2, @NotNull String migrationId) {
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        this.log.info("Sending preload finalized event(s) for migrationId: " + migrationId);
        Closeable closeable = new PreloadedDataAggregateAndDispatcherByCloudAppKey(migrationId, cloudId2);
        Throwable throwable = null;
        try {
            PreloadedDataAggregateAndDispatcherByCloudAppKey it = (PreloadedDataAggregateAndDispatcherByCloudAppKey)closeable;
            boolean bl = false;
            this.appDataPreloadService.visitEachByMigrationIdOrderByCloudAppKey(migrationId, (Function1<? super PartialAppDataPreloadStatus, Unit>)((Function1)new Function1<PartialAppDataPreloadStatus, Unit>((Object)it){

                public final void invoke(@NotNull PartialAppDataPreloadStatus p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((PreloadedDataAggregateAndDispatcherByCloudAppKey)this.receiver).addAndNotify(p0);
                }
            }));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nJ\b\u0010\u0012\u001a\u00020\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0002R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/jira/migration/app/preload/AppDataPreloadTrigger$PreloadedDataAggregateAndDispatcherByCloudAppKey;", "Ljava/io/Closeable;", "migrationId", "", "cloudId", "(Lcom/atlassian/jira/migration/app/preload/AppDataPreloadTrigger;Ljava/lang/String;Ljava/lang/String;)V", "getCloudId", "()Ljava/lang/String;", "currentRecordSet", "", "Lcom/atlassian/jira/migration/app/preload/PartialAppDataPreloadStatus;", "getMigrationId", "toCsvRecord", "Lkotlin/Function1;", "", "addAndNotify", "", "preloadedEventRecord", "close", "notifyIfAny", "jira-migration-plugin"})
    public final class PreloadedDataAggregateAndDispatcherByCloudAppKey
    implements Closeable {
        @NotNull
        private final String migrationId;
        @NotNull
        private final String cloudId;
        @NotNull
        private Set<PartialAppDataPreloadStatus> currentRecordSet;
        @NotNull
        private final Function1<PartialAppDataPreloadStatus, CharSequence> toCsvRecord;

        public PreloadedDataAggregateAndDispatcherByCloudAppKey(@NotNull String migrationId, String cloudId2) {
            Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
            Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
            this.migrationId = migrationId;
            this.cloudId = cloudId2;
            this.currentRecordSet = new LinkedHashSet();
            this.toCsvRecord = toCsvRecord.1.INSTANCE;
        }

        @NotNull
        public final String getMigrationId() {
            return this.migrationId;
        }

        @NotNull
        public final String getCloudId() {
            return this.cloudId;
        }

        public final void addAndNotify(@NotNull PartialAppDataPreloadStatus preloadedEventRecord) {
            Intrinsics.checkNotNullParameter((Object)preloadedEventRecord, (String)"preloadedEventRecord");
            if (!((Collection)this.currentRecordSet).isEmpty() && !Intrinsics.areEqual((Object)((PartialAppDataPreloadStatus)CollectionsKt.first((Iterable)this.currentRecordSet)).getCloudAppKey(), (Object)preloadedEventRecord.getCloudAppKey())) {
                this.notifyIfAny();
                this.currentRecordSet = new LinkedHashSet();
                this.currentRecordSet.add(preloadedEventRecord);
            } else {
                this.currentRecordSet.add(preloadedEventRecord);
            }
        }

        @Override
        public void close() {
            if (!((Collection)this.currentRecordSet).isEmpty()) {
                this.notifyIfAny();
            }
        }

        private final void notifyIfAny() {
            block3: {
                Throwable throwable;
                Object $this$notifyIfAny_u24lambda_u240;
                PartialAppDataPreloadStatus record = (PartialAppDataPreloadStatus)CollectionsKt.first((Iterable)this.currentRecordSet);
                TransferDetails transferDetails = new TransferDetails(record.getTransferId(), this.migrationId, this.cloudId, record.getCloudAppKey());
                Object object = this;
                AppDataPreloadTrigger appDataPreloadTrigger = AppDataPreloadTrigger.this;
                try {
                    $this$notifyIfAny_u24lambda_u240 = object;
                    boolean bl = false;
                    InitializeUploadResponse initResponse = appDataPreloadTrigger.appDataPreloadService.initializePreload(transferDetails);
                    String data2 = CollectionsKt.joinToString$default((Iterable)((PreloadedDataAggregateAndDispatcherByCloudAppKey)$this$notifyIfAny_u24lambda_u240).currentRecordSet, (CharSequence)"\n", null, null, (int)0, null, ((PreloadedDataAggregateAndDispatcherByCloudAppKey)$this$notifyIfAny_u24lambda_u240).toCsvRecord, (int)30, null);
                    Sha256Calculator sha256Calculator = Sha256Calculator.Companion.newInstance();
                    AppDataPreloadService appDataPreloadService = appDataPreloadTrigger.appDataPreloadService;
                    byte[] byArray = data2.getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                    byte[] byArray2 = data2.getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
                    UploadedChunkDetails uploadedChunkDetails = AppDataPreloadService.uploadChunk$default(appDataPreloadService, byArray, initResponse, transferDetails, sha256Calculator.calculateAndEncodeToBase64(byArray2), 0, 16, null);
                    appDataPreloadTrigger.appDataPreloadService.finalizePreload(CollectionsKt.listOf((Object)uploadedChunkDetails.getEtag()), CollectionsKt.listOf((Object)uploadedChunkDetails.getContentSha256()), initResponse, transferDetails);
                    appDataPreloadTrigger.appDataPreloadService.notifyFinalizedConnectEventForPreload(transferDetails, initResponse.getS3Key());
                    $this$notifyIfAny_u24lambda_u240 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable bl) {
                    $this$notifyIfAny_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                object = $this$notifyIfAny_u24lambda_u240;
                appDataPreloadTrigger = AppDataPreloadTrigger.this;
                if (Result.isSuccess-impl((Object)object)) {
                    Unit it = (Unit)object;
                    boolean bl = false;
                    appDataPreloadTrigger.log.info("Notifying preload data for cloudAppKey " + record.getCloudAppKey() + " was successfully, {}", (Object)transferDetails);
                }
                appDataPreloadTrigger = AppDataPreloadTrigger.this;
                Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
                if (throwable2 == null) break block3;
                Throwable it = throwable = throwable2;
                boolean bl = false;
                appDataPreloadTrigger.log.error("Notifying preload data for cloudAppKey " + record.getCloudAppKey() + " was failed, {}", (Object)transferDetails, (Object)it);
            }
        }
    }
}

