/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.app.rest;

import com.atlassian.cmpt.check.base.CheckExecutionStatus;
import com.atlassian.cmpt.check.dto.ChecksResultDto;
import com.atlassian.jira.migration.app.AppMigrationDevelopmentService;
import com.atlassian.jira.migration.app.AppTransferLogService;
import com.atlassian.jira.migration.app.rest.StartAppMigRequestDto;
import com.atlassian.jira.migration.app.services.AppCancellationService;
import com.atlassian.jira.migration.app.services.AppRerunService;
import com.atlassian.jira.migration.infrastructure.rest.ResponseUtils;
import com.atlassian.jira.migration.preflight.PreflightService;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.migration.progress.AppsProgressService;
import com.atlassian.migration.app.dto.AppProgressResponse;
import com.atlassian.migration.app.dto.TransferLogResponse;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.SysadminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.EnumSet;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="app-migration")
@ResourceFilters(value={SysadminOnlyResourceFilter.class})
@SystemAdminOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B7\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u001c\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0016\u001a\u00020\u0015H\u0007J&\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0017\u001a\u00020\u00152\b\b\u0001\u0010\u0016\u001a\u00020\u0015H\u0007J\u001c\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u001a\u001a\u00020\u00152\b\b\u0001\u0010\u0016\u001a\u00020\u0015H\u0007J\u0012\u0010\u001b\u001a\u00020\u001c2\b\b\u0001\u0010\u0016\u001a\u00020\u0015H\u0007J(\u0010\u001d\u001a\u00020\u00192\b\b\u0001\u0010\u0016\u001a\u00020\u00152\b\b\u0001\u0010\u0014\u001a\u00020\u00152\n\b\u0001\u0010\u0017\u001a\u0004\u0018\u00010\u0015H\u0007J&\u0010\u001e\u001a\u00020\u00192\b\b\u0001\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0016\u001a\u00020\u00152\b\b\u0001\u0010\u001a\u001a\u00020\u0015H\u0007J0\u0010\u001e\u001a\u00020\u00192\b\b\u0001\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0017\u001a\u00020\u00152\b\b\u0001\u0010\u0016\u001a\u00020\u00152\b\b\u0001\u0010\u001a\u001a\u00020\u0015H\u0007J(\u0010\u001f\u001a\u00020\u00192\b\b\u0001\u0010\u0016\u001a\u00020\u00152\b\b\u0001\u0010\u0014\u001a\u00020\u00152\n\b\u0001\u0010\u0017\u001a\u0004\u0018\u00010\u0015H\u0007J&\u0010 \u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0016\u001a\u00020\u00152\b\b\u0001\u0010\u001a\u001a\u00020\u0015H\u0007J0\u0010 \u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0016\u001a\u00020\u00152\b\b\u0001\u0010\u0017\u001a\u00020\u00152\b\b\u0001\u0010\u001a\u001a\u00020\u0015H\u0007J\u0010\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u0015H\u0002J\u0012\u0010#\u001a\u00020\u00192\b\b\u0001\u0010\u0016\u001a\u00020\u0015H\u0007J\u0012\u0010$\u001a\u00020\u00192\b\b\u0001\u0010\u0016\u001a\u00020\u0015H\u0007J\u001a\u0010%\u001a\u00020\u00192\b\b\u0001\u0010\u0016\u001a\u00020\u00152\u0006\u0010&\u001a\u00020'H\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/atlassian/jira/migration/app/rest/AppMigrationResource;", "", "appMigrationDevelopmentService", "Lcom/atlassian/jira/migration/app/AppMigrationDevelopmentService;", "appsProgressService", "Lcom/atlassian/jira/migration/progress/AppsProgressService;", "preflightService", "Lcom/atlassian/jira/migration/preflight/PreflightService;", "appRerunService", "Lcom/atlassian/jira/migration/app/services/AppRerunService;", "appCancellationService", "Lcom/atlassian/jira/migration/app/services/AppCancellationService;", "appTransferLogService", "Lcom/atlassian/jira/migration/app/AppTransferLogService;", "(Lcom/atlassian/jira/migration/app/AppMigrationDevelopmentService;Lcom/atlassian/jira/migration/progress/AppsProgressService;Lcom/atlassian/jira/migration/preflight/PreflightService;Lcom/atlassian/jira/migration/app/services/AppRerunService;Lcom/atlassian/jira/migration/app/services/AppCancellationService;Lcom/atlassian/jira/migration/app/AppTransferLogService;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "cancelAppMigration", "", "containerId", "", "planId", "transferId", "executeAppOwnedPreflightCheck", "Ljavax/ws/rs/core/Response;", "serverAppKey", "getProgressForHuman", "Lcom/atlassian/migration/app/dto/AppProgressResponse;", "getTransferLogsCsv", "isRerunEnabled", "isTransferLogsEnabled", "rerunAppMigration", "sanitiseString", "stringToSanitise", "startMigration", "triggerAppMigration", "triggerAppMigrationForSelection", "request", "Lcom/atlassian/jira/migration/app/rest/StartAppMigRequestDto;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAppMigrationResource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppMigrationResource.kt\ncom/atlassian/jira/migration/app/rest/AppMigrationResource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,201:1\n1#2:202\n*E\n"})
public final class AppMigrationResource {
    @NotNull
    private final AppMigrationDevelopmentService appMigrationDevelopmentService;
    @NotNull
    private final AppsProgressService appsProgressService;
    @NotNull
    private final PreflightService preflightService;
    @NotNull
    private final AppRerunService appRerunService;
    @NotNull
    private final AppCancellationService appCancellationService;
    @NotNull
    private final AppTransferLogService appTransferLogService;
    private final Logger log;

    @Inject
    public AppMigrationResource(@NotNull AppMigrationDevelopmentService appMigrationDevelopmentService, @NotNull AppsProgressService appsProgressService, @NotNull PreflightService preflightService, @NotNull AppRerunService appRerunService, @NotNull AppCancellationService appCancellationService, @NotNull AppTransferLogService appTransferLogService) {
        Intrinsics.checkNotNullParameter((Object)appMigrationDevelopmentService, (String)"appMigrationDevelopmentService");
        Intrinsics.checkNotNullParameter((Object)appsProgressService, (String)"appsProgressService");
        Intrinsics.checkNotNullParameter((Object)preflightService, (String)"preflightService");
        Intrinsics.checkNotNullParameter((Object)appRerunService, (String)"appRerunService");
        Intrinsics.checkNotNullParameter((Object)appCancellationService, (String)"appCancellationService");
        Intrinsics.checkNotNullParameter((Object)appTransferLogService, (String)"appTransferLogService");
        this.appMigrationDevelopmentService = appMigrationDevelopmentService;
        this.appsProgressService = appsProgressService;
        this.preflightService = preflightService;
        this.appRerunService = appRerunService;
        this.appCancellationService = appCancellationService;
        this.appTransferLogService = appTransferLogService;
        this.log = LoggerFactory.getLogger(AppMigrationResource.class);
    }

    @GET
    @Deprecated(message="https://hello.atlassian.net/browse/CME-3348")
    @Path(value="/rerun/{planId}")
    @Consumes(value={"*/*"})
    @NotNull
    public final Response startMigration(@PathParam(value="planId") @NotNull String planId) {
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        this.log.warn("You are using a deprecated endpoint. Please update your scripts to use GET /app-migration/trigger/{planId}");
        this.appMigrationDevelopmentService.rerunAppMigrationForPlan(planId);
        Response response2 = Response.noContent().build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    @GET
    @Path(value="/trigger/{planId}")
    @Consumes(value={"*/*"})
    @NotNull
    public final Response triggerAppMigration(@PathParam(value="planId") @NotNull String planId) {
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        this.appMigrationDevelopmentService.rerunAppMigrationForPlan(planId);
        Response response2 = Response.noContent().build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    @POST
    @Path(value="/trigger/{planId}")
    @NotNull
    public final Response triggerAppMigrationForSelection(@PathParam(value="planId") @NotNull String planId, @NotNull StartAppMigRequestDto request) {
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.appMigrationDevelopmentService.rerunAppMigrationForPlan(planId, request.getIncludeServerAppKeys());
        Response response2 = Response.noContent().build();
        Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"build(...)");
        return response2;
    }

    @GET
    @Path(value="/rerun/{planId}/{containerId}/enabled")
    @NotNull
    public final Response isRerunEnabled(@PathParam(value="containerId") @NotNull String containerId, @PathParam(value="planId") @NotNull String planId, @QueryParam(value="serverAppKey") @NotNull String serverAppKey) {
        Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Intrinsics.checkNotNullParameter((Object)serverAppKey, (String)"serverAppKey");
        this.log.debug("Checking rerun enabled for planId: " + planId + " containerId: " + containerId);
        return ResponseUtils.INSTANCE.ok(AppRerunService.isRerunEnabled$default(this.appRerunService, containerId, planId, serverAppKey, null, 8, null));
    }

    @GET
    @Path(value="/rerun/{planId}/{containerId}/{transferId}/enabled")
    @NotNull
    public final Response isRerunEnabled(@PathParam(value="containerId") @NotNull String containerId, @PathParam(value="transferId") @NotNull String transferId, @PathParam(value="planId") @NotNull String planId, @QueryParam(value="serverAppKey") @NotNull String serverAppKey) {
        Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
        Intrinsics.checkNotNullParameter((Object)transferId, (String)"transferId");
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Intrinsics.checkNotNullParameter((Object)serverAppKey, (String)"serverAppKey");
        this.log.debug("Checking rerun enabled for planId: " + planId + " containerId: " + containerId);
        return ResponseUtils.INSTANCE.ok(this.appRerunService.isRerunEnabled(containerId, planId, serverAppKey, transferId));
    }

    @POST
    @Path(value="/rerun/{planId}/{containerId}/{transferId}")
    public final void rerunAppMigration(@PathParam(value="containerId") @NotNull String containerId, @PathParam(value="planId") @NotNull String planId, @PathParam(value="transferId") @NotNull String transferId, @QueryParam(value="serverAppKey") @NotNull String serverAppKey) {
        Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Intrinsics.checkNotNullParameter((Object)transferId, (String)"transferId");
        Intrinsics.checkNotNullParameter((Object)serverAppKey, (String)"serverAppKey");
        this.appRerunService.rerunAppMigration(planId, containerId, serverAppKey, transferId);
    }

    @POST
    @Path(value="/rerun/{planId}/{containerId}")
    public final void rerunAppMigration(@PathParam(value="containerId") @NotNull String containerId, @PathParam(value="planId") @NotNull String planId, @QueryParam(value="serverAppKey") @NotNull String serverAppKey) {
        Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Intrinsics.checkNotNullParameter((Object)serverAppKey, (String)"serverAppKey");
        AppRerunService.rerunAppMigration$default(this.appRerunService, planId, containerId, serverAppKey, null, 8, null);
    }

    @POST
    @Path(value="/cancel/{planId}/{containerId}")
    public final void cancelAppMigration(@PathParam(value="containerId") @NotNull String containerId, @PathParam(value="planId") @NotNull String planId) {
        Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        AppCancellationService.cancelAppMigration$default(this.appCancellationService, planId, containerId, "Cancellation requested by user", null, 8, null);
    }

    @POST
    @Path(value="/cancel/{planId}/{containerId}/{transferId}")
    public final void cancelAppMigration(@PathParam(value="containerId") @NotNull String containerId, @PathParam(value="transferId") @NotNull String transferId, @PathParam(value="planId") @NotNull String planId) {
        Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
        Intrinsics.checkNotNullParameter((Object)transferId, (String)"transferId");
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        this.appCancellationService.cancelAppMigration(planId, containerId, "Cancellation requested by user", transferId);
    }

    @GET
    @Path(value="/progress/{planId}")
    @NotNull
    public final AppProgressResponse getProgressForHuman(@PathParam(value="planId") @NotNull String planId) {
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        return this.appsProgressService.getAppMigrationProgress(planId);
    }

    @GET
    @Path(value="/transfer/log/enabled")
    @NotNull
    public final Response isTransferLogsEnabled(@QueryParam(value="planId") @NotNull String planId, @QueryParam(value="containerId") @NotNull String containerId, @QueryParam(value="transferId") @Nullable String transferId) {
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
        return ResponseUtils.INSTANCE.ok(this.appTransferLogService.isTransferLogsEnabled(planId, containerId, transferId));
    }

    @GET
    @Path(value="/transfer/log/csv")
    @NotNull
    public final Response getTransferLogsCsv(@QueryParam(value="planId") @NotNull String planId, @QueryParam(value="containerId") @NotNull String containerId, @QueryParam(value="transferId") @Nullable String transferId) {
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
        TransferLogResponse response2 = this.appTransferLogService.getTransferLogCsv(planId, containerId, transferId);
        Response response3 = Response.ok((Object)response2.getCsv()).type("text/csv").header("Content-disposition", (Object)response2.getContentDispositionHeader()).build();
        Intrinsics.checkNotNullExpressionValue((Object)response3, (String)"build(...)");
        return response3;
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @Path(value="/check/{planId}/run/{appKey}")
    @NotNull
    public final Response executeAppOwnedPreflightCheck(@PathParam(value="appKey") @NotNull String serverAppKey, @PathParam(value="planId") @NotNull String planId) {
        ChecksResultDto checksResultDto;
        Intrinsics.checkNotNullParameter((Object)serverAppKey, (String)"serverAppKey");
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        this.log.info("Running " + (Object)((Object)CheckType.AppVendorCheck) + " for app " + serverAppKey + " , planId: " + planId);
        String string = this.sanitiseString(planId);
        EnumSet<Enum> enumSet = EnumSet.of((Enum)CheckType.AppVendorCheck);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
        CheckExecutionStatus result2 = this.preflightService.executeCheckForAppOnSavedPlan(string, enumSet, serverAppKey);
        ResponseUtils responseUtils = ResponseUtils.INSTANCE;
        CheckExecutionStatus checkExecutionStatus = result2;
        if (checkExecutionStatus != null) {
            void it;
            CheckExecutionStatus checkExecutionStatus2 = checkExecutionStatus;
            ResponseUtils responseUtils2 = responseUtils;
            boolean bl = false;
            checksResultDto = this.preflightService.toCheckResultDto((CheckExecutionStatus)it);
            responseUtils = responseUtils2;
        } else {
            checksResultDto = null;
        }
        return responseUtils.ok(checksResultDto);
    }

    private final String sanitiseString(String stringToSanitise) {
        CharSequence charSequence = stringToSanitise;
        if (!new Regex("^[a-zA-Z0-9,-_$]*$").matches(charSequence)) {
            throw new IllegalArgumentException("Invalid input: '" + stringToSanitise + "'. The string must only contain alphanumeric characters and -,_$");
        }
        return stringToSanitise;
    }
}

