/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.app.rest;

import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.features.StatsigFx3Gates;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.SysadminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import io.prometheus.metrics.expositionformats.PrometheusTextFormatWriter;
import io.prometheus.metrics.model.registry.PrometheusRegistry;
import io.prometheus.metrics.model.snapshots.MetricSnapshots;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Path(value="prometheus")
@ResourceFilters(value={SysadminOnlyResourceFilter.class})
@SystemAdminOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0007J\n\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0002J\n\u0010\b\u001a\u0004\u0018\u00010\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/atlassian/jira/migration/app/rest/PrometheusMetricResource;", "", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "getMetrics", "Ljavax/ws/rs/core/Response;", "notImplemented", "returnMetrics", "jira-migration-plugin"})
public final class PrometheusMetricResource {
    @NotNull
    private final MigrationFeatures migrationFeatures;

    @Inject
    public PrometheusMetricResource(@NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.migrationFeatures = migrationFeatures;
    }

    @GET
    @Path(value="/metrics")
    @NotNull
    public final Response getMetrics() {
        Response response2 = this.migrationFeatures.buildRolloutWithStatsigFeature(StatsigFx3Gates.ENABLE_PROMETHEUS_METRICS).withJvmEnabledOverride("jcma.export_prometheus.enabled").whenDisabled(() -> PrometheusMetricResource.getMetrics$lambda$0(this)).whenEnabled(() -> PrometheusMetricResource.getMetrics$lambda$1(this)).run();
        Intrinsics.checkNotNull((Object)response2);
        return response2;
    }

    private final Response returnMetrics() {
        MetricSnapshots metricSnapshots = PrometheusRegistry.defaultRegistry.scrape();
        Intrinsics.checkNotNullExpressionValue((Object)metricSnapshots, (String)"scrape(...)");
        MetricSnapshots scrape = metricSnapshots;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        new PrometheusTextFormatWriter(false).write((OutputStream)byteArrayOutputStream, scrape);
        String metrics = byteArrayOutputStream.toString("UTF-8");
        return Response.ok((Object)metrics).type("text/plain; version=0.0.4; charset=utf-8").build();
    }

    private final Response notImplemented() {
        return Response.status((int)501).header("reason", (Object)("set JVM arg 'jcma.export_prometheus.enabled' to true or enable '" + StatsigFx3Gates.ENABLE_PROMETHEUS_METRICS.getGateKey() + '\'')).build();
    }

    private static final Response getMetrics$lambda$0(PrometheusMetricResource this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.notImplemented();
    }

    private static final Response getMetrics$lambda$1(PrometheusMetricResource this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.returnMetrics();
    }
}

